/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import weibo4j.WeiboException;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Count
implements Serializable {
    private static final long serialVersionUID = 9076424494907778181L;
    private long id;
    private long comments;
    private long rt;
    private long dm;
    private long mentions;
    private long followers;

    public Count(JSONObject json) throws WeiboException, JSONException {
        this.id = json.getLong("id");
        this.comments = json.getLong("comments");
        this.rt = json.getLong("rt");
        this.dm = json.getLong("dm");
        this.mentions = json.getLong("mentions");
        this.followers = json.getLong("followers");
    }

    Count(Response res) throws WeiboException {
        JSONObject json = res.asJSONObject();
        try {
            this.id = json.getLong("id");
            this.comments = json.getLong("comments");
            this.rt = json.getLong("rt");
            this.dm = json.getLong("dm");
            this.mentions = json.getLong("mentions");
            this.followers = json.getLong("followers");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    static List<Count> constructCounts(Response res) throws WeiboException {
        try {
            System.out.println(res.asString());
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<Count> counts = new ArrayList<Count>(size);
            int i = 0;
            while (i < size) {
                counts.add(new Count(list.getJSONObject(i)));
                ++i;
            }
            return counts;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Count other = (Count)obj;
        return this.id == other.id;
    }

    public long getComments() {
        return this.comments;
    }

    public long getRt() {
        return this.rt;
    }

    public long getDm() {
        return this.dm;
    }

    public long getMentions() {
        return this.mentions;
    }

    public long getFollowers() {
        return this.followers;
    }

    public String toString() {
        return "Count{ id=" + this.id + ", comments=" + this.comments + ", rt=" + this.rt + ", dm=" + this.dm + ", mentions=" + this.mentions + ", followers=" + this.followers + '}';
    }
}

