/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.ArrayList;
import java.util.List;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Emotion
extends WeiboResponse {
    private static final long serialVersionUID = -4096813631691846494L;
    private String phrase;
    private String type;
    private String url;
    private boolean is_hot;
    private boolean is_common;
    private int order_number;
    private String category;

    public Emotion(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.phrase = json.getString("phrase");
            this.type = json.getString("type");
            this.url = json.getString("url");
            this.is_hot = json.getBoolean("is_hot");
            this.order_number = json.getInt("order_number");
            this.category = json.getString("category");
            this.is_common = json.getBoolean("is_common");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public Emotion(JSONObject json) throws WeiboException {
        try {
            this.phrase = json.getString("phrase");
            this.type = json.getString("type");
            this.url = json.getString("url");
            this.is_hot = json.getBoolean("is_hot");
            this.order_number = json.getInt("order_number");
            this.category = json.getString("category");
            this.is_common = json.getBoolean("is_common");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    static List<Emotion> constructEmotions(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<Emotion> emotions = new ArrayList<Emotion>(size);
            int i = 0;
            while (i < size) {
                emotions.add(new Emotion(list.getJSONObject(i)));
                ++i;
            }
            return emotions;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public Emotion() {
    }

    public String getPhrase() {
        return this.phrase;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isIs_hot() {
        return this.is_hot;
    }

    public void setIs_hot(boolean isHot) {
        this.is_hot = isHot;
    }

    public boolean isIs_common() {
        return this.is_common;
    }

    public void setIs_common(boolean isCommon) {
        this.is_common = isCommon;
    }

    public int getOrder_number() {
        return this.order_number;
    }

    public void setOrder_number(int orderNumber) {
        this.order_number = orderNumber;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String toString() {
        return "Emotion [phrase=" + this.phrase + ", type=" + this.type + ", url=" + this.url + ", is_hot=" + this.is_hot + ", is_common=" + this.is_common + ", order_number=" + this.order_number + ", category=" + this.category + "]";
    }
}

