/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.Date;
import org.w3c.dom.Element;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class RateLimitStatus
extends WeiboResponse {
    private int remainingHits;
    private int hourlyLimit;
    private int resetTimeInSeconds;
    private Date resetTime;
    private static final long serialVersionUID = 933996804168952707L;

    RateLimitStatus(Response res) throws WeiboException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        this.remainingHits = RateLimitStatus.getChildInt("remaining-hits", elem);
        this.hourlyLimit = RateLimitStatus.getChildInt("hourly-limit", elem);
        this.resetTimeInSeconds = RateLimitStatus.getChildInt("reset-time-in-seconds", elem);
        this.resetTime = RateLimitStatus.getChildDate("reset-time", elem, "EEE MMM d HH:mm:ss z yyyy");
    }

    RateLimitStatus(Response res, Weibo w) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.remainingHits = json.getInt("remaining_hits");
            this.hourlyLimit = json.getInt("hourly_limit");
            this.resetTimeInSeconds = json.getInt("reset_time_in_seconds");
            this.resetTime = RateLimitStatus.parseDate(json.getString("reset_time"), "EEE MMM dd HH:mm:ss z yyyy");
        }
        catch (JSONException jsone) {
            throw new WeiboException(String.valueOf(jsone.getMessage()) + ":" + json.toString(), jsone);
        }
    }

    public int getRemainingHits() {
        return this.remainingHits;
    }

    public int getHourlyLimit() {
        return this.hourlyLimit;
    }

    public int getResetTimeInSeconds() {
        return this.resetTimeInSeconds;
    }

    public Date getDateTime() {
        return this.resetTime;
    }

    public Date getResetTime() {
        return this.resetTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RateLimitStatus{remainingHits:");
        sb.append(this.remainingHits);
        sb.append(";hourlyLimit:");
        sb.append(this.hourlyLimit);
        sb.append(";resetTimeInSeconds:");
        sb.append(this.resetTimeInSeconds);
        sb.append(";resetTime:");
        sb.append(this.resetTime);
        sb.append("}");
        return sb.toString();
    }
}

