/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class SearchResult
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 8227371192527300467L;
    private Date createdAt;
    private long to_user_id;
    private String to_user;
    private String text;
    private String source;
    private long id;
    private long from_user_id;
    private String from_user;
    private String iso_language_code;
    private String profileImageUrl;

    public SearchResult(JSONObject json) throws WeiboException, JSONException {
        this.createdAt = SearchResult.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        this.to_user_id = json.getLong("to_user_id");
        this.to_user = json.getString("to_user");
        this.text = json.getString("text");
        this.source = json.getString("source");
        this.id = json.getLong("id");
        this.from_user_id = json.getLong("from_user_id");
        this.from_user = json.getString("from_user");
        this.iso_language_code = json.getString("iso_language_code");
        this.profileImageUrl = json.getString("profile_image_url");
    }

    public static List<SearchResult> constructResults(Response res) throws WeiboException {
        JSONObject json = res.asJSONObject();
        try {
            JSONArray list = json.getJSONArray("results");
            int size = list.length();
            ArrayList<SearchResult> rt = new ArrayList<SearchResult>(size);
            int i = 0;
            while (i < size) {
                rt.add(new SearchResult(list.getJSONObject(i)));
                ++i;
            }
            return rt;
        }
        catch (JSONException je) {
            throw new WeiboException(je);
        }
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public long getToUserId() {
        return this.to_user_id;
    }

    public long getId() {
        return this.id;
    }

    public long getFromUserId() {
        return this.from_user_id;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public String getFromUser() {
        return this.from_user;
    }

    public String getToUser() {
        return this.to_user;
    }

    public String getName() {
        return this.iso_language_code;
    }

    public URL getProfileImageURL() {
        try {
            return new URL(this.profileImageUrl);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from_user == null ? 0 : this.from_user.hashCode());
        result = 31 * result + (int)(this.from_user_id ^ this.from_user_id >>> 32);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.to_user == null ? 0 : this.to_user.hashCode());
        result = 31 * result + (int)(this.to_user_id ^ this.to_user_id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchResult other = (SearchResult)obj;
        if (this.from_user == null ? other.from_user != null : !this.from_user.equals(other.from_user)) {
            return false;
        }
        if (this.from_user_id != other.from_user_id) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.to_user == null ? other.to_user != null : !this.to_user.equals(other.to_user)) {
            return false;
        }
        return this.to_user_id == other.to_user_id;
    }

    public String toString() {
        return "Result{ " + this.to_user_id + "," + this.to_user + "," + this.text + "," + this.id + "," + this.from_user_id + "," + this.from_user + "," + this.iso_language_code + "," + this.source + "," + this.profileImageUrl + "," + this.createdAt + '}';
    }
}

