/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weibo4j.RetweetDetails;
import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Status
extends WeiboResponse
implements Serializable {
    private Date createdAt;
    private long id;
    private String text;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private long inReplyToUserId;
    private boolean isFavorited;
    private String inReplyToScreenName;
    private double latitude = -1.0;
    private double longitude = -1.0;
    private String thumbnail_pic;
    private String bmiddle_pic;
    private String original_pic;
    @Deprecated
    private RetweetDetails retweetDetails;
    private Status retweeted_status;
    private String mid;
    private static final long serialVersionUID = 1608000492860584608L;
    private User user = null;

    Status(Response res, Weibo weibo) throws WeiboException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        this.init(res, elem, weibo);
    }

    Status(Response res, Element elem, Weibo weibo) throws WeiboException {
        super(res);
        this.init(res, elem, weibo);
    }

    Status(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.constructJson(json);
    }

    private void constructJson(JSONObject json) throws WeiboException {
        try {
            this.id = json.getLong("id");
            this.text = json.getString("text");
            this.source = json.getString("source");
            this.createdAt = Status.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.inReplyToStatusId = Status.getLong("in_reply_to_status_id", json);
            this.inReplyToUserId = Status.getLong("in_reply_to_user_id", json);
            this.isFavorited = Status.getBoolean("favorited", json);
            this.thumbnail_pic = json.getString("thumbnail_pic");
            this.bmiddle_pic = json.getString("bmiddle_pic");
            this.original_pic = json.getString("original_pic");
            if (!json.isNull("user")) {
                this.user = new User(json.getJSONObject("user"));
            }
            this.inReplyToScreenName = json.getString("inReplyToScreenName");
            if (!json.isNull("retweeted_status")) {
                this.retweetDetails = new RetweetDetails(json.getJSONObject("retweeted_status"));
                this.retweeted_status = new Status(json.getJSONObject("retweeted_status"));
            }
            this.mid = json.getString("mid");
            String geo = json.getString("geo");
            if (geo != null && !"".equals(geo) && !"null".equals(geo)) {
                this.getGeoInfo(geo);
            }
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    private void getGeoInfo(String geo) {
        StringBuffer value = new StringBuffer();
        char[] cArray = geo.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c > '-' && c < ':') {
                value.append(c);
            }
            if (c == ',' && value.length() > 0) {
                this.latitude = Double.parseDouble(value.toString());
                value.delete(0, value.length());
            }
            ++n2;
        }
        this.longitude = Double.parseDouble(value.toString());
    }

    public Status(JSONObject json) throws WeiboException, JSONException {
        this.constructJson(json);
    }

    public Status(String str) throws WeiboException, JSONException {
        JSONObject json = new JSONObject(str);
        this.constructJson(json);
    }

    private void init(Response res, Element elem, Weibo weibo) throws WeiboException {
        NodeList retweetDetailsNode;
        Status.ensureRootNodeNameIs("status", elem);
        this.user = new User(res, (Element)elem.getElementsByTagName("user").item(0), weibo);
        this.id = Status.getChildLong("id", elem);
        this.text = Status.getChildText("text", elem);
        this.source = Status.getChildText("source", elem);
        this.createdAt = Status.getChildDate("created_at", elem);
        this.isTruncated = Status.getChildBoolean("truncated", elem);
        this.inReplyToStatusId = Status.getChildLong("in_reply_to_status_id", elem);
        this.inReplyToUserId = Status.getChildLong("in_reply_to_user_id", elem);
        this.isFavorited = Status.getChildBoolean("favorited", elem);
        this.inReplyToScreenName = Status.getChildText("in_reply_to_screen_name", elem);
        NodeList georssPoint = elem.getElementsByTagName("georss:point");
        if (1 == georssPoint.getLength()) {
            String[] point = georssPoint.item(0).getFirstChild().getNodeValue().split(" ");
            if (!"null".equals(point[0])) {
                this.latitude = Double.parseDouble(point[0]);
            }
            if (!"null".equals(point[1])) {
                this.longitude = Double.parseDouble(point[1]);
            }
        }
        if (1 == (retweetDetailsNode = elem.getElementsByTagName("retweet_details")).getLength()) {
            this.retweetDetails = new RetweetDetails(res, (Element)retweetDetailsNode.item(0), weibo);
            this.retweeted_status = new Status(res, (Element)retweetDetailsNode.item(0), weibo);
        }
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public long getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public long getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean isFavorited() {
        return this.isFavorited;
    }

    public String getThumbnail_pic() {
        return this.thumbnail_pic;
    }

    public String getBmiddle_pic() {
        return this.bmiddle_pic;
    }

    public String getOriginal_pic() {
        return this.original_pic;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isRetweet() {
        return this.retweeted_status != null;
    }

    public RetweetDetails getRetweetDetails() {
        return this.retweetDetails;
    }

    public Status getRetweeted_status() {
        return this.retweeted_status;
    }

    public String getMid() {
        return this.mid;
    }

    static List<Status> constructStatuses(Response res, Weibo weibo) throws WeiboException {
        Document doc = res.asDocument();
        if (Status.isRootNodeNilClasses(doc)) {
            return new ArrayList<Status>(0);
        }
        try {
            Status.ensureRootNodeNameIs("statuses", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("status");
            int size = list.getLength();
            ArrayList<Status> statuses = new ArrayList<Status>(size);
            int i = 0;
            while (i < size) {
                Element status = (Element)list.item(i);
                statuses.add(new Status(res, status, weibo));
                ++i;
            }
            return statuses;
        }
        catch (WeiboException te) {
            Status.ensureRootNodeNameIs("nil-classes", doc);
            return new ArrayList<Status>(0);
        }
    }

    static List<Status> constructStatuses(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<Status> statuses = new ArrayList<Status>(size);
            int i = 0;
            while (i < size) {
                statuses.add(new Status(list.getJSONObject(i)));
                ++i;
            }
            return statuses;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Status other = (Status)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "Status [createdAt=" + this.createdAt + ", id=" + this.id + ", text=" + this.text + ", source=" + this.source + ", isTruncated=" + this.isTruncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isFavorited=" + this.isFavorited + ", inReplyToScreenName=" + this.inReplyToScreenName + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", thumbnail_pic=" + this.thumbnail_pic + ", bmiddle_pic=" + this.bmiddle_pic + ", original_pic=" + this.original_pic + ", retweetDetails=" + this.retweetDetails + ",  mid=" + this.mid + ", user=" + this.user + "retweeted_status=" + (this.retweeted_status == null ? "null" : this.retweeted_status.toString()) + "]";
    }
}

