/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.ArrayList;
import java.util.List;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class UserTrend
extends WeiboResponse {
    private String num;
    private String hotword = null;
    private String trend_id = null;
    private static final long serialVersionUID = 1925956704460743946L;

    public UserTrend() {
    }

    public UserTrend(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.num = json.getString("num");
            this.hotword = json.getString("hotword");
            this.trend_id = json.getString("trend_id");
            if (json.getString("topicid") != null) {
                this.trend_id = json.getString("topicid");
            }
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public UserTrend(JSONObject json) throws WeiboException {
        try {
            this.num = json.getString("num");
            this.hotword = json.getString("hotword");
            this.trend_id = json.getString("trend_id");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    static List<UserTrend> constructTrendList(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<UserTrend> trends = new ArrayList<UserTrend>(size);
            int i = 0;
            while (i < size) {
                trends.add(new UserTrend(list.getJSONObject(i)));
                ++i;
            }
            return trends;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public String getNum() {
        return this.num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getHotword() {
        return this.hotword;
    }

    public void setHotword(String hotword) {
        this.hotword = hotword;
    }

    public String getTrend_id() {
        return this.trend_id;
    }

    public void setTrend_id(String trend_id) {
        this.trend_id = trend_id;
    }

    public String toString() {
        return "Trend [num=" + this.num + ", hotword=" + this.hotword + ", trend_id=" + this.trend_id + "]";
    }
}

