/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weibo4j.Comment;
import weibo4j.Configuration;
import weibo4j.Count;
import weibo4j.Emotion;
import weibo4j.IDs;
import weibo4j.Paging;
import weibo4j.Query;
import weibo4j.RateLimitStatus;
import weibo4j.RetweetDetails;
import weibo4j.SavedSearch;
import weibo4j.SearchResult;
import weibo4j.Status;
import weibo4j.Tag;
import weibo4j.Trends;
import weibo4j.User;
import weibo4j.UserTrend;
import weibo4j.UserWapper;
import weibo4j.WeiboException;
import weibo4j.WeiboSupport;
import weibo4j.http.AccessToken;
import weibo4j.http.HttpClient;
import weibo4j.http.ImageItem;
import weibo4j.http.PostParameter;
import weibo4j.http.RequestToken;
import weibo4j.http.Response;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;
import weibo4j.util.URLEncodeUtils;

public class Weibo
extends WeiboSupport
implements Serializable {
    public static String CONSUMER_KEY = "";
    public static String CONSUMER_SECRET = "";
    private String baseURL = String.valueOf(Configuration.getScheme()) + "api.t.sina.com.cn/";
    private String searchBaseURL = String.valueOf(Configuration.getScheme()) + "api.t.sina.com.cn/";
    private static final long serialVersionUID = -1486360080128882436L;
    private SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    public static final Device IM = new Device("im");
    public static final Device SMS = new Device("sms");
    public static final Device NONE = new Device("none");

    public List<User> searchUser(Query query) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.searchBaseURL) + "users/search.json", query.getParameters(), false));
    }

    public List<SearchResult> search(Query query) throws WeiboException {
        return SearchResult.constructResults(this.get(String.valueOf(this.searchBaseURL) + "search.json", query.getParameters(), true));
    }

    public List<Status> statussearch(Query query) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.searchBaseURL) + "statuses/search.json", query.getParameters(), true));
    }

    public List<Status> getFavorites(int page) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "favorites.json", "page", String.valueOf(page), true));
    }

    public Status createFavorite(long id) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "favorites/create/" + id + ".json", true));
    }

    public Status destroyFavorite(long id) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "favorites/destroy/" + id + ".json", true));
    }

    public List<Status> destroyFavorites(String ids) throws WeiboException {
        return Status.constructStatuses(this.http.post(String.valueOf(this.getBaseURL()) + "favorites/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}, true));
    }

    public List<Status> destroyFavorites(String ... ids) throws WeiboException {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            sb.append(id).append(',');
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        return Status.constructStatuses(this.http.post(String.valueOf(this.getBaseURL()) + "favorites/destroy_batch.json", new PostParameter[]{new PostParameter("ids", sb.toString())}, true));
    }

    public User verifyCredentials() throws WeiboException {
        return new User(this.get(String.valueOf(this.getBaseURL()) + "account/verify_credentials.json", true).asJSONObject());
    }

    public User updateProfile(String name, String email, String url, String location, String description) throws WeiboException {
        ArrayList<PostParameter> profile = new ArrayList<PostParameter>(5);
        this.addParameterToList(profile, "name", name);
        this.addParameterToList(profile, "email", email);
        this.addParameterToList(profile, "url", url);
        this.addParameterToList(profile, "location", location);
        this.addParameterToList(profile, "description", description);
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "account/update_profile.json", profile.toArray(new PostParameter[profile.size()]), true).asJSONObject());
    }

    public User updateProfileImage(File image) throws WeiboException {
        return new User(this.http.multPartURL("image", String.valueOf(this.getBaseURL()) + "account/update_profile_image.json", new PostParameter[]{new PostParameter("source", CONSUMER_KEY)}, image, true).asJSONObject());
    }

    public RateLimitStatus rateLimitStatus() throws WeiboException {
        return new RateLimitStatus(this.http.get(String.valueOf(this.getBaseURL()) + "account/rate_limit_status.json", true), this);
    }

    public User endSession() throws WeiboException {
        return new User(this.get(String.valueOf(this.getBaseURL()) + "account/end_session.json", true).asJSONObject());
    }

    public List<Tag> getTags(String userId, Paging paging) throws WeiboException {
        return Tag.constructTags(this.get(String.valueOf(this.getBaseURL()) + "tags.json", new PostParameter[]{new PostParameter("user_id", userId)}, paging, true));
    }

    public List<Tag> createTags(String ... tags) throws WeiboException {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            sb.append(tag).append(",");
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        return this.createTags(sb.toString());
    }

    public List<Tag> createTags(String tags) throws WeiboException {
        return Tag.constructTags(this.http.post(String.valueOf(this.getBaseURL()) + "tags/create.json", new PostParameter[]{new PostParameter("tags", tags)}, true));
    }

    public List<Tag> getSuggestionsTags() throws WeiboException {
        return Tag.constructTags(this.get(String.valueOf(this.getBaseURL()) + "tags/suggestions.json", true));
    }

    public boolean destoryTag(String tag_id) throws WeiboException {
        try {
            return this.http.post(String.valueOf(this.getBaseURL()) + "tags/destroy.json", new PostParameter[]{new PostParameter("tag_id", tag_id)}, true).asJSONObject().getInt("result") == 0;
        }
        catch (JSONException e) {
            throw new WeiboException(e);
        }
    }

    public List<Tag> destory_batchTags(String ids) throws WeiboException {
        return Tag.constructTags(this.http.post(String.valueOf(this.getBaseURL()) + "tags/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}, true));
    }

    public User createBlock(String userid) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "blocks/create.json", new PostParameter[]{new PostParameter("user_id", userid)}, true).asJSONObject());
    }

    public User createBlockByScreenName(String screenName) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "blocks/create.json", new PostParameter[]{new PostParameter("screen_name", screenName)}, true).asJSONObject());
    }

    public User destroyBlock(String id) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "blocks/destroy.json", new PostParameter[]{new PostParameter("id", id)}, true).asJSONObject());
    }

    public boolean existsBlock(String id) throws WeiboException {
        try {
            return -1 == this.get(String.valueOf(this.getBaseURL()) + "blocks/exists.json?user_id=" + id, true).asString().indexOf("<error>You are not blocking this user.</error>");
        }
        catch (WeiboException te) {
            if (te.getStatusCode() == 404) {
                return false;
            }
            throw te;
        }
    }

    public List<User> getBlockingUsers() throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "blocks/blocking.json", true));
    }

    public List<User> getBlockingUsers(int page) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "blocks/blocking.json?page=" + page, true));
    }

    public IDs getBlockingUsersIDs() throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "blocks/blocking/ids.json", true), this);
    }

    public IDs getFriendsIDSByUserId(String userid, Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.baseURL) + "friends/ids.json", new PostParameter[]{new PostParameter("user_id", userid)}, paging, true), this);
    }

    public IDs getFriendsIDSByScreenName(String screenName, Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.baseURL) + "friends/ids.json", new PostParameter[]{new PostParameter("screen_name", screenName)}, paging, true), this);
    }

    public IDs getFollowersIDSByUserId(String userid, Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.baseURL) + "followers/ids.json", new PostParameter[]{new PostParameter("user_id", userid)}, paging, true), this);
    }

    public IDs getFollowersIDSByScreenName(String screenName, Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.baseURL) + "followers/ids.json", new PostParameter[]{new PostParameter("screen_name", screenName)}, paging, true), this);
    }

    public List<UserTrend> getTrends(String userid, Paging paging) throws WeiboException {
        return UserTrend.constructTrendList(this.get(String.valueOf(this.baseURL) + "trends.json", new PostParameter[]{new PostParameter("user_id", userid)}, paging, true));
    }

    public List<Status> getTrendStatus(String trendName, Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.baseURL) + "trends/statuses.json", new PostParameter[]{new PostParameter("trend_name", trendName)}, paging, true));
    }

    public UserTrend trendsFollow(String treandName) throws WeiboException {
        return new UserTrend(this.http.post(String.valueOf(this.baseURL) + "trends/follow.json", new PostParameter[]{new PostParameter("trend_name", treandName)}, true));
    }

    public boolean trendsDestroy(String trendId) throws WeiboException {
        JSONObject obj = this.http.delete(String.valueOf(this.baseURL) + "trends/destroy.json?trend_id=" + trendId + "&source=" + CONSUMER_KEY, true).asJSONObject();
        try {
            return obj.getBoolean("result");
        }
        catch (JSONException e) {
            throw new WeiboException("e");
        }
    }

    public List<Trends> getTrendsHourly(Integer baseApp) throws WeiboException {
        if (baseApp == null) {
            baseApp = 0;
        }
        return Trends.constructTrendsList(this.get(String.valueOf(this.baseURL) + "trends/hourly.json", "base_app", baseApp.toString(), true));
    }

    public List<Trends> getTrendsDaily(Integer baseApp) throws WeiboException {
        if (baseApp == null) {
            baseApp = 0;
        }
        return Trends.constructTrendsList(this.get(String.valueOf(this.baseURL) + "trends/daily.json", "base_app", baseApp.toString(), true));
    }

    public List<Trends> getTrendsWeekly(Integer baseApp) throws WeiboException {
        if (baseApp == null) {
            baseApp = 0;
        }
        return Trends.constructTrendsList(this.get(String.valueOf(this.baseURL) + "trends/weekly.json", "base_app", baseApp.toString(), true));
    }

    private String toDateStr(Date date) {
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public User createFriendship(String id) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "friendships/create.json", new PostParameter[]{new PostParameter("id", id)}, true).asJSONObject());
    }

    public User createFriendshipByScreenName(String screenName) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "friendships/create.json", new PostParameter[]{new PostParameter("screen_name", screenName)}, true).asJSONObject());
    }

    public User createFriendshipByUserid(String userid) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "friendships/create.json", new PostParameter[]{new PostParameter("user_id", userid)}, true).asJSONObject());
    }

    public User destroyFriendship(String id) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "friendships/destroy.json", "id", id, true).asJSONObject());
    }

    public User destroyFriendshipByUserid(String userid) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "friendships/destroy.json", "user_id", userid, true).asJSONObject());
    }

    public User destroyFriendshipByScreenName(String screenName) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "friendships/destroy.json", "screen_name", screenName, true).asJSONObject());
    }

    public User showUser(String user_id) throws WeiboException {
        return new User(this.get(String.valueOf(this.getBaseURL()) + "users/show.json", new PostParameter[]{new PostParameter("id", user_id)}, this.http.isAuthenticationEnabled()).asJSONObject());
    }

    public List<User> getFriendsStatuses() throws WeiboException {
        return User.constructResult(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends.json", true));
    }

    public List<User> getFriendsStatuses(int cursor) throws WeiboException {
        return User.constructUser(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends.json", new PostParameter[]{new PostParameter("cursor", cursor)}, true));
    }

    public List<User> getFriendsStatuses(String id, Paging paging) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends.json", new PostParameter[]{new PostParameter("id", id)}, paging, true));
    }

    public List<User> getFriendsStatuses(Paging paging) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends.json", null, paging, true));
    }

    public List<User> getFriendsStatuses(String id) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends.json", new PostParameter[]{new PostParameter("id", id)}, true));
    }

    public List<User> getFollowersStatuses() throws WeiboException {
        return User.constructResult(this.get(String.valueOf(this.getBaseURL()) + "statuses/followers.json", true));
    }

    public List<User> getFollowersStatuses(String id, Paging paging) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/followers.json", new PostParameter[]{new PostParameter("id", id)}, paging, true));
    }

    public List<User> getFollowersStatuses(Paging paging) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/followers.json", null, paging, true));
    }

    public List<User> getFollowersStatuses(int cursor) throws WeiboException {
        return User.constructUser(this.get(String.valueOf(this.getBaseURL()) + "statuses/followers.json", new PostParameter[]{new PostParameter("cursor", cursor)}, true));
    }

    public List<User> getFollowersStatuses(String id) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/followers.json", new PostParameter[]{new PostParameter("id", id)}, true));
    }

    public List<User> getHotUsers(String category) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "users/hot.json", "category", category, true));
    }

    public User updateRemark(String userid, String remark) throws WeiboException {
        if (!URLEncodeUtils.isURLEncoded(remark)) {
            remark = URLEncodeUtils.encodeURL(remark);
        }
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "user/friends/update_remark.json", new PostParameter[]{new PostParameter("user_id", userid), new PostParameter("remark", remark)}, true).asJSONObject());
    }

    public User updateRemark(Long userid, String remark) throws WeiboException {
        return this.updateRemark(Long.toString(userid), remark);
    }

    public List<User> getSuggestionUsers() throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "users/suggestions.json", "with_reason", "0", true));
    }

    public List<Status> getPublicTimeline() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/public_timeline.json", true));
    }

    public List<Status> getPublicTimeline(int count, int baseApp) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/public_timeline.json", new PostParameter[]{new PostParameter("count", count), new PostParameter("base_app", baseApp)}, false));
    }

    public List<Status> getFriendsTimeline() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends_timeline.json", true));
    }

    public List<Status> getFriendsTimeline(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends_timeline.json", null, paging, true));
    }

    public List<Status> getHomeTimeline() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/home_timeline.json", true));
    }

    public List<Status> getHomeTimeline(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/home_timeline.json", null, paging, true));
    }

    public List<Status> getUserTimeline(String id, Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline.json", new PostParameter[]{new PostParameter("id", id)}, paging, this.http.isAuthenticationEnabled()));
    }

    public List<Status> getUserTimeline(String id, Integer baseAPP, Integer feature, Paging paging) throws WeiboException {
        HashMap<String, String> maps = new HashMap<String, String>();
        if (id != null) {
            maps.put("id", id);
        }
        if (baseAPP != null) {
            maps.put("base_app", baseAPP.toString());
        }
        if (feature != null) {
            maps.put("feature", feature.toString());
        }
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline.json", this.generateParameterArray(maps), paging, this.http.isAuthenticationEnabled()));
    }

    public List<Status> getUserTimeline(String id) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline.json", new PostParameter[]{new PostParameter("id", id)}, this.http.isAuthenticationEnabled()));
    }

    public List<Status> getUserTimeline() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline.json", true));
    }

    public List<Status> getUserTimeline(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline.json", null, paging, true));
    }

    public List<Status> getUserTimeline(Integer baseAPP, Integer feature, Paging paging) throws WeiboException {
        return this.getUserTimeline(null, baseAPP, feature, paging);
    }

    public List<Status> getMentions() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/mentions.json", null, true));
    }

    public List<Status> getMentions(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/mentions.json", null, paging, true));
    }

    public List<Comment> getCommentsTimeline() throws WeiboException {
        return Comment.constructComments(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments_timeline.json", true));
    }

    public List<Comment> getCommentsTimeline(Paging paging) throws WeiboException {
        return Comment.constructComments(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments_timeline.json", null, paging, true));
    }

    public List<Comment> getCommentsByMe() throws WeiboException {
        return Comment.constructComments(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments_by_me.json", true));
    }

    public List<Comment> getCommentsByMe(Paging paging) throws WeiboException {
        return Comment.constructComments(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments_by_me.json", null, paging, true));
    }

    public List<Comment> getCommentsToMe() throws WeiboException {
        return Comment.constructComments(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments_to_me.json", true));
    }

    public List<Comment> getCommentsToMe(Paging paging) throws WeiboException {
        return Comment.constructComments(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments_to_me.json", null, paging, true));
    }

    public List<Status> getrepostbyme(String id) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/repost_by_me.json", "id", id, true));
    }

    public List<Status> getrepostbyme(String id, Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/repost_by_me.json", new PostParameter[]{new PostParameter("id", id)}, paging, true));
    }

    public List<Status> getreposttimeline(String id) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/repost_timeline.json", "id", id, true));
    }

    public List<Status> getreposttimeline(String id, Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/repost_timeline.json", new PostParameter[]{new PostParameter("id", id)}, paging, true));
    }

    public List<Comment> getComments(String id) throws WeiboException {
        return Comment.constructComments(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments.json", "id", id, true));
    }

    public List<Comment> getComments(String id, Paging paging) throws WeiboException {
        return Comment.constructComments(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments.json", new PostParameter[]{new PostParameter("id", id)}, paging, true));
    }

    public List<Count> getCounts(String ids) throws WeiboException {
        return Count.constructCounts(this.get(String.valueOf(this.getBaseURL()) + "statuses/counts.json", "ids", ids, true));
    }

    public Count getUnread() throws WeiboException {
        return new Count(this.get(String.valueOf(this.getBaseURL()) + "statuses/unread.json", true));
    }

    public Count getUnread(Integer withNewStatus, Long sinceId) throws WeiboException, JSONException {
        HashMap<String, String> maps = new HashMap<String, String>();
        if (withNewStatus != null) {
            maps.put("with_new_status", Integer.toString(withNewStatus));
        }
        if (sinceId != null) {
            maps.put("since_id", Long.toString(sinceId));
        }
        return new Count(this.get(String.valueOf(this.getBaseURL()) + "statuses/unread.json", this.generateParameterArray(maps), true).asJSONObject());
    }

    public Boolean resetCount(int type) throws WeiboException {
        boolean res = false;
        JSONObject json = null;
        try {
            json = this.http.post(String.valueOf(this.getBaseURL()) + "statuses/reset_count.json", new PostParameter[]{new PostParameter("type", type)}, true).asJSONObject();
            res = json.getBoolean("result");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json, je);
        }
        return res;
    }

    public List<Emotion> getEmotions(String type, String language) throws WeiboException {
        if (type == null) {
            type = "face";
        }
        if (language == null) {
            language = "cnname";
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("type", type);
        maps.put("language", language);
        return Emotion.constructEmotions(this.get(String.valueOf(this.getBaseURL()) + "emotions.json", this.generateParameterArray(maps), true));
    }

    public List<Emotion> getEmotions() throws WeiboException {
        return this.getEmotions(null, null);
    }

    public Status showStatus(String id) throws WeiboException {
        return new Status(this.get(String.valueOf(this.getBaseURL()) + "statuses/show/" + id + ".json", true));
    }

    public Status showStatus(long id) throws WeiboException {
        return this.showStatus(Long.toString(id));
    }

    public Status updateStatus(String status) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status)}, true));
    }

    public Status updateStatus(String status, double latitude, double longitude) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("lat", latitude), new PostParameter("long", longitude)}, true));
    }

    public Status updateStatus(String status, long inReplyToStatusId) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("in_reply_to_status_id", String.valueOf(inReplyToStatusId)), new PostParameter("source", this.source)}, true));
    }

    public Status updateStatus(String status, long inReplyToStatusId, double latitude, double longitude) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("lat", latitude), new PostParameter("long", longitude), new PostParameter("in_reply_to_status_id", String.valueOf(inReplyToStatusId)), new PostParameter("source", this.source)}, true));
    }

    public Status uploadStatus(String status, ImageItem item) throws WeiboException {
        if (!URLEncodeUtils.isURLEncoded(status)) {
            status = URLEncodeUtils.encodeURL(status);
        }
        return new Status(this.http.multPartURL(String.valueOf(this.getBaseURL()) + "statuses/upload.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("source", this.source)}, item, true));
    }

    public Status uploadStatus(String status, ImageItem item, double latitude, double longitude) throws WeiboException {
        if (!URLEncodeUtils.isURLEncoded(status)) {
            status = URLEncodeUtils.encodeURL(status);
        }
        return new Status(this.http.multPartURL(String.valueOf(this.getBaseURL()) + "statuses/upload.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("source", this.source), new PostParameter("lat", latitude), new PostParameter("long", longitude)}, item, true));
    }

    public Status uploadStatus(String status, File file) throws WeiboException {
        if (!URLEncodeUtils.isURLEncoded(status)) {
            status = URLEncodeUtils.encodeURL(status);
        }
        return new Status(this.http.multPartURL("pic", String.valueOf(this.getBaseURL()) + "statuses/upload.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("source", this.source)}, file, true));
    }

    public Status uploadStatus(String status, File file, double latitude, double longitude) throws WeiboException {
        if (!URLEncodeUtils.isURLEncoded(status)) {
            status = URLEncodeUtils.encodeURL(status);
        }
        return new Status(this.http.multPartURL("pic", String.valueOf(this.getBaseURL()) + "statuses/upload.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("source", this.source), new PostParameter("lat", latitude), new PostParameter("long", longitude)}, file, true));
    }

    public Status destroyStatus(long statusId) throws WeiboException {
        return this.destroyStatus(Long.toString(statusId));
    }

    public Status destroyStatus(String statusId) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/destroy/" + statusId + ".json", new PostParameter[0], true));
    }

    public Status repost(String sid, String status) throws WeiboException {
        return this.repost(sid, status, 0);
    }

    public Status repost(String sid, String status, int isComment) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/repost.json", new PostParameter[]{new PostParameter("id", sid), new PostParameter("status", status), new PostParameter("is_comment", isComment)}, true));
    }

    public Comment updateComment(String comment, String id, String cid) throws WeiboException {
        PostParameter[] params = null;
        params = cid == null ? new PostParameter[]{new PostParameter("comment", comment), new PostParameter("id", id)} : new PostParameter[]{new PostParameter("comment", comment), new PostParameter("cid", cid), new PostParameter("id", id)};
        return new Comment(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/comment.json", params, true));
    }

    public Comment destroyComment(long commentId) throws WeiboException {
        return new Comment(this.http.delete(String.valueOf(this.getBaseURL()) + "statuses/comment_destroy/" + commentId + ".json?source=" + CONSUMER_KEY, true));
    }

    public List<Comment> destroyComments(String ids) throws WeiboException {
        return Comment.constructComments(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/comment/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}, true));
    }

    public List<Comment> destroyComments(String[] ids) throws WeiboException {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            sb.append(id).append(',');
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        return Comment.constructComments(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/comment/destroy_batch.json", new PostParameter[]{new PostParameter("ids", sb.toString())}, true));
    }

    public Comment reply(String sid, String cid, String comment) throws WeiboException {
        return new Comment(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/reply.json", new PostParameter[]{new PostParameter("id", sid), new PostParameter("cid", cid), new PostParameter("comment", comment)}, true));
    }

    public synchronized void setOAuthConsumer(String consumerKey, String consumerSecret) {
        this.http.setOAuthConsumer(consumerKey, consumerSecret);
    }

    public RequestToken getOAuthRequestToken() throws WeiboException {
        return this.http.getOAuthRequestToken();
    }

    public RequestToken getOAuthRequestToken(String callback_url) throws WeiboException {
        return this.http.getOauthRequestToken(callback_url);
    }

    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken) throws WeiboException {
        return this.http.getOAuthAccessToken(requestToken);
    }

    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken, String pin) throws WeiboException {
        AccessToken accessToken = this.http.getOAuthAccessToken(requestToken, pin);
        return accessToken;
    }

    public synchronized AccessToken getOAuthAccessToken(String token, String tokenSecret) throws WeiboException {
        AccessToken accessToken = this.http.getOAuthAccessToken(token, tokenSecret);
        return accessToken;
    }

    public synchronized AccessToken getOAuthAccessToken(String token, String tokenSecret, String oauth_verifier) throws WeiboException {
        return this.http.getOAuthAccessToken(token, tokenSecret, oauth_verifier);
    }

    public synchronized AccessToken getXAuthAccessToken(String userId, String passWord, String mode) throws WeiboException {
        return this.http.getXAuthAccessToken(userId, passWord, mode);
    }

    public synchronized AccessToken getXAuthAccessToken(String userid, String password) throws WeiboException {
        return this.getXAuthAccessToken(userid, password, "client_auth");
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.http.setOAuthAccessToken(accessToken);
    }

    public void setOAuthAccessToken(String token, String tokenSecret) {
        this.setOAuthAccessToken(new AccessToken(token, tokenSecret));
    }

    public RateLimitStatus getRateLimitStatus() throws WeiboException {
        return new RateLimitStatus(this.get(String.valueOf(this.getBaseURL()) + "account/rate_limit_status.json", true), this);
    }

    public List<Status> getRetweetedByMe() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweeted_by_me.json", null, true));
    }

    public List<Status> getRetweetedByMe(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweeted_by_me.json", null, true));
    }

    public List<Status> getRetweetedToMe() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweeted_to_me.json", null, true));
    }

    public List<Status> getRetweetedToMe(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweeted_to_me.json", null, paging, true));
    }

    public List<Status> getRetweetsOfMe() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweets_of_me.json", null, true));
    }

    public List<Status> getRetweetsOfMe(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweets_of_me.json", null, paging, true));
    }

    public Status retweetStatus(long statusId) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/retweet/" + statusId + ".json", new PostParameter[0], true));
    }

    public List<RetweetDetails> getRetweets(long statusId) throws WeiboException {
        return RetweetDetails.createRetweetDetails(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweets/" + statusId + ".json", true));
    }

    public User updatePrivacy(String comment) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "account/update_privacy.json", new PostParameter[]{new PostParameter("comment", comment)}, true).asJSONObject());
    }

    public List<User> getFeatured() throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/featured.json", true));
    }

    public boolean existsFriendship(String userA, String userB) throws WeiboException {
        return -1 != this.get(String.valueOf(this.getBaseURL()) + "friendships/exists.json", "user_a", userA, "user_b", userB, true).asString().indexOf("true");
    }

    public IDs getFriendsIDs() throws WeiboException {
        return this.getFriendsIDs(-1L);
    }

    public IDs getFriendsIDs(long cursor) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "friends/ids.xml?cursor=" + cursor, true));
    }

    public IDs getFriendsIDs(int userId) throws WeiboException {
        return this.getFriendsIDs(userId, -1L);
    }

    public IDs getFriendsIDs(int userId, long cursor) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "friends/ids.json?user_id=" + userId + "&cursor=" + cursor, true), this);
    }

    public IDs getFriendsIDs(String screenName) throws WeiboException {
        return this.getFriendsIDs(screenName, -1L);
    }

    public IDs getFriendsIDs(String screenName, long cursor) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "friends/ids.json?screen_name=" + screenName + "&cursor=" + cursor, true), this);
    }

    public IDs getFollowersIDs() throws WeiboException {
        return this.getFollowersIDs(-1L);
    }

    public IDs getFollowersIDs(long cursor) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "followers/ids.json?cursor=" + cursor, true), this);
    }

    public IDs getFollowersIDs(int userId) throws WeiboException {
        return this.getFollowersIDs(userId, -1L);
    }

    public IDs getFollowersIDs(int userId, long cursor) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "followers/ids.xml?user_id=" + userId + "&cursor=" + cursor, true));
    }

    public IDs getFollowersIDs(String screenName) throws WeiboException {
        return this.getFollowersIDs(screenName, -1L);
    }

    public IDs getFollowersIDs(String screenName, long cursor) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "followers/ids.json?screen_name=" + screenName + "&cursor=" + cursor, true), this);
    }

    private void addParameterToList(List<PostParameter> colors, String paramName, String color) {
        if (color != null) {
            colors.add(new PostParameter(paramName, color));
        }
    }

    public User enableNotification(String id) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "notifications/follow/" + id + ".json", true).asJSONObject());
    }

    public User disableNotification(String id) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "notifications/leave/" + id + ".json", true).asJSONObject());
    }

    public List<SavedSearch> getSavedSearches() throws WeiboException {
        return SavedSearch.constructSavedSearches(this.get(String.valueOf(this.getBaseURL()) + "saved_searches.json", true));
    }

    public SavedSearch showSavedSearch(int id) throws WeiboException {
        return new SavedSearch(this.get(String.valueOf(this.getBaseURL()) + "saved_searches/show/" + id + ".json", true));
    }

    public SavedSearch createSavedSearch(String query) throws WeiboException {
        return new SavedSearch(this.http.post(String.valueOf(this.getBaseURL()) + "saved_searches/create.json", new PostParameter[]{new PostParameter("query", query)}, true));
    }

    public SavedSearch destroySavedSearch(int id) throws WeiboException {
        return new SavedSearch(this.http.post(String.valueOf(this.getBaseURL()) + "saved_searches/destroy/" + id + ".json", true));
    }

    public List<Status> getListStatuses(String uid, String listId, boolean auth) throws WeiboException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseURL()).append(uid).append("/lists/").append(listId).append("/statuses.xml").append("?source=").append(CONSUMER_KEY);
        String httpMethod = "GET";
        String url = sb.toString();
        return Status.constructStatuses(this.http.httpRequest(url, null, auth, httpMethod), this);
    }

    public UserWapper getListMembers(String uid, String listId, boolean auth) throws WeiboException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseURL()).append(uid).append("/").append(listId).append("/members.xml").append("?source=").append(CONSUMER_KEY);
        String httpMethod = "GET";
        String url = sb.toString();
        return User.constructWapperUsers(this.http.httpRequest(url, null, auth, httpMethod), this);
    }

    public UserWapper getListSubscribers(String uid, String listId, boolean auth) throws WeiboException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseURL()).append(uid).append("/").append(listId).append("/subscribers.xml").append("?source=").append(CONSUMER_KEY);
        String httpMethod = "GET";
        String url = sb.toString();
        return User.constructWapperUsers(this.http.httpRequest(url, null, auth, httpMethod), this);
    }

    public boolean isListMember(String uid, String listId, String targetUid, boolean auth) throws WeiboException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseURL()).append(uid).append("/").append(listId).append("/members/").append(targetUid).append(".xml").append("?source=").append(CONSUMER_KEY);
        String url = sb.toString();
        String httpMethod = "GET";
        Document doc = this.http.httpRequest(url, null, auth, httpMethod).asDocument();
        Element root = doc.getDocumentElement();
        return "true".equals(root.getTextContent());
    }

    public boolean isListSubscriber(String uid, String listId, String targetUid, boolean auth) throws WeiboException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseURL()).append(uid).append("/").append(listId).append("/subscribers/").append(targetUid).append(".xml").append("?source=").append(CONSUMER_KEY);
        String url = sb.toString();
        String httpMethod = "GET";
        Document doc = this.http.httpRequest(url, null, auth, httpMethod).asDocument();
        Element root = doc.getDocumentElement();
        return "true".equals(root.getTextContent());
    }

    public boolean test() throws WeiboException {
        return -1 != this.get(String.valueOf(this.getBaseURL()) + "help/test.json", false).asString().indexOf("ok");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Weibo weibo = (Weibo)o;
        if (!this.baseURL.equals(weibo.baseURL)) {
            return false;
        }
        if (!this.format.equals(weibo.format)) {
            return false;
        }
        if (!this.http.equals(weibo.http)) {
            return false;
        }
        if (!this.searchBaseURL.equals(weibo.searchBaseURL)) {
            return false;
        }
        return this.source.equals(weibo.source);
    }

    public int hashCode() {
        int result = this.http.hashCode();
        result = 31 * result + this.baseURL.hashCode();
        result = 31 * result + this.searchBaseURL.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.format.hashCode();
        return result;
    }

    public String toString() {
        return "Weibo{http=" + this.http + ", baseURL='" + this.baseURL + '\'' + ", searchBaseURL='" + this.searchBaseURL + '\'' + ", source='" + this.source + '\'' + ", format=" + this.format + '}';
    }

    public JSONObject showFriendships(String target_id) throws WeiboException {
        return this.get(String.valueOf(this.getBaseURL()) + "friendships/show.json?target_id=" + target_id, true).asJSONObject();
    }

    public JSONObject showFriendships(String source_id, String target_id) throws WeiboException {
        return this.get(String.valueOf(this.getBaseURL()) + "friendships/show.json?target_id=" + target_id + "&source_id=" + source_id + "&source=" + CONSUMER_KEY, true).asJSONObject();
    }

    public JSONObject register(String ip, String ... args) throws WeiboException {
        return this.http.post(String.valueOf(this.getBaseURL()) + "account/register.json", new PostParameter[]{new PostParameter("nick", args[2]), new PostParameter("gender", args[3]), new PostParameter("password", args[4]), new PostParameter("email", args[5]), new PostParameter("ip", ip)}, true).asJSONObject();
    }

    public Weibo() {
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.http.setRequestTokenURL(String.valueOf(Configuration.getScheme()) + "api.t.sina.com.cn/oauth/request_token");
        this.http.setAuthorizationURL(String.valueOf(Configuration.getScheme()) + "api.t.sina.com.cn/oauth/authorize");
        this.http.setAccessTokenURL(String.valueOf(Configuration.getScheme()) + "api.t.sina.com.cn/oauth/access_token");
    }

    public void setToken(String token, String tokenSecret) {
        this.http.setToken(token, tokenSecret);
    }

    public Weibo(String baseURL) {
        this();
        this.baseURL = baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setSearchBaseURL(String searchBaseURL) {
        this.searchBaseURL = searchBaseURL;
    }

    public String getSearchBaseURL() {
        return this.searchBaseURL;
    }

    private Response get(String url, boolean authenticate) throws WeiboException {
        return this.get(url, null, authenticate);
    }

    protected Response get(String url, String name1, String value1, boolean authenticate) throws WeiboException {
        return this.get(url, new PostParameter[]{new PostParameter(name1, value1)}, authenticate);
    }

    protected Response get(String url, String name1, String value1, String name2, String value2, boolean authenticate) throws WeiboException {
        return this.get(url, new PostParameter[]{new PostParameter(name1, value1), new PostParameter(name2, value2)}, authenticate);
    }

    protected Response get(String url, PostParameter[] params, boolean authenticate) throws WeiboException {
        if (url.indexOf("?") == -1) {
            url = String.valueOf(url) + "?source=" + CONSUMER_KEY;
        } else if (url.indexOf("source") == -1) {
            url = String.valueOf(url) + "&source=" + CONSUMER_KEY;
        }
        if (params != null && params.length > 0) {
            url = String.valueOf(url) + "&" + HttpClient.encodeParameters(params);
        }
        return this.http.get(url, authenticate);
    }

    protected Response get(String url, PostParameter[] params, Paging paging, boolean authenticate) throws WeiboException {
        if (paging != null) {
            ArrayList<PostParameter> pagingParams = new ArrayList<PostParameter>(4);
            if (-1L != paging.getMaxId()) {
                pagingParams.add(new PostParameter("max_id", String.valueOf(paging.getMaxId())));
            }
            if (-1L != paging.getSinceId()) {
                pagingParams.add(new PostParameter("since_id", String.valueOf(paging.getSinceId())));
            }
            if (-1 != paging.getPage()) {
                pagingParams.add(new PostParameter("page", String.valueOf(paging.getPage())));
            }
            if (-1 != paging.getCount()) {
                if (-1 != url.indexOf("search")) {
                    pagingParams.add(new PostParameter("rpp", String.valueOf(paging.getCount())));
                } else {
                    pagingParams.add(new PostParameter("count", String.valueOf(paging.getCount())));
                }
            }
            PostParameter[] newparams = null;
            PostParameter[] arrayPagingParams = pagingParams.toArray(new PostParameter[pagingParams.size()]);
            if (params != null) {
                newparams = new PostParameter[params.length + pagingParams.size()];
                System.arraycopy(params, 0, newparams, 0, params.length);
                System.arraycopy(arrayPagingParams, 0, newparams, params.length, pagingParams.size());
            } else if (arrayPagingParams.length != 0) {
                String encodedParams = HttpClient.encodeParameters(arrayPagingParams);
                url = -1 != url.indexOf("?") ? String.valueOf(url) + "&source=" + CONSUMER_KEY + "&" + encodedParams : String.valueOf(url) + "?source=" + CONSUMER_KEY + "&" + encodedParams;
            }
            return this.get(url, newparams, authenticate);
        }
        return this.get(url, params, authenticate);
    }

    private PostParameter[] generateParameterArray(Map<String, String> parames) throws WeiboException {
        PostParameter[] array = new PostParameter[parames.size()];
        int i = 0;
        for (String key : parames.keySet()) {
            if (parames.get(key) == null) continue;
            array[i] = new PostParameter(key, parames.get(key));
            ++i;
        }
        return array;
    }

    public List<User> getFriends(String id, Paging paging) throws WeiboException {
        return this.getFriendsStatuses(id, paging);
    }

    public List<User> getFriends(String id, int page) throws WeiboException {
        return this.getFriendsStatuses(id, new Paging(page));
    }

    public List<User> getFriends(int page) throws WeiboException {
        return this.getFriendsStatuses(new Paging(page));
    }

    public List<User> getFriends() throws WeiboException {
        return this.getFriendsStatuses();
    }

    public List<User> getFriends(Paging paging) throws WeiboException {
        return this.getFriendsStatuses(paging);
    }

    public List<User> getFriends(String id) throws WeiboException {
        return this.getFriendsStatuses(id);
    }

    public List<User> getFollowers(String id, Paging paging) throws WeiboException {
        return this.getFollowersStatuses(id, paging);
    }

    public List<User> getFollowers(String id, int page) throws WeiboException {
        return this.getFollowersStatuses(id, new Paging(page));
    }

    public List<User> getFollowers() throws WeiboException {
        return this.getFollowersStatuses();
    }

    public List<User> getFollowers(Paging paging) throws WeiboException {
        return this.getFollowersStatuses(paging);
    }

    public List<User> getFollowers(int page) throws WeiboException {
        return this.getFollowersStatuses(new Paging(page));
    }

    public List<User> getFollowers(String id) throws WeiboException {
        return this.getFollowersStatuses(id);
    }

    public List<Status> getPublicTimeline(int sinceID) throws WeiboException {
        return this.getPublicTimeline((long)sinceID);
    }

    public List<Status> getPublicTimeline(long sinceID) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/public_timeline.json", null, new Paging(sinceID), false));
    }

    public List<Status> getFriendsTimelineByPage(int page) throws WeiboException {
        return this.getFriendsTimeline(new Paging(page));
    }

    public List<Status> getFriendsTimeline(int page) throws WeiboException {
        return this.getFriendsTimeline(new Paging(page));
    }

    public List<Status> getFriendsTimeline(long sinceId, int page) throws WeiboException {
        return this.getFriendsTimeline(new Paging(page).sinceId(sinceId));
    }

    public List<Status> getFriendsTimeline(String id) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getFriendsTimelineByPage(String id, int page) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getFriendsTimeline(String id, int page) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getFriendsTimeline(long sinceId, String id, int page) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getFriendsTimeline(String id, Paging paging) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getFriendsTimeline(Date since) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends_timeline.xml", "since", this.format.format(since), true), this);
    }

    public List<Status> getFriendsTimeline(long sinceId) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends_timeline.xml", "since_id", String.valueOf(sinceId), true), this);
    }

    public List<Status> getFriendsTimeline(String id, Date since) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getFriendsTimeline(String id, long sinceId) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getUserTimeline(String id, int count, Date since) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline/" + id + ".xml", "since", this.format.format(since), "count", String.valueOf(count), this.http.isAuthenticationEnabled()), this);
    }

    public List<Status> getUserTimeline(String id, int count, long sinceId) throws WeiboException {
        return this.getUserTimeline(id, new Paging(sinceId).count(count));
    }

    public List<Status> getUserTimeline(String id, Date since) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline/" + id + ".xml", "since", this.format.format(since), this.http.isAuthenticationEnabled()), this);
    }

    public List<Status> getUserTimeline(String id, int count) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline/" + id + ".xml", "count", String.valueOf(count), this.http.isAuthenticationEnabled()), this);
    }

    public List<Status> getUserTimeline(int count, Date since) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline.xml", "since", this.format.format(since), "count", String.valueOf(count), true), this);
    }

    public List<Status> getUserTimeline(int count, long sinceId) throws WeiboException {
        return this.getUserTimeline(new Paging(sinceId).count(count));
    }

    public List<Status> getUserTimeline(String id, long sinceId) throws WeiboException {
        return this.getUserTimeline(id, new Paging(sinceId));
    }

    public List<Status> getUserTimeline(long sinceId) throws WeiboException {
        return this.getUserTimeline(new Paging(sinceId));
    }

    public Status update(String status) throws WeiboException {
        return this.updateStatus(status);
    }

    public Status update(String status, long inReplyToStatusId) throws WeiboException {
        return this.updateStatus(status, inReplyToStatusId);
    }

    public List<Status> getReplies() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/replies.xml", true), this);
    }

    public List<Status> getReplies(long sinceId) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/replies.xml", "since_id", String.valueOf(sinceId), true), this);
    }

    public List<Status> getRepliesByPage(int page) throws WeiboException {
        if (page < 1) {
            throw new IllegalArgumentException("page should be positive integer. passed:" + page);
        }
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/replies.xml", "page", String.valueOf(page), true), this);
    }

    public List<Status> getReplies(int page) throws WeiboException {
        if (page < 1) {
            throw new IllegalArgumentException("page should be positive integer. passed:" + page);
        }
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/replies.xml", "page", String.valueOf(page), true), this);
    }

    public List<Status> getReplies(long sinceId, int page) throws WeiboException {
        if (page < 1) {
            throw new IllegalArgumentException("page should be positive integer. passed:" + page);
        }
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/replies.xml", "since_id", String.valueOf(sinceId), "page", String.valueOf(page), true), this);
    }

    public Status show(int id) throws WeiboException {
        return this.showStatus(id);
    }

    public Status show(long id) throws WeiboException {
        return new Status(this.get(String.valueOf(this.getBaseURL()) + "statuses/show/" + id + ".xml", false), this);
    }

    public User getUserDetail(String id) throws WeiboException {
        return this.showUser(id);
    }

    public User create(String id) throws WeiboException {
        return this.createFriendship(id);
    }

    public User destroy(String id) throws WeiboException {
        return this.destroyFriendship(id);
    }

    public boolean exists(String userA, String userB) throws WeiboException {
        return this.existsFriendship(userA, userB);
    }

    public IDs getFriendsIDs(Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "friends/ids.xml", null, paging, true));
    }

    public IDs getFriendsIDs(int userId, Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "friends/ids.xml?user_id=" + userId, null, paging, true));
    }

    public IDs getFriendsIDs(String screenName, Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "friends/ids.xml?screen_name=" + screenName, null, paging, true));
    }

    public IDs getFollowersIDs(Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "followers/ids.xml", null, paging, true));
    }

    public IDs getFollowersIDs(int userId, Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "followers/ids.xml?user_id=" + userId, null, paging, true));
    }

    public IDs getFollowersIDs(String screenName, Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "followers/ids.xml?screen_name=" + screenName, null, paging, true));
    }

    public User updateLocation(String location) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "account/update_location.xml", new PostParameter[]{new PostParameter("location", location)}, true), this);
    }

    public List<Status> favorites() throws WeiboException {
        return this.getFavorites();
    }

    public List<Status> favorites(int page) throws WeiboException {
        return this.getFavorites(page);
    }

    public List<Status> favorites(String id) throws WeiboException {
        return this.getFavorites(id);
    }

    public List<Status> favorites(String id, int page) throws WeiboException {
        return this.getFavorites(id, page);
    }

    public User follow(String id) throws WeiboException {
        return this.enableNotification(id);
    }

    public User leave(String id) throws WeiboException {
        return this.disableNotification(id);
    }

    public User block(String id) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "blocks/create/" + id + ".xml", true), this);
    }

    public User unblock(String id) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "blocks/destroy/" + id + ".xml", true), this);
    }

    public User getAuthenticatedUser() throws WeiboException {
        return new User(this.get(String.valueOf(this.getBaseURL()) + "account/verify_credentials.xml", true), this);
    }

    public String getDowntimeSchedule() throws WeiboException {
        throw new WeiboException("this method is not supported by the Weibo API anymore", new NoSuchMethodException("this method is not supported by the Weibo API anymore"));
    }

    public List<Trends> getDailyTrends() throws WeiboException {
        return Trends.constructTrendsList(this.get(String.valueOf(this.searchBaseURL) + "trends/daily.json", false));
    }

    public List<Trends> getDailyTrends(Date date, boolean excludeHashTags) throws WeiboException {
        return Trends.constructTrendsList(this.get(String.valueOf(this.searchBaseURL) + "trends/daily.json?date=" + this.toDateStr(date) + (excludeHashTags ? "&exclude=hashtags" : ""), false));
    }

    public List<Trends> getWeeklyTrends() throws WeiboException {
        return Trends.constructTrendsList(this.get(String.valueOf(this.searchBaseURL) + "trends/weekly.json", false));
    }

    public List<Trends> getWeeklyTrends(Date date, boolean excludeHashTags) throws WeiboException {
        return Trends.constructTrendsList(this.get(String.valueOf(this.searchBaseURL) + "trends/weekly.json?date=" + this.toDateStr(date) + (excludeHashTags ? "&exclude=hashtags" : ""), false));
    }

    public void setToken(AccessToken accessToken) {
        this.setToken(accessToken.getToken(), accessToken.getTokenSecret());
    }

    public List<Tag> gettags(String user_id) throws WeiboException {
        return Tag.constructTags(this.http.get(String.valueOf(this.getBaseURL()) + "tags.json?" + "user_id=" + user_id, true));
    }

    public List<Tag> getSuggestions() throws WeiboException {
        return Tag.constructTags(this.get(String.valueOf(this.getBaseURL()) + "tags/suggestions.json", true));
    }

    public List<Status> getFavorites() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "favorites.json", new PostParameter[0], true));
    }

    public List<Status> getFavorites(String id) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "favorites/" + id + ".json", new PostParameter[0], true));
    }

    public List<Status> getFavorites(String id, int page) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "favorites/" + id + ".json", "page", String.valueOf(page), true));
    }

    static class Device {
        final String DEVICE;

        public Device(String device) {
            this.DEVICE = device;
        }
    }
}

