/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import weibo4j.Configuration;
import weibo4j.http.HttpClient;

class WeiboSupport {
    protected HttpClient http = new HttpClient();
    protected String source = Configuration.getSource();
    protected final boolean USE_SSL = Configuration.useSSL();

    WeiboSupport() {
        this(null, null);
    }

    WeiboSupport(String userId, String password) {
        this.setClientVersion(null);
        this.setClientURL(null);
    }

    public void setUserAgent(String userAgent) {
        this.http.setUserAgent(userAgent);
    }

    public String getUserAgent() {
        return this.http.getUserAgent();
    }

    public void setClientVersion(String version) {
        this.setRequestHeader("X-Weibo-Client-Version", Configuration.getCilentVersion(version));
    }

    public String getClientVersion() {
        return this.http.getRequestHeader("X-Weibo-Client-Version");
    }

    public void setClientURL(String clientURL) {
        this.setRequestHeader("X-Weibo-Client-URL", Configuration.getClientURL(clientURL));
    }

    public String getClientURL() {
        return this.http.getRequestHeader("X-Weibo-Client-URL");
    }

    public String getUserId() {
        return this.http.getUserId();
    }

    public String getPassword() {
        return this.http.getPassword();
    }

    public void setHttpProxy(String proxyHost, int proxyPort) {
        this.http.setProxyHost(proxyHost);
        this.http.setProxyPort(proxyPort);
    }

    public void setHttpProxyAuth(String proxyUser, String proxyPass) {
        this.http.setProxyAuthUser(proxyUser);
        this.http.setProxyAuthPassword(proxyPass);
    }

    public void setHttpConnectionTimeout(int connectionTimeout) {
        this.http.setConnectionTimeout(connectionTimeout);
    }

    public void setHttpReadTimeout(int readTimeoutMilliSecs) {
        this.http.setReadTimeout(readTimeoutMilliSecs);
    }

    public void setSource(String source) {
        this.source = Configuration.getSource(source);
        this.setRequestHeader("X-Weibo-Client", this.source);
    }

    public String getSource() {
        return this.source;
    }

    public void setRequestHeader(String name, String value) {
        this.http.setRequestHeader(name, value);
    }

    public void forceUsePost(boolean forceUsePost) {
    }

    public boolean isUsePostForced() {
        return false;
    }

    public void setRetryCount(int retryCount) {
        this.http.setRetryCount(retryCount);
    }

    public void setRetryIntervalSecs(int retryIntervalSecs) {
        this.http.setRetryIntervalSecs(retryIntervalSecs);
    }
}

