/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.http;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartBase;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import weibo4j.Configuration;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.http.AccessToken;
import weibo4j.http.ImageItem;
import weibo4j.http.OAuth;
import weibo4j.http.OAuthToken;
import weibo4j.http.PostParameter;
import weibo4j.http.RequestToken;
import weibo4j.http.Response;

public class HttpClient
implements Serializable {
    private static final int OK = 200;
    private static final int NOT_MODIFIED = 304;
    private static final int BAD_REQUEST = 400;
    private static final int NOT_AUTHORIZED = 401;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int NOT_ACCEPTABLE = 406;
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int BAD_GATEWAY = 502;
    private static final int SERVICE_UNAVAILABLE = 503;
    private static final boolean DEBUG = Configuration.getDebug();
    private int retryCount = Configuration.getRetryCount();
    private int retryIntervalMillis = Configuration.getRetryIntervalSecs() * 1000;
    private String userId = Configuration.getUser();
    private String password = Configuration.getPassword();
    private String proxyHost = Configuration.getProxyHost();
    private int proxyPort = Configuration.getProxyPort();
    private String proxyAuthUser = Configuration.getProxyUser();
    private String proxyAuthPassword = Configuration.getProxyPassword();
    private int connectionTimeout = Configuration.getConnectionTimeout();
    private int readTimeout = Configuration.getReadTimeout();
    private static final long serialVersionUID = 808018030183407996L;
    private static boolean isJDK14orEarlier = false;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private OAuth oauth = null;
    private String requestTokenURL = String.valueOf(Configuration.getScheme()) + "api.t.sina.com.cn/oauth/request_token";
    private String authorizationURL = String.valueOf(Configuration.getScheme()) + "api.t.sina.com.cn/oauth/authorize";
    private String authenticationURL = String.valueOf(Configuration.getScheme()) + "api.t.sina.com.cn/oauth/authenticate";
    private String accessTokenURL = String.valueOf(Configuration.getScheme()) + "api.t.sina.com.cn/oauth/access_token";
    private OAuthToken oauthToken = null;
    private String token = null;

    static {
        try {
            String versionStr = System.getProperty("java.specification.version");
            if (versionStr != null) {
                isJDK14orEarlier = 1.5 > Double.parseDouble(versionStr);
            }
        }
        catch (AccessControlException ace) {
            isJDK14orEarlier = true;
        }
    }

    public HttpClient() {
        this.setUserAgent(null);
        this.setOAuthConsumer(null, null);
        this.setRequestHeader("Accept-Encoding", "gzip");
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAuthenticationEnabled() {
        return this.oauth != null;
    }

    public void setOAuthConsumer(String consumerKey, String consumerSecret) {
        consumerKey = Configuration.getOAuthConsumerKey(consumerKey);
        consumerSecret = Configuration.getOAuthConsumerSecret(consumerSecret);
        if (consumerKey != null && consumerSecret != null && consumerKey.length() != 0 && consumerSecret.length() != 0) {
            this.oauth = new OAuth(consumerKey, consumerSecret);
        }
    }

    public RequestToken setToken(String token, String tokenSecret) {
        this.token = token;
        this.oauthToken = new RequestToken(token, tokenSecret);
        return (RequestToken)this.oauthToken;
    }

    public RequestToken getOAuthRequestToken() throws WeiboException {
        this.oauthToken = new RequestToken(this.httpRequest(this.requestTokenURL, null, true), this);
        return (RequestToken)this.oauthToken;
    }

    public RequestToken getOauthRequestToken(String callback_url) throws WeiboException {
        this.oauthToken = new RequestToken(this.httpRequest(this.requestTokenURL, new PostParameter[]{new PostParameter("oauth_callback", callback_url)}, true), this);
        return (RequestToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(RequestToken token) throws WeiboException {
        try {
            this.oauthToken = token;
            this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[0], true));
        }
        catch (WeiboException te) {
            throw new WeiboException("The user has not given access to the account.", te, te.getStatusCode());
        }
        return (AccessToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(RequestToken token, String pin) throws WeiboException {
        try {
            this.oauthToken = token;
            this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[]{new PostParameter("oauth_verifier", pin)}, true));
        }
        catch (WeiboException te) {
            throw new WeiboException("The user has not given access to the account.", te, te.getStatusCode());
        }
        return (AccessToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(String token, String tokenSecret) throws WeiboException {
        try {
            this.oauthToken = new OAuthToken(token, tokenSecret){};
            this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[0], true));
        }
        catch (WeiboException te) {
            throw new WeiboException("The user has not given access to the account.", te, te.getStatusCode());
        }
        return (AccessToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(String token, String tokenSecret, String oauth_verifier) throws WeiboException {
        try {
            this.oauthToken = new OAuthToken(token, tokenSecret){};
            this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[]{new PostParameter("oauth_verifier", oauth_verifier)}, true));
        }
        catch (WeiboException te) {
            throw new WeiboException("The user has not given access to the account.", te, te.getStatusCode());
        }
        return (AccessToken)this.oauthToken;
    }

    public AccessToken getXAuthAccessToken(String userId, String passWord, String mode) throws WeiboException {
        this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[]{new PostParameter("x_auth_username", userId), new PostParameter("x_auth_password", passWord), new PostParameter("x_auth_mode", mode)}, true));
        return (AccessToken)this.oauthToken;
    }

    public void setOAuthAccessToken(AccessToken token) {
        this.oauthToken = token;
    }

    public void setRequestTokenURL(String requestTokenURL) {
        this.requestTokenURL = requestTokenURL;
    }

    public String getRequestTokenURL() {
        return this.requestTokenURL;
    }

    public void setAuthorizationURL(String authorizationURL) {
        this.authorizationURL = authorizationURL;
    }

    public String getAuthorizationURL() {
        return this.authorizationURL;
    }

    public String getAuthenticationURL() {
        return this.authenticationURL;
    }

    public void setAuthenticationURL(String authenticationURL) {
        this.authenticationURL = authenticationURL;
    }

    public String getAuthenticationRL() {
        return this.authenticationURL;
    }

    public void setAccessTokenURL(String accessTokenURL) {
        this.accessTokenURL = accessTokenURL;
    }

    public String getAccessTokenURL() {
        return this.accessTokenURL;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = Configuration.getProxyHost(proxyHost);
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = Configuration.getProxyPort(proxyPort);
    }

    public String getProxyAuthUser() {
        return this.proxyAuthUser;
    }

    public void setProxyAuthUser(String proxyAuthUser) {
        this.proxyAuthUser = Configuration.getProxyUser(proxyAuthUser);
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String proxyAuthPassword) {
        this.proxyAuthPassword = Configuration.getProxyPassword(proxyAuthPassword);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = Configuration.getConnectionTimeout(connectionTimeout);
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = Configuration.getReadTimeout(readTimeout);
    }

    public void setRetryCount(int retryCount) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("RetryCount cannot be negative.");
        }
        this.retryCount = Configuration.getRetryCount(retryCount);
    }

    public void setUserAgent(String ua) {
        this.setRequestHeader("User-Agent", Configuration.getUserAgent(ua));
    }

    public String getUserAgent() {
        return this.getRequestHeader("User-Agent");
    }

    public void setRetryIntervalSecs(int retryIntervalSecs) {
        if (retryIntervalSecs < 0) {
            throw new IllegalArgumentException("RetryInterval cannot be negative.");
        }
        this.retryIntervalMillis = Configuration.getRetryIntervalSecs(retryIntervalSecs) * 1000;
    }

    public Response post(String url, PostParameter[] postParameters, boolean authenticated) throws WeiboException {
        PostParameter[] newPostParameters = Arrays.copyOf(postParameters, postParameters.length + 1);
        newPostParameters[postParameters.length] = new PostParameter("source", Weibo.CONSUMER_KEY);
        return this.httpRequest(url, newPostParameters, authenticated);
    }

    public Response post(String url, String key, String value, boolean authenticated) throws WeiboException {
        return this.post(url, new PostParameter[]{new PostParameter(key, value)}, authenticated);
    }

    public Response delete(String url, boolean authenticated) throws WeiboException {
        return this.httpRequest(url, null, authenticated, "DELETE");
    }

    private org.apache.commons.httpclient.HttpClient getHttpClient() {
        org.apache.commons.httpclient.HttpClient client = new org.apache.commons.httpclient.HttpClient();
        if (this.proxyHost != null && !this.proxyHost.equals("")) {
            client.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
            client.getParams().setAuthenticationPreemptive(true);
            if (this.proxyAuthUser != null && !this.proxyAuthUser.equals("")) {
                client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.proxyAuthUser, this.proxyAuthPassword));
                HttpClient.log("Proxy AuthUser: " + this.proxyAuthUser);
                HttpClient.log("Proxy AuthPassword: " + this.proxyAuthPassword);
            }
        }
        return client;
    }

    public Response multPartURL(String url, PostParameter[] params, ImageItem item, boolean authenticated) throws WeiboException {
        PostMethod post = new PostMethod(url);
        try {
            org.apache.commons.httpclient.HttpClient client = this.getHttpClient();
            long t = System.currentTimeMillis();
            Part[] parts = null;
            parts = params == null ? new Part[1] : new Part[params.length + 1];
            if (params != null) {
                int i = 0;
                PostParameter[] postParameterArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    PostParameter entry = postParameterArray[n2];
                    parts[i++] = new StringPart(entry.getName(), entry.getValue());
                    ++n2;
                }
                parts[parts.length - 1] = new ByteArrayPart(item.getContent(), item.getName(), item.getContentType());
            }
            post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
            ArrayList<Header> headers = new ArrayList<Header>();
            if (authenticated) {
                String authorization = null;
                if (this.oauth == null) {
                    throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
                }
                authorization = this.oauth.generateAuthorizationHeader("POST", url, params, this.oauthToken);
                headers.add(new Header("Authorization", authorization));
                HttpClient.log("Authorization: " + authorization);
            }
            client.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
            client.executeMethod((HttpMethod)post);
            Response response = new Response();
            response.setResponseAsString(post.getResponseBodyAsString());
            response.setStatusCode(post.getStatusCode());
            HttpClient.log("multPartURL URL:" + url + ", result:" + response + ", time:" + (System.currentTimeMillis() - t));
            Response response2 = response;
            return response2;
        }
        catch (Exception ex) {
            throw new WeiboException(ex.getMessage(), ex, -1);
        }
        finally {
            post.releaseConnection();
        }
    }

    public Response multPartURL(String fileParamName, String url, PostParameter[] params, File file, boolean authenticated) throws WeiboException {
        PostMethod post = new PostMethod(url);
        org.apache.commons.httpclient.HttpClient client = this.getHttpClient();
        try {
            long t = System.currentTimeMillis();
            Part[] parts = null;
            parts = params == null ? new Part[1] : new Part[params.length + 1];
            if (params != null) {
                int i = 0;
                PostParameter[] postParameterArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    PostParameter entry = postParameterArray[n2];
                    parts[i++] = new StringPart(entry.getName(), entry.getValue());
                    ++n2;
                }
            }
            FilePart filePart = new FilePart(fileParamName, file.getName(), file, new MimetypesFileTypeMap().getContentType(file), "UTF-8");
            filePart.setTransferEncoding("binary");
            parts[parts.length - 1] = filePart;
            post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
            ArrayList<Header> headers = new ArrayList<Header>();
            if (authenticated) {
                String authorization = null;
                if (this.oauth == null) {
                    throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
                }
                authorization = this.oauth.generateAuthorizationHeader("POST", url, params, this.oauthToken);
                headers.add(new Header("Authorization", authorization));
                HttpClient.log("Authorization: " + authorization);
            }
            client.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
            client.executeMethod((HttpMethod)post);
            Response response = new Response();
            response.setResponseAsString(post.getResponseBodyAsString());
            response.setStatusCode(post.getStatusCode());
            HttpClient.log("multPartURL URL:" + url + ", result:" + response + ", time:" + (System.currentTimeMillis() - t));
            Response response2 = response;
            return response2;
        }
        catch (Exception ex) {
            throw new WeiboException(ex.getMessage(), ex, -1);
        }
        finally {
            post.releaseConnection();
            client = null;
        }
    }

    public Response post(String url, boolean authenticated) throws WeiboException {
        return this.httpRequest(url, new PostParameter[0], authenticated);
    }

    public Response post(String url, PostParameter[] PostParameters) throws WeiboException {
        return this.httpRequest(url, PostParameters, false);
    }

    public Response post(String url) throws WeiboException {
        return this.httpRequest(url, new PostParameter[0], false);
    }

    public Response get(String url, boolean authenticated) throws WeiboException {
        return this.httpRequest(url, null, authenticated);
    }

    public Response get(String url) throws WeiboException {
        return this.httpRequest(url, null, false);
    }

    protected Response httpRequest(String url, PostParameter[] postParams, boolean authenticated) throws WeiboException {
        int len = 1;
        PostParameter[] newPostParameters = postParams;
        String method = "GET";
        if (postParams != null) {
            method = "POST";
            len = postParams.length + 1;
            newPostParameters = Arrays.copyOf(postParams, len);
            newPostParameters[postParams.length] = new PostParameter("source", Weibo.CONSUMER_KEY);
        }
        return this.httpRequest(url, newPostParameters, authenticated, method);
    }

    public Response httpRequest(String url, PostParameter[] postParams, boolean authenticated, String httpMethod) throws WeiboException {
        int retry = this.retryCount + 1;
        Response res = null;
        int retriedCount = 0;
        while (retriedCount < retry) {
            block25: {
                int responseCode = -1;
                try {
                    HttpURLConnection con = null;
                    OutputStream osw = null;
                    try {
                        con = this.getConnection(url);
                        con.setDoInput(true);
                        this.setHeaders(url, postParams, con, authenticated, httpMethod);
                        if (postParams != null || "POST".equals(httpMethod)) {
                            con.setRequestMethod("POST");
                            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            con.setDoOutput(true);
                            String postParam = "";
                            if (postParams != null) {
                                postParam = HttpClient.encodeParameters(postParams);
                            }
                            HttpClient.log("Post Params: ", postParam);
                            byte[] bytes = postParam.getBytes("UTF-8");
                            con.setRequestProperty("Content-Length", Integer.toString(bytes.length));
                            osw = con.getOutputStream();
                            osw.write(bytes);
                            osw.flush();
                            osw.close();
                        } else if ("DELETE".equals(httpMethod)) {
                            con.setRequestMethod("DELETE");
                        } else {
                            con.setRequestMethod("GET");
                        }
                        res = new Response(con);
                        responseCode = con.getResponseCode();
                        if (DEBUG) {
                            HttpClient.log("Response: ");
                            Map<String, List<String>> responseHeaders = con.getHeaderFields();
                            for (String key : responseHeaders.keySet()) {
                                List<String> values = responseHeaders.get(key);
                                for (String value : values) {
                                    if (key != null) {
                                        HttpClient.log(String.valueOf(key) + ": " + value);
                                        continue;
                                    }
                                    HttpClient.log(value);
                                }
                            }
                        }
                        if (responseCode == 200) break;
                        if (responseCode < 500 || retriedCount == this.retryCount) {
                            throw new WeiboException(String.valueOf(HttpClient.getCause(responseCode)) + "\n" + res.asString(), responseCode);
                        }
                    }
                    finally {
                        try {
                            osw.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException ioe) {
                    if (retriedCount != this.retryCount) break block25;
                    throw new WeiboException(ioe.getMessage(), ioe, responseCode);
                }
            }
            try {
                if (DEBUG && res != null) {
                    res.asString();
                }
                HttpClient.log("Sleeping " + this.retryIntervalMillis + " millisecs for next retry.");
                Thread.sleep(this.retryIntervalMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++retriedCount;
        }
        return res;
    }

    public static String encodeParameters(PostParameter[] postParams) {
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < postParams.length) {
            if (j != 0) {
                buf.append("&");
            }
            try {
                buf.append(URLEncoder.encode(postParams[j].name, "UTF-8")).append("=").append(URLEncoder.encode(postParams[j].value, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            ++j;
        }
        return buf.toString();
    }

    private void setHeaders(String url, PostParameter[] params, HttpURLConnection connection, boolean authenticated, String httpMethod) {
        HttpClient.log("Request: ");
        HttpClient.log(String.valueOf(httpMethod) + " ", url);
        if (authenticated) {
            String authorization = null;
            if (this.oauth == null) {
                throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
            }
            authorization = this.oauth.generateAuthorizationHeader(httpMethod, url, params, this.oauthToken);
            connection.addRequestProperty("Authorization", authorization);
            HttpClient.log("Authorization: " + authorization);
        }
        for (String key : this.requestHeaders.keySet()) {
            connection.addRequestProperty(key, this.requestHeaders.get(key));
            HttpClient.log(String.valueOf(key) + ": " + this.requestHeaders.get(key));
        }
    }

    public void setRequestHeader(String name, String value) {
        this.requestHeaders.put(name, value);
    }

    public String getRequestHeader(String name) {
        return this.requestHeaders.get(name);
    }

    private HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection con = null;
        if (this.proxyHost != null && !this.proxyHost.equals("")) {
            if (this.proxyAuthUser != null && !this.proxyAuthUser.equals("")) {
                HttpClient.log("Proxy AuthUser: " + this.proxyAuthUser);
                HttpClient.log("Proxy AuthPassword: " + this.proxyAuthPassword);
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                            return new PasswordAuthentication(HttpClient.this.proxyAuthUser, HttpClient.this.proxyAuthPassword.toCharArray());
                        }
                        return null;
                    }
                });
            }
            Proxy proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(this.proxyHost, this.proxyPort));
            if (DEBUG) {
                HttpClient.log("Opening proxied connection(" + this.proxyHost + ":" + this.proxyPort + ")");
            }
            con = (HttpURLConnection)new URL(url).openConnection(proxy);
        } else {
            con = (HttpURLConnection)new URL(url).openConnection();
        }
        if (this.connectionTimeout > 0 && !isJDK14orEarlier) {
            con.setConnectTimeout(this.connectionTimeout);
        }
        if (this.readTimeout > 0 && !isJDK14orEarlier) {
            con.setReadTimeout(this.readTimeout);
        }
        return con;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessTokenURL == null ? 0 : this.accessTokenURL.hashCode());
        result = 31 * result + (this.authenticationURL == null ? 0 : this.authenticationURL.hashCode());
        result = 31 * result + (this.authorizationURL == null ? 0 : this.authorizationURL.hashCode());
        result = 31 * result + this.connectionTimeout;
        result = 31 * result + (this.oauth == null ? 0 : this.oauth.hashCode());
        result = 31 * result + (this.oauthToken == null ? 0 : this.oauthToken.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.proxyAuthPassword == null ? 0 : this.proxyAuthPassword.hashCode());
        result = 31 * result + (this.proxyAuthUser == null ? 0 : this.proxyAuthUser.hashCode());
        result = 31 * result + (this.proxyHost == null ? 0 : this.proxyHost.hashCode());
        result = 31 * result + this.proxyPort;
        result = 31 * result + this.readTimeout;
        result = 31 * result + (this.requestHeaders == null ? 0 : this.requestHeaders.hashCode());
        result = 31 * result + (this.requestTokenURL == null ? 0 : this.requestTokenURL.hashCode());
        result = 31 * result + this.retryCount;
        result = 31 * result + this.retryIntervalMillis;
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpClient other = (HttpClient)obj;
        if (this.accessTokenURL == null ? other.accessTokenURL != null : !this.accessTokenURL.equals(other.accessTokenURL)) {
            return false;
        }
        if (this.authenticationURL == null ? other.authenticationURL != null : !this.authenticationURL.equals(other.authenticationURL)) {
            return false;
        }
        if (this.authorizationURL == null ? other.authorizationURL != null : !this.authorizationURL.equals(other.authorizationURL)) {
            return false;
        }
        if (this.connectionTimeout != other.connectionTimeout) {
            return false;
        }
        if (this.oauth == null ? other.oauth != null : !this.oauth.equals(other.oauth)) {
            return false;
        }
        if (this.oauthToken == null ? other.oauthToken != null : !this.oauthToken.equals(other.oauthToken)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.proxyAuthPassword == null ? other.proxyAuthPassword != null : !this.proxyAuthPassword.equals(other.proxyAuthPassword)) {
            return false;
        }
        if (this.proxyAuthUser == null ? other.proxyAuthUser != null : !this.proxyAuthUser.equals(other.proxyAuthUser)) {
            return false;
        }
        if (this.proxyHost == null ? other.proxyHost != null : !this.proxyHost.equals(other.proxyHost)) {
            return false;
        }
        if (this.proxyPort != other.proxyPort) {
            return false;
        }
        if (this.readTimeout != other.readTimeout) {
            return false;
        }
        if (this.requestHeaders == null ? other.requestHeaders != null : !this.requestHeaders.equals(other.requestHeaders)) {
            return false;
        }
        if (this.requestTokenURL == null ? other.requestTokenURL != null : !this.requestTokenURL.equals(other.requestTokenURL)) {
            return false;
        }
        if (this.retryCount != other.retryCount) {
            return false;
        }
        if (this.retryIntervalMillis != other.retryIntervalMillis) {
            return false;
        }
        if (this.token == null ? other.token != null : !this.token.equals(other.token)) {
            return false;
        }
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }

    private static void log(String message) {
        if (DEBUG) {
            System.out.println("[" + new Date() + "]" + message);
        }
    }

    private static void log(String message, String message2) {
        if (DEBUG) {
            HttpClient.log(String.valueOf(message) + message2);
        }
    }

    private static String getCause(int statusCode) {
        String cause = null;
        switch (statusCode) {
            case 304: {
                break;
            }
            case 400: {
                cause = "The request was invalid.  An accompanying error message will explain why. This is the status code will be returned during rate limiting.";
                break;
            }
            case 401: {
                cause = "Authentication credentials were missing or incorrect.";
                break;
            }
            case 403: {
                cause = "The request is understood, but it has been refused.  An accompanying error message will explain why.";
                break;
            }
            case 404: {
                cause = "The URI requested is invalid or the resource requested, such as a user, does not exists.";
                break;
            }
            case 406: {
                cause = "Returned by the Search API when an invalid format is specified in the request.";
                break;
            }
            case 500: {
                cause = "Something is broken.  Please post to the group so the Weibo team can investigate.";
                break;
            }
            case 502: {
                cause = "Weibo is down or being upgraded.";
                break;
            }
            case 503: {
                cause = "Service Unavailable: The Weibo servers are up, but overloaded with requests. Try again later. The search and trend methods use this to indicate when you are being rate limited.";
                break;
            }
            default: {
                cause = "";
            }
        }
        return String.valueOf(statusCode) + ":" + cause;
    }

    private static class ByteArrayPart
    extends PartBase {
        private byte[] mData;
        private String mName;

        public ByteArrayPart(byte[] data, String name, String type) throws IOException {
            super(name, type, "UTF-8", "binary");
            this.mName = name;
            this.mData = data;
        }

        protected void sendData(OutputStream out) throws IOException {
            out.write(this.mData);
        }

        protected long lengthOfData() throws IOException {
            return this.mData.length;
        }

        protected void sendDispositionHeader(OutputStream out) throws IOException {
            super.sendDispositionHeader(out);
            StringBuilder buf = new StringBuilder();
            buf.append("; filename=\"").append(this.mName).append("\"");
            out.write(buf.toString().getBytes());
        }
    }
}

