/*
 * Copyright 2003-2005 the original author or authors.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.jdon.jivejdon.model.auth;

/**
 * in jivejdon_permisision.xml must be same as this class's role value  
 * @author <a href="mailto:banqJdon<AT>jdon.com">banq</a>
 * @see jivejdon_permission.xml
 * @see web.xml
 *  <security-role>
    <description>administrator</description>
    <role-name>Admin</role-name>
  </security-role>
   <security-role>
    <description>register user</description>
    <role-name>User</role-name>
 * 
 * 
 */

public interface Role {
    
    /**
     * Administrator
     */
    String ADMIN = "Admin";
    
    /**
     * register user
     */
    String USER = "User";
    
    String MODERATOR ="Moderator";
    
    String ANONYMOUS = "Anonymous";

}
