/*
 * Copyright 2003-2005 the original author or authors.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.jdon.jivejdon.presentation.action;

import javax.servlet.http.HttpServletRequest;

import com.jdon.controller.WebAppUtil;
import com.jdon.controller.model.PageIterator;
import com.jdon.jivejdon.model.Forum;
import com.jdon.jivejdon.presentation.action.util.ForumEtagFilterList;
import com.jdon.jivejdon.service.ForumService;

/**
 * @author <a href="mailto:banq@163.com">banq</a>
 * 
 */
public class ForumListAction extends ForumEtagFilterList {

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.jdon.strutsutil.ModelListAction#getPageIterator(javax.servlet.http.HttpServletRequest,
	 *      int, int)
	 */
	public PageIterator getPageIterator(HttpServletRequest request, int start, int count) {
		ForumService forumService = (ForumService) WebAppUtil.getService("forumService", request);
		return forumService.getForums(start, count);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.jdon.strutsutil.ModelListAction#findModelByKey(javax.servlet.http.HttpServletRequest,
	 *      java.lang.Object)
	 */
	public Object findModelIFByKey(HttpServletRequest request, Object key) {
		ForumService forumService = (ForumService) WebAppUtil.getService("forumService", request);
		Forum forum = forumService.getForum((Long) key);
		return forum;
	}

}
