/*
 * Copyright 2003-2009 the original author or authors.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.jdon.jivejdon.repository;

import com.jdon.controller.model.PageIterator;
import com.jdon.jivejdon.model.Account;
import com.jdon.jivejdon.model.ShortMessage;

public interface ShortMessageRepository {

	public abstract void updateShortMessage(ShortMessage msg) throws Exception;

	public abstract void deleteShortMessage(ShortMessage msg) throws Exception;

	public abstract void deleteUserAllShortMessage(String userId) throws Exception;

	public abstract void deleteUserRecAllShortMessage(String username) throws Exception;

	public abstract PageIterator getShortMessages(int start, int count, Long userId);

	public abstract PageIterator getReceiveShortMessages(int start, int count, Account account);

	public abstract PageIterator getSendShortMessages(int start, int count, Account account);

	public abstract PageIterator getSaveShortMessages(int start, int count, Account account);

}