<%
'==========================================
'文 件 名：Cls_Fso.asp
'文件用途：常规函数类
'系统名称：方卡企业建站系统
'系统开发：方卡工作室
'技术支持：http://www.fangka.net/
'技 术 QQ：861118936
'联系邮箱：fangka@vip.qq.com
'==========================================

Class Cls_Fso
	'==============================
	'函 数 名：FsoLineWrite
	'作    用：按行写入文件
	'参    数：文件相对路径FilePath，写入行号LineNum，写入内容LineContent
	'==============================
	Function FsoLineWrite(FilePath,LineNum,LineContent)
		If LineNum<1 Then Exit Function
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		If Not Fso.FileExists(Server.MapPath(FilePath)) Then Exit Function
		Temp=FsoFileRead(FilePath)
		TempArr=Split(Temp,Chr(13)&Chr(10))
		TempArr(LineNum-1)=LineContent
		Temp=Join(TempArr,Chr(13)&Chr(10))
		Call CreateFile(FilePath,Temp)
		Set Fso=Nothing
	End Function
	
	'==============================
	'函 数 名：FsoFileRead
	'作    用：读取文件
	'参    数：文件相对路径FilePath
	'==============================
	Function FsoFileRead(FilePath) 
		Set objAdoStream = Server.CreateObject("A"&"dod"&"b.St"&"r"&"eam")
		If Err.Number=-2147221005 Then 
			Response.Write "方卡错误提示：服务器不支持ADODB.Stream"
			Err.Clear
			Response.End
		End If
		With objAdoStream
			.type=2
			.mode=3
			.Charset = "utf-8"
			.Open
			.LoadFromFile Server.MapPath(FilePath)
			.Position = 2 
			FsoFileRead=.ReadText
		End With
		objAdoStream.Close
		Set objAdoStream=Nothing
	End Function
	
	'==============================
	'函 数 名：CreateFolder
	'作    用：创建文件夹
	'参    数：文件夹相对路径FolderPath
	'==============================
	Function CreateFolder(FolderPath)
'		On Error Resume Next
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		Set F=Fso.CreateFolder(Server.MapPath(FolderPath))
		CreateFolder=F.Path
		Set F=Nothing
		Set Fso=Nothing
'		Select Case Err
'			Case 424 Response.Write("方卡错误提示：创建"&FolderPath&"文件夹时，路径未找到或者该目录没有写入权限！")
'		End Select
	End Function
	
	'==============================
	'函 数 名：CreateFile
	'作    用：创建文件
	'参    数：文件相对路径FilePath，文件内容FileContent
	'==============================
	Function CreateFile(FilePath,FileContent)
'		On Error Resume Next
		Dim Temps
		Temps=""
		TempArr=Split(FilePath,"/")
		For i=0 to UBound(TempArr)-1
			If Temps="" Then
				Temps=TempArr(i)
			Else
				Temps=Temps&"/"&TempArr(i)
			End If
			If IsFolder(Temps)=False Then
				Call CreateFolder(Temps)
			End If
		Next
		Set objAdoStream = Server.CreateObject("A"&"dod"&"b.St"&"r"&"eam")
		objAdoStream.Type = 2
		objAdoStream.Charset = "UTF-8" 
		objAdoStream.Open
		objAdoStream.WriteText = FileContent
		objAdoStream.SaveToFile Server.MapPath(FilePath),2
		objAdoStream.Close()
		Set objAdoStream = Nothing
'		Select Case Err       
'			 Case 424 Response.Write("方卡错误提示：创建"&FilePath&"文件时，路径未找到或者该目录没有写入权限！")
'		End Select
	End Function
	
	'==============================
	'函 数 名：DelFolder
	'作    用：删除文件夹
	'参    数：文件夹相对路径FolderPath
	'==============================
	Function DelFolder(FolderPath)
		If IsFolder(FolderPath)=True Then
			Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
			Fso.DeleteFolder(Server.MapPath(FolderPath))
			Set Fso=Nothing
		End If 
'		Select Case Err      
'			 Case 424 Response.Write("方卡错误提示：删除"&FolderPath&"文件夹时，路径未找到或者该目录没有写入权限！")
'		End Select
	End Function 
	
	'==============================
	'函 数 名：DelFile
	'作    用：删除文件
	'参    数：文件相对路径FilePath
	'==============================
	Function DelFile(FilePath)
'		On Error Resume Next
		If IsFile(FilePath)=True Then 
			Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
			Fso.DeleteFile(Server.MapPath(FilePath))
			Set Fso=Nothing
		End If
'		Select Case Err      
'			 Case 424 Response.Write("方卡错误提示：删除"&FilePath&"文件时，路径未找到或者该目录没有写入权限！")
'		End Select
	End Function 
	 
	'==============================
	'函 数 名：IsFile
	'作    用：检测文件是否存在
	'参    数：文件相对路径FilePath
	'==============================
	Function IsFile(FilePath) 
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		If (Fso.FileExists(Server.MapPath(FilePath))) Then
			IsFile=True
		Else
			IsFile=False
		End If
		Set Fso=Nothing
	End Function
	
	'==============================
	'函 数 名：IsFolder
	'作    用：检测文件夹是否存在
	'参    数：文件相对路径FolderPath
	'==============================
	Function IsFolder(FolderPath)
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		If Fso.FolderExists(Server.MapPath(FolderPath)) Then  
			IsFolder=True
		Else
			IsFolder=False
		End If
		Set Fso=Nothing
	End Function
	
	'==============================
	'函 数 名：CopyFiles
	'作    用：复制文件
	'参    数：文件来源地址SourcePath，文件复制到地址CopyToPath
	'==============================
	Function CopyFiles(SourcePath,CopyToPath)
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		 Fso.CopyFile Server.MapPath(SourcePath),Server.MapPath(CopyToPath)
		 Set Fso=nothing
	End Function
	
	'==============================
	'函 数 名：SaveRemoteFile
	'作    用：保存远程图片
	'参    数：图片来源网址SourceUrl，图片保存地址SavePath
	'==============================
	Sub SaveRemoteFile(SourceUrl,SavePath)
		On Error Resume Next
		Set Temp = Server.CreateObject("Mic"&"roso"&"ft.XML"&"HT"&"TP")
		With Temp
			.Open "Get", SourceUrl, False, "", ""
			.Send
			If Err.number<>0 Then
				Exit Sub
			End If
			F = .ResponseBody
		End With
		Set Temp = Nothing
		Set objAdoStream = Server.CreateObject("A"&"dod"&"b.St"&"r"&"eam")
		With objAdoStream
			.Type = 1
			.Open
			.Write F
			.SaveToFile Server.MapPath(SavePath), 2
			.Cancel()
			.Close()
		End With
		Set objAdoStream=nothing
	End Sub
End Class
%>
