<%
'==========================================
'文 件 名：Cls_Get.asp
'文件用途：内容采集函数类
'系统名称：方卡美女图片小偷Z1版
'系统开发：方卡工作室
'技术支持：http://www.fangka.net/
'技 术 QQ：861118936
'联系邮箱：fangka@vip.qq.com
'==========================================

Class Cls_Get
	Private Codes2
'========================内容整合区===========================
	'==============================
	'函 数 名：GetPicList
	'作    用：获取图片列表
	'参    数：
	'==============================
	Public Function GetPicList(Codes)
		'基础处理
		Codes=GetPicListContent(Codes)
		
		'获取图片列表
		PageCodes=Codes
		Temp=GetPicListPhoto(PageCodes)
		FKPicPhoto=Split(Temp,"||")
		
		'获取标题列表
		PageCodes=Codes
		Temp=GetPicListTitle(PageCodes)
		FKPicTitle=Split(Temp,"||")
		
		'获取链接列表
		PageCodes=Codes
		Temp=GetPicListUrl(PageCodes)
		FKPicUrl=Split(Temp,"||")
	
		'获取今日更新数量
		PageCodes=Codes
		FkTodayCount=GetTodayCount(PageCodes)
		
		'获取总页数
		PageCodes=Codes
		FKAllPageCount=GetAllPageCount(PageCodes)
	End Function
	
	'==============================
	'函 数 名：GetPic
	'作    用：获取图片展示内容
	'参    数：
	'==============================
	Public Function GetPic(Codes)
		'获取标题
		PageCodes=Codes
		FKPicTitle=GetPicTitle(PageCodes)
		
		'获取图片
		PageCodes=Codes
		FKPicPhoto=GetPicPhoto(PageCodes)
		
		'获取上一篇信息
		PageCodes=Codes
		Temp=Split(GetPrev(PageCodes),"||")
		PrevTitle=Temp(1)
		If PrevTitle<>"没有了" Then
			PrevUrl="Show.asp?Id="&Temp(0)
		Else
			PrevUrl="Index.asp"
		End If
		
		'获取下一篇信息
		PageCodes=Codes
		Temp=Split(GetNext(PageCodes),"||")
		NextTitle=Temp(1)
		NextUrl="Show.asp?Id="&Temp(0)
	End Function
	
'========================内容分离区===========================
	'==============================
	'函 数 名：GetPicListContent
	'作    用：获取图片列表有效区域
	'参    数：
	'==============================
	Private Function GetPicListContent(Codes)
		Codes=Split(Codes,"<div class=""d3"">")(1) '去除前部无用代码
		Codes=Split(Codes,"</div>")(0) '去除后部无用代码
		GetPicListContent=Codes
	End Function

	'==============================
	'函 数 名：GetPicListPhoto
	'作    用：获取图片列表缩略图
	'参    数：
	'==============================
	Private Function GetPicListPhoto(Codes)
		Codes=RegExpTest("src=.*? />", Codes)
		Codes=Replace(Codes,"src=","")
		Codes=Replace(Codes," />","")
		TempArr=Split(Codes,"||")
		Codes2=""
		For Each Temp In TempArr
			If Temp<>"" Then
				If Codes2="" Then
					Codes2=Temp
				Else
					Codes2=Codes2&"||"&Temp
				End If
			End If
		Next
		GetPicListPhoto=Codes2
	End Function
	
	'==============================
	'函 数 名：GetPicListTitle
	'作    用：获取图片列表标题
	'参    数：
	'==============================
	Private Function GetPicListTitle(Codes)
		Codes=RegExpTest("/></a><br />.*?</a></li>", Codes)
		Codes=RegExpTest("target=_blank>.*?</a></li>", Codes)
		Codes=Replace(Codes,"target=_blank>","")
		Codes=Replace(Codes,"</a></li>","")
		TempArr=Split(Codes,"||")
		Codes2=""
		For Each Temp In TempArr
			If Temp<>"" Then
				If Codes2="" Then
					Codes2=Temp
				Else
					Codes2=Codes2&"||"&Temp
				End If
			End If
		Next
		GetPicListTitle=Codes2
	End Function
	
	'==============================
	'函 数 名：GetPicListUrl
	'作    用：获取图片列表链接
	'参    数：
	'==============================
	Private Function GetPicListUrl(Codes)
		Codes=RegExpTest("href=\.\./.*? target=_blank", Codes)
		Codes=Replace(Codes,"href=../Disp/","")
		Codes=Replace(Codes,".htm target=_blank","")
		TempArr=Split(Codes,"||")
		Codes2=""
		i=1
		For Each Temp In TempArr
			If Temp<>"" Then
				If Codes2="" and (i Mod 2)=0 Then
					Codes2="Show.asp?Id="&Temp
				ElseIf (i Mod 2)=0 Then
					Codes2=Codes2&"||"&"Show.asp?Id="&Temp
				End If
				i=i+1
			End If
		Next
		GetPicListUrl=Codes2
	End Function
	
	'==============================
	'函 数 名：GetTodayCount
	'作    用：获取今日更新数量
	'参    数：
	'==============================
	Private Function GetTodayCount(Codes)
		Codes=RegExpTest("今日更新 <strong>.*?</strong>", Codes)
		Codes=Replace(Codes,"今日更新 <strong>","")
		Codes=Replace(Codes,"</strong>||","")
		GetTodayCount=Codes
	End Function
	
	'==============================
	'函 数 名：GetAllPageCount
	'作    用：获取总页数
	'参    数：
	'==============================
	Private Function GetAllPageCount(Codes)
		Codes=RegExpTest("/ <strong>.*?</strong>", Codes)
		Codes=Replace(Codes,"/ <strong>","")
		Codes=Replace(Codes,"</strong>||","")
		GetAllPageCount=Codes
	End Function

	'==============================
	'函 数 名：GetPicTitle
	'作    用：获取图片标题
	'参    数：
	'==============================
	Function GetPicTitle(Codes)
		Codes=RegExpTest("		<strong>.*?</strong>", Codes)
		Codes=Replace(Codes,"		<strong>","")
		Codes=Replace(Codes,"</strong>||","")
		GetPicTitle=Codes
	End Function

	'==============================
	'函 数 名：GetPicPhoto
	'作    用：获取内容图片
	'参    数：
	'==============================
	Function GetPicPhoto(Codes)
		Dim TempCode
		TempCode=Codes
		Codes=RegExpTest("<img src="".*?"" alt=""", Codes)
		Codes=Replace(Codes,"<img src=""","")
		Codes=Replace(Codes,""" alt=""","")
		TempArr=Split(Codes,"||")
		Codes2=""
		For Each Temp In TempArr
			If Temp<>"" Then
				If Codes2="" Then
					Codes2=Temp
				Else
					Codes2=Codes2&"||"&Temp
				End If
			End If
		Next
		If Codes2="" Then
			Codes=RegExpTest("<div class=""d2"">(.|\n)*?	</div>", TempCode)
			Codes=Replace(Codes,"<div class=""d2"">","")
			Codes=Replace(Codes,"	</div>||","")
			GetPicPhoto=Codes
		Else
			GetPicPhoto=Codes2
		End If
	End Function

	'==============================
	'函 数 名：GetPrev
	'作    用：获取上一篇
	'参    数：
	'==============================
	Function GetPrev(Codes)
		Codes=RegExpTest("上一篇：<a href=.*?</a>", Codes)
		Codes=Replace(Codes,"上一篇：<a href='","")
		Codes=Replace(Codes,"</a>||","")
		If Instr(Codes,"没有了") Then
			Temp=Split(Codes,".htm'>")
		Else
			Temp=Split(Split(Codes,"href='")(1),".htm'>")
		End If
		Codes=Temp(0)&"||"&Temp(1)
		GetPrev=Codes
	End Function
	
	'==============================
	'函 数 名：GetNext
	'作    用：获取下一篇
	'参    数：
	'==============================
	Function GetNext(Codes)
		Codes=RegExpTest("下一篇：<a href=.*?'>.*?</a>", Codes)
		Codes=Replace(Codes,"下一篇：<a href='","")
		Codes=Replace(Codes,"</a>||","")
		If Instr(Codes,"没有了") Then
			Temp=Split(Codes,".htm'>")
		Else
			Temp=Split(Split(Codes,"href='")(1),".htm'>")
		End If
		Codes=Temp(0)&"||"&Temp(1)
		GetNext=Codes
	End Function
	
'========================采集函数区===========================
	'==============================
	'函 数 名：GetHttpPage
	'作    用：获取页面源代码函数
	'参    数：采集链接HttpUrl
	'==============================	
	Public Function GetHttpPage(HttpUrl)
		If IsNull(HttpUrl)=True Then
			Response.Write("请输入网址！")
			Exit Function
		End If
		On Error Resume Next
		Dim Http
		Set Http=Server.CreateObject("MSX"&"ML2.XML"&"HTTP")
		Http.Open "GET",HttpUrl,False
		Http.Send()
		If Err Then
			Err.clear
			Response.Write(SiteCloseStr)
			Response.End()
		End If
		If Http.Readystate<>4 then
			Set Http=Nothing
			Response.Write("该网页无法访问！")
			Exit function
		End if
		GetHttpPage=BytesToBSTR(Http.responseBody,"GB2312")
		Set Http=Nothing
		If Err.number<>0 then
			Err.Clear
		End If
	End Function
	
	'==============================
	'函 数 名：BytesToBstr
	'作    用：转换编码函数
	'参    数：解码字符串Body，编码Cset
	'==============================	
	Private Function BytesToBstr(Body,Cset)
		Set objAdoStream = Server.CreateObject("adod"&"b.stream")
		objAdoStream.Type = 1
		objAdoStream.Mode =3
		objAdoStream.Open
		objAdoStream.Write body
		objAdoStream.Position = 0
		objAdoStream.Type = 2
		objAdoStream.Charset = Cset
		BytesToBstr = objAdoStream.ReadText 
		objAdoStream.Close
		Set objAdoStream = Nothing
	End Function
	
	'==============================
	'函 数 名：RegExpTest
	'作    用：正则表达式
	'参    数：
	'==============================	
	Private Function RegExpTest(patrn, strng)
		Dim regEx, Matchs, Matches, RetStr
		Set regEx = New RegExp 
		regEx.Pattern = patrn 
		regEx.IgnoreCase = True
		regEx.Global = True
		Set Matches = regEx.Execute(strng) 
		For Each Matchs in Matches
			RetStr = RetStr & Matchs.Value & "||"
		Next 
		RegExpTest = RetStr 
	End Function 
End Class
%>
