/*
 * Simplpan Admin Panel
 * Copyright (c) 2011 Kasper Kismul
 * http://themeforest.net/user/Kaasper/profile
 * This file configures all the different jQuery scripts used in the Simplpan Admin Panel template. 
 */

//-------------------------------------------------------------- */
// Inserts "v"'s for dropdowns before documment load
//-------------------------------------------------------------- */
$("<span class='v'></span>").insertBefore("#userpanel ul.dropdown ul.subnav");
$("<span class='v'></span>").insertAfter("ul#navigation.dropdown ul.subnav");

//-------------------------------------------------------------- */
// When document is loaded, load custom jQuery
//-------------------------------------------------------------- */
(function($){
  $(document).ready(function(){

//-------------------------------------------------------------- */
// Dropdown z-index Fix for IE7 (Added in 1.2)
//-------------------------------------------------------------- */
  $(function() {
    var zIndexNumber = 1000;
    $('.ie7 #wrap div').each(function() {
      $(this).css('zIndex', zIndexNumber);
      zIndexNumber -= 10;
    });
  });

/* End - Added in 1.2 */

//-------------------------------------------------------------- */
//
//   **** Graphs, Bars, Pie (Visualize) **** 
//
//   For more information go to:
//  http://www.filamentgroup.com/lab/update_to_jquery_visualize_accessible_charts_with_html5_from_designing_with/
//
//-------------------------------------------------------------- */
/*
@import vGraphs.js
*/
  
//-------------------------------------------------------------- */
// Box Slider
//-------------------------------------------------------------- */
  // When top box is clicked, it slides up
  $(".box_top h2").click(function(){
    $(this).toggleClass("toggle_closed").parent().next().slideToggle("slow");
    return false; //Prevent the browser jump to the link anchor
  }); 

//-------------------------------------------------------------- */
//
//   **** Accordion (jQuery UI) **** 
//
//   For more information go to:
//  http://jqueryui.com/demos/
//
//-------------------------------------------------------------- */
  $( ".accordion" ).accordion();

//-------------------------------------------------------------- */
// Box Tabs
//-------------------------------------------------------------- */
  $('div.tabs').each(function() {
    var $tabs_name = $(this);
    // If there is a tab, find the active
    if ($(this).parent().prev().children('ul.sorting').length) {
      // Sorting shortcut
      var $tabs_tabs = $(this).parent().prev().children('ul.sorting');
      // If it active, then show it
      if ($($tabs_tabs).children().children('a').hasClass('active')) {
        // Finds the href and removes the #
        var $stats_type = $($tabs_tabs).children().find('.active').attr('href');
        $($tabs_tabs).children().children('a').each(function() {
          var $tab_names = $(this).attr('href');
          // Hides all
          $($tabs_name).find($tab_names).hide();
        });
        $($tabs_name).find($stats_type).show();
      };
      // When one of the tabs are clicked
      $($tabs_tabs).children().children('a').click(function(){
        $($tabs_tabs).children().children('a').each(function() {
          var $tab_names = $(this).attr('href');
          // Hides all
          $($tabs_name).find($tab_names).hide();
        });
        // The href without #
        var $tabs_tabs_type = $(this).attr('href');
        // Fades inn the one thats clicked
        $($tabs_name).parent().find($tabs_tabs_type).fadeIn('slow');
        // Removes 'active' class
        $($tabs_tabs).children().children('a').removeClass('active');
        // Adds active state to the one you clicked
        $(this).addClass('active');
        return false; //Prevent the browser jump to the link anchor
      }); 
    };  
    
  });

//-------------------------------------------------------------- */
//
//   **** Table Sorting (DataTables) **** 
//
//   For more information go to:
//  http://www.datatables.net/
//
//-------------------------------------------------------------- */

  // Table Sorting with every feature (search, pagination..)
  $('table.sorting').dataTable( {
    "sPaginationType": "full_numbers",
    "bAutoWidth": false
  } );
  
  // Table Sorting with only pagination
  $('table.simple_sorting').dataTable( {
    "sPaginationType": "full_numbers",
    "bFilter": false,
    "bLengthChange": false,
    "bSort": false,
    "bSortClasses": false,
    "bAutoWidth": false
  } );
  
  // Removes sorting information if there are table actions due to space issues
  if ($('.table_actions')) {
    $('.table_actions').each(function() {
      $(this).parent().find('.dataTables_info').hide();
    });  
  };

//-------------------------------------------------------------- */
//
//   **** Popups (Facebox) **** 
//
//   For more information go to:
//  http://defunkt.io/facebox/
//
//-------------------------------------------------------------- */
  $('.popup').facebox();

//-------------------------------------------------------------- */
//
//   **** Tips (Poshytip) **** 
//
//   For more information go to:
//  http://vadikom.com/demos/poshytip/
//
//-------------------------------------------------------------- */

  // Tip for home icon etc.
  $('.tip').poshytip({
    className: 'tip-theme',
    showTimeout: 1,
    alignTo: 'target',
    alignX: 'center',
    alignY: 'bottom',
    offsetX: 0,
    offsetY: 16,
    allowTipHover: false,
    fade: false,
    slide: false
  });
  
  // Tip that stays
  $('.tip-stay').poshytip({
    className: 'tip-theme',
    showOn:'focus',
    showTimeout: 1,
    alignTo: 'target',
    alignX: 'center',
    alignY: 'bottom',
    offsetX: 0,
    offsetY: 16,
    allowTipHover: false,
    fade: false,
    slide: false
  });

//-------------------------------------------------------------- */
// Removal of notice boxes when pressed
//-------------------------------------------------------------- */
  $("div.notice, p.error, p.warning, p.info, p.note, p.success").click(function() { 
    $(this).fadeOut('slow');
  });   

//-------------------------------------------------------------- */
//
//   **** Datepicker (jQuery UI) **** 
//
//   For more information go to:
//  http://jqueryui.com/demos/
//
//-------------------------------------------------------------- */
  $("input.date").datepicker();
  $(".inlinedate").datepicker();

//-------------------------------------------------------------- */
// Validation
//-------------------------------------------------------------- */
  // Validator function
  function validation(){
    // Does the validation on blur (when you go to off the input field)
    $(".validate").blur(function () {
      // If something is not typed, error icon
      if ($(this).val() === ""){
        $(this).removeClass("validate_success");
          $(this).addClass("validate_error");
          return false;
      }
      // If something is typed, success icon
      else {
        $(this).removeClass("validate_error");
          $(this).addClass("validate_success");
          return true;
      };
    });
  };
  // Calls the validator function when focusing on an input field
  $(".validate").focus(function () {
        return validation();
  });
  

//-------------------------------------------------------------- */
// Drop Downs
//-------------------------------------------------------------- */
// User Panel Dropdown
  
  // When hovering over a ul element with "dropdown" class
  $("#userpanel ul.dropdown").hover(function() { 
    // Sets the top text as active (the dropdown)
    $(this).find(".top").addClass("active");
    // Slides the "subnav" on hover
    $(this).find("ul.subnav").show();
    // Shows the white 'v'
    $(this).find("span.v").addClass("active");
    // On hover off
    $(this).hover(function() {  
    }, function(){  
      // Hides the subnavigation when isn't on the "subnav" anymore
      $(this).find("ul.subnav").stop(false, true).hide(); 
      // Removes top text as active (the dropdown)
      $(this).find(".top").removeClass("active");
      // Hides the white 'v'
      $(this).find("span.v").removeClass("active");
    });  
  });  

// Navigation Dropdown
  // When hovering over a ul element with "dropdown" class
  $("ul#navigation.dropdown li.topnav").hover(function() { 
    // Copys the navigation name and the "v" icon to the top of the dropdown
    $(this).clone().prependTo("ul#navigation.dropdown .subnav");
    $("ul#navigation.dropdown .subnav .subnav").remove();  
    // Slides the "subnav" on hover
    $(this).find("ul.subnav").show();
    // On hover off
    $("ul#navigation.dropdown ul.subnav").parent().hover(function() {  
    }, function(){  
      // Hides the subnavigation when isn't on the "subnav" anymore
      $(this).find("ul.subnav").stop(false, true).hide(); 
      // Removes the top part to prevent duplication
      $("ul#navigation.dropdown .subnav .topnav").remove();
    });  
  });  
 
//-------------------------------------------------------------- */
// Gallery Actions
//-------------------------------------------------------------- */
  function galleryActions(){
    // When hovering over gallery li element
    $("ul.gallery li").hover(function() { 
      var $image = (this);
      // Shows actions when hovering
      $(this).find(".actions").show();
      // If the "x" icon is pressed, show confirmation (#dialog-confirm)
      $(this).find(".actions .delete").click(function () {
        // Confirmation
        $( "#dialog-confirm" ).dialog({
          resizable: false,
          modal: true,
          minHeight: 0,
          draggable: false,
          buttons: {
            "Delete": function() {
              $( this ).dialog( "close" );
              // Removes image if delete is pressed
              $($image).fadeOut('slow', function() { 
                $($image).remove(); 
              });
            },
            // Removes dialog if cancel is pressed
            Cancel: function() {
              $( this ).dialog( "close" );
            }
          }
        });
        return false;
        });
      
      // Changes opacity of the image
      $(this).find("img").css("opacity","0.5");
      // On hover off
      $(this).hover(function() {  
      }, function(){  
        // Hides actions when hovering off
        $(this).find(".actions").hide();
        // Changes opacity of the image back to normal
        $(this).find("img").css("opacity","1");
      });  
    }); 
  };
  galleryActions();

//-------------------------------------------------------------- */
//
//   **** Gallery Sorting (Quicksand) **** 
//
//   For more information go to:
//  http://razorjack.net/quicksand/
//
//-------------------------------------------------------------- */
$('ul.gallery').each(function() {
    // get the action filter option item on page load
    var $fileringType = $("ul.sorting li.active a[data-type]").first().before(this);
    var $filterType = $($fileringType).attr('data-id');
    var $gallerySorting = $(this).parent().prev().children('ul.sorting');
    // get and assign the ourHolder element to the
    // $holder varible for use later
    var $holder = $(this);
    // clone all items within the pre-assigned $holder element
    var $data = $holder.clone();
    // attempt to call Quicksand when a filter option
    // item is clicked
    $($gallerySorting).find("a[data-type]").click(function(e) {
      // reset the active class on all the buttons
      $($gallerySorting).find("a[data-type].active").removeClass('active');
      // assign the class of the clicked filter option
      // element to our $filterType variable
      var $filterType = $(this).attr('data-type');
      $(this).addClass('active');
      if ($filterType == 'all') {
        // assign all li items to the $filteredData var when
        // the 'All' filter option is clicked
        var $filteredData = $data.find('li');
      }
      else {
        // find all li elements that have our required $filterType
        // values for the data-type element
        var $filteredData = $data.find('li[data-type=' + $filterType + ']');
      }
      // call quicksand and assign transition parameters
      $holder.quicksand($filteredData, {
        duration: 800,
        easing: 'easeInOutQuad',
        useScaling: true,
        adjustHeight: 'auto'
      }, function() { 
        // callback gallery actions
        $('.popup').facebox();
        galleryActions();
      });
      return false;
    });
  });

//-------------------------------------------------------------- */
//
//   **** Wysiwyg (jWYSIWYG) **** 
//
//   For more information go to:
//  http://plugins.jquery.com/project/jWYSIWYG
//
//-------------------------------------------------------------- */
$(".wysiwyg").wysiwyg();

//-------------------------------------------------------------- */
//
//   **** Form Elements (uniform) **** 
//
//   For more information go to:
//  http://uniformjs.com/
//
//-------------------------------------------------------------- */
$(".box_content select, .box_content input:checkbox, .box_content input:radio, .box_content input:file, .box_content button").uniform();

//-------------------------------------------------------------- */
// Check all checkboxes
//-------------------------------------------------------------- */
  $('.checkall').click(function () {
    var checkall = $(this).parents('form,.box_content,.box_all').eq(0).find(':checkbox').attr('checked', this.checked);
    $.uniform.update(checkall);
  });

// End jQuery
  });
})(jQuery);

//-------------------------------------------------------------- */
//
//   **** Syntax Highlight (SyntaxHighlighter) **** 
//
//   For more information go to:
//  http://code.google.com/p/syntaxhighlighter/
//
//-------------------------------------------------------------- */
//dp.SyntaxHighlighter.ClipboardSwf = 'syntaxHighlighter/clipboard.swf';
//dp.SyntaxHighlighter.HighlightAll('code');