  (function ($){
     $(document).ready(function() {

//-------------------------------------------------------------- */
//
//   **** Graphs, Bars, Pie (Visualize) **** 
//
//   For more information go to:
//  http://www.filamentgroup.com/lab/update_to_jquery_visualize_accessible_charts_with_html5_from_designing_with/
//
//-------------------------------------------------------------- */

  $('table.stats').each(function() {
    
    var $stats_table = $(this);

    // Gets width of box container
    if ($(this).parent('div').width() > "840") {  
      var $stats_width = "833";
    }
    else {
      var $stats_width = ($(this).parent('div').width()) - 100;
    }
    
    // If there is a tab, find the active
    if ($(this).parent().prev().children('ul.sorting').length) {
      
      // Sorting shortcut
      var $stats_sorting = $(this).parent().prev().children('ul.sorting');
      
      // Adds 
      $($stats_sorting).find('a').each(function() {
        
        // Finds the href and removes the #
        var $stats_type = $(this).attr('href').replace("#","");
        
        // If it active, then show it
        if ($(this).hasClass('active')) {
          

          if($stats_type == 'line' || $stats_type == 'pie') {    
            $($stats_table).hide().visualize({
              type: $stats_type,  // 'bar', 'area', 'pie', 'line'
              width: $stats_width,
              height: '240px',
              colors: ['#6fb9e8', '#ec8526', '#9dc453', '#ddd74c'],
              lineDots: 'double',
              interaction: true,
              multiHover: 15,
              tooltip: true,
              tooltiphtml: function(data) {
                var html ='';
                for(var i=0; i<data.point.length; i++){
                  html += '<p class="stats_tooltip"><strong>'+data.point[i].value+'</strong> '+data.point[i].yLabels[0]+'</p>';
                }  
                return html;
              }
            }).addClass($stats_type);
          } else {
            $($stats_table).hide().visualize({
              type: $stats_type,  // 'bar', 'area', 'pie', 'line'
              width: $stats_width,
              height: '240px',
              colors: ['#6fb9e8', '#ec8526', '#9dc453', '#ddd74c']
            }).addClass($stats_type);
          };
          

        }
        
        // Else hide it
        else {
          
          if($stats_type == 'line' || $stats_type == 'pie') {    
            $($stats_table).hide().visualize({
              type: $stats_type,  // 'bar', 'area', 'pie', 'line'
              width: $stats_width,
              height: '240px',
              colors: ['#6fb9e8', '#ec8526', '#9dc453', '#ddd74c'],
              lineDots: 'double',
              interaction: true,
              multiHover: 15,
              tooltip: true,
              tooltiphtml: function(data) {
                var html ='';
                for(var i=0; i<data.point.length; i++){
                  html += '<p class="stats_tooltip"><strong>'+data.point[i].value+'</strong> '+data.point[i].yLabels[0]+'</p>';
                }  
                return html;
              }
            }).hide().addClass($stats_type);
          } else {
            $($stats_table).hide().visualize({
              type: $stats_type,  // 'bar', 'area', 'pie', 'line'
              width: $stats_width,
              height: '240px',
              colors: ['#6fb9e8', '#ec8526', '#9dc453', '#ddd74c']
            }).hide().addClass($stats_type);
          };
          
        };
        
      });

      // When one of the tabs are clicked
      $($stats_sorting).children().children('a').click(function(){
        
        // The href without #
        var $stats_sorting_type = "." + $(this).attr('href').replace("#","");
        
        // Hides all
        $($stats_table).parent().find(".visualize").hide();
        
        // Fades inn the one thats clicked
        $($stats_table).parent().find($stats_sorting_type).fadeIn('slow');
        
        // Removes 'active' class
        $($stats_sorting).children().children('a').removeClass('active');
        
        // Adds active state to the one you clicked
        $(this).addClass('active');
        return false; //Prevent the browser jump to the link anchor
      }); 
      
    }
    // If there is no tabs
    else {
      if ($(this).hasClass('bar')) {
        var $stats_type = 'bar';
      }
      else if ($(this).hasClass('line')) {
        var $stats_type = 'line';
      }
      else if ($(this).hasClass('pie')) {
        var $stats_type = 'pie';
      }
      else if ($(this).hasClass('area')) {
        var $stats_type = 'area';
      }
      else {
        // Default stats type
        var $stats_type = 'line';
      };
      
      if($stats_type == 'line' || $stats_type == 'pie') {    
            $($stats_table).hide().visualize({
              type: $stats_type,  // 'bar', 'area', 'pie', 'line'
              width: $stats_width,
              height: '240px',
              colors: ['#6fb9e8', '#ec8526', '#9dc453', '#ddd74c'],
              lineDots: 'double',
              interaction: true,
              multiHover: 15,
              tooltip: true,
              tooltiphtml: function(data) {
                var html ='';
                for(var i=0; i<data.point.length; i++){
                  html += '<p class="stats_tooltip"><strong>'+data.point[i].value+'</strong> '+data.point[i].yLabels[0]+'</p>';
                }  
                return html;
              }
            }).addClass($stats_type);
          } else {
            $($stats_table).hide().visualize({
              type: $stats_type,  // 'bar', 'area', 'pie', 'line'
              width: $stats_width,
              height: '240px',
              colors: ['#6fb9e8', '#ec8526', '#9dc453', '#ddd74c']
            }).addClass($stats_type);
        };
      
    };
    
  });

  /* IE Fix - Added in 1.1 */
  // Change inner color on mouseover intecation
  if(!$.browser.msie) { // IE is a bit slow, but is possible. Future versions may solve this problem
    var currentHoverPoint = null;
    // listen for hovering events
    $('table.stats')
      .bind('vizualizeOver',function(e,data){
        currentHoverPoint = data.point;
        $(data.point.elem).parents('table').trigger('visualizeRedraw');
      })
      .bind('vizualizeOut',function(e,data){
        currentHoverPoint = null;
        $(data.point.elem).parents('table').trigger('visualizeRedraw');
      });
  
    // Modify painting for hovering effect
    $('table.stats').bind('vizualizeBeforeDraw',function hoverBeforeDraw(e,data){
      if(currentHoverPoint) {
        var item,i,j,len = data.tableData.allItems.length;
        for(i=0;i<len;i+=1) { item = data.tableData.allItems[i];
          if(currentHoverPoint == item) {
            item.innerColor = item.color;
            // item.dotSize = item.dotSize*1.4;
            // item.dotInnerSize = item.dotInnerSize*1.4;
          }
        }
      }
    });
    
  };
  /* IE Fix End - Added in 1.1 */
  

// End jQuery
   });
})(jQuery);
