CREATE TABLE IF NOT EXISTS `{$dbprefix}admin` (
  `id` int(4) NOT NULL auto_increment,
  `account` varchar(20) NOT NULL,
  `password` varchar(32) NOT NULL,
  `name` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `qq` varchar(15) NOT NULL,
  `date` datetime NOT NULL,
  `sex` varchar(2) NOT NULL,
  `email` varchar(100) NOT NULL,
  `address` varchar(400) NOT NULL,
  `remark` varchar(200) default NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `account` (`account`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}admin_log` (
  `id` int(4) NOT NULL auto_increment,
  `content` varchar(400) NOT NULL,
  `model` varchar(50) NOT NULL,
  `adminId` int(4) NOT NULL,
  `ip` varchar(50) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1616 ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}appmoney` (
  `id` int(4) NOT NULL auto_increment,
  `memberId` int(4) NOT NULL,
  `bank` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `account` varchar(50) NOT NULL,
  `contact` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `date` datetime NOT NULL,
  `value` int(4) NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `{$dbprefix}area` (
  `id` int(4) NOT NULL auto_increment,
  `cityId` int(4) NOT NULL,
  `name` varchar(20) NOT NULL,
  `englishName` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `status` varchar(20) NOT NULL,
  `displayOrder` int(4) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=45 ;

CREATE TABLE IF NOT EXISTS `{$dbprefix}article` (
  `id` int(4) NOT NULL auto_increment,
  `title` varchar(50) NOT NULL,
  `content` text NOT NULL,
  `cover` varchar(100) NOT NULL,
  `typeId` int(4) NOT NULL,
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=22 ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}city` (
  `id` int(4) NOT NULL auto_increment,
  `provinceId` int(4) NOT NULL,
  `name` varchar(20) NOT NULL,
  `englishName` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `status` varchar(20) NOT NULL,
  `displayOrder` int(4) NOT NULL,
  `isdel` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=22 ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}comment` (
  `id` int(4) NOT NULL auto_increment,
  `type` varchar(10) NOT NULL,
  `hotelId` int(4) NOT NULL,
  `roomId` int(4) NOT NULL,
  `roomNo` varchar(10) NOT NULL,
  `orderCode` varchar(30) NOT NULL,
  `score` varchar(10) NOT NULL,
  `memberId` int(4) NOT NULL,
  `indate` date NOT NULL,
  `outdate` date NOT NULL,
  `remark` varchar(500) NOT NULL,
  `takeMoney` int(4) NOT NULL,
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=381 ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}comment_impression` (
  `id` int(4) NOT NULL auto_increment,
  `commentId` int(4) NOT NULL,
  `hotelId` int(4) NOT NULL,
  `roomId` int(4) NOT NULL,
  `memberId` int(4) NOT NULL,
  `value` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1323 ;

CREATE TABLE IF NOT EXISTS `{$dbprefix}country` (
  `id` int(4) NOT NULL auto_increment,
  `name` varchar(20) NOT NULL COMMENT '',
  `englishname` varchar(50) NOT NULL COMMENT 'Ӣ',
  `data` datetime NOT NULL COMMENT 'ʱ',
  `img` varchar(200) NOT NULL COMMENT 'ͼƬ',
  `delta_id` int(4) NOT NULL COMMENT 'ID',
  `status` varchar(20) NOT NULL,
  `isdel` int(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=124 ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}delta` (
  `id` int(4) NOT NULL auto_increment,
  `name` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}dict_roomprice` (
  `id` int(4) NOT NULL auto_increment,
  `roomId` int(4) NOT NULL,
  `marketPrice` decimal(9,2) NOT NULL,
  `costPrice` decimal(9,2) NOT NULL,
  `price` decimal(9,2) NOT NULL,
  `week` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `roomId` (`roomId`),
  KEY `week` (`week`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4626 ;

CREATE TABLE IF NOT EXISTS `{$dbprefix}elong_hotels` (
  `id` varchar(11) NOT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `shortName` varchar(50) NOT NULL,
  `enName` varchar(50) NOT NULL,
  `areaId` varchar(11) NOT NULL,
  `cityid` varchar(11) NOT NULL,
  `levelId` varchar(11) NOT NULL,
  `landmarkId` varchar(11) NOT NULL,
  `shopareaId` varchar(11) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `address` varchar(200) NOT NULL,
  `title` varchar(200) NOT NULL,
  `keywords` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `listTitle` varchar(10) NOT NULL,
  `cover` int(4) NOT NULL,
  `source` enum('0','1') NOT NULL default '0' COMMENT '0Լ 1ELONG',
  `service` varchar(100) NOT NULL,
  `detail` text NOT NULL,
  `catering` text NOT NULL,
  `facility` text NOT NULL,
  `meeting` text NOT NULL,
  `scenery` text NOT NULL,
  `traffic` text NOT NULL,
  `baiduMapX` varchar(20) default NULL,
  `baiduMapY` varchar(20) default NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `{$dbprefix}elong_photo` (
  `id` int(4) NOT NULL auto_increment,
  `uploader` varchar(10) NOT NULL,
  `uploaderId` varchar(11) NOT NULL,
  `categoryName` varchar(10) NOT NULL,
  `categoryRelId` varchar(11) NOT NULL,
  `typeRelId` varchar(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `content` varchar(200) NOT NULL,
  `width` int(4) NOT NULL,
  `height` int(4) NOT NULL,
  `orderCode` varchar(20) NOT NULL,
  `takeMoney` int(4) NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `{$dbprefix}elong_room` (
  `id` varchar(11) NOT NULL,
  `hotelId` varchar(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `bed` varchar(50) NOT NULL,
  `canAddBed` varchar(50) NOT NULL,
  `size` int(4) NOT NULL,
  `internet` varchar(50) NOT NULL,
  `breakfast` varchar(50) NOT NULL,
  `remark` text NOT NULL,
  `status` varchar(20) NOT NULL,
  `photo` varchar(200) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `{$dbprefix}finance` (
  `id` int(4) NOT NULL auto_increment,
  `memberId` int(4) NOT NULL,
  `type` varchar(20) NOT NULL,
  `date` datetime NOT NULL,
  `value` int(4) NOT NULL,
  `relTableName` varchar(50) NOT NULL,
  `relId` int(4) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;



CREATE TABLE IF NOT EXISTS `{$dbprefix}hotel` (
  `id` int(4) NOT NULL auto_increment,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `shortName` varchar(50) NOT NULL,
  `enName` varchar(50) NOT NULL,
  `areaId` int(4) NOT NULL,
  `levelId` int(4) NOT NULL,
  `landmarkId` int(4) NOT NULL,
  `shopareaId` int(4) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `address` varchar(200) NOT NULL,
  `title` varchar(200) NOT NULL,
  `keywords` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `listTitle` varchar(10) NOT NULL,
  `cover` int(4) NOT NULL,
  `service` varchar(100) NOT NULL,
  `detail` text NOT NULL,
  `catering` text NOT NULL,
  `facility` text NOT NULL,
  `meeting` text NOT NULL,
  `scenery` text NOT NULL,
  `traffic` text NOT NULL,
  `baiduMapX` varchar(20) default NULL,
  `baiduMapY` varchar(20) default NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=192 ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}landmark` (
  `id` int(4) NOT NULL auto_increment,
  `areaId` int(4) NOT NULL,
  `category` varchar(20) NOT NULL,
  `name` varchar(20) NOT NULL,
  `englishName` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `status` varchar(20) NOT NULL,
  `displayOrder` int(4) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=65 ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}level` (
  `id` int(4) NOT NULL auto_increment,
  `type` varchar(10) NOT NULL,
  `name` varchar(20) NOT NULL,
  `picture` varchar(100) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `status` varchar(20) NOT NULL,
  `displayOrder` int(4) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=28 ;



CREATE TABLE IF NOT EXISTS `{$dbprefix}member` (
  `id` int(4) NOT NULL auto_increment,
  `account` varchar(20) NOT NULL,
  `password` varchar(32) NOT NULL,
  `name` varchar(30) NOT NULL,
  `sex` varchar(2) NOT NULL,
  `mobile` varchar(15) NOT NULL,
  `qq` varchar(15) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `address` varchar(400) NOT NULL,
  `company` varchar(300) NOT NULL,
  `postcode` varchar(20) NOT NULL,
  `type` varchar(10) NOT NULL,
  `siteKey` varchar(20) default NULL,
  `hotelReturn` decimal(18,2) NOT NULL default '0.00',
  `status` varchar(20) NOT NULL,
  `remark` varchar(200) default NULL,
  `vipCode` varchar(25) NOT NULL,
  `Integral` int(4) NOT NULL default '999',
  `date` datetime NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `account` (`account`),
  KEY `type` (`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=49 ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}nopay` (
  `id` int(4) NOT NULL auto_increment,
  `categoryname` varchar(20) NOT NULL,
  `categoryid` int(4) NOT NULL,
  `date` datetime NOT NULL,
  `isdel` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ;



CREATE TABLE IF NOT EXISTS `{$dbprefix}order_room` (
  `id` int(4) NOT NULL auto_increment,
  `code` varchar(20) NOT NULL,
  `personNum` int(4) NOT NULL,
  `certType` varchar(100) NOT NULL,
  `name` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `inTimeMin` varchar(5) NOT NULL,
  `inTimeMax` varchar(5) NOT NULL,
  `roomId` int(4) NOT NULL,
  `roomNum` int(4) NOT NULL,
  `indate` date NOT NULL,
  `outdate` date NOT NULL,
  `takeMoney` decimal(9,2) NOT NULL,
  `price` decimal(9,2) NOT NULL,
  `memberId` int(4) NOT NULL,
  `siteKey` varchar(25) NOT NULL,
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `doState` varchar(20) NOT NULL,
  `doResult` varchar(20) NOT NULL,
  `priceDetail` text NOT NULL,
  `remark` text NOT NULL,
  `returnRemark` varchar(200) NOT NULL,
  `integral` varchar(11) NOT NULL default '100' COMMENT 'ѻ',
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `code` (`code`),
  KEY `roomId` (`roomId`),
  KEY `memberId` (`memberId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=140 ;




CREATE TABLE IF NOT EXISTS `{$dbprefix}order_visa` (
  `id` int(4) NOT NULL auto_increment,
  `adult` int(4) NOT NULL COMMENT '',
  `children` int(4) NOT NULL COMMENT 'ͯ',
  `code` varchar(20) NOT NULL,
  `personNum` int(4) NOT NULL,
  `certType` varchar(100) NOT NULL,
  `name` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `visaId` int(4) NOT NULL,
  `price` decimal(9,0) NOT NULL,
  `memberId` int(4) NOT NULL,
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}pay` (
  `id` int(4) NOT NULL auto_increment,
  `name` varchar(20) NOT NULL,
  `ch_name` varchar(30) NOT NULL ,
  `account` varchar(50) NOT NULL,
  `partnerid` varchar(50) NOT NULL,
  `key` varchar(50) NOT NULL,
  `modular` varchar(200) NOT NULL ,
  `noPay` varchar(250) NOT NULL ,
  `return` varchar(250) NOT NULL  ,
  `deposit` varchar(200) NOT NULL default '0' ,
  `date` datetime NOT NULL,
  `status` varchar(10) NOT NULL  ,
  `isdel` varchar(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
)  ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}photo` (
  `id` int(4) NOT NULL auto_increment,
  `uploader` varchar(10) NOT NULL,
  `uploaderId` int(4) NOT NULL,
  `categoryName` varchar(10) NOT NULL,
  `categoryRelId` int(4) NOT NULL,
  `typeRelId` int(4) NOT NULL,
  `name` varchar(100) NOT NULL,
  `content` varchar(200) NOT NULL,
  `width` int(4) NOT NULL,
  `height` int(4) NOT NULL,
  `orderCode` varchar(20) NOT NULL,
  `takeMoney` int(4) NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
)  ;





CREATE TABLE IF NOT EXISTS `{$dbprefix}price_room` (
  `id` int(11) NOT NULL auto_increment,
  `date` date NOT NULL,
  `dateofweek` varchar(20) NOT NULL,
  `roomId` int(11) NOT NULL,
  `marketPrice` decimal(9,2) NOT NULL,
  `costPrice` decimal(9,2) NOT NULL,
  `price` decimal(9,2) NOT NULL,
  `commonReturn` decimal(9,2) NOT NULL,
  `vipReturn` decimal(9,2) NOT NULL,
  `peerReturn` decimal(9,2) NOT NULL,
  `Integral` int(11) NOT NULL COMMENT '',
  `isFull` tinyint(1) default '0',
  `remark` varchar(200) default NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `tpr_date` (`date`),
  KEY `tpr_roomId` (`roomId`)
) ;



CREATE TABLE IF NOT EXISTS `{$dbprefix}province` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(20) NOT NULL,
  `englishName` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `status` varchar(20) NOT NULL,
  `displayOrder` int(11) NOT NULL,
  `isdel` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ;



CREATE TABLE IF NOT EXISTS `{$dbprefix}question` (
  `id` int(11) NOT NULL auto_increment,
  `memberId` int(11) NOT NULL,
  `categoryName` varchar(10) NOT NULL,
  `categoryRelId` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `content` varchar(500) NOT NULL,
  `adminId` int(11) default '0',
  `adminReply` varchar(500) default NULL,
  `adminReplyDate` varchar(21) default NULL,
  `viewNum` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}reply` (
  `id` int(11) NOT NULL auto_increment,
  `questionId` int(11) NOT NULL,
  `memberId` int(11) NOT NULL,
  `content` varchar(500) NOT NULL,
  `agree` int(11) NOT NULL,
  `accusation` tinyint(4) NOT NULL default '0',
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}room` (
  `id` int(11) NOT NULL auto_increment,
  `hotelId` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `bed` varchar(50) NOT NULL,
  `canAddBed` varchar(50) NOT NULL,
  `size` int(11) NOT NULL,
  `internet` varchar(50) NOT NULL,
  `breakfast` varchar(50) NOT NULL,
  `remark` text NOT NULL,
  `status` varchar(20) NOT NULL,
  `photo` varchar(200) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ;




CREATE TABLE IF NOT EXISTS `{$dbprefix}shoparea` (
  `id` int(11) NOT NULL auto_increment,
  `areaId` int(11) NOT NULL,
  `type` varchar(20) NOT NULL,
  `name` varchar(20) NOT NULL,
  `englishName` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `status` varchar(20) NOT NULL,
  `displayOrder` int(11) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}trace` (
  `id` int(11) NOT NULL auto_increment,
  `relTable` varchar(50) NOT NULL,
  `relId` int(11) NOT NULL,
  `adminId` int(11) NOT NULL,
  `adminName` varchar(50) NOT NULL,
  `adminAccount` varchar(50) NOT NULL,
  `content` varchar(200) NOT NULL,
  `statusRemark` varchar(50) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY  (`id`)
) ;



CREATE TABLE IF NOT EXISTS `{$dbprefix}type` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(20) NOT NULL,
  `rewrite` varchar(20) NOT NULL,
  `category` varchar(20) NOT NULL,
  `sort` varchar(20) NOT NULL,
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`)
) ;



CREATE TABLE IF NOT EXISTS `{$dbprefix}visa_city` (
  `id` int(11) NOT NULL auto_increment,
  `cityid` int(11) NOT NULL COMMENT 'id',
  `data` datetime NOT NULL COMMENT 'ʱ',
  `status` varchar(20) NOT NULL,
  `isdel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ;


CREATE TABLE IF NOT EXISTS `{$dbprefix}visa_manage` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  `countryid` varchar(100) NOT NULL COMMENT 'ǩ֤ID',
  `cityid` varchar(20) NOT NULL COMMENT 'ID',
  `visatypeid` varchar(100) NOT NULL COMMENT 'ǩ֤ID',
  `count` varchar(200) NOT NULL COMMENT '뾳',
  `money` int(15) NOT NULL COMMENT 'Ǯ',
  `effective` varchar(20) NOT NULL COMMENT 'ǩ֤Ч',
  `longesttime` varchar(100) NOT NULL COMMENT 'ͣʱ',
  `handlingtime` varchar(100) NOT NULL COMMENT 'ʱ',
  `scope` text NOT NULL COMMENT 'Χ',
  `materials` text NOT NULL COMMENT '',
  `notice` text NOT NULL COMMENT 'Ԥ֪',
  `remind` text NOT NULL COMMENT 'ܰ',
  `process` text NOT NULL COMMENT 'Ԥ',
  `payment` text NOT NULL COMMENT 'ǩԼ',
  `interview` varchar(50) NOT NULL COMMENT 'ǷҪ',
  `invitation` varchar(50) NOT NULL COMMENT 'ǷҪ뺯',
  `invitation_info` varchar(80) default NULL COMMENT '뺯ȡʽ',
  `clickcount` int(11) NOT NULL,
  `status` varchar(10) NOT NULL COMMENT '״̬',
  `isdel` int(11) NOT NULL default '0',
  `data` datetime NOT NULL,
  PRIMARY KEY  (`id`)
);



CREATE TABLE IF NOT EXISTS `{$dbprefix}visa_type` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(20) NOT NULL,
  `data` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

