var highLightIndex = -1;
$(function() {
	var O_AreaDrop = $("#areaDrop");
	var O_HotelDrop = $("#hotelDrop");
	var O_SearchKey = $("#searchKey");
	var O_SearchBtn = $("#O_SearchBtn");
	var O_KeyOffset = O_SearchKey.offset();
	var O_Auto = $("#auto");
	var O_AutoF = $("#autoF");
	O_AutoF.hide();
	O_Auto.hide(); //隐藏自动补全框
	var top = O_KeyOffset.top + O_SearchKey.height() + 5;
	var left = O_KeyOffset.left;
	O_Auto.css("border", "1px solid #817F82")
	.css("background-color", "#fff")
	.css("position", "absolute")
	.css("z-index", "1000")
	.css("top", top)
	.css("left", left)
	.css("width", O_SearchKey.width() + 3);
	
	O_AutoF.css("background-color", "#fff")
	.css("position", "absolute")
	.css("z-index", "20");
	
	var O_Flush = $("#O_Flush");
	O_Flush.hide();
	
	//点击区域筛选下拉列
	O_AreaDrop.change(function() {
		O_Flush.show();
		var areaId = O_AreaDrop.val();
		
		if(areaId == ""){
			$.post("?m=admin/hotel.getList", { pageSize:0, json:true  , firefox:'firefox'}, function(data) {//alert(data);
				O_HotelDrop.empty();
				O_HotelDrop.append("<option value=\"\">==酒店==</option>");
				$.each(data, function(id, item) {
					O_HotelDrop.append("<option value=\"" + item.id + "\">" + item.name + "</option>");
				});
				O_Flush.hide();
			}, "json");
		} else {
			$.post("?m=admin/hotel.getListByArea", { areaId:areaId, pageSize:0, json:true , firefox:'firefox'}, function(data) {//alert(data);
				O_HotelDrop.empty();
				O_HotelDrop.append("<option value=\"\">==酒店==</option>");
				$.each(data, function(id, item) {
					O_HotelDrop.append("<option value=\"" + item.id + "\">" + item.name + "</option>");
				});
				O_Flush.hide();
			}, "json");
		}
	});
	//点击酒店筛选下拉列
	O_HotelDrop.change(function() {
		var hotelId = O_HotelDrop.val();
		if(hotelId == ""){
			O_SearchKey.val("");
		} else {
			O_SearchKey.val(O_HotelDrop.find("option:selected").text());
		}
	});
	var O_Add = $("#O_Add");
	O_Add.click(function() {
		var O_Name = $("#O_Name");
		var O_Size = $("#O_Size");
		var O_Bed = $("#O_Bed");
		var O_CanAddBed = $(":input[name='O_CanAddBed']:checked");
		var O_Internet = $(":input[name='O_Internet']:checked");
		var O_Breakfast = $(":input[name='O_Breakfast']:checked");
		var O_Remark = $("#O_Remark");
		var O_Status = $(":input[name='O_Status']:checked");
		
		var v_hotelId = O_HotelDrop.val();
		var v_name = O_Name.val().replace(/ /g, '').replace(/'/g, '').replace(/"/g, '');
		var v_size = O_Size.val();
		var v_bed = O_Bed.val().replace(/ /g, '').replace(/'/g, '').replace(/"/g, '');
		var v_canAddBed = O_CanAddBed.val();
		var v_internet = O_Internet.val();
		var v_breakfast = O_Breakfast.val();
		var v_remark = O_Remark.val().replace(/ /g, '').replace(/'/g, '').replace(/"/g, '');
		var v_status = O_Status.val();
		
		if(v_hotelId == "") {
			alert("请选择酒店名称！");
			O_HotelDrop.focus();
		} else if(v_name == "") {
			alert("请填写客房名称！");
			O_Name.focus();
		} else {
			O_Add.attr("disabled", true);
			$.post("?m=admin/room.addHandle", { hotelId:v_hotelId, name:v_name, size:v_size, bed:v_bed, canAddBed:v_canAddBed, internet:v_internet, breakfast:v_breakfast, remark:v_remark, status:v_status }, function(data) {//alert(data);
				alert(data[1]);
				if(data[0] == "success") {
					O_Name.val("");
					O_Size.val("");
					O_Bed.val("");
					O_Remark.val("");
					$(":input[name='O_CanAddBed'][value='不能']").attr("checked", true);
					$(":input[name='O_Internet'][value='没有']").attr("checked", true);
					$(":input[name='O_Breakfast'][value='无早']").attr("checked", true);
				} else {
					if(data[2] == "hotelId is null") {
						O_HotelDrop.focus();
					} else if(data[2] == "name is null") {
						O_Name.focus();
					} else if(data[2] == "size is null") {
						O_Size.focus();
					}
				}
				O_Add.attr("disabled", false);
			}, "json");
		}
	});
	O_SearchBtn.click(function() {
		hotelSearch();
	});
	O_SearchKey.focus();
	O_SearchKey.keyup(function(event) {
		var myEvent = event || window.event;
		var keyCode = myEvent.keyCode;//alert(keyCode);
		var key = O_SearchKey.val().replace(/ /g, '').replace(/'/g, '');
		if(key.length > 0){
			if(keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90 || keyCode == 8 || keyCode == 46 || keyCode == 32) {//alert(keyCode);
				highLightIndex = -1;
				getKeyList("name", key);
			} else if (keyCode == 38 || keyCode == 40) {//alert(keyCode);
				//向上/向下箭头
				var nodes = O_Auto.children("div");
				//使未向上移时的当前项底色去掉
				if(highLightIndex != -1) { nodes.eq(highLightIndex).css("background-color", "#fff"); }
				if(keyCode == 38) { //向上
					nodes.css("background-color", "#fff").css("border", "1px solid #fff");
					highLightIndex--;
					if(highLightIndex == -1) { highLightIndex = nodes.length - 1; }
				}
				if(keyCode == 40){ //向下
					nodes.css("background-color", "#fff").css("border", "1px solid #fff");
					highLightIndex++;
					if(highLightIndex == nodes.length) { highLightIndex = 0; }
				}
				//使用当前项高亮
				nodes.eq(highLightIndex).css("background-color", "#eee").css("border", "1px solid #ccc");
			} else if (keyCode == 13) {
				//如果输入的是回车
				//如果下拉框有高亮内容
				if(highLightIndex != -1) {
					O_SearchKey.val(O_Auto.children("div").eq(highLightIndex).html());
					highLightIndex = -1;
					O_Auto.html("");
					O_AutoF.hide();
					O_Auto.hide();
				} else {
					O_SearchBtn.trigger("click");
				}
			} else {
			}
		} else {
			highLightIndex = -1;
			O_Auto.html("");
			O_AutoF.hide();
			O_Auto.hide();
			//绑定回车键与点击快捷搜索一致
			if (keyCode == 13) { O_SearchBtn.trigger("click"); }
		}
		
	});
	//搜索失去焦点
	O_SearchKey.blur(function() {
		if(highLightIndex != -1) {
			var nodes = O_Auto.children("div");
			O_SearchKey.val(nodes.eq(highLightIndex).html());
			highLightIndex = -1;
		}
		O_AutoF.hide();
		O_Auto.hide();
		O_SearchBtn.focus();
	});
	//点击搜索关键字
	O_SearchKey.click(function() {
		var key = O_SearchKey.val().replace(/ /g, '').replace(/'/g, '');
		getKeyList("name", key);
	});
});
//获取关键字列表
function getKeyList(field, key) {
	var O_Auto = $("#auto");
	var O_AutoF = $("#autoF");
	var O_SearchKey = $("#searchKey");
	var O_KeyOffset = O_SearchKey.offset();
	if(key.length > 0) {
		$.post("?m=admin/hotel.simpleSearch", { field:field, key:key, pageSize:0, json:true }, function(data) {//alert(data);
			var str = "";
			$.each(data, function(id, item) {
				str += "<div>" + item.name + "</div>";
			});
			if(str.length > 0) {
				O_Auto.html(str);
				var top = O_KeyOffset.top + O_SearchKey.height() + 5;
				var left = O_KeyOffset.left;
				O_Auto.css("top", top)
				.css("left", left);
				
				var width = O_Auto.width();
				var height = O_Auto.height() + 10;
				if($.browser.mozilla) {//修正火狐偏差
					width = width - 2;
					height = height - 4;
				}
				O_AutoF.css("top", top)
				.css("left", left)
				.css("width", width)
				.css("height", height);
				
				O_Auto.show();
				O_AutoF.show();
				
				var nodes = O_Auto.children("div");
				var width = O_Auto.width() - 2;
				nodes.each(function(i) {
					var node = $(this);
					node.attr("id", i).css("width", width).css("cursor", "pointer").css("overflow", "hidden").css("line-height", "25px").css("height", "25px").css("border", "1px solid #fff");
					//鼠标移上
					node.mouseover(function() {
						nodes.css("background-color", "#fff").css("border", "1px solid #fff");
						highLightIndex = this.id; 
						node.css("background-color", "#eee").css("border", "1px solid #ccc");
					});
					//鼠标离开
					node.mouseout(function() {
						node.css("background-color", "#fff").css("border", "1px solid #fff");
						highLightIndex = -1;
					});
					//鼠标点击
					node.click(function() {
						O_SearchKey.focus();
						O_SearchKey.val(node.html());
						highLightIndex = -1;
						O_Auto.html("");
						O_AutoF.hide();
						O_Auto.hide();
					});
				});
			} else {
				O_Auto.html("");
				O_AutoF.hide();
				O_Auto.hide();
			}
		}, "json");
	} else {
		O_Auto.html("");
		O_AutoF.hide();
		O_Auto.hide();
	}
}
//酒店搜索
function hotelSearch() {
	var O_AreaDrop = $("#areaDrop");
	var O_HotelDrop = $("#hotelDrop");
	var O_Flush = $("#O_Flush");
	var O_SearchKey = $("#searchKey");
	var v_key = O_SearchKey.val().replace(/ /g, '').replace(/'/g, '');
	$.post("?m=admin/hotel.getCount", { field:"name", key:v_key }, function(data) {//alert(data);
		var count = parseInt(data['all']);
		if(count > 1) {
			//2个以上酒店
			O_Flush.show();
			$.post("?m=admin/hotel.simpleSearch", { field:"name", key:v_key, pageSize:0, json:true }, function(data) {//alert(data);
				O_HotelDrop.empty();
				O_HotelDrop.append("<option value=\"\">==酒店==</option>");
				$.each(data, function(id, item) {
					O_HotelDrop.append("<option value=\"" + item.id + "\">" + item.name + "</option>");
				});
				O_Flush.hide();
			}, "json");
		} else if(count == 0) {
			O_Flush.show();
			$.post("?m=admin/hotel.getListByArea", { areaId:"", pageSize:0, json:true }, function(data) {//alert(data);
				O_HotelDrop.empty();
				O_HotelDrop.append("<option value=\"\">==酒店==</option>");
				$.each(data, function(id, item) {
					O_HotelDrop.append("<option value=\"" + item.id + "\">" + item.name + "</option>");
				});
				O_Flush.hide();
			}, "json");
		} else if(count == 1) {
			O_Flush.show();
			$.post("?m=admin/hotel.getInfoByName", { name:v_key }, function(data) {//alert(data);
				if(data != null) {
					var areaId = data.areaId;
					var hotelId = data.id;
					O_AreaDrop.attr("value", areaId);
					$.post("?m=admin/hotel.getListByArea", { areaId:areaId, pageSize:0, json:true }, function(data) {
						O_HotelDrop.empty();
						O_HotelDrop.append("<option value=\"\">==酒店==</option>");
						$.each(data, function(id, item) {
							O_HotelDrop.append("<option value=\"" + item.id + "\">" + item.name + "</option>");
						});
						O_HotelDrop.attr("value", hotelId);
						O_Flush.hide();
					}, "json");
				} else {
					$.post("?m=admin/hotel.getListByArea", { areaId:"", pageSize:0, json:true }, function(data) {//alert(data);
						O_HotelDrop.empty();
						O_HotelDrop.append("<option value=\"\">==酒店==</option>");
						$.each(data, function(id, item) {
							O_HotelDrop.append("<option value=\"" + item.id + "\">" + item.name + "</option>");
						});
						O_Flush.hide();
					}, "json");
				}
			}, "json");
		}
	}, "json");
}