$(function() {
	var stypeid = $("#stypeid");     //门票类型ID
	var sel_stype = $("#sel_stype");  //门票类型
	var tickettext = $("#tickettext");  //票面价格
	var sametext = $("#sametext");    //平日价格
	var weekentext = $("#weekentext");  //周末价格
	var holidaytext = $("#holidaytext");  //节日价格
	var remarkstext = $("#remarkstext");   //备注
	var payment = $("#payment0");    //支付方式 单选按钮
	

	var updatebutton = $("#updatebutton");
	var returnbutton = $("#returnbutton");
	
	var sel_province = $("#sel_province");  //省份下拉列表
	var sel_city = $("#sel_city");   //城市下拉列表
	var sel_area = $("#sel_area");   //区县下拉列表
	var sel_scenic = $("#sel_scenic");  //景点内容 下拉列表
	
	updatebutton.click(function(){
		var v_id = stypeid.html();     //门票类型ID
		var v_sel_stype = sel_stype.attr('value');  //门票类型
		var v_tickettext = tickettext.attr('value');   //票面价格
		var v_sametext = sametext.attr('value');  //平日价格
		var v_weekentext = weekentext.attr('value');  //周末价格
		var v_holidaytext = holidaytext.attr('value');  //节日价格
		var v_remarkstext = remarkstext.attr('value');  //备注
		var v_sel_scenic = sel_scenic.attr('value');  //景点内容 下拉列表
		
		var v_payment = 1;   //支付方式 单选按钮
		if(payment.attr('checked') == 'checked')
		{
			v_payment=0;	
		}
		
		//alert(v_stypetext);
		//alert(v_payment);
		//alert(v_weekentext);
		//alert(v_tickettext);
		//alert(v_cenicinfoid);
		//alert(v_sametext);
		//alert(v_remarkstext);
		//return;
		
		if(v_sel_stype == 0)
		{
			alert('请选择门票类型！');
			return;
		}else if(v_sel_scenic == 0)
		{
			alert('请选择景点！');
			return;
		}else if(v_tickettext != ""){
			if(!/^\d+$/.test(v_tickettext))
			{
				alert('请正确输入票面价格！');
				tickettext.focus();
				return;
			}
		}else if(v_sametext != ""){
			if(!/^\d+$/.test(v_sametext))
			{
				alert('请正确输入平日价格！');
				sametext.focus();
				return;
			}
		}else if(v_weekentext != "")
		{
			if(!/^\d+$/.test(v_weekentext))
			{
				alert('请正确输入周末价格！');
				weekentext.focus();
				return;
			}
		}else if(v_holidaytext != "")
		{
			if(!/^\d+$/.test(v_holidaytext))
			{
				alert('请正确输入节日价格！');
				holidaytext.focus();
				return;
			}
		}else if(v_remarkstext != ""){
			if(v_remarkstext.length>90)
			{
				alert('您输入的景点门票备注长度超长！小于200个字符');
				remarkstext.focus();
				return;
			}
		}
		$.post("?m=admin/scenic.ticketUpdate", {
			   id:v_id,    //门票类型ID
			   sel_stype:v_sel_stype,   //门票类型
			   tickettext:v_tickettext,  //票面价格
			   sametext:v_sametext,     //平日价格
			   weekentext:v_weekentext,   //周末价格
			   holidaytext:v_holidaytext,   //节日价格
			   remarkstext:v_remarkstext,    //备注
			   cenicinfoid:v_sel_scenic,    //景点内容 下拉列表
			   payment:v_payment,		//支付方式 单选按钮  
			   pageSize:0}, function(data) {
				//alert(data);    //data 返回内容为提交页面的echo 或 print值 return不算
				if(data == 1){
					alert("景点门票类型已更新！");
					updatebutton.attr('disabled','disabled');
					//location.href= "?m=admin/scenic";
				}else{
					alert("景点门票类型更新失败");
					return;
				}
		});	
		
	});
	
	returnbutton.click(function(){
		location.href = "?m=admin/scenic.ticket";	 
	});
	
	
	//选择省份加区城市
	sel_province.change(function() {
		var v_province = sel_province.val();
		if(v_province != "") {
			$.post("?m=admin/scenic.getListByProvince", { province:v_province, pageSize:0, json:true }, function(data) {//alert(data);
				sel_city.empty();
				sel_city.append("<option value=\"\">==城市==</option>");
				sel_area.empty();
				sel_area.append("<option value=\"\">==区县==</option>");
				sel_scenic.empty();
			sel_scenic.append("<option value=\"\">==景点==</option>");
				$.each(data, function(id, item) {
					sel_city.append("<option value=\"" + item.id + "\">" + item.name + "</option>");
				});
			}, "json");
		} else {
			sel_city.empty();
			sel_city.append("<option value=\"\">==城市==</option>");
			sel_city.empty();
			sel_city.append("<option value=\"\">==区县==</option>");
			sel_scenic.empty();
			sel_scenic.append("<option value=\"\">==景点==</option>");
		}
	});
	
	//选择城市添加区
	sel_city.change(function() {
		var cityId = sel_city.val();
		if(cityId != "") {
			$.post("?m=admin/scenic.getListByCity", { cityId:cityId, pageSize:0, json:true }, function(data) {//alert(data);
				sel_area.empty();
				sel_area.append("<option value=\"\">==区县==</option>");
				sel_scenic.empty();
			sel_scenic.append("<option value=\"\">==景点==</option>");
				$.each(data, function(id, item) {
					sel_area.append("<option value=\"" + item.id + "\">" + item.name + "</option>");
				});
			}, "json");			
		} else {
			sel_area.empty();
			sel_area.append("<option value=\"\">==区县==</option>");
			sel_scenic.empty();
			sel_scenic.append("<option value=\"\">==景点==</option>");
		}
	});
	
	//选择区县添加景点
	sel_area.change(function() {
		var areaId = sel_area.val();
		
		if(areaId != "") {
			
			$.post("?m=admin/scenic.getscenicById", { areaId:areaId, pageSize:0, json:true }, function(data) {
																									
				sel_scenic.empty();
				sel_scenic.append("<option value=\"\">==景点==</option>");
				$.each(data, function(id, item) {
					sel_scenic.append("<option value=\"" + item.Id + "\">" + item.name + "</option>");
				});
			}, "json");
		} else {
			sel_scenic.empty();
			sel_scenic.append("<option value=\"\">==景点==</option>");
		}
	});
	
	
	
	
}); 