﻿$(function() {
    var O_IsFlush = $("#O_IsFlush");
    var O_HelpOpen = $("#O_HelpOpen");
    var O_Helpbox = $("#helpbox");
    var O_HelpClose = $("#O_HelpClose");
    var O_ZoomIn = $("#O_ZoomIn");
    var O_ZoomOut = $("#O_ZoomOut");
    var O_MapSearch = $("#O_MapSearch");
    var O_MapKey = $("#O_MapKey");
    var O_BusSearch = $("#O_BusSearch");
    var O_BusFrom = $("#O_BusFrom");
    var O_BusTo = $("#O_BusTo");
    var O_BusKeyChange = $("#O_BusKeyChange");
    var O_CarSearch = $("#O_CarSearch");
    var O_CarFrom = $("#O_CarFrom");
    var O_CarTo = $("#O_CarTo");
    var O_CarKeyChange = $("#O_CarKeyChange");
    var map = new BMap.Map("O_MyMap");
	var mapX = $("#O_MyMapX").val();
    var mapY = $("#O_MyMapY").val();
	var city = $("#O_City").val();
    map.centerAndZoom(new BMap.Point(mapX, mapY), 11);
    //map.addControl(new BMap.NavigationControl());  //向地图添加控件
    var opts = {type: BMAP_NAVIGATION_CONTROL_LARGE}
    map.addControl(new BMap.NavigationControl(opts));
    
    map.addControl(new BMap.ScaleControl());                    // 添加比例尺控件
    map.addControl(new BMap.OverviewMapControl());              //添加缩略地图控件
	
    var local = new BMap.LocalSearch(city, {
      renderOptions: {
        map: map,
        autoViewport: true,
        selectFirstResult: false
      }
    });
    local.search("");
    
    //地图搜索
    O_MapSearch.click(function() {
        var v_mapkey = O_MapKey.val().replace(/ /g, '').replace(/'/g, '');
        if(v_mapkey == ""){
		    alert("请输入搜索关键字！");O_MapKey.focus();return false;
	    } else {
            local.search(v_mapkey);
        }
    });
    //公交搜索
    O_BusSearch.click(function() {
        var v_busFrom = O_BusFrom.val().replace(/ /g, '').replace(/'/g, '');
        var v_busTo = O_BusTo.val().replace(/ /g, '').replace(/'/g, '');
        if(v_busFrom == "") {
		    alert("请输入出发地关键字！");O_BusFrom.focus();return false;
	    } else if(v_busTo == "") {
		    alert("请输入目的地关键字！");O_BusTo.focus();return false;
	    } else {
	        O_BusSearch.attr("value", "查找中");
            O_BusSearch.attr("disabled", true);
	        var transit = new BMap.TransitRoute(map, {
                renderOptions: {map: map, panel: "O_Results"}
            });
            transit.search(v_busFrom, v_busTo);
            O_IsFlush.val("1");
            //alert(O_IsFlush.val());
            O_BusSearch.attr("value", "查 询");
            O_BusSearch.attr("disabled", false);
	    }
    });
    //公交搜索关键字切换
    O_BusKeyChange.click(function() {
        var v_busTo = O_BusTo.val();
        O_BusTo.val(O_BusFrom.val());
        O_BusFrom.val(v_busTo);
    });
    //驾车搜索
    O_CarSearch.click(function() {
        var v_carFrom = O_CarFrom.val().replace(/ /g, '').replace(/'/g, '');
        var v_carTo = O_CarTo.val().replace(/ /g, '').replace(/'/g, '');
        if(v_carFrom == "") {
		    alert("请输入出发地关键字！");O_CarFrom.focus();return false;
	    } else if(v_carTo == "") {
		    alert("请输入目的地关键字！");O_CarTo.focus();return false;
	    } else {
	        O_CarSearch.attr("value", "查找中");
            O_CarSearch.attr("disabled", true);
            var driving = new BMap.DrivingRoute(map, {renderOptions: {map: map, panel: "O_Results", autoViewport: true}});
            driving.search(v_carFrom, v_carTo);
            O_IsFlush.val("1");
            //alert(O_IsFlush.val());
            O_CarSearch.attr("value", "查 询");
            O_CarSearch.attr("disabled", false);
	    }
    });
    //驾车搜索关键字切换
    O_CarKeyChange.click(function() {
        var v_carTo = O_CarTo.val();
        O_CarTo.val(O_CarFrom.val());
        O_CarFrom.val(v_carTo);
    });
    //放大
    O_ZoomIn.click(function() {
        map.zoomTo(map.getZoom() + 1);
    });
    //缩小
    O_ZoomOut.click(function() {
        map.zoomTo(map.getZoom() - 1);
    });
    //打开帮助面版
    O_HelpOpen.click(function() {
        O_Helpbox.show();
    });
    //关闭帮助面版
    O_HelpClose.click(function() {
        O_Helpbox.hide();
    });
});