$(function() {
	// 搜索框
	var highLightIndex = -1;
	var $searchCity = $("#search-city");
	var $hiddenCity = $("#hidden-city");
	var $citySelect = $("#city-select");
	var $selectTips = $citySelect.find("div.select-tips");
	var $selectItem = $citySelect.find("div.select-item");
	var $selectList = $citySelect.find("div.select-list");
	
	$searchCity.click(function(event) {
		event.stopPropagation();
		$dropBox.hide();
		$selectTips.html("<strong>热门城市</strong>(可直接选择城市或输入城市拼音)");
		$selectItem.show();
		$selectList.hide();
		
		var $parent = $searchCity.parent();
		var $offset = $parent.offset();
		var height = $parent[0].offsetHeight;
		var left = $offset.left;
		var top = $offset.top;
		
		$citySelect.css({ "left":left, "top":top + height + 1 }).show().click(function(event) {
			event.stopPropagation();
		});
		$selectItem.find("li").click(function() {
			$searchCity.val($(this).html()).removeClass("txt-gray");
			$hiddenCity.val($(this).html());
			$citySelect.hide();
		});
	}).keyup(function(event) {
		var myEvent = event || window.event;
		var keyCode = myEvent.keyCode;
		var key = $searchCity.val().replace(/ /g, '').replace(/'/g, '');
		
		if(key.length > 0) {
			if(keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90 || keyCode == 8 || keyCode == 46 || keyCode == 32) {
				highLightIndex = -1;
				$selectItem.hide();
				$selectList.empty().show();
				$.post(root + "?m=city.getSearch", { key:key }, function(data) {
					if(data.length > 0) {
						$selectTips.html("<strong>城市列表</strong>(可直接选择城市或输入城市拼音)");
						$selectList.empty();
						$.each(data, function(id, item) {
							$selectList.append("<dl><dt>" + item.name + "</dt><dd>" + item.englishName + "</dd></dl>");
						});
						$selectList.find("dl").click(function() {
							$searchCity.val($(this).find("dt").eq(0).html());
							$citySelect.hide();
						});
					} else {
						$selectTips.html('对不起, 找不到: <strong class="txt-red">' + key + "</strong>");
					}
				}, "json");
			} else if(keyCode == 38 || keyCode == 40) {
				// 向上/向下箭头
				var nodes = $selectList.find("dl");
				//使未向上移时的当前项底色去掉
//				if(highLightIndex != -1) { nodes.eq(highLightIndex).css("background-color", "#fff"); }
//				if(keyCode == 38) { //向上
//					nodes.css("background-color", "#fff").css("border", "1px solid #fff");
//					highLightIndex--;
//					if(highLightIndex == -1) { highLightIndex = nodes.length - 1; }
//				}
//				if(keyCode == 40){ //向下
//					nodes.css("background-color", "#fff").css("border", "1px solid #fff");
//					highLightIndex++;
//					if(highLightIndex == nodes.length) { highLightIndex = 0; }
//				}
//				//使用当前项高亮
//				nodes.eq(highLightIndex).css("background-color", "#eee").css("border", "1px solid #ccc");
			} else if(keyCode == 13) {
				// 如果输入的是回车
				// 如果下拉框有高亮内容
				if(highLightIndex != -1) {
					$searchCity.val($selectList.find("dt").eq(highLightIndex).html());
					highLightIndex = -1;
					$citySelect.hide();
				}
			}
		} else {
			highLightIndex = -1;
			$.post(root + "?m=city.getSearch", { key:key }, function(data) {
				$selectTips.html("<strong>热门城市</strong>(可直接选择城市或输入城市拼音)");
				$selectItem.show();
				$selectList.hide();
			}, "json");
		}
	});
	
	$("input.search-date").click(function() {
		var $this = $(this);
		WdatePicker({ isShowClear:false, readOnly:true, minDate:'%y-%M-#{%d}', el:this, onpicked:function() {
			var date = $dp.cal.date.y + '/' + $dp.cal.date.M + '/' + $dp.cal.date.d;
			var today = new Date().getFullYear() + '/' + (new Date().getMonth() + 1) + '/' + new Date().getDate();
			date = new Date(date);
			today = new Date(today);
			var days = parseInt((date.getTime() - today.getTime()) / (1000 * 60 * 60 * 24));
			var html = "";
			switch(date.getDay()) {
				case 0: html = "星期日"; break;
				case 1: html = "星期一"; break;
				case 2: html = "星期二"; break;
				case 3: html = "星期三"; break;
				case 4: html = "星期四"; break;
				case 5: html = "星期五"; break;
				case 6: html = "星期六"; break;
			}
			switch(days) {
				case 0: html = "今天"; break;
				case 1: html = "明天"; break;
				case 2: html = "后天"; break;
			}
			$this.parent().find("span").html(html);
		}});
	});
	var $searchLevel = $("#search-level");
	var $dropBox = $("#drop-box");
	$searchLevel.click(function(event) {
		event.stopPropagation();
		$citySelect.hide();
		var $offset = $searchLevel.offset();
		$dropBox.css({
			"left":$offset.left,
			"top":$offset.top
		}).show();
		$searchLevel.css({ "box-shadow":"0 0 2px #baddff inset", "background":"#f1f9ff", "border-color":"#67a1e2" });
	});
	$dropBox.find("li").click(function() {
		$("#txt-level").html(this.innerHTML);
		$("#hidden-level").val(this.innerHTML == "不限" ? "" : this.innerHTML);
	});
	
	$(document).click(function() {
		$searchLevel.css({ "box-shadow":"0 0 2px #ccc inset", "background":"#fff", "border-color":"#ccc" });
		$dropBox.hide();
		$citySelect.hide();
	});
	
	initInputTips($searchCity, $hiddenCity, "中文/拼音");
	initInputTips($("#search-address"), $("#hidden-address"), "输入位置关键词");
	initInputTips($("#search-hotel"), $("#hidden-hotel"), "输入酒店关键词");
	
	$("#form-search button.search-btn").click(function() {
		var $city = $("#hidden-city");
		var $indate = $("#search-indate");
		var $outdate = $("#search-outdate");
		var $address = $("#hidden-address");
		var $hotel = $("#hidden-hotel");
		
		
		
		var city = $.trim($city.val());
		var indate = $.trim($indate.val());
		var outdate = $.trim($outdate.val());
		var address = $.trim($address.val());
		var hotel = $.trim($hotel.val());
		
		
		indate = new Date(indate.replace(/-/g, "/"));
		outdate = new Date(outdate.replace(/-/g, "/"));
		
		$.post(root + "?m=hotel.setHotelBookDate",{ indate:indate,outdate:outdate },function(data) {
           
        });
		
		var days = parseInt((outdate.getTime() - indate.getTime()) / (1000 * 60 * 60 * 24));
		if(city == "") {
			alert("请选择入住城市！");
		} else if(days < 1) {
			alert("离店日期必须晚于入住日期！");
		} else {
			$("#form-search").ajaxSubmit({
				success:function(data) {
					
					window.location.href = root + "hotel/list-search.html";
				}
			});
		}
	});
	
	// 图表框3
	$("ul.chart-box").find("li").hover(function() {
		var $this = $(this);
		var $offset = $this.offset();
		var $parent = $this.parent();
		var $parentOffset = $parent.offset();
		var $picItem = $this.find("figure.pic-item");
		var $picInfo = $this.find("figcaption.pic-info");
		var $infoBg = $picInfo.find("div.info-bg");
		var $infoBox = $picInfo.find("dl.info-box");
		
		var boxLeft = $parentOffset.left;
		var boxTop = $parentOffset.top;
		var boxWidth = $parent.width();
		var boxHeight = $parent.height();
		var itemLeft = $offset.left;
		var itemTop = $offset.top;
		var itemWidth = $this.width();
		var itemHeight = $this.height();
		var margin = 11;
		
		if(this.className == "pic-big") {
			$picItem.css({ "top":0 }).animate({ "top":itemHeight * -1 }, 300);
		} else if(itemLeft + itemWidth * 2.1 > boxLeft + boxWidth) {
			$picInfo.show();
			if($infoBox.hasClass("right") == false) {
				$infoBox.addClass("right");
			}
			$infoBg.css({
				"left":itemLeft + itemWidth,
				"top":itemTop + itemHeight / 2,
				"width":0,
				"height":0
			}).show().animate({
				"left":itemLeft - itemWidth - (margin + 20) * 2,
				"top":itemTop - margin,
				"width":(itemWidth + margin + 25) * 2,
				"height":itemHeight + margin * 2
			}, 300);//
			$infoBox.css({
				"left":itemLeft + itemWidth - 16,
				"top":itemTop + itemHeight / 2,
				"width":0,
				"height":0
			}).show().animate({
				"left":itemLeft - itemWidth - (margin + 20) * 2 + 5,
				"top":itemTop - margin + 4,
				"width":(itemWidth + 25) * 2,
				"height":itemHeight
			}, 300);
		} else {
			$picInfo.show();
			if($infoBox.hasClass("left") == false) {
				$infoBox.addClass("left");
			}
			$infoBg.css({
				"left":itemLeft - margin,
				"top":itemTop + itemHeight / 2,
				"width":0,
				"height":0
			}).show().animate({
				"top":itemTop - margin,
				"width":(itemWidth + margin + 25) * 2,
				"height":itemHeight + margin * 2
			}, 300);
			$infoBox.css({
				"left":itemLeft - margin + 4,
				"top":itemTop + itemHeight / 2 + 4,
				"width":0,
				"height":0
			}).show().animate({
				"top":itemTop - margin + 4,
				"width":(itemWidth + 25) * 2,
				"height":itemHeight
			}, 300);
		}
	}, function() {
		var $this = $(this);
		var $picItem = $this.find("figure.pic-item");
		var $picInfo = $this.find("figcaption.pic-info");
		
		if(this.className == "pic-big") {
			$picItem.animate({ "top":0 }, 300);
		} else {
			$picInfo.hide();
		}
	});
});
// 初始化带提示文本框
var initInputTips = function(input, hidden, tip) {
	input.val(tip);
	input.focus(function() {
		if($.trim(this.value) == tip) {
			input.val("");
		}
		input.removeClass("txt-gray").css({ "background":"#f1f9ff" });
		input.parent().css({ "box-shadow":"0 0 2px #baddff inset", "background":"#f1f9ff", "border-color":"#67a1e2" });
	}).blur(function() {
		var value = $.trim(this.value);
		hidden.val(value);
		if(value == "") {
			input.val(tip).addClass("txt-gray");
		}
		input.css({ "background":"#fff" });
		input.parent().css({ "box-shadow":"0 0 2px #ccc inset", "background":"#fff", "border-color":"#ccc" });
	});
};