<?php 

//添加主题选项
include_once('admin-option/theme-option.php');

//添加菜单
if(function_exists('register_nav_menus')){
	register_nav_menus(
	array(
		'top_nav_menu'=>'头部导航菜单',
		'bottom_nav_menu'=>'底部导航菜单',
		'page_nav_menu'=>'页面导航',
	));
}

//添加特色图片功能
if ( function_exists( 'add_theme_support' ) ) {
	add_theme_support( 'post-thumbnails' );
		if ( function_exists( 'add_image_size' ) ) { 
			add_image_size('case',178,178,true);
		}
}

//获取第一张缩略图<img>
function web589_thumbnail_img($size="thumbnail"){
	global $post;
	$args=array('post_type'=>'attachment','post_mime_type'=>'image','post_parent'=>$post->ID,'order'=>'asc');
	$images=get_children($args);
	if(has_post_thumbnail()) return get_the_post_thumbnail($post->ID,$size);
	else if($images){
		$attachment_id=key($images);
		return wp_get_attachment_image($attachment_id,$size);
	}
	else {
		$preg="/(<img )([^>]*)(>)/"; 
		$content=$post->post_content;
		preg_match($preg,$content,$img);
		return $img[0];
	}
}

//截取中文字节
function web589_ch_substr($str,$len,$start=0){
	if($start!=0){
		$s=$start*2;
		for($j=0;$j<$s;$j++){
			if(ord(substr($str,$j,1))>0xa0){
				$j+=2;
				$s++;
			}
		}
		$start=$j;
	}
	$len=$len*2+$start;
	for($i=$start;$i<$len;$i++){
		if(ord(substr($str,$i,1))>0xa0){
			$tmpstr.=substr($str,$i,3);
			$i+=2;
			$len++;
		}
		else{
			$tmpstr.=substr($str,$i,1);
		}
	}
	return $tmpstr;
}



//获取摘要
function web589_get_the_excerpt($len){
	global $post;
	if($post->post_excerpt) $excerpt=get_the_excerpt();
	else $excerpt=web589_ch_substr(get_the_excerpt(),$len);	
	return $excerpt;
}

//链接下拉列表
function wp_dropdown_bookmarks($name){
	$bms=get_terms('link_category');
	echo '<select name="'.$name.'" id="'.$name.'" class="bookmarks">';
	foreach($bms as $bm){
		if($bm->term_id == get_option($name)) $select='selected'; else $select='';
		echo '<option value="'.$bm->term_id.'" '.$select.' >'.$bm->name.'</option>';
	}
	echo '</select>';
}

//设置posts_per_page为-1
if(get_option('posts_per_page')) update_option('posts_per_page','-1');

//面包屑导航
function web589_crumbs($sep='>'){
	$par=web589_get_parrents($sep);
	if(!empty($par)){
		$num=count($par);
		$m=1;
		echo '<a href="'.get_bloginfo('url').'/">首页</a>'.$sep;
		foreach($par as $link=>$name){
			if($m==$num) echo $name;
			else echo '<a href="'.$link.'">'.$name.'</a>'.$sep;
			$m++;
		}
	}
}
function web589_get_parrents($sep='>'){
	if(is_category()){
		$par=get_ancestors(get_query_var('cat'),'category');
		$num=count($par);
		for($i=$num;$i>=1;$i--){
			$j=$i-1;
			$id=$par[$j];
			$array[get_category_link($id)]=get_cat_name($id);
		}
		$array[get_category_link(get_query_var('cat'))]=get_cat_name(get_query_var('cat'));
	}
	if(is_page()){
		$par=get_ancestors(get_the_ID(),'page');
		$num=count($par);
		for($i=$num;$i>=1;$i--){
			$j=$i-1;
			$id=$par[$j];
			$page=get_page($id);
			$array[get_page_link($id)]=$page->post_title;
		}
		$cur_page=get_page(get_the_ID());
		$array[get_page_link(get_the_ID())]=$cur_page->post_title;		
	}
	if(is_single()){
		$cats=get_the_category();
		foreach($cats as $cat){
			foreach($cats as $child){
				if(!cat_is_ancestor_of($cat,$child)) $id=$cat->cat_ID;
			}
		}		
		$par=get_ancestors($id,'category');
		$num=count($par);
		for($i=$num;$i>=1;$i--){
			$j=$i-1;
			$p_id=$par[$j];
			$array[get_category_link($p_id)]=get_cat_name($p_id);
		};
		$array[get_category_link($id)]=get_cat_name($id);						
		$array[get_permalink()]=get_the_title();
	}
	if(is_tag()){
		$tag=get_tag(get_query_var('tag_id'));
		$array[]=$tag->name;
	}
	return $array;
}

//添加自定义域选项
add_action('add_meta_boxes','web589_meta_box');

function web589_meta_box(){
	add_meta_box('web589_meta_box','来源','web589_meta_post_form','post','side','high');
	if( get_post_meta(get_the_ID(),'_wp_page_template',true) == 'page-1.php' ) add_meta_box('web589_meta_box','展示栏','web589_meta_page1_form','page','normal','high');
	if( get_post_meta(get_the_ID(),'_wp_page_template',true) == 'page-2.php' ) add_meta_box('web589_meta_box','展示栏','web589_meta_page2_form','page','normal','high');	
}

function web589_meta_post_form(){
	echo '<input name="_fzp-source" type="text" size="40" value="'.get_post_meta(get_the_ID(),'_fzp-source',true).'"/>';
}
function web589_meta_page1_form(){
	 include_once('includes/postmeta-form1.php');
}
function web589_meta_page2_form(){
	include_once('includes/postmeta-form2.php');
}

//保存自定义域选项
add_action('save_post','web589_save_meta');
function web589_save_meta(){
	if($_POST['_fzp-source']){
		update_post_meta(get_the_ID(),'_fzp-source',$_POST['_fzp-source']);
	}
	if( $_POST['save'] && $_POST['page_template']=='page-1.php' ){
		update_post_meta(get_the_ID(),'_web589-page-cat-1',$_POST['_web589-page-cat-1']);
		update_post_meta(get_the_ID(),'_web589-page-cat-2',$_POST['_web589-page-cat-2']);
		update_post_meta(get_the_ID(),'_web589-page-cat-3',$_POST['_web589-page-cat-3']);
	}
	if( $_POST['save'] && $_POST['page_template']=='page-2.php' ){
		update_post_meta(get_the_ID(),'_web589-page-title-1-1',$_POST['_web589-page-title-1-1']);
		update_post_meta(get_the_ID(),'_web589-page-cat-1-1',$_POST['_web589-page-cat-1-1']);
		update_post_meta(get_the_ID(),'_web589-page-title-1-2',$_POST['_web589-page-title-1-2']);
		update_post_meta(get_the_ID(),'_web589-page-cat-1-2',$_POST['_web589-page-cat-1-2']);
		update_post_meta(get_the_ID(),'_web589-page-title-1-3',$_POST['_web589-page-title-1-3']);
		update_post_meta(get_the_ID(),'_web589-page-cat-1-3',$_POST['_web589-page-cat-1-3']);
		update_post_meta(get_the_ID(),'_web589-page-cat-2',$_POST['_web589-page-cat-2']);
		update_post_meta(get_the_ID(),'_web589-page-cat-3',$_POST['_web589-page-cat-3']);
	}
}

//添加目录表单
add_filter('edit_category_form','web589_category_form');

function web589_category_form(){
	if(isset($_GET['action']) && $_GET['action']=="edit"){
		global $tag;
		include_once('includes/catmeta-form.php');
	}
}

//category保存选项
if(isset($_POST['action']) && $_POST['action']=="editedtag" && $_POST['taxonomy']=="category") {	
	update_option('web589-cat-template-'.$_POST['tag_ID'],$_POST['web589-cat-template']);
	update_option('web589-cat-num-'.$_POST['tag_ID'],$_POST['web589-cat-num']);
}

//目录分页
function web589_cat_paging($posts_per_page){
	add_action('wp_footer','web589_paging_css');
	$all_posts_num=web589_count_posts();
	$cur_page=get_query_var('paged') ? get_query_var('paged'):1;
	$np=$cur_page+1;
	$pp=$cur_page-1;
	$page['count']=$all_posts_num;
	$page['num']=(int)ceil($all_posts_num/$posts_per_page);
	$page['next']=get_pagenum_link($np);
	$page['previous']=get_pagenum_link($pp);
	$page['home']=get_pagenum_link();
	for($i=1;$i<=$page['num'];$i++){
		$page['num-'.$i]=get_pagenum_link($i);
	}
	$page['end']=get_pagenum_link($page['num']);	
	if($page['num']>=2) include_once('includes/paging.php');
}

//统计目录下所有文章数
function web589_count_posts(){
	query_posts(array('posts_per_page'=>-1,'cat'=>get_query_var('cat')));
	$i=0;
	while(have_posts()){
		the_post();
		$i++;
	}
	wp_reset_query();
	return $i;
}

//加载css
function web589_paging_css(){
	echo '<link rel="stylesheet" type="text/css" media="all" href="'.get_bloginfo('template_url').'/includes/paging.css"/>';
}

/* 访问计数 */
function record_visitors()
{
	if (is_singular()) 
	{
	  global $post;
	  $post_ID = $post->ID;
	  if($post_ID) 
	  {
		  $post_views = (int)get_post_meta($post_ID, 'views', true);
		  if(!update_post_meta($post_ID, 'views', ($post_views+1))) 
		  {
			add_post_meta($post_ID, 'views', 1, true);
		  }
	  }
	}
}
add_action('wp_head', 'record_visitors');  
 
/// 函数名称：post_views 
/// 函数作用：取得文章的阅读次数
function post_views($before = '(点击 ', $after = ' 次)', $echo = 1)
{
  global $post;
  $post_ID = $post->ID;
  $views = (int)get_post_meta($post_ID, 'views', true);
  if ($echo) echo $before, number_format($views), $after;
  else return $views;
}
?>