<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.net Sunwin
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="/xml/@action=1"><xsl:call-template name="Announcements_1"/></xsl:when>
		<xsl:when test="/xml/@action=2"><xsl:call-template name="Announcements_2"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="Announcements_0"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="Announcements_0">
	<xsl:for-each select="xml/datalist/row">
		<a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a>(<xsl:value-of select="@datetime" disable-output-escaping="yes"/>) 
	</xsl:for-each>
</xsl:template>
<xsl:template name="Announcements_1">
	<xsl:for-each select="xml/datalist/row">
		 <xsl:value-of select="@topic" disable-output-escaping="yes"/> <xsl:if test="/xml/@showdate=1">(<xsl:value-of select="@datetime" disable-output-escaping="yes"/>)</xsl:if> 
	</xsl:for-each>
</xsl:template>
<xsl:template name="Announcements_2">
	<xsl:for-each select="xml/datalist/row">
		<li><xsl:text disable-output-escaping="yes"><![CDATA[ &rsaquo; ]]></xsl:text><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a><xsl:if test="/xml/@showdate=1"><em>(<xsl:value-of select="@datetime" disable-output-escaping="yes"/>)</em></xsl:if></li>
	</xsl:for-each>
</xsl:template>
</xsl:stylesheet>