<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.net Sunwin
	-->

<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="/xml/@action=1"><xsl:call-template name="downloadlist1"/></xsl:when>
		<xsl:when test="/xml/@action=2"><xsl:call-template name="downloadlink"/></xsl:when>
		<xsl:when test="/xml/@action=3"><xsl:call-template name="downloadlist3"/></xsl:when>
		<xsl:when test="/xml/@action=5"><xsl:call-template name="downloadlist5"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="downloadlist2"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="downloadlist1">
	<xsl:for-each select="xml/datalist/row">
		<img src="{$installdir}skins/icons/icon_download.gif" border="0" align="absMiddle"/><a href="{@link}" target="_blank"> <xsl:value-of select="@link" disable-output-escaping="yes"/></a><br/>
	</xsl:for-each>
</xsl:template>

<xsl:template name="downloadlist2">
	<xsl:for-each select="xml/datalist/row">
		<img src="{$installdir}skins/icons/icon_download.gif" border="0" align="absMiddle"/><a href="{@link}" target="_blank"><b>  <xsl:value-of select="@downname" disable-output-escaping="yes"/></b></a><br/>
	</xsl:for-each>
</xsl:template>

<xsl:template name="downloadlink">
	<a href="{xml/datalist/row/@link}"><img src="{$installdir}skins/icons/downloadBtn.gif" border="0" alt="{xml/datalist/row/@title}" /></a>
</xsl:template>

<xsl:template name="downloadlist3">
	<xsl:for-each select="xml/datalist/row">
		arrDownurl[<xsl:value-of select="@n" />]=new Array('<xsl:value-of select="@downname" />','<xsl:value-of select="@link" />','<xsl:value-of select="@title" />',<xsl:value-of select="@show" />,<xsl:value-of select="@downid" />);
	</xsl:for-each>
</xsl:template>

<xsl:template name="downloadlist5">
	<script src="http://pstatic.xunlei.com/js/webThunderDetect.js"></script>
	<xsl:for-each select="xml/datalist/row">
		<img src="{$installdir}skins/icons/icon_download.gif" border="0" align="absMiddle"/>
		<xsl:choose>
			<xsl:when test="@isouter=2">
				<a href="javascript:" thunderHref="{@link}" thunderPid="{/xml/@thunderid}" thunderType="" thunderResTitle="" onClick="return OnDownloadClick_Simple(this,2)" oncontextmenu="ThunderNetwork_SetHref(this)"><b>  <xsl:value-of select="@downname" disable-output-escaping="yes"/></b></a><br/>
			</xsl:when>
			<xsl:when test="@isouter=3">
				<a href="{@link}" target="_blank"><b>  <xsl:value-of select="@downname" disable-output-escaping="yes"/></b></a><br/>
			</xsl:when>
			<xsl:otherwise>
				<a href="{@link}" target="_blank"><b>  <xsl:value-of select="@downname" disable-output-escaping="yes"/></b></a><br/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
</xsl:template>
</xsl:stylesheet>