<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.net Sunwin
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="/xml/@action=1"><xsl:call-template name="showimagelist1"/></xsl:when>
		<xsl:when test="/xml/@action=2"><xsl:call-template name="showimagelist2"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="showimagelist"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="showimagelist">
	<xsl:for-each select="xml/datalist/row">
	<TABLE cellSpacing="1" cellPadding="1"  border="0"> 
                    <TR>
                      <TD bgColor="#ffffff"><a href="{@link}"><img src="{@imglink}" width="{/xml/@width}" height="{/xml/@height}" border="0" /></a></TD></TR>   
              <TR>
                <TD align="middle"> <a href="{@link}" title="{@title}"  target="_blank"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></TD></TR> </TABLE>  <xsl:if test="position()!=last()"> <xsl:text>  </xsl:text>  </xsl:if>
	</xsl:for-each>
</xsl:template>

<xsl:template name="showimagelist1">
	<xsl:for-each select="xml/datalist/row">
		<li><xsl:choose>
			<xsl:when test="/xml/@width=0 or /xml/@height=0"><a href="{@link}"><img src="{@imglink}" border="0" /></a></xsl:when>
			<xsl:otherwise><a href="{@link}"><img src="{@imglink}" width="{/xml/@width}" height="{/xml/@height}" border="0" /></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="showimagelist2">
	<xsl:for-each select="xml/datalist/row">
		<li style="{@linewidth}"><xsl:choose>
			<xsl:when test="/xml/@width=0 or /xml/@height=0"><a href="{@link}"><img src="{@imglink}" border="0" /></a></xsl:when>
			<xsl:otherwise><a href="{@link}"><img src="{@imglink}" width="{/xml/@width}" height="{/xml/@height}" border="0" /></a></xsl:otherwise>
		</xsl:choose>
		<br/><a href="{@link}" target="_blank"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></li>
	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>