<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:newasp="#newasp-functions" exclude-result-prefixes="msxsl newasp">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.net Sunwin
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="/xml/@action=0"><xsl:call-template name="showPageList_1"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="showPageList_2"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<!--#ASP̬ҳҳ-->
<xsl:template name="showPageList_1">
	<xsl:value-of select="/xml/@totalrec"/>̳ <xsl:value-of select="/xml/@pagenow"/>/<xsl:value-of select="/xml/@pagecount"/><xsl:text disable-output-escaping="yes"><![CDATA[<code>]]> </xsl:text> 
	<xsl:choose>
		<xsl:when test="/xml/@pagenow=1">
			<kbd class="disable"> ҳ </kbd>
			<xsl:text disable-output-escaping="yes"><![CDATA[<code>]]> </xsl:text>
		 
		</xsl:when>
		<xsl:otherwise>
			<kbd ><a href="{/xml/@link}page=1">ҳ</a></kbd>
			<xsl:text disable-output-escaping="yes"><![CDATA[<code>]]> </xsl:text>
		 
		</xsl:otherwise>
	</xsl:choose>
	
	<xsl:choose>
		<xsl:when test="/xml/@pagenow=1">
			<kbd class="disable"> һҳ </kbd>
			<xsl:text disable-output-escaping="yes"><![CDATA[<code>]]> </xsl:text>
		 
		</xsl:when>
		<xsl:otherwise>
			<kbd><a href="{/xml/@link}page={/xml/@pagenow - 1}">һҳ</a></kbd>
			<xsl:text disable-output-escaping="yes"><![CDATA[<code>]]> </xsl:text>
		 
		</xsl:otherwise>
	</xsl:choose>
	
	   
	<xsl:choose>
		<xsl:when test="/xml/@pagenow &gt;= /xml/@pagecount">
			<xsl:if test="/xml/@pagecount &gt; 9"><a href="{/xml/@link}page={/xml/@pagecount}" class="active"><xsl:value-of select="/xml/@pagecount"/></a></xsl:if>
			<xsl:text disable-output-escaping="yes"><![CDATA[</code>]]></xsl:text>
			<span class="disable"> һҳ </span> 
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="/xml/@pagecount &gt; 9"><a href="{/xml/@link}page={/xml/@pagecount}"><xsl:value-of select="/xml/@pagecount"/></a></xsl:if>
			<xsl:text disable-output-escaping="yes"><![CDATA[</code>]]></xsl:text>
			 <a href="{/xml/@link}page={/xml/@pagenow + 1}">һҳ</a> 
		</xsl:otherwise>
	</xsl:choose>
	 <xsl:choose>
		<xsl:when test="/xml/@pagenow=/xml/@pagecount">
			<kbd class="disable"> ĩҳ </kbd> 
		</xsl:when>
		<xsl:otherwise>
			<kbd ><a href="{/xml/@link}page={/xml/@pagecount}"> ĩҳ </a></kbd> 
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<!--#̬HTMLҳ-->
<xsl:template name="showPageList_2">
	<script type="text/javascript">var strPageLinks='<xsl:value-of select="/xml/@link"/>';</script>
	<xsl:value-of select="/xml/@totalrec"/>̳ <xsl:value-of select="/xml/@pagenow2"/>/<xsl:value-of select="/xml/@pagecount2"/><xsl:text disable-output-escaping="yes"><![CDATA[<code>]]> </xsl:text> 
	<xsl:choose>
		<xsl:when test="/xml/@pagenow=1">
			<kbd class="disable"> ҳ </kbd>
			<xsl:text disable-output-escaping="yes"><![CDATA[<code>]]> </xsl:text>
		 
		</xsl:when>
		<xsl:otherwise>
			<kbd ><a href="{newasp:ReplaceString(string(/xml/@link),1)}">ҳ</a></kbd>
			<xsl:text disable-output-escaping="yes"><![CDATA[<code>]]> </xsl:text>
		 
		</xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
		<xsl:when test="/xml/@pagenow2=1">
			 һҳ 
			<xsl:text disable-output-escaping="yes"><![CDATA[<code>]]></xsl:text>
 
		</xsl:when>
		<xsl:otherwise>
			<kbd><a href="{newasp:ReplaceString(string(/xml/@link),/xml/@pagenow2 - 1)}">һҳ</a></kbd>
			<xsl:text disable-output-escaping="yes"><![CDATA[<code>]]></xsl:text>
		 
		</xsl:otherwise>
	</xsl:choose>
 
	<xsl:choose>
		<xsl:when test="/xml/@pagenow &gt;= /xml/@pagecount2">
			<xsl:if test="/xml/@pagecount2 &gt; 9"><a href="{newasp:ReplaceString(string(/xml/@link),number(/xml/@pagecount2))}" class="active"><xsl:value-of select="/xml/@pagecount2"/></a></xsl:if>
			<xsl:text disable-output-escaping="yes"><![CDATA[</code>]]></xsl:text>
			  һҳ 
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="/xml/@pagecount2 &gt; 9"><a href="{newasp:ReplaceString(string(/xml/@link),number(/xml/@pagecount2))}"><xsl:value-of select="/xml/@pagecount2"/></a></xsl:if>
			<xsl:text disable-output-escaping="yes"><![CDATA[</code>]]></xsl:text>
			 <a href="{newasp:ReplaceString(string(/xml/@link),number(/xml/@pagenow2 + 1))}">һҳ</a> 
		</xsl:otherwise>
	</xsl:choose>
 <xsl:choose>
		<xsl:when test="/xml/@pagenow=/xml/@pagecount">
			<kbd class="disable"> ĩҳ </kbd> 
		</xsl:when>
		<xsl:otherwise>
			<kbd ><a href="{newasp:ReplaceString(string(/xml/@link2),number(/xml/@pagecount2))}"> ĩҳ </a></kbd> 
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<msxsl:script language="VBScript" implements-prefix="newasp" xmlns:msxsl="urn:schemas-microsoft-com:xslt"><![CDATA[							
	Option Explicit
	
	Function ReplaceString(strValue,i)
		ReplaceString = Replace(strValue, "[page]", i)
	End Function

	Function ReplaceChar(nodelist,strValue,i)
		strValue=GetValue(nodelist,strValue)
		ReplaceChar = Replace(strValue, "[page]", i)
	End Function

	Function GetValue(nodelist,strRef)
		Dim objNode
		Set objNode = nodelist.item(0).selectSingleNode(strRef)
		GetValue = objNode.text
		Set objNode = Nothing
	End Function
]]>
</msxsl:script>

</xsl:stylesheet>