<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.net Sunwin
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="/xml/@action=1"><xsl:call-template name="newslist1"/></xsl:when>
		<xsl:when test="/xml/@action=2"><xsl:call-template name="newslist2"/></xsl:when>
		<xsl:when test="/xml/@action=3"><xsl:call-template name="newslist3"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="newslist"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="newslist">
	<xsl:for-each select="xml/datalist/row">
		<li class="list{@m}"><xsl:if test="/xml/@showdate=1"><span class="globalDate"><xsl:value-of select="@writetime" disable-output-escaping="yes"/></span></xsl:if><xsl:if test="/xml/@showcate=1">[<a href="{@link2}"><xsl:value-of select="@classname"/></a>]</xsl:if>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="newslist1">
	<xsl:for-each select="xml/datalist/row">
		<li class="list-{@m}"><xsl:if test="/xml/@showdate=1"><span class="globalDate"><xsl:value-of select="@writetime" disable-output-escaping="yes"/></span></xsl:if><xsl:if test="/xml/@showcate=1">[<a href="{@link2}"><xsl:value-of select="@classname"/></a>]</xsl:if>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="newslist2">
	<xsl:for-each select="xml/datalist/row">
		<li><xsl:if test="/xml/@showdate=1"><span class="globalDate"><xsl:value-of select="@writetime" disable-output-escaping="yes"/></span></xsl:if><xsl:text disable-output-escaping="yes"><![CDATA[ &rsaquo; ]]></xsl:text><xsl:if test="/xml/@showcate=1">[<a href="{@link2}"><xsl:value-of select="@classname"/></a>]</xsl:if>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="newslist3">
	<xsl:for-each select="xml/datalist/row">
		<li><xsl:if test="/xml/@showdate=1"><span class="globalDate"><xsl:value-of select="@writetime" disable-output-escaping="yes"/></span></xsl:if><xsl:if test="/xml/@showcate=1">[<a href="{@link2}"><xsl:value-of select="@classname"/></a>]</xsl:if>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>
</xsl:stylesheet>