<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.net Sunwin
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="/xml/@action=1"><xsl:call-template name="relatedlist1"/></xsl:when>
		<xsl:when test="/xml/@action=2"><xsl:call-template name="relatedlist2"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="relatedlist"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="relatedlist">
	<xsl:for-each select="xml/datalist/row">
		<li class="list{@m}"><xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="relatedlist1">
	<xsl:for-each select="xml/datalist/row">
		<li class="list-{@m}"><xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="relatedlist2">
	<xsl:for-each select="xml/datalist/row">
		<li><xsl:text disable-output-escaping="yes"><![CDATA[ &rsaquo; ]]></xsl:text><xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>
</xsl:stylesheet>