﻿<!--
 * Copyright (C) 2003-2006 Frederico Caldeira Knabben
 * 
 * Licensed under the terms of the GNU Lesser General Public License:
 * 		http://www.opensource.org/licenses/lgpl-license.php
 * 
 * For further information visit:
 * 		http://www.gzshopping.com/
 *
 * 
 * File Name: basexml.asp
 * 	This file include the functions that create the base XML output.
 * 
 * File Authors:
 * 		Frederico Caldeira Knabben (fredck@gzshopping.com)
-->
<%

Sub SetXmlHeaders()
	' Cleans the response buffer.
	Response.Clear()

	' Prevent the browser from caching the result.
	Response.CacheControl = "no-cache"

	' Set the response format.
	Response.CharSet		= "gb2312"
	Response.ContentType	= "text/xml"
End Sub

Sub CreateXmlHeader( command, resourceType, currentFolder )
	' Create the XML document header.
	Response.Write "<?xml version=""1.0"" encoding=""gb2312"" ?>"

	' Create the main "Connector" node.
	Response.Write "<Connector command=""" & command & """ resourceType=""" & resourceType & """>"
	
	' Add the current folder node.
	Response.Write "<CurrentFolder path=""" & ConvertToXmlAttribute( currentFolder ) & """ url=""" & ConvertToXmlAttribute( GetUrlFromPath( resourceType, currentFolder) ) & """ />"
End Sub

Sub CreateXmlFooter()
	Response.Write "</Connector>"
End Sub

Sub SendError( number, text )
	SetXmlHeaders
	
	' Create the XML document header.
	Response.Write "<?xml version=""1.0"" encoding=""gb2312"" ?>"
	
	Response.Write "<Connector><Error number=""" & number & """ text=""" & Server.HTMLEncode( text ) & """ /></Connector>"
	
	Response.End
End Sub
%>