<%'@ Language=VBScript %>
<%
'**************************************************************************
' CLASS: cRandom
'	Calls randomize to seed the random number generator.
'	Provides functions for returning ranged random integers or arrays of
'	ranged random integers.
'**************************************************************************
Class Ixinde_Random
	
	' Calling randomize to seed the random number generator at the time the 
	' class is created seemed like a reasonable thing to do.
	Private sub Class_Initialize()
		' Check the VBScript documentation for the specifics relating
		' to the Randomize function
		Randomize
	End sub
		
	' Terminate doesn't need to do anything for this class
	Private sub Class_Terminate()
		
	End sub
		
	'**********************************************************************
	' FUNCTION:		RangedRandom
	' PARAMETER:	lowerBound, the lowest allowable number to return
	' PARAMETER:	upperBound, the highest allowable number to return
	' RETURNS:		A random integer between lowerBound and UpperBound,
	'				inclusive
	'**********************************************************************
	Public Function RangedRandom( lowerBound, upperBound )
		RangedRandom = CInt((upperBound - lowerBound) * Rnd + lowerBound)
	End Function
		
	'**********************************************************************
	' FUNCTION:  RangedRandomArray
	' PARAMETER: lowerBound, the lowest allowable number to return
	' PARAMETER: upperBound, the highest allowable number to return
	' PARAMETER: arraySize, zero based number specifying the size of the array
	' PARAMETER: duplicates, true or false to indicate whether duplicate
	'            random values are allowed in the array
	' RETURNS:	 A single dimension array sized to match the arraySize 
	'			 parameter, containing random integers between lowerBound and 
	'			 upperBound, inclusive
	'**********************************************************************
	Public Function RangedRandomArray(lowerBound, upperBound, arraySize, duplicates)
		Dim tempArray()
		Dim filledElements, tempValue, badValue, i
			
		' resize the tempArray to hold the number of elements passed in the
		' arraySize parameter
		Redim tempArray(arraySize)
		
		' This is a loop counter, set it to 0
		filledElements = 0
		
		' loop until filledElements is equal to the arraySize + 1
		Do until filledElements = arraySize + 1
			
			' Call the RangedRandom function with the lowerBound and upperBoundparameters
			tempValue = RangedRandom( lowerBound, upperBound )
			
			' Handle the case where we don't want duplicate values
			If duplicates = false Then
				badValue = false
				For i = 0 to UBound(tempArray)
					' check if the new random value already exists in the array
					' if it does set the badValue flag to true and break out of the loop
					If tempValue = tempArray(i) Then
						badValue = true
						Exit For
					End If
				Next 
				If badValue = false Then
					tempArray(filledElements) = tempValue
					filledElements = filledElements + 1
				End If
			Else
				' Handle the case where duplicate values in the array are acceptable
				tempArray(filledElements) = tempValue
				filledElements = filledElements + 1
			End If
		loop
		
		' return the array
		RangedRandomArray = tempArray
	End Function
		
	Public Function RangedRandomNumber( lowerBound, upperBound, size)
		
		Dim randomNumber, i
		For i = 1 to size
			randomNumber = randomNumber & RangedRandom( lowerBound, upperBound )
		Next
		
		RangedRandomNumber = randomNumber
		
	End Function

End Class
%> 
