<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.net Sunwin
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="/xml/@action=1"><xsl:call-template name="imagelist1"/></xsl:when>
        <xsl:when test="/xml/@action=2"><xsl:call-template name="imagelist2"/></xsl:when>
        <xsl:when test="/xml/@action=3"><xsl:call-template name="imagelist3"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="imagelist"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="imagelist1">
	<xsl:for-each select="xml/datalist/row">
		<li class="listimg1"><a href="{@link}"><img src="{@imglink}" width="{/xml/@width}" height="{/xml/@height}" border="0" /></a><span><xsl:value-of select="@content" disable-output-escaping="yes"/></span><br />
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="imagelist">
	<xsl:for-each select="xml/datalist/row">
		<li class="listimg1"><xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}"><img src="{@imglink}" width="{/xml/@width}" height="{/xml/@height}" border="0" alt="{@title}" /></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}"><img src="{@imglink}" width="{/xml/@width}" height="{/xml/@height}" border="0" alt="{@title}" /></a></xsl:otherwise>
		</xsl:choose>
		<span><xsl:value-of select="@content" disable-output-escaping="yes"/></span>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="imagelist2">
	<xsl:for-each select="xml/datalist/row">
      <li style="padding:0 13px"><a target="_blank" href="{@link}"> <img alt="{@title}"  src="{@imglink}" /> </a><a target="_blank" href="{@link}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></li>
	</xsl:for-each>
</xsl:template>
<xsl:template name="imagelist3">
	<xsl:for-each select="xml/datalist/row">
    	<li><a 
href="{@link}" target="_blank"><img src="{@imglink}"  alt="{@title}"  width="130" height="88"/></a><a href="{@link}"
target="_blank"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></li>
	</xsl:for-each>
</xsl:template>
</xsl:stylesheet>