<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:newasp="#newasp-functions" exclude-result-prefixes="msxsl newasp">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.net Sunwin
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="/xml/@action=0"><xsl:call-template name="showPageList_1"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="showPageList_2"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<!--#ASP̬ҳҳ-->
<xsl:template name="showPageList_1">
	<span><xsl:value-of select="/xml/@totalrec"/>/<xsl:value-of select="/xml/@pagecount"/></span>
	<xsl:choose>
		<xsl:when test="/xml/@pagenow=1">
			
			<xsl:if test="/xml/@pagenow &lt;= /xml/@m">
				<a href="index_{@i}.html" class="active">1</a>
			</xsl:if>
		</xsl:when>
		<xsl:otherwise>
		
			<xsl:if test="/xml/@pagenow &lt;= /xml/@m or /xml/@pagecount &lt;= /xml/@max">
				<a href="index_{@i}.html">1</a>
			</xsl:if>
		</xsl:otherwise>
	</xsl:choose>
	
	<xsl:for-each select="xml/datalist/row">
		<xsl:choose>
			<xsl:when test="/xml/@pagenow = @i">
				<a href="index_{@i}.html" class="active"><xsl:value-of select="@i"/></a> 
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="@s = 0">
						<!--a href="javascript:;"><xsl:value-of select="@i"/></a--> 
					</xsl:when>
					<xsl:otherwise>
						<a href="index_{@i}.html"><xsl:value-of select="@i"/></a>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	<xsl:choose>
		<xsl:when test="/xml/@pagenow &gt;= /xml/@pagecount">
			<xsl:if test="/xml/@pagenow &gt; /xml/@m and /xml/@pagecount &gt; /xml/@max">
				<xsl:choose>
					<xsl:when test="/xml/@pagenow = /xml/@i">
						<a href="index_{@i}.html" class="active"><xsl:value-of select="/xml/@i"/></a> 
					</xsl:when>
					<xsl:otherwise>
						<a href="index_{@i}.html"><xsl:value-of select="/xml/@i"/></a>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="/xml/@pagenow &gt; /xml/@m and /xml/@pagecount &gt; /xml/@max"><a href="index_{@i}.html"><xsl:value-of select="/xml/@i"/></a></xsl:if>
		
		</xsl:otherwise>
	</xsl:choose>
	<span><input type="text" title="֣سת" size="3" onkeydown="if (13==event.keyCode) document.location.href='{/xml/@link}page='+this.value" value="{/xml/@pagenow}" /></span>
</xsl:template>
<!--#̬HTMLҳ-->
<xsl:template name="showPageList_2">
	<script type="text/javascript">var strPageLinks='<xsl:value-of select="/xml/@link"/>';</script>
	<span><xsl:value-of select="/xml/@totalrec"/>/<xsl:value-of select="/xml/@pagecount"/></span>
	<xsl:choose>
		<xsl:when test="/xml/@pagenow=1">
		
			<xsl:if test="/xml/@pagenow &lt;= /xml/@m">
				<a href="" class="active">1</a>
			</xsl:if>
		</xsl:when>
		<xsl:otherwise>
		
			<xsl:if test="/xml/@pagenow &lt;= /xml/@m or /xml/@pagecount &lt;= /xml/@max">
				<a href="">1</a>
			</xsl:if>
		</xsl:otherwise>
	</xsl:choose>
	
	<xsl:for-each select="xml/datalist/row">
		<xsl:choose>
			<xsl:when test="/xml/@pagenow = @i">
				<a href="index_{@i}.html" class="active"><xsl:value-of select="@i"/></a> 
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="@s = 0">
						<!--a href="javascript:;"><xsl:value-of select="@i"/></a--> 
					</xsl:when>
					<xsl:otherwise>
						<a href="index_{@i}.html"><xsl:value-of select="@i"/></a>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	
	<xsl:choose>
		<xsl:when test="/xml/@pagenow &gt;= /xml/@pagecount">
			<xsl:if test="/xml/@pagenow &gt; /xml/@m and /xml/@pagecount &gt; /xml/@max">
				<xsl:choose>
					<xsl:when test="/xml/@pagenow = /xml/@i">
						<a href="index_{@i}.html" class="active"><xsl:value-of select="/xml/@i"/></a> 
					</xsl:when>
					<xsl:otherwise>
						<a href="index_{@i}.html"><xsl:value-of select="/xml/@i"/></a>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="/xml/@pagenow &gt; /xml/@m and /xml/@pagecount &gt; /xml/@max"><a href="index_{@i}.html"><xsl:value-of select="/xml/@i"/></a></xsl:if>
		
		</xsl:otherwise>
	</xsl:choose>
	<span><input type="text" title="֣سת" size="3" onkeydown="if (13==event.keyCode) document.location.href=strPageLinks.replace(/\[page\]/ig,this.value)" value="{/xml/@pagenow}" /></span>
</xsl:template>

<msxsl:script language="VBScript" implements-prefix="newasp" xmlns:msxsl="urn:schemas-microsoft-com:xslt"><![CDATA[							
	Option Explicit
	
	Function ReplaceString(strValue,i)
		ReplaceString = Replace(strValue, "[page]", i)
	End Function

	Function ReplaceChar(nodelist,strValue,i)
		strValue=GetValue(nodelist,strValue)
		ReplaceChar = Replace(strValue, "[page]", i)
	End Function

	Function GetValue(nodelist,strRef)
		Dim objNode
		Set objNode = nodelist.item(0).selectSingleNode(strRef)
		GetValue = objNode.text
		Set objNode = Nothing
	End Function
]]>
</msxsl:script>

</xsl:stylesheet>