<%
Class UBBEditor_Cls
	Private m_strBasePath
	Private m_strWidth
	Private m_strHeight
	Private m_strValue
	Private m_strToolbarSet
	Private m_strInstanceName
	Private m_blnUserMode
	Private MsxmlVersion
	
	Private Sub Class_Initialize()
		m_strBasePath		= "/editor/ubbeditor/"
		m_strWidth		= "100%"
		m_strHeight		= "300"
		m_strToolbarSet		= "default"
		m_strValue		= ""
		m_strInstanceName	= "textContent"
		m_blnUserMode		= False
		MsxmlVersion		= ".3.0"
	End Sub

	Public Property Let BasePath( basePathValue )
		m_strBasePath = basePathValue
	End Property

	Public Property Let InstanceName( instanceNameValue )
		m_strInstanceName = instanceNameValue
	End Property

	Public Property Let Width( widthValue )
		m_strWidth = widthValue
		If m_strWidth = "0" Then m_strWidth = "100%"
		If InStr( m_strWidth, "%" ) > 0  Then
			m_strWidth = m_strWidth
		Else
			m_strWidth = m_strWidth & "px"
		End If
	End Property

	Public Property Let Height( heightValue )
		m_strHeight = heightValue
		If m_strHeight = "0" Then m_strHeight = "100%"
		If InStr( m_strHeight, "%" ) > 0  Then
			m_strHeight = m_strHeight
		Else
			m_strHeight = m_strHeight & "px"
		End If
	End Property
	
	Public Property Let ToolbarSet( toolbarSetValue )
		If ( IsNull( toolbarSetValue ) OR IsEmpty( toolbarSetValue ) ) Then
			m_strToolbarSet = "default"
		Else
			m_strToolbarSet = LCase(toolbarSetValue)
		End If
	End Property

	Public Property Let UserMode( userModeValue )
		m_blnUserMode = userModeValue
	End Property
	
	Public Property Let Value( newValue )
		If ( IsNull( newValue ) OR IsEmpty( newValue ) ) Then
			m_strValue = ""
		Else
			m_strValue = newValue
		End If
	End Property
	
	Public Function CreateEditor()
		Dim XMLDom,Node,xmlNode,XSLT,XMLStyle,proc
		Set XMLDom=Server.CreateObject("msxml2.FreeThreadedDOMDocument"& MsxmlVersion)
		XMLDom.appendChild(XMLDom.createElement("xml"))
		Set Node=XMLDom.createNode(1,"setting","")
		Node.attributes.setNamedItem(XMLDom.createNode(2,"width","")).text = m_strWidth
		Node.attributes.setNamedItem(XMLDom.createNode(2,"height","")).text = m_strHeight
		Node.attributes.setNamedItem(XMLDom.createNode(2,"path","")).text = m_strBasePath
		Node.attributes.setNamedItem(XMLDom.createNode(2,"instancename","")).text = m_strInstanceName
		Node.attributes.setNamedItem(XMLDom.createNode(2,"toolbar","")).text = m_strToolbarSet
		Node.attributes.setNamedItem(XMLDom.createNode(2,"value","")).text = Server.HTMLEncode(m_strValue)
		Node.attributes.setNamedItem(XMLDom.createNode(2,"usermode","")).text = m_blnUserMode
		XMLDom.documentElement.appendChild(Node)

		Set xmlNode = XMLDom.cloneNode(True)
		Set XSLT = Server.CreateObject("Msxml2.XSLTemplate" & MsxmlVersion)
		Set XMLStyle = Server.CreateObject("Msxml2.FreeThreadedDOMDocument"& MsxmlVersion)
		If XMLStyle.load(Server.MapPath(m_strBasePath & "ubbeditor.xslt")) Then
			XSLT.stylesheet = XMLStyle
			Set proc = XSLT.createProcessor()
			proc.input = xmlNode
			proc.transform()
			Response.Write proc.output
			Set proc = Nothing
		Else
			Response.Write vbNullString
		End If
		Set XMLStyle = Nothing
		Set XSLT = Nothing:Set xmlNode = Nothing
		Set Node = Nothing:Set XMLDom = Nothing

	End Function
	
	
End Class
%>