﻿<%
Const MsxmlVersion = "Microsoft.XMLDOM"

Class class_connxml
    Public xmldom, xml_root, xml_nodelist, xmlfile, error_info, xml_newnode

    Private Sub class_initialize()
        On Error Resume Next
        Set xmldom = Server.CreateObject(MsxmlVersion)
        If Int(Err.Number)> 0 Then
            response.Write Err.Description
            Err.Clear
            response.End
        End If
    End Sub

    Function isexist_file(file_path)
        Dim filetemp, fileos, fso_sys_var
        fso_sys_var = "script"&"ing.file"&"sys"&"tem"&"object"
        Set fileos = server.CreateObject(fso_sys_var)
        isexist_file = False
        If (fileos.FileExists(file_path)) Then
            filetemp = True
        Else
            filetemp = False
        End If
        Set fileos = Nothing
        isexist_file = filetemp
    End Function

    Public Sub load_xmldoc(filepath)
        If IsNull(xmldom) = False Then
            xmlfile = server.mappath(filepath)
            If Not xmldom.load(xmlfile) Then
                Response.Write "内核数据初始化错误！"
                Response.End
                Exit Sub
            End If
            xmldom.PreserveWhitespace = True
            Set xml_root = xmldom.documentElement
        End If
    End Sub

    Public Sub load_xmltxt(filepath)
        If IsNull(xmldom) = False Then
            Dim isok_loadxml, xmldoc_txt
            xmldoc_txt = get_formatfile(filepath, -1)
            xmldom.async = False
            isok_loadxml = xmldom.loadXML(xmldoc_txt)
            If isok_loadxml = False Then
                Response.Write "内核数据初始化错误！"
                Response.End
                Exit Sub
            End If
            xmldom.PreserveWhitespace = False
            Set xml_root = xmldom.documentElement
        End If
    End Sub

    Public Function get_subnode(nodename)
        Dim current_node
        Set current_node = xml_root.selectNodes(nodename)
        If Not(current_node Is Nothing) And (current_node.Length>0) Then
            Set xml_nodelist = current_node
        Else
            Set xml_nodelist = Nothing
        End If
        Set get_subnode = xml_nodelist
    End Function

    Public Function get_onenode(sel_nodeinfo)
        Dim current_node
        Set current_node = xml_root.selectSingleNode(sel_nodeinfo)
        If Not(current_node Is Nothing) Then
            Set get_onenode = current_node
        Else
            Set get_onenode = Nothing
        End If
    End Function

    Public Function get_attrnode(nodename, attr_name, attr_text)
        Dim current_node
        Set current_node = xml_root.selectSingleNode(nodename & "[@" & attr_name & "='" & attr_text & "']")
        If Not(current_node Is Nothing) Then
            Set get_attrnode = current_node
        Else
            Set get_attrnode = Nothing
        End If
    End Function

    Public Sub update_attrnode(node_obj, attr_name, attr_text)
        Dim current_node, nownode_obj
        Set nownode_obj = node_obj
        If Not(node_obj Is Nothing) Then
            Set current_node = nownode_obj.Attributes.getNamedItem(attr_name)
            If Not(current_node Is Nothing) Then
                current_node.text = attr_text
            End If
        End If
    End Sub

    Public Sub update_elemnode(nodename, elem_name, elem_text)
        Dim current_node, cdata_elem
        If Trim(nodename)<>"" Then
            Set current_node = xml_root.selectSingleNode(nodename & "/" & elem_name)
        Else
            Set current_node = xml_root.selectSingleNode(elem_name)
        End If
        Set cdata_elem = xmldom.createCDATASection(elem_text)
        If Not(current_node Is Nothing) Then
            current_node.removeChild(current_node.firstChild)
            current_node.appendChild(cdata_elem)
        End If
    End Sub

    Public Sub delete_elemnode(node_obj)
        If Not(node_obj Is Nothing) Then
            xmldom.PreserveWhitespace = True
            xml_root.removeChild(node_obj)
        End If
    End Sub

    Public Sub save_xmldom()
        xmldom.PreserveWhitespace = True
        xmldom.save xmlfile
    End Sub

    Public Function getattr_value(nodename, attr_name, attr_text, other_attrname)
        If Not(xml_root Is Nothing) Then
            Dim current_node, other_attrobj
            getattr_value = ""
            Set current_node = xml_root.selectSingleNode(nodename & "[@" & attr_name & "='" & attr_text & "']")
            If Not(current_node Is Nothing) Then
                Set other_attrobj = current_node.Attributes.getNamedItem(other_attrname)
                If Not(other_attrobj Is Nothing) Then
                    getattr_value = other_attrobj.text
                End If
            End If
        End If
    End Function

    Public Function getelem_value(nodename, elem_name)
        If IsNull(xml_root) = False Then
            Dim current_node, other_attrobj
            getelem_value = ""
            If Trim(nodename)<>"" Then
                Set current_node = xml_root.selectSingleNode(nodename & "/" & elem_name)
            Else
                Set current_node = xml_root.selectSingleNode(elem_name)
            End If
            If Not(current_node Is Nothing) Then
                getelem_value = current_node.text
            End If
        End If
    End Function

    Public Sub xmldom_clear()
        Set xmldom = Nothing
        Set xml_root = Nothing
        Set xml_nodelist = Nothing
        xmlfile = ""
    End Sub

    Function getHtml_XmlXslt(xml_file, xsl_file)
        Dim xmlDoc, xslDoc, xmlfile, xslfile
        xmlfile = server.MapPath(xml_file)
        xslfile = server.MapPath(xsl_file)
        On Error Resume Next
        Set xmlDoc = Server.CreateObject(MsxmlVersion)
        If Err.Number > 0 Then
            error_info = Err.Description
            Err.Clear
            response.End
        End If
        xmlDoc.async = False
        xmlDoc.load(xmlfile)
        Set xslDoc = Server.CreateObject(MsxmlVersion)
        If Err.Number > 0 Then
            error_info = Err.Description
            Err.Clear
            response.End
        End If
        xslDoc.async = False
        xslDoc.load(xslfile)
        getHtml_XmlXslt = xmlDoc.transformNode(xslDoc)
        Set xmlDoc = Nothing
        Set xslDoc = Nothing
    End Function

    Function getHtml_DocXslt(xml_file, xsl_file)
        Dim xmlDoc, xslDoc, xmlfile, xslfile
        xslfile = server.MapPath(xsl_file)
        On Error Resume Next
        Set xmlDoc = Server.CreateObject(MsxmlVersion)
        If Err.Number > 0 Then
            error_info = Err.Description
            Err.Clear
            response.End
        End If
        xmlDoc.async = False
        xmlDoc.loadXML(xml_file)
        Set xslDoc = Server.CreateObject(MsxmlVersion)
        If Err.Number > 0 Then
            error_info = Err.Description
            Err.Clear
            response.End
        End If
        xslDoc.async = False
        xslDoc.load(xslfile)
        getHtml_DocXslt = xmlDoc.transformNode(xslDoc)
        Set xmlDoc = Nothing
        Set xslDoc = Nothing
    End Function

    Public Property Get getErrorInfo()
        getErrorInfo = error_info
    End Property

End Class
%>