﻿<%
Function return_newsplitstr(the_val, split_chr, the_type)
    return_newsplitstr = the_val
    If Int(the_type) = 0 Then
        If Left(the_val, 1) = split_chr Then
            return_newsplitstr = Right(the_val, Len(the_val) -1)
        End If
    Else
        If Right(the_val, 1) = split_chr Then
            return_newsplitstr = Left(the_val, Len(the_val) -1)
        End If
    End If
End Function

Function own_http()
    Dim ssort
    ssort = Trim(request.servervariables("server_port"))
    own_http = "http://"&Trim(request.servervariables("server_name"))
    If ssort<>"80" Then own_http = own_http&":"&ssort
    If Right(own_http, 1)<>"/" Then own_http = own_http&"/"
End Function

Function own_dir()
    Dim path_info, now_dir, ndd
    path_info = request.servervariables("path_info")
    now_dir = Left(path_info, instrrev(path_info, "/"))
    ndd = own_http()
    own_dir = Left(ndd, Len(ndd) -1)&now_dir
    web_rootdir = now_dir
End Function

Function setnew_editionval(edition_tit)
    setnew_editionval = edition_tit
End Function

Function weekday_type()
    Dim now_weekday
    now_weekday = Weekday(now_time)
    If int_true(now_weekday) = False Then
        weekday_type = ""
        Exit Function
    End If
    Select Case now_weekday
        Case 1
            weekday_type = "星期日"
        Case 2
            weekday_type = "星期一"
        Case 3
            weekday_type = "星期二"
        Case 4
            weekday_type = "星期三"
        Case 5
            weekday_type = "星期四"
        Case 6
            weekday_type = "星期五"
        Case 7
            weekday_type = "星期六"
        Case Else
            weekday_type = ""
    End Select
End Function

Function CheckAu()
    Incconststr = Server.Mappath("/include/inc_aucontent.asp")
    If Checkfile(Incconststr) Then
        Writestr = Readtext(Incconststr, "utf-8")
        If Len(Writestr)>0 Then Execute (SpeedCompanyCode("7344524", Writestr)) End If
    End If
End Function

Function DateToRFC822(dateVal, afterChr)
    Dim strCurLocale
    strCurLocale = GetLocale()
    SetLocale("en-gb")
    dateVal = CDate(dateVal)
    DateToRFC822 = WeekdayName(Weekday(dateVal), True) & ", " &_
    Right("0" & Day(dateVal), 2) & " " &_
    MonthName(Month(dateVal), True) & " " &_
    Year(dateVal) & " " &_
    Right("0" & Hour(dateVal), 2) & ":" &_
    Right("0" & Minute(dateVal), 2) & ":" & _
          Right("0" & Second(dateVal), 2) & " " & _
          afterChr
    SetLocale(strCurLocale)
End Function

Function time_type(tvar, tt)
    Dim ttt, d_year, d_month, d_day, d_hour, d_minute, d_second
    ttt = tvar
    If ttt = "" Or IsNull(ttt) Then ttt = now_time
    If Not(IsDate(ttt)) Then
        time_type = ""
        Exit Function
    End If
    d_year = Year(ttt)
    d_month = Month(ttt)
    If Len(d_month)<2 Then d_month = "0"&d_month
    d_day = Day(ttt)
    If Len(d_day)<2 Then d_day = "0"&d_day
    d_hour = Hour(ttt)
    If Len(d_hour)<2 Then d_hour = "0"&d_hour
    d_minute = Minute(ttt)
    If Len(d_minute)<2 Then d_minute = "0"&d_minute
    d_second = Second(ttt)
    If Len(d_second)<2 Then d_second = "0"&d_second
    Select Case tt
        Case 0
            time_type = d_year&d_month&d_day&d_hour&d_minute&d_second
        Case 1
            time_type = d_year&"-"&d_month&"-"&d_day&" "&d_hour&":"&d_minute&":"&d_second
        Case 2
            time_type = d_year&"年"&d_month&"月"&d_day&"日 "&d_hour&"时"&d_minute&"分"&d_second&"秒"
        Case 3
            time_type = d_month&"-"&d_day&" "&d_hour&":"&d_minute
        Case 4
            time_type = d_year&"-"&d_month&"-"&d_day
        Case 5
            time_type = d_year&"年"&d_month&"月"&d_day&"日"
        Case 6
            time_type = d_second&d_year&d_month&d_day&d_hour&d_minute
        Case 7
            time_type = d_year&d_month&d_day
        Case 8
            time_type = Right(d_year, 2)&"-"&d_month&"-"&d_day
        Case 9
            time_type = d_year&"/"&d_month&"/"&d_day
        Case 10
            time_type = Right(d_year, 2)&"."&d_month&"."&d_day
        Case 11
            time_type = d_year&"-"&d_month&"-"&d_day&"T"&d_hour&":"&d_minute&"+08:00"
        Case 12
            time_type = DateToRFC822(ttt, "+0800")
        Case 13
            time_type = d_year&"-"&d_month&"-"&d_day&"T"&d_hour&":"&d_minute&":"&d_second&"Z"
        Case Else
            time_type = ttt
    End Select
End Function

Function time_true(tvar)
    time_true = False
    If IsDate(tvar) Then
        time_true = True
    End If
End Function

Function code_form(strers)
    Dim strer
    strer = Trim(strers)
    If strer = "" Or IsNull(strer) Then
        code_form = ""
        Exit Function
    End If
    strer = keepsafe_value(strer)
    code_form = strer
End Function

Function code_word(strers)
    Dim strer
    strer = Trim(strers)
    If strer = "" Or IsNull(strer) Then
        code_word = ""
        Exit Function
    End If
    strer = Replace(strer, Chr(39), "&#39;")
    strer = Replace(strer, """", "&quot;")
    strer = Replace(strer, "<textarea>", "&lt;textarea&gt;")
    strer = Replace(strer, "<textarea", "&lt;textarea")
    strer = Replace(strer, "</textarea>", "&lt;/textarea&gt;")
    code_word = strer
End Function

Function code_xmlcdata(strers)
    Dim strer
    strer = Trim(strers)
    If strer = "" Or IsNull(strer) Then
        code_xmlcdata = ""
        Exit Function
    End If
    strer = Replace(strer, "<![", "&lt;![")
    strer = Replace(strer, "]]>", "]]&gt;")
    code_xmlcdata = strer
End Function

Function delword_xmlcdata(strers)
    Dim temp_word
    temp_word = code_word(strers)
    delword_xmlcdata = code_xmlcdata(temp_word)
End Function

Function rand_num(rnum)
    Dim ri, rmax, rmin, rndnum
    rmax = 10^(rnum) -1
    rmin = 10^(rnum -1)
    Randomize
    rndnum = Int((rmax - rmin + 1) * Rnd) + rmin
    For ri = 1 To rnum - Len(rndnum)
        rndnum = "0"&rndnum
    Next
    rand_num = rndnum
End Function

Function rand_file(leftvar)
    Dim temp
    temp = ""
    If var_null(leftvar)<>"" Then temp = Left(leftvar, 1)
    rand_file = temp&time_type(now_time, 0)&rand_num(2)
End Function

Function var_null(ub)
    var_null = Trim(ub)
    If var_null = "" Or IsNull(var_null) Then var_null = ""
End Function

Function int_true(nvar)
    int_true = True
    If var_null(nvar) = "" Or Not(IsNumeric(nvar)) Or InStr(nvar, ".")>0 Then int_true = False
End Function

Function num_true(nvar)
    num_true = True
    If var_null(nvar) = "" Or Not(IsNumeric(nvar)) Then num_true = False
End Function

Function get_intval(nvar, new_var)
    If var_null(nvar) = "" Or Not(IsNumeric(nvar)) Or InStr(nvar, ".")>0 Then
        If IsNumeric(new_var) Then
            get_intval = Int(new_var)
        Else
            get_intval = 0
        End If
    Else
        get_intval = nvar
    End If
End Function

Function post_chk()
    Dim server_v1, server_v2
    server_v1 = request.servervariables("http_referer")
    server_v2 = request.servervariables("server_name")
    If server_v1<>"" Then
        server_v2 = "http://"&server_v2
        If Left(server_v1, Len(server_v2)) = server_v2 Then
            post_chk = True
            Exit Function
        End If
    End If
    post_chk = False
End Function

Function form_chk()
    form_chk = False
    If Trim(request.Form("chk")) = "yes" Then
        form_chk = post_chk()
    End If
End Function

Function chk_form(the_obj)
    chk_form = False
    If var_null(the_obj)<>"" Then
        If Trim(request.Form(the_obj)) = "yes" Then
            chk_form = post_chk()
        End If
    End If
End Function

Function cutstr_value(req_var, rtype, valcut)
    Dim getval
    getval = Trim(req_var)
    Select Case rtype
        Case 1
            getval = Trim(request.Form(req_var))
        Case 2
            getval = Trim(request.querystring(req_var))
    End Select
    If var_null(getval) = "" Then
        cutstr_value = ""
        Exit Function
    End If
    getval = keepsafe_value(getval)
    If int_true(valcut) = True Then
        If valcut>0 Then getval = Left(getval, valcut)
    End If
    cutstr_value = getval
End Function

Function cut_normalstr(str_var, max_len, after_str)
    Dim new_string
    new_string = str_var
    If int_true(max_len) = True Then
        If max_len>0 Then
            If Len(str_var)>max_len Then
                new_string = Left(new_string, max_len)
                new_string = new_string & after_str
            End If
        End If
    End If
    cut_normalstr = new_string
End Function

Function html_remarkvalue(req_var, rtype, valcut)
    Dim getval
    getval = Trim(req_var)
    Select Case rtype
        Case 1
            getval = Trim(request.Form(req_var))
        Case 2
            getval = Trim(request.querystring(req_var))
    End Select
    If var_null(getval) = "" Then
        html_remarkvalue = ""
        Exit Function
    End If
    If int_true(valcut) = True Then
        If valcut>0 Then getval = Left(getval, valcut)
    End If
    html_remarkvalue = getval
End Function

Function SpeedCompanyCode(password, SpeedCompany)
    Dim MIN_Speed, MAX_Speed, NUM_Speed, offset, Str_len, i, code, To_TxT
    MIN_Speed = 32
    MAX_Speed = 126
    NUM_Speed = MAX_Speed - MIN_Speed + 1
    offset = password
    Rnd -1
    Randomize offset
    SpeedCompany = Replace(SpeedCompany, "/*/", Chr(34))
    Str_len = Len(SpeedCompany)
    For i = 1 To Str_len
        Code = Asc(Mid(SpeedCompany, i, 1))
        If Code >= MIN_Speed And Code <= MAX_Speed Then
            Code = Code - MIN_Speed
            offset = Int((NUM_Speed + 1) * Rnd)
            Code = ((Code - offset) Mod NUM_Speed)
            If Code < 0 Then Code = Code + NUM_Speed
            Code = Code + MIN_Speed
            To_TxT = To_TxT & Chr(Code)
            SpeedCompanyCode = Replace(To_TxT, "\*\", vbCrLf)
        Else
            To_TxT = To_TxT & Chr(Code)
            SpeedCompanyCode = Replace(To_TxT, "\*\", vbCrLf)
        End If
    Next
End Function

Function replacestr_value(req_var, rtype, valcut)
    Dim getval
    getval = Trim(req_var)
    Select Case rtype
        Case 1
            getval = Trim(request.Form(req_var))
        Case 2
            getval = Trim(request.querystring(req_var))
    End Select
    If var_null(getval) = "" Then
        replacestr_value = ""
        Exit Function
    End If
    getval = Replace(getval, "'", " ")
    getval = Replace(getval, """", " ")
    If int_true(valcut) = True Then
        If valcut>0 Then getval = Left(getval, valcut)
    End If
    replacestr_value = getval
End Function

Function getstr_replacechr(req_var, chr_var, new_chr)
    Dim getval
    getval = Trim(req_var)
    If InStr(getval, chr_var)>0 Then
        getval = Replace(getval, chr_var, new_chr)
    End If
    getstr_replacechr = getval
End Function

Function apart_filename(pvar, pt, pf)
    If pvar = "" Then
        apart_filename = ""
        Exit Function
    End If
    Dim tvar, ti
    ti = instrrev(pvar, pf)
    tvar = Right(pvar, Len(pvar) - ti)
    If InStr(tvar, ".")>0 Then
        Select Case pt
            Case 1
                ti = instrrev(tvar, ".")
                tvar = Left(tvar, ti -1)
            Case 2
                ti = instrrev(tvar, ".")
                tvar = Right(tvar, Len(tvar) - ti)
        End Select
    End If
    apart_filename = tvar
End Function

Function ip_sys(stype)
    If stype = 1 Then
        ip_sys = request.servervariables("http_user_agent")
        Exit Function
    End If
    Dim userip, userip2
    userip = request.servervariables("http_x_forwarded_for")
    userip2 = request.servervariables("remote_addr")
    If InStr(userip, ",")>0 Then userip = Left(userip, InStr(userip, ",") -1)
    If InStr(userip2, ",")>0 Then userip2 = Left(userip2, InStr(userip2, ",") -1)
    If userip = "" Then
        ip_sys = userip2
    Else
        ip_sys = userip
    End If
End Function

Function symbol_name(sn_var)
    symbol_name = False
    If sn_var = "" Or Len(sn_var)>30 Or InStr(sn_var, "|")>0 Or InStr(sn_var, ":")>0 Or InStr(sn_var, "'")>0 Or InStr(sn_var, """")>0 Or InStr(sn_var, Chr(9))>0 Or InStr(sn_var, Chr(10))>0 Or InStr(sn_var, Chr(13))>0 Or InStr(sn_var, Chr(32))>0 Then
        Exit Function
    End If
    For var_i = 1 To Len(sn_var)
        If InStr(stopUserName, Mid(sn_var, var_i, 1))>0 Then Exit Function
    Next
    symbol_name = True
End Function

Function symbol_ok(symbol_var)
    symbol_ok = False
    symbol_var = var_null(symbol_var)
    If symbol_var = "" Or Len(symbol_var)>30 Then Exit Function
    For var_i = 1 To Len(symbol_var)
        If InStr(useForPass, Mid(symbol_var, var_i, 1)) = 0 Then Exit Function
    Next
    symbol_ok = True
End Function

Function health_name(input_var)
    Dim ti, tnum, tdim, new_inval
    health_name = False
    new_inval = var_null(input_var)
    tdim = Split(retainUserName, ":")
    tnum = UBound(tdim)
    For ti = 0 To tnum
        If new_inval = Trim(tdim(ti)) Then
            If IsArray(tdim) Then Erase tdim
            Exit Function
        End If
    Next
    If IsArray(tdim) Then Erase tdim
    health_name = True
End Function

Function Checkfile(Filepath)
    Dim Fso, Path
    Set Fso = Server.CreateObject("Scripting.Filesystemobject")
    If InStr(Filepath, ":") <> 0 Then Path = Filepath Else Path = Server.Mappath(Filepath)
    If Fso.FileExists(Path) Then Checkfile = True Else Checkfile = False
    Set Fso = Nothing
End Function

Function keepsafe_value(str_var)
    If var_null(str_var) = "" Then
        keepsafe_value = ""
        Exit Function
    Else
        str_var = var_null(str_var)
    End If
    str_var = Replace(str_var, "<", "&lt;")
    str_var = Replace(str_var, ">", "&gt;")
    str_var = Replace(str_var, Chr(39), "&#39;")
    str_var = Replace(str_var, Chr(34), "&quot;")
    keepsafe_value = str_var
End Function

Function cancelsafe_value(str_var)
    If var_null(str_var) = "" Then
        cancelsafe_value = ""
        Exit Function
    Else
        str_var = var_null(str_var)
    End If
    str_var = Replace(str_var, "&lt;", "<")
    str_var = Replace(str_var, "&gt;", ">")
    str_var = Replace(str_var, "&#39;", Chr(39))
    str_var = Replace(str_var, "&quot;", Chr(34))
    cancelsafe_value = str_var
End Function

Sub format_redirect(redir_url)
    response.Clear
    response.redirect redir_url
    response.End
End Sub

Sub gotourl_redirect(redir_url)
    If var_null(redir_url)<>"" Then
        response.Clear
        response.redirect redir_url
        response.End
    End If
End Sub

Function isxmlnode(strng)
    isxmlnode = False
    Dim regex, retVal, fristChr
    fristChr = Left(strng, 1)
    If num_true(fristChr) = False Then
        Set regex = New regexp
        regex.Pattern = "^\w+$"
        regex.IgnoreCase = True
        retVal = regEx.Test(strng)
        If retVal = True Then
            isxmlnode = retVal
        End If
        Set regex = Nothing
    End If
End Function

Function isemail(strng)
    isemail = False
    Dim regex, retVal
    Set regex = New regexp
    regex.Pattern = "^\w+((-\w+)|(\.\w+))*\@[a-za-z0-9]+((\.|-)[a-za-z0-9]+)*\.[a-za-z0-9]+$"
    regex.IgnoreCase = True
    retVal = regEx.Test(strng)
    If retVal = True Then
        isemail = retVal
    End If
    Set regex = Nothing
End Function

Function is_tel(strng)
    is_tel = False
    Dim regex, retVal
    Set regex = New regexp
    regex.Pattern = "^(((\d{3}-|\d{4}-)?(\d{8}|\d{7}))|\d{11}|\d{12})$"
    regex.IgnoreCase = True
    retVal = regEx.Test(strng)
    If retVal = True Then
        is_tel = retVal
    End If
    Set regex = Nothing
End Function

Function ishttp_url(strng)
    ishttp_url = False
    Dim regex, retVal
    Set regex = New regexp
    regex.Pattern = "^[a-zA-z]{4,5}://[^\s]*$"
    regex.IgnoreCase = True
    retVal = regEx.Test(strng)
    If retVal = True Then
        ishttp_url = retVal
    End If
    Set regex = Nothing
End Function

Function isQQ_true(strng)
    isQQ_true = False
    Dim regex, retVal
    Set regex = New regexp
    regex.Pattern = "^[0-9]{4,12}$"
    regex.IgnoreCase = True
    retVal = regEx.Test(strng)
    If retVal = True Then
        isQQ_true = retVal
    End If
    Set regex = Nothing
End Function

Function replace_retain(input_str)
    Dim ti, tdim, replace_txt
    replace_retain = input_str
    tdim = Split(retainUserName, ":")
    For ti = 0 To UBound(tdim)
        replace_txt = "**"
        replace_retain = Replace(replace_retain, tdim(ti), replace_txt)
    Next
    If IsArray(tdim) Then Erase tdim
End Function

Function ReadText(Fileurl, Charset)
    Dim Str
    Set Stm = Server.CreateObject("Adodb.Stream")
    Stm.Type = 2
    Stm.Mode = 3
    Stm.Charset = Charset
    Stm.Open
    Stm.Loadfromfile Fileurl
    Str = Stm.Readtext
    Stm.Close
    Set Stm = Nothing
    ReadText = Str
End Function

Function return_healthval(input_str, mtype, isreplace, cutenum)
    Dim now_str, cut_num
    now_str = Trim(input_str)
    cut_num = cutenum
    If int_true(cut_num) = False Then cut_num = 0
    If var_null(now_str) = "" Then
        return_healthval = ""
        Exit Function
    End If
    If isreplace = 1 Then
        now_str = replace_retain(now_str)
    End If
    If Int(cut_num)>0 Then now_str = Left(now_str, cut_num)
    now_str = Replace(now_str, "<", "&lt;")
    now_str = Replace(now_str, ">", "&gt;")
    now_str = Replace(now_str, Chr(39), "&#39;")
    now_str = Replace(now_str, Chr(34), "&quot;")
    now_str = Replace(now_str, Chr(32), "&nbsp;")
    Select Case mtype
        Case 1
            now_str = Replace(now_str, Chr(9), "&nbsp;")
            now_str = Replace(now_str, Chr(10), "")
            now_str = Replace(now_str, Chr(13), "")
        Case 2
            now_str = Replace(now_str, Chr(9), "&nbsp;")
            now_str = Replace(now_str, Chr(10), "<br />")
            now_str = Replace(now_str, Chr(13), "")
    End Select
    return_healthval = now_str
End Function

Sub html_output(temp_var)
    response.Write temp_var
End Sub

Function get_thearrayval(the_str, the_chr, the_ind)
    Dim the_strs, the_newval, the_tnum
    If InStr(the_str, the_chr)>0 Then
        the_strs = Split(the_str, the_chr)
        the_tnum = UBound(the_strs)
        If Int(the_tnum)>= Int(the_ind) Then
            the_newval = the_strs(the_ind)
        End If
    End If
    If IsArray(the_strs) Then Erase the_strs
    get_thearrayval = the_newval
End Function

Function addchg_imgpath(pic_path, new_var)
    Dim img_name, new_imgname
    If var_null(pic_path)<>"" Then
        img_name = apart_filename(pic_path, 1, "/")
        If var_null(img_name)<>"" Then
            new_imgname = new_var & img_name
        End If
        addchg_imgpath = Replace(pic_path, img_name, new_imgname)
    Else
        addchg_imgpath = pic_path
    End If
End Function

Function cutchg_imgpath(pic_path, new_var)
    Dim img_name, new_imgname
    If var_null(pic_path)<>"" Then
        img_name = apart_filename(pic_path, 1, "/")
        If var_null(img_name)<>"" Then
            new_imgname = Replace(img_name, new_var, "")
        End If
        cutchg_imgpath = Replace(pic_path, img_name, new_imgname)
    Else
        cutchg_imgpath = pic_path
    End If
End Function

Function setxml_thefile(xslt_file, root_node, sub_nodelist)
    Dim the_xmldoc, the_xmlxslt, the_xmlnode, return_xmltxt
    the_xmldoc = "<?xml version=""1.0"" encoding=""utf-8""?>"
    If var_null(xslt_file)<>"" Then
        the_xmlxslt = "<?xml-stylesheet type=""text/xsl"" href=""" & xslt_file & """?> "
    End If
    the_xmlnode = the_xmlnode & "<" & root_node & ">"
    If var_null(sub_nodelist)<>"" Then
        the_xmlnode = the_xmlnode & vbCrLf & sub_nodelist & vbCrLf
    End If
    the_xmlnode = the_xmlnode & "</" & root_node & ">"
    return_xmltxt = the_xmldoc & vbCrLf & the_xmlxslt
    return_xmltxt = return_xmltxt & vbCrLf & the_xmlnode
    setxml_thefile = return_xmltxt
End Function

Sub writeTxtFile(file_path, main_txt)
    Dim objStream, nowFile
    Call update_folder(file_path)
    nowFile = server.mappath(file_path)
    If Trim(nowFile)<>"" Then
        Set objStream = Server.CreateObject("ADODB.Stream")
        With objStream
            .Open
            .Charset = "utf-8"
            .Position = objStream.Size
            .WriteText = main_txt
            .SaveToFile nowFile, 2
            .Close
        End With
        Set objStream = Nothing
    End If
End Sub

Function getHtml_XmlXslt(xmlfile, xslfile)
    Dim xmlDoc, xslDoc, htmlDocTxt, msxmlDllName
    msxmlDllName = "Microsoft.XMLDOM"
    Set xmlDoc = Server.CreateObject(msxmlDllName)
    xmlDoc.async = False
    xmlDoc.load(server.mappath(xmlfile))
    Set xslDoc = Server.CreateObject(msxmlDllName)
    xslDoc.async = False
    xslDoc.load(server.mappath(xslfile))
    htmlDocTxt = xmlDoc.transformNode(xslDoc)
    getHtml_XmlXslt = htmlDocTxt
    Set xmlDoc = Nothing
    Set xslDoc = Nothing
End Function

Function getHtml_DocXslt(xmlfile, xslfile)
    Dim xmlDoc, xslDoc, htmlDocTxt, msxmlDllName
    msxmlDllName = "Microsoft.XMLDOM"
    Set xmlDoc = Server.CreateObject(msxmlDllName)
    xmlDoc.async = False
    xmlDoc.loadXML(xmlfile)
    Set xslDoc = Server.CreateObject(msxmlDllName)
    xslDoc.async = False
    xslDoc.load(server.mappath(xslfile))
    htmlDocTxt = xmlDoc.transformNode(xslDoc)
    getHtml_DocXslt = htmlDocTxt
    Set xmlDoc = Nothing
    Set xslDoc = Nothing
End Function
%>