﻿<%
Dim defaulttemp_url, seokeytem_url, seometatemp_url, robotstemp_url, sitemaphtml_url
defaulttemp_url = "/page_data/seo_xmldata/seo_defaulttemp.htm"
seokeytem_url = "/page_data/seo_xmldata/seokey_temp.html"
seometatemp_url = "/page_data/seo_xmldata/seometa_temp.htm"
robotstemp_url = "/page_data/seo_xmldata/seo_robotstemp.txt"
sitemaphtml_url = "/page_data/seo_xmldata/seo_sitemaptemp.html"

Function seometa_value()
    Dim rs_nobj, sql_ncmd, editionVar, returnVal, tempSeoMeta, webSeoMeta
    If exists_file(seometatemp_url) = True Then
        tempSeoMeta = get_file(seometatemp_url)
    End If
    editionVar = edition_defaultid()
    webSeoMeta = get_webseometa()
    If int_true(editionVar) = True Then
        sql_ncmd = "select top 1 * from T_SysMainInfo where editionId=" & editionVar
        Set rs_nobj = web_dbobj.exec_sql(sql_ncmd, 1)
        If Not rs_nobj.EOF Then
            returnVal = Replace(tempSeoMeta, "{$webtitle}", rs_nobj("webName"))
            returnVal = Replace(returnVal, "{$keywords}", rs_nobj("webWordKeys"))
            returnVal = Replace(returnVal, "{$description}", rs_nobj("webDescription"))
            returnVal = Replace(returnVal, "{$webauthor}", rs_nobj("webAuthor"))
        End If
        rs_nobj.Close
        Set rs_nobj = Nothing
    End If
    If var_null(returnVal)<>"" Then
        returnVal = Replace(returnVal, "{$webseometa}", webSeoMeta)
    End If
    seometa_value = returnVal
End Function

Function edition_defaultid()
    Dim rs_nobj, sql_ncmd, the_editionid
    the_editionid = 1
    sql_ncmd = "select * from T_SysConfig"
    Set rs_nobj = web_dbobj.exec_sql(sql_ncmd, 1)
    If Not rs_nobj.EOF Then
        the_editionid = rs_nobj("webStatus")
    End If
    rs_nobj.Close
    Set rs_nobj = Nothing
    edition_defaultid = the_editionid
End Function

Sub update_webdefault()
    Dim tempDefault, webSeoMetaVal, defaultFile, returnVal
    defaultFile = "/default.htm"
    If exists_file(defaulttemp_url) = True Then
        tempDefault = stream_getfile(defaulttemp_url, 0)
    End If
    webSeoMetaVal = seometa_value()
    returnVal = Replace(tempDefault, "{$seometa_value}", webSeoMetaVal)
    If var_null(returnVal)<>"" Then
        Call writeTxtFile(defaultFile, returnVal)
    End If
End Sub

Sub update_webrobots(webSiteMap)
    Dim tempRobots, robotsSiteMap, robotsFile, returnVal
    robotsFile = "/robots.txt"
    If exists_file(robotstemp_url) = True Then
        tempRobots = get_file(robotstemp_url)
    End If
    robotsSiteMap = "Sitemap: " & webSiteMap
    returnVal = Replace(tempRobots, "{$sitemap_file}", robotsSiteMap)
    If var_null(returnVal)<>"" Then
        Call create_file(robotsFile, returnVal)
    End If
End Sub

Sub cupdate_seokeyfile(seokeyfile, seokeyval)
    Dim tempSeoKey, seoKey_File, returnVal
    seoKey_File = "/" & seokeyfile
    If exists_file(seokeytem_url) = True Then
        tempSeoKey = get_file(seokeytem_url)
    End If
    returnVal = Replace(tempSeoKey, "{$seokey_val}", seokeyval)
    If var_null(returnVal)<>"" Then
        Call create_file(seoKey_File, returnVal)
    End If
End Sub

Function get_webseometa()
    Dim sql_ncmd, rs_nobj, the_seoverify, returnVal
    the_seoverify = 0
    If isexist_table("T_SeoConfig") = True Then
        If int_true(the_seoverify) = True Then
            sql_ncmd = "select * from T_SeoConfig where seoVerify=" & the_seoverify & " order by configId"
        Else
            sql_ncmd = "select * from T_SeoConfig order by configId"
        End If
        Set rs_nobj = web_dbobj.exec_sql(sql_ncmd, 1)
        Do While Not rs_nobj.EOF
            Dim seoMetaValue, theMetaVal
            theMetaVal = rs_nobj("seoMetaValue")
            seoMetaValue = cancelsafe_value(theMetaVal)
            If var_null(seoMetaValue)<>"" Then
                returnVal = returnVal & vbCrLf & seoMetaValue
            End If
            rs_nobj.movenext
        Loop
        rs_nobj.Close
        Set rs_nobj = Nothing
    End If
    get_webseometa = returnVal
End Function

Function nowcreate_seometa()
    Dim returnVal, tempSeoMeta
    If exists_file(seometatemp_url) = True Then
        tempSeoMeta = get_file(seometatemp_url)
    End If
    If var_null(tempSeoMeta)<>"" Then
        returnVal = Replace(tempSeoMeta, "{$webtitle}", webName)
        returnVal = Replace(returnVal, "{$keywords}", webWordKeys)
        returnVal = Replace(returnVal, "{$description}", webDescription)
        returnVal = Replace(returnVal, "{$webauthor}", webAuthor)
    End If
    If var_null(returnVal)<>"" Then
        returnVal = Replace(returnVal, "{$webseometa}", "")
    End If
    nowcreate_seometa = returnVal
End Function

Sub create_sitemaphtml(sitemap_url, sitemap_list)
    Dim tempSiteMap, seokeyVal, returnVal, theNowTime
    If var_null(sitemap_url)<>"" Then
        seokeyVal = nowcreate_seometa()
        If exists_file(sitemaphtml_url) = True Then
            tempSiteMap = stream_getfile(sitemaphtml_url, 0)
        End If
        theNowTime = time_type(now_time, 1)
        returnVal = Replace(tempSiteMap, "{$seometa_value}", seokeyVal)
        returnVal = Replace(returnVal, "{$websiteurl}", own_http())
        returnVal = Replace(returnVal, "{$websitename}", webName)
        returnVal = Replace(returnVal, "{$updatedtime}", theNowTime)
        returnVal = Replace(returnVal, "{$sitemaplist}", sitemap_list)
        returnVal = Replace(returnVal, "{$copyright}", webCopyRight)
        If var_null(returnVal)<>"" Then
            Call writeTxtFile(sitemap_url, returnVal)
        End If
    End If
End Sub
%>