﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:template match="/">
    <xsl:call-template name="import_sitemaplists"/>
  </xsl:template>
  <xsl:template name="import_sitemaplists">
    <xsl:param name="parentId" select="0"/>
    <xsl:param name="sortUlClass" select="'p_m_div'"/>
    <xsl:element name="div">
      <xsl:if test="$sortUlClass!=''">
        <xsl:attribute name="class">
          <xsl:value-of select="$sortUlClass"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:for-each select="/sitemaplists/menuitem[@parentid=$parentId]">
        <ul class="p_m_ul">
          <li>
            <xsl:if test="$parentId=0">
              <xsl:attribute name="class">
                <xsl:value-of select="'p_m_menu'"/>
              </xsl:attribute>
            </xsl:if>
            <a href="{@urlpath}" target="{@urltarget}"><xsl:value-of select="@menutopic"/></a>
          </li>
          <xsl:if test="@submenunum &gt; 0">
            <li class="p_m_li2">
              <xsl:call-template name="import_sitemaplists">
                <xsl:with-param name="parentId" select="@menuid"/>
                <xsl:with-param name="sortUlClass" select="'p_m_div2'"/>
              </xsl:call-template>
            </li>
          </xsl:if>
          <xsl:if test="@isshowsort=1">
            <li class="p_m_li1">
              <xsl:call-template name="import_menusortlists">
                <xsl:with-param name="pMenuId" select="./@menuid"/>
                <xsl:with-param name="sortPId" select="0"/>
              </xsl:call-template>
            </li>
          </xsl:if>
        </ul>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <xsl:template name="import_menusortlists">
    <xsl:param name="pMenuId" select="0"/>
    <xsl:param name="sortPId" select="0"/>
    <xsl:for-each select="/sitemaplists/sortlists[@menuid=$pMenuId]/sortitem[@sortpid=$sortPId]">
      <ul class="p_m_class">
        <li>
          ● <a href="{@sorturl}" target="{@sorttarget}"><xsl:value-of select="@sorttopic" disable-output-escaping="yes"/></a>
        </li>
        <xsl:if test="@subsortnum &gt; 0">
          <li class="p_m_cli">
            <xsl:call-template name="import_menusortlists">
              <xsl:with-param name="pMenuId" select="$pMenuId"/>
              <xsl:with-param name="sortPId" select="@sortid"/>
            </xsl:call-template>
          </li>
        </xsl:if>
      </ul>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>