<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="siteMapLists" select="//sitemaplists" />
  <xsl:template name="import_sitemaplists">
    <xsl:param name="parentId" select="0"/>
    <xsl:param name="sortUlClass" select="'sitemap_indexlists'"/>
    <xsl:element name="div">
      <xsl:if test="$sortUlClass!=''">
        <xsl:attribute name="class">
          <xsl:value-of select="$sortUlClass"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:for-each select="$siteMapLists/menuitem[@parentid=$parentId]">
        <ul class="sitemap_lists">
          <li>
            <xsl:value-of select="position()" />、<a href="{@urlpath}" target="{@urltarget}"><xsl:value-of select="@menutopic"/></a>
          </li>
          <xsl:if test="@submenunum &gt; 0">
            <li class="sub_menuli">
              <xsl:call-template name="import_sitemaplists">
                <xsl:with-param name="parentId" select="@menuid"/>
                <xsl:with-param name="sortUlClass" select="'submenu_listdiv'"/>
              </xsl:call-template>
            </li>
          </xsl:if>
          <xsl:if test="@isshowsort=1">
            <li class="menu_sortli">
              <xsl:call-template name="import_menusortlists">
                <xsl:with-param name="pMenuId" select="./@menuid"/>
                <xsl:with-param name="sortPId" select="0"/>
              </xsl:call-template>
            </li>
          </xsl:if>
        </ul>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <xsl:template name="import_menusortlists">
    <xsl:param name="pMenuId" select="0"/>
    <xsl:param name="sortPId" select="0"/>
    <xsl:for-each select="$siteMapLists/sortlists[@menuid=$pMenuId]/sortitem[@sortpid=$sortPId]">
      <ul class="menusort_lists">
        <li>
          <a href="{@sorturl}" target="{@sorttarget}"><xsl:value-of select="@sorttopic" disable-output-escaping="yes"/></a>
        </li>
        <xsl:if test="@subsortnum &gt; 0">
          <li class="sub_msortli">
            <xsl:call-template name="import_menusortlists">
              <xsl:with-param name="pMenuId" select="$pMenuId"/>
              <xsl:with-param name="sortPId" select="@sortid"/>
            </xsl:call-template>
          </li>
        </xsl:if>
      </ul>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>