﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="pSortDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/productsSortList', '.xml'))"/>
  <xsl:variable name="pSortList" select="$pSortDoc/productssortlist"/>
  <xsl:template name="import_productsearchbar">
    <form id="productSearch" name="productSearch" action="products.htm" method="get">
      <input type="hidden" id="action" name="action" value="search"/>
      <input type="text" id="keywords" name="keywords" value=""/>
      <input type="submit" id="subbtn" title="{//pagemodules/searchbutton}" value="搜索"/>
    </form>
  </xsl:template>
  <xsl:template name="import_searchsortbar">
    <xsl:param name="parentId" select="0"/>
    <xsl:param name="sortFore" select="''"/>
    <xsl:for-each select="$pSortList/sortitem[@parentid=$parentId]">
      <xsl:if test="@subsortnum &gt; '0'">
        <option value="{@parentid}_{@sortid}">
          <xsl:value-of select="$sortFore"/>
          <xsl:value-of select="@sorttopic"/>
        </option>
        <xsl:call-template name="import_searchsortbar">
          <xsl:with-param name="parentId" select="@sortid"/>
          <xsl:with-param name="sortFore">
            <xsl:if test="$sortFore=''">
              <xsl:value-of select="'|—'"/>
            </xsl:if>
            <xsl:if test="$sortFore!=''">
              <xsl:value-of select="$sortFore"/>
              <xsl:value-of select="'—'"/>
            </xsl:if>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:if>
      <xsl:if test="@subsortnum = '0'">
        <option value="{@parentid}_{@sortid}">
          <xsl:value-of select="$sortFore"/>
          <xsl:value-of select="@sorttopic"/>
        </option>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>