<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="http://www.yisence.com/" exclude-result-prefixes="msxsl user">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="rssXmlListDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/indexRssList', '.xml'))"/>
  <xsl:variable name="rssXmlLists" select="$rssXmlListDoc/rssxmllists"/>
  <xsl:variable name="rssReaderDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/indexRssReader', '.xml'))"/>
  <xsl:variable name="rssReaderLists" select="$rssReaderDoc/rssreaderlists"/>
  <xsl:template name="import_mainrssxml">
    <xsl:param name="subscribeToTitle" select="//pagemodules/subscribeto"/>
    <div class="main_rssxmllist">
      <xsl:for-each select="$rssXmlLists/rssxmllistitem">
        <xsl:variable name="rssXmlUrl" select="@rssxmlurl" />
        <ul>
          <li class="rssmain_topbar">
            <a href="{@menuurl}" title="{@menutitle}" class="rssmain_toptit"><xsl:value-of select="@menutitle"/></a>
            <div class="rssmain_topbtn">
              <span class="rssxml_url">
                <a href="{$rssXmlUrl}" target="_blank"><img src="/images/rss.gif" alt="RSS+XML" /></a>
              </span>
              <span class="rssxml_btn" onmouseover="showhide_objdiv('rssreader_o{position()}',1,this)" onmouseout="showhide_objdiv('rssreader_o{position()}',0,this)">
                <div class="subscribe_btn" title="{$subscribeToTitle}">
                  <xsl:choose>
                    <xsl:when test="$subscribeToTitle!=''">
                      <xsl:value-of select="$subscribeToTitle" />
                    </xsl:when>
                    <xsl:otherwise>Subscribe</xsl:otherwise>
                  </xsl:choose>
                </div>
                <xsl:if test="$rssReaderLists/rssreaderlistitem[@isused=1 and readertype=1]">
                  <div id="rssreader_o{position()}" class="subscribe_list" style="display: none;">
                    <xsl:for-each select="$rssReaderLists/rssreaderlistitem[@isused=1 and readertype=1]">
                      <xsl:variable name="new_rssxmlurl" select="user:getReplacedStr(string(rssporturl),'{0}',string($rssXmlUrl))" />
                      <xsl:choose>
                        <xsl:when test="readericon!=''">
                          <a href="{$new_rssxmlurl}" target="_blank"><img src="{readericon}" alt="{concat($subscribeToTitle,readertopic)}" /></a>
                        </xsl:when>
                        <xsl:otherwise>
                          <a href="{$new_rssxmlurl}" target="_blank" title="{concat($subscribeToTitle,readertopic)}"><xsl:value-of select="readertopic" /></a>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:for-each>
                  </div>
                </xsl:if>
              </span>
            </div>
          </li>
          <xsl:if test="viewitem!=''">
            <li class="viewitem_list">
              <ul>
                <xsl:for-each select="viewitem">
                  <xsl:if test="position()&lt;6">
                    <li>
                      <a href="{urlpath}" title="{viewtopic}"><xsl:value-of select="viewtopic"/></a>
                      <span>(<xsl:value-of select="viewtime"/>)</span>
                    </li>
                  </xsl:if>
                </xsl:for-each>
              </ul>
            </li>
          </xsl:if>
        </ul>
      </xsl:for-each>
    </div>
  </xsl:template>
  <msxsl:script language="JavaScript" implements-prefix="user">
    <![CDATA[
        function getReplacedStr(str,old_chr,new_chr)
        {
                if(str)
                {
                        return str.replace(old_chr,new_chr);
                }
        else
        {
                return "";
        }
        }
        ]]>
  </msxsl:script>
</xsl:stylesheet>