﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="adsInfoDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/webAdsInfo', '.xml'))"/>
  <xsl:variable name="adsInfo" select="$adsInfoDoc/web_adsinfo"/>
  <xsl:template name="import_webadsinfo">
    <xsl:param name="adsType" select="$adsInfo/defaulttype" />
    <xsl:param name="adsItems" select="$adsInfo/adsitems[@adstype=$adsType]" />
    <xsl:if test="$adsType=0">
    </xsl:if>
    <xsl:if test="$adsType=1">
      <xsl:if test="$adsItems/adsisuseing!=0">
        <script src="/jscript/popup_window.js" language="javascript" type="text/javascript"></script>
        <style type="text/css">
        #popupAds .adsTit
        {
            background: url(/images/bar_title.jpg);
            color: #FFFFFF;
            height: 22px;
            line-height: 22px;
            padding-left: 4px;
        }
        .adsTit span
        {
            float: left;
        }
        .adsTit img
        {
            float: right;
            padding: 3px;
            margin-top: 3px;
            margin-right: 4px;
        }
        .floatMain
        {
            height: 100%;
            background-color: #E6F7FF;
            padding: 2px;
        }
        </style>
        <div id="popupAds" style="position: absolute; z-index: 1000; background-color: #EBEBEB; cursor: pointer; left: 0px; top: 0px; display: none;" onMousedown="initializedrag(event)" onMouseup="stopdrag()" onSelectStart="return false">
          <div class="adsTit">
            <span>
              <xsl:value-of select="$adsItems/adstopic"/>
            </span>
            <img id="popup_close" style="cursor: pointer;" src="/images/barclose.jpg" onClick="closeit()" />
            <img id="popup_maxmin" style="cursor: pointer;" src="/images/barresume.jpg" onClick="maximize()" />
          </div>
          <div id="popupMain" class="floatMain">
            <a href="{$adsItems/adslink}" target="_blank"><xsl:value-of select="$adsItems/adsremark" disable-output-escaping="yes"/></a>
          </div>
          <div style="background: url(/images/bar_bottom.jpg); height: 4px; font-size: 4px;"></div>
        </div>
        <script type="text/javascript">
          loadwindow(300,200);
        </script>
      </xsl:if>
    </xsl:if>
    <xsl:if test="$adsType=2">
      <xsl:if test="$adsItems/adsisuseing!=0">
        <script src="/jscript/float_ads.js" language="javascript" type="text/javascript"></script>
        <script type="text/javascript">
          if(window.attachEvent)
          {
          window.attachEvent('onload',floatAds_Open);
          }
          else if(window.addEventListener)
          {
          window.addEventListener('load',floatAds_Open,false);
          }
          function floatAds_Open() {
          var b = new scrollBanner(10, 10);
          b.add($ById("floatAds"), 10, 0, 1,$ById("ads_close"));
          b = null;
          }
        </script>
        <style type="text/css">
        #floatAds
        {
            width: 192px;
        }
        #floatAds .floatMain
        {
            clear: both;
        }
        .adsTit
        {
            background: url(/images/ser_title.jpg);
            color: #FFFFFF;
            height: 22px;
            line-height: 22px;
            padding-left: 4px;
        }
        .adsTit span
        {
            float: left;
        }
        .adsTit img
        {
            float: right;
            padding: 3px;
            margin-top: 3px;
            margin-right: 4px;
        }
        .nomralAds
        {
        }
        .minAds
        {
            height: 29px;
        }
        .nomralAds .floatMain
        {
            display: block;
            overflow: auto;
            height: 170px;
            background-color: #E6F7FF;
        }
        .minAds .floatMain
        {
            display: none;
        }
        </style>
        <div id="floatAds" class="nomralAds">
          <div class="adsTit">
            <span>
              <xsl:value-of select="$adsItems/adstopic"/>
            </span>
            <img id="ads_close" src="/images/boxmin.jpg" />
          </div>
          <div class="floatMain">
            <a href="{$adsItems/adslink}" target="_blank"><xsl:value-of select="$adsItems/adsremark" disable-output-escaping="yes"/></a>
          </div>
          <div>
            <img src="/images/ser_b.jpg" width="192" height="7" />
          </div>
        </div>
      </xsl:if>
    </xsl:if>
    <xsl:if test="$adsType=3">
      <xsl:if test="$adsItems/adsisuseing!=0">
        <style type="text/css">
        #fscrollAds
        {
            width: 192px;
        }
        #fscrollAds .floatMain
        {
            clear: both;
            padding: 2px;
        }
        .adsTit
        {
            background: url(/images/ser_title.jpg);
            color: #FFFFFF;
            height: 22px;
            line-height: 22px;
            padding-left: 4px;
        }
        .adsTit span
        {
            float: left;
        }
        .adsTit img
        {
            float: right;
            padding: 3px;
            margin-top: 3px;
            margin-right: 4px;
        }
        </style>
        <div id="fscrollAds" style="z-index: 9999; position: absolute; background-color: #FFFFFF;">
          <div class="adsTit">
            <span>
              <xsl:value-of select="$adsItems/adstopic"/>
            </span>
            <img id="ads_close" style="cursor: pointer;" onclick="closeAD()" src="/images/barclose.jpg" />
          </div>
          <div class="floatMain">
            <a href="{$adsItems/adslink}" target="_blank"><xsl:value-of select="$adsItems/adsremark" disable-output-escaping="yes"/></a>
          </div>
          <div>
            <img src="/images/ser_b.jpg" width="192" height="7" />
          </div>
        </div>
        <script type="text/javascript">
          var x = 50,y = 460;
          var xin = true, yin = true;
          var step = 1;
          var delay = 20;
          var obj=document.getElementById("fscrollAds");
          function floatAD() {
          var L=T=0;
          var R= document.body.clientWidth-obj.offsetWidth;
          var B = document.body.clientHeight-obj.offsetHeight;
          obj.style.left = x + document.body.scrollLeft;
          obj.style.top = y + document.body.scrollTop;
          x = x + step*(xin?1:-1);
          if (x <xsl:text disable-output-escaping="yes">&lt;</xsl:text> L) { xin = true; x = L; }
          if (x <xsl:text disable-output-escaping="yes">&gt;</xsl:text> R){ xin = false; x = R; }
          y = y + step*(yin?1:-1);
          if (y <xsl:text disable-output-escaping="yes">&lt;</xsl:text> T) { yin = true; y = T; }
          if (y <xsl:text disable-output-escaping="yes">&gt;</xsl:text> B) { yin = false; y = B; }
          }
          if(obj.style.display=="")
          {
          var itl= setInterval("floatAD()", delay);
          obj.onmouseover=function(){clearInterval(itl)};
          obj.onmouseout=function(){itl=setInterval("floatAD()", delay)};
          }
          function closeAD() {
          obj.style.display="none";
          }
        </script>
      </xsl:if>
    </xsl:if>
    <xsl:if test="$adsType=4">
      <script src="/templates/jscript/imgflash_ads.js" language="javascript" type="text/javascript"></script>
      <div id="flashcontent_ad"></div>
      <script language="javascript" type="text/javascript">
        var pic_width=1003;
        var pic_height=319;
        var button_pos=4;
        var stop_time=8000;
        var show_text=0;
        var txtcolor="000000";
        var bgcolor="DDDDDD";
        var imag=new Array();
        var thelink=new Array();
        var text=new Array();
        <xsl:for-each select="$adsItems">
          <xsl:if test="position()&lt;12">
            imag[<xsl:value-of select="position()" />]=&quot;<xsl:value-of select="adsfile" />&quot;;
            thelink[<xsl:value-of select="position()" />]=&quot;<xsl:value-of select="adslink" />&quot;;
            text[<xsl:value-of select="position()" />]=&quot;<xsl:value-of select="adstopic" />&quot;;
          </xsl:if>
        </xsl:for-each>
        var swf_height=show_text==1?pic_height+20:pic_height;
        var pics="", links="", texts="";
        for(var i=1; i<xsl:text disable-output-escaping="yes">&lt;</xsl:text>imag.length; i++){
        pics=pics+("|"+imag[i]);
        links=links+("|"+thelink[i]);
        texts=texts+("|"+text[i]);
        }
        pics=pics.substring(1);
        links=links.substring(1);
        texts=texts.substring(1);
        var sohuFlash2 = new sohuFlash("/templates/flash/images_focus.swf","sohuFlashId01",pic_width,swf_height,"7","#ffffff");
        sohuFlash2.addParam("quality", "high");
        sohuFlash2.addParam("wmode", "opaque");
        sohuFlash2.addVariable("pics", pics);
        sohuFlash2.addVariable("links",links);
        sohuFlash2.addVariable("texts",texts);
        sohuFlash2.addVariable("pic_width",pic_width);
        sohuFlash2.addVariable("pic_height",swf_height);
        sohuFlash2.addVariable("show_text",show_text);
        sohuFlash2.addVariable("txtcolor",txtcolor);
        sohuFlash2.addVariable("bgcolor",bgcolor);
        sohuFlash2.addVariable("button_pos",button_pos);
        sohuFlash2.addVariable("stop_time",stop_time);
        sohuFlash2.write("flashcontent_ad");
      </script>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="$adsInfo/defaulttype!=''">
        <xsl:if test="$adsType!=4">
          <xsl:call-template name="import_webbanner"/>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="import_webbanner"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>