﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="baseFileDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/webBaseFile', '.xml'))"/>
  <xsl:variable name="baseFile" select="$baseFileDoc/web_basefile"/>
  <xsl:template name="import_weblogo">
    <xsl:variable name="logoFile" select="$baseFile/weblogo"/>
    <xsl:variable name="logoType" select="$logoFile/@logotype"/>
    <xsl:if test="$logoFile=''">
      <a href="/"><img src="/templates/images/logo.png" class="default_logo" /></a>
    </xsl:if>
    <xsl:if test="$logoFile!=''">
      <xsl:if test="$logoType='img'">
        <a href="/"><img src="{$logoFile}" /></a>
      </xsl:if>
      <xsl:if test="$logoType='swf'">
        <div id="weblogo_content"></div>
        <script type="text/javascript" language="javascript">
          var so = new SWFObject(&quot;<xsl:value-of select="$logoFile"/>&quot;, "weblogo", "237", "85", "7", "");
          so.addParam("quality", "high");
          so.addParam("wmode", "transparent");
          so.addParam("menu", "false");
          so.write("weblogo_content");
        </script>
      </xsl:if>
      <xsl:if test="$logoType=''">
        &#32;
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_webbanner">
    <xsl:param name="newBannerNum" select="//sitebanners/@bannernum"/>
    <xsl:param name="newBannerItem" select="//sitebanners/bannersitem"/>
    <xsl:param name="pageBannerTrue" select="0"/>
    <xsl:variable name="bannerFile" select="$baseFile/webbanner"/>
    <xsl:variable name="bannerType" select="$bannerFile/@bannertype"/>
    <xsl:variable name="bannerBgSwf" select="$baseFile/bannerimgswf"/>
    <xsl:if test="$newBannerNum=0">
      <xsl:if test="$pageBannerTrue=0">
        <xsl:if test="$bannerFile=''">
          <img src="/templates/images/banner.jpg" style="border: 0px;" />
        </xsl:if>
        <xsl:if test="$bannerFile!=''">
          <xsl:if test="$bannerType='img'">
            <xsl:if test="$bannerBgSwf=''">
              <xsl:element name="img">
                <xsl:attribute name="src">
                  <xsl:value-of select="$bannerFile"/>
                </xsl:attribute>
              </xsl:element>
            </xsl:if>
            <xsl:if test="$bannerBgSwf!=''">
              <xsl:variable name="bannerBgSwfAlign" select="$bannerBgSwf/@imgswfalign"/>
              <xsl:variable name="bannerBgSwfSize" select="$bannerBgSwf/@imgswfsize"/>
              <xsl:variable name="bannerBgSwfWidth" select="$bannerBgSwf/@imgswfwidth"/>
              <xsl:variable name="bannerBgSwfHeight" select="$bannerBgSwf/@imgswfheight"/>
              <div style="width: 1003px; height: 319px; background: url({$bannerFile}); text-align: {$bannerBgSwfAlign};" id="bannerimgswf_content"></div>
              <script type="text/javascript" language="javascript">
                var so = new SWFObject(&quot;<xsl:value-of select="$bannerBgSwf"/>&quot;, "bannerimgswf", &quot;<xsl:value-of select="$bannerBgSwfWidth"/>&quot;, &quot;<xsl:value-of select="$bannerBgSwfHeight"/>&quot;, "7", "");
                so.addParam("quality", "high");
                so.addParam("wmode", "transparent");
                so.addParam("menu", "false");
                so.addParam("align", &quot;<xsl:value-of select="$bannerBgSwfAlign"/>&quot;);
                //so.addParam("style", &quot;<xsl:value-of select="$bannerBgSwfSize"/>&quot;);
                so.write("bannerimgswf_content");
              </script>
            </xsl:if>
          </xsl:if>
          <xsl:if test="$bannerType='swf'">
            <div id="webbanner_content"></div>
            <script type="text/javascript" language="javascript">
              var so = new SWFObject(&quot;<xsl:value-of select="$bannerFile"/>&quot;, "webbanner", &quot;<xsl:value-of select="$bannerBgSwf/@imgswfwidth"/>&quot;, &quot;<xsl:value-of select="$bannerBgSwf/@imgswfheight"/>&quot;, "7", "");
              so.addParam("quality", "high");
              so.addParam("wmode", "transparent");
              so.addParam("menu", "false");
              so.write("webbanner_content");
            </script>
          </xsl:if>
          <xsl:if test="$bannerType=''">
            &#32;
          </xsl:if>
        </xsl:if>
      </xsl:if>
      <xsl:if test="$pageBannerTrue=1">
        <img src="/templates/images/banner1.jpg" style="border: 0px;" />
      </xsl:if>
    </xsl:if>
    <xsl:if test="$newBannerNum=1">
      <xsl:if test="$newBannerItem/@bannertype=1">
        <xsl:element name="a">
          <xsl:attribute name="class">pimg_banner</xsl:attribute>
          <xsl:if test="$newBannerItem/@bannerurl!='' and $newBannerItem/@bannerurl!='#'">
            <xsl:attribute name="href">
              <xsl:value-of select="$newBannerItem/@bannerurl"/>
            </xsl:attribute>
          </xsl:if>
          <img src="{$newBannerItem}" style="border: 0px;" />
        </xsl:element>
      </xsl:if>
      <xsl:if test="$newBannerItem/@bannertype=2">
        <div id="webbanner_content"></div>
        <script type="text/javascript" language="javascript">
          var so = new SWFObject(&quot;<xsl:value-of select="$newBannerItem"/>&quot;, "webbanner", "1003", "319", "7", "");
          so.addParam("quality", "high");
          so.addParam("wmode", "transparent");
          so.addParam("menu", "false");
          so.write("webbanner_content");
        </script>
      </xsl:if>
      <xsl:if test="$newBannerItem/@bannertype=0">
        <xsl:element name="a">
          <xsl:if test="$newBannerItem/@bannerurl!='' and $newBannerItem/@bannerurl!='#'">
            <xsl:attribute name="href">
              <xsl:value-of select="$newBannerItem/@bannerurl"/>
            </xsl:attribute>
          </xsl:if>
          <xsl:value-of select="$newBannerItem" disable-output-escaping="yes"/>
        </xsl:element>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_webbackground">
    <xsl:variable name="webBgImage" select="$baseFile/webbgimage"/>
    <xsl:variable name="webBgColor" select="$baseFile/webbgcolor"/>
    <xsl:if test="$webBgImage!=''">
      <style type="text/css">
        <xsl:text disable-output-escaping="yes">&lt;!--</xsl:text>
        body
        {
                background-image: url(<xsl:value-of select="$webBgImage"/>);
        }
        <xsl:text disable-output-escaping="yes">//--&gt;
        </xsl:text>
      </style>
    </xsl:if>
    <xsl:if test="$webBgColor!=''">
      <style type="text/css">
        <xsl:text disable-output-escaping="yes">&lt;!--</xsl:text>
        body
        {
                background-color: <xsl:value-of select="$webBgColor"/>;
        }
        <xsl:text disable-output-escaping="yes">//--&gt;
        </xsl:text>
      </style>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_webbgmusic">
    <xsl:variable name="musicFile" select="$baseFile/webbgmusic"/>
    <xsl:variable name="playType" select="$musicFile/@playtype"/>
    <xsl:if test="$playType='0'">
    </xsl:if>
    <xsl:if test="$playType='1'">
      <bgsound src="{$musicFile}" autostart="{$musicFile/@autoplay}" loop="{$musicFile/@loopvalue}" />
    </xsl:if>
    <xsl:if test="$playType='2'">
      <embed src="{$musicFile}" autostart="{$musicFile/@autoplay}" loop="{$musicFile/@loopvalue}" hidden="true" style="display: none;"></embed>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>