﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:template match="/">
    <div class="viewproduct_title" >
      <xsl:value-of select="products_view/producttopic"/>
    </div>
    <xsl:if test="products_view/productpiclist=''">
      <xsl:if test="products_view/productbigimg!=''">
        <div class="viewproduct_bigimg">
          <a href="{products_view/productbigimg}" target="_blank"><img src="{products_view/productbigimg}" title="{products_view/producttopic}" /></a>
        </div>
      </xsl:if>
    </xsl:if>
    <xsl:if test="products_view/productpiclist!=''">
      <div>
        <xsl:value-of select="products_view/productpiclist" disable-output-escaping="yes"/>
      </div>
    </xsl:if>
    <div class="product_others">
      <xsl:if test="products_view/otherattribute!=''">
        <ul>
          <xsl:for-each select="products_view/otherattribute/productitem">
            <li>
              <strong>
                <xsl:value-of select="@propertytopic"/>
              </strong>：<xsl:value-of select="." disable-output-escaping="yes"/>
            </li>
          </xsl:for-each>
        </ul>
      </xsl:if>
    </div>
    <div class="viewproduct_remark">
      <xsl:value-of select="products_view/productremark" disable-output-escaping="yes"/>
    </div>
  </xsl:template>
</xsl:stylesheet>