<!--#include file="ewcfg7.asp"-->
<!--#include file="aspfn7.asp"-->
<!--#include file="userfn7.asp"-->
<% Session.Timeout = 900 %>
<%
Response.Expires = 0
Response.ExpiresAbsolute = Now() - 1
Response.AddHeader "pragma", "no-cache"
Response.AddHeader "cache-control", "private, no-cache, no-store, must-revalidate"
%>
<%

' Define page object
Dim logout
Set logout = New clogout
Set Page = logout

' Page init processing
Call logout.Page_Init()

' Page main processing
Call logout.Page_Main()
%>
<%

' Drop page object
Set logout = Nothing
%>
<%

' -----------------------------------------------------------------
' Page Class
'
Class clogout

	' Page ID
	Public Property Get PageID()
		PageID = "logout"
	End Property

	' Page Object Name
	Public Property Get PageObjName()
		PageObjName = "logout"
	End Property

	' Page Name
	Public Property Get PageName()
		PageName = ew_CurrentPage()
	End Property

	' Page Url
	Public Property Get PageUrl()
		PageUrl = ew_CurrentPage() & "?"
	End Property

	' Message
	Public Property Get Message()
		Message = Session(EW_SESSION_MESSAGE)
	End Property

	Public Property Let Message(v)
		If Session(EW_SESSION_MESSAGE) <> "" Then ' Append
			Session(EW_SESSION_MESSAGE) = Session(EW_SESSION_MESSAGE) & "<br>" & v
		Else
			Session(EW_SESSION_MESSAGE) = v
		End If
	End Property

	' Show Message
	Public Sub ShowMessage()
		If Message <> "" Then ' Message in Session, display
			Response.Write "<p><span class=""ewMessage"">" & Message & "</span></p>"
			Session(EW_SESSION_MESSAGE) = "" ' Clear message in Session
		End If
	End Sub

	' -----------------------
	'  Validate Page request
	'
	Public Function IsPageRequest()
		IsPageRequest = True
	End Function

	' -----------------------------------------------------------------
	'  Class initialize
	'  - init objects
	'  - open ADO connection
	'
	Private Sub Class_Initialize()

		' Initialize form object
		Set ObjForm = Nothing

		' Intialize page id (for backward compatibility)
		EW_PAGE_ID = "logout"

		' Open connection to the database
		Set Conn = Server.CreateObject("ADODB.Connection")
		Conn.Open EW_DB_CONNECTION_STRING
	End Sub

	' -----------------------------------------------------------------
	'  Subroutine Page_Init
	'  - called before page main
	'  - check Security
	'  - set up response header
	'  - call page load events
	'
	Sub Page_Init()
		Set Security = New cAdvancedSecurity

		' Global page loading event (in userfn7.asp)
		Call Page_Loading()

		' Page load event, used in current page
		Call Page_Load()
	End Sub

	' -----------------------------------------------------------------
	'  Class terminate
	'  - clean up page object
	'
	Private Sub Class_Terminate()
		Call Page_Terminate("")
	End Sub

	' -----------------------------------------------------------------
	'  Subroutine Page_Terminate
	'  - called when exit page
	'  - clean up ADO connection and objects
	'  - if url specified, redirect to url
	'
	Sub Page_Terminate(url)

		' Page unload event, used in current page
		Call Page_Unload()

		' Global page unloaded event (in userfn60.asp)
		Call Page_Unloaded()
		If Not (Conn Is Nothing) Then Conn.Close ' Close Connection
		Set Conn = Nothing
		Set Security = Nothing

		' Go to url if specified
		If url <> "" Then
			Response.Clear
			Response.Redirect url
		End If
	End Sub

	'
	'  Subroutine Page_Terminate (End)
	' ----------------------------------------
	' -----------------------------------------------------------------
	' Page main processing
	'
	Sub Page_Main()
		Dim bValidate
		bValidate = True
		Dim sLastUrl, sUsername
		sUsername = Security.CurrentUserName

		' Call User LoggingOut event
		bValidate = User_LoggingOut(sUsername)
		If Not bValidate Then
			sLastUrl = Security.LastUrl
			If sLastUrl = "" Then sLastUrl = "default.asp"
			Call Page_Terminate(sLastUrl) ' Go to last accessed url
		Else
			If Request.Cookies(EW_PROJECT_NAME)("autologin") = "" Then ' Not autologin
				Response.Cookies(EW_PROJECT_NAME)("username") = "" ' clear user name cookie
			End If
			Response.Cookies(EW_PROJECT_NAME)("password") = "" ' clear password cookie
			Response.Cookies(EW_PROJECT_NAME)("lasturl") = "" ' clear last url

			' Clear session
			Session.Abandon

			' Call User LoggedOut event
			Call User_LoggedOut(sUsername)
			Call Page_Terminate("login.asp") ' Go to login page
		End If
	End Sub

	' Page Load event
	Sub Page_Load()

		'Response.Write "Page Load"
	End Sub

	' Page Unload event
	Sub Page_Unload()

		'Response.Write "Page Unload"
	End Sub

	' User Logging Out event
	Function User_LoggingOut(usr)
		If Not EW_DEBUG_ENABLED Then On Error Resume Next

		' Enter your code here
		' To cancel, set return value to False

		User_LoggingOut = True
	End Function

	' User Logged Out event
	Sub User_LoggedOut(usr)

		' Response.Write "User Logged Out"
	End Sub
End Class
%>
