<script>
/*
    title   :       page list bar
    creator :       tklmilk
    date    :       2004-9-29

    example:
        var plb = new PageListBar('plb', 343, 6, '?', 10);
        document.write(plb);
*/

function PageListBar(name, pagecount, currpage, url, listlength)
{
    this.name = name;
    this.pagecount = pagecount;                                 //total page num
    this.currpage = currpage;                                   //current page
    this.url = url;                                             //link
    this.listlength = listlength?listlength:10;                                       //number of page showed

    if(this.pagecount <=0)
    {
        this.pagecount = 1;
    }
    if(this.currpage > this.pagecount)
    {
        this.currpage = this.pagecount;
    }
}

PageListBar.prototype.go = function(pagenum)
{
    window.location.href = '?currpage=' + pagenum + this.url;
}

PageListBar.prototype.goto = function()
{
    var currpage = prompt("תҳ",this.currpage);
    if(currpage)
    {
        if(currpage <= this.pagecount && currpage>=1)
        {
            this.go(currpage);
        }
    }
}

PageListBar.prototype.toString = function()
{
    var str = '', pStart = pEnd = 1;

    if(this.pagecount <= 1)
    {
        pStart = pEnd = 1;
    }else{
        if(this.pagecount <= this.listlength)
        {
            pStart = 1;
            pEnd = this.pagecount;
        }else{
            var movestep = Math.round(this.listlength/2);
            if(this.currpage > movestep)
            {
                pStart = this.currpage - movestep;
                pEnd = this.currpage + movestep;
                if(pEnd > this.pagecount)
                {
                    pStart -= pEnd - this.pagecount;
                    pEnd = this.pagecount;
                }

                if(pEnd > this.pagecount)
                {
                    pEnd = this.pagecount;
                    pStart -= (pEnd - this.pagecount);
                }
            }else{
                pStart = 1;
                pEnd = this.listlength;
            }
        }
    }

    for(var i=pStart; i<=pEnd; i++)
    {
        str += '<a href="javascript:' + this.name + '.go(' + i + ');void(0);">' + (i==this.currpage?('<b>' + i + '</b>'):i) + '</a>&nbsp;';
    }

    str = ' ' + this.pagecount + '/'+this.listlength+' ҳ&nbsp;&nbsp;<a href="javascript:' + this.name + '.go(1);void(0);">ҳ</a>&nbsp;<a href="javascript:' + this.name + '.go(' + ((this.currpage-1)<=1?1:(this.currpage-1)) + ');void(0);"' + (this.currpage==1?'disabled':'') + '><font face="webdings">3</font></a>&nbsp;' + str + '<a href="javascript:' + this.name + '.go(' + ((this.currpage+1)>=this.pagecount?this.pagecount:(this.currpage+1)) + ');void(0);"' + (this.currpage==this.pagecount?'disabled':'') + '><font face="webdings">4</font></a>&nbsp;<a href="javascript:' + this.name + '.go(' + this.pagecount + ');void(0);">βҳ</a>&nbsp;<a href="javascript:' + this.name + '.goto();void(0);">ת</a>';

    return str;
}
</script>