<?php
class upload
{
	var $savepath;
	var $alowexts;
	var $maxsize;
	var $overwrite;
	var $files = array();
	var $uploads = 0;
	var $uploadeds = 0;
	var $imageexts = array('gif', 'jpg', 'jpeg', 'png', 'bmp');
	var $uploadedfiles = array();
	var $error;

	function upload($inputname, $savepath = '', $savename = '', $alowexts = 'jpg|jpeg|gif|bmp|png|doc|docx|xls|ppt|pdf|txt|rar|zip', $maxsize = 0, $overwrite = 0)
	{
		if(!isset($_FILES[$inputname]) && !is_array($_FILES)) return false;
		$savepath = str_replace("\\", '/', $savepath);
		$this->set_savepath($savepath);
		$this->savename = $savename;
		$this->alowexts = $alowexts;
		$this->maxsize = $maxsize;
		$this->overwrite = $overwrite;
		$this->uploads = count($_FILES[$inputname]['name']);
		if(1 == $this->uploads)
		{
			$this->uploads = 1;
			$uploadfiles[0] = array('tmp_name' => $_FILES[$inputname]['tmp_name'], 'name' => $_FILES[$inputname]['name'], 'type' => $_FILES[$inputname]['type'], 'size' => $_FILES[$inputname]['size'], 'error' => $_FILES[$inputname]['error']);
		}
		else
		{
			foreach($_FILES[$inputname]['name'] as $key => $error) 
			{
				$uploadfiles[$key] = array('tmp_name' => $_FILES[$inputname]['tmp_name'][$key], 'name' => $_FILES[$inputname]['name'][$key], 'type' => $_FILES[$inputname]['type'][$key], 'size' => $_FILES[$inputname]['size'][$key], 'error' => $_FILES[$inputname]['error'][$key], 'description'=>$description[$key]);
			}
			
		}
		
		if(!is_dir($this->savepath) && !mkdir($this->savepath, 0777))
		{
			$this->error = 8;
			return false;
		}

		@chmod($this->savepath, 0777);
		if(!is_writeable($this->savepath) && ($this->savepath != '/'))
		{
			$this->error = 9;
			return false;
		}
		$this->files = $uploadfiles;
		return $this->files;
	}

	function up()
	{
		if(empty($this->files)) return false;
		foreach($this->files as $k=>$file)
		{
			$fileext = fileext($file['name']);
			
			if(!preg_match("/^(".$this->alowexts.")$/", $fileext))
			{
				$this->error = 10;
				return false;
			}
			if($this->maxsize && $file['size'] > $this->maxsize)
			{
				$this->error = 11;
				return false;
			}
			if(!$this->isuploadedfile($file['tmp_name']))
			{
				$this->error = 12;
				return false;
			}
			if(!dir_create($this->savepath))
			{
				$this->error = 8;
				return false;
			}
			$savename = $this->savename ? $this->savename : $file['name'];
			$savefile = PHPCMS_ROOT.$this->savepath.$savename;
			if(!$this->overwrite && file_exists($savefile)) continue;
			if(move_uploaded_file($file['tmp_name'], $savefile) || @copy($file['tmp_name'], $savefile))
			{
				$this->uploadeds++;
				@chmod($savefile, 0644);
				@unlink($file['tmp_name']);
				$this->uploadedfiles[] = array('saveto'=>$savefile, 'filename'=>$file['name'], 'filepath'=>$filepath, 'filetype'=>$file['type'], 'filesize'=>$file['size'], 'fileext'=>$fileext, 'description'=>$file['description']);
			}
		}
		return $this->uploadedfiles;
	}

	/**
     * ñ·
     * @param string ļ· "/" β
     */
    function set_savepath($savepath)
    {
		$savepath = str_replace("\\", "/", $savepath);
	    $savepath = substr($savepath,-1)=="/" ? $savepath : $savepath."/";
        $this->savepath = $savepath;
		return $this->savepath;
    }

	function isuploadedfile($file)
	{
		return is_uploaded_file($file) || is_uploaded_file(str_replace('\\\\', '\\', $file));
	}

	function error()
	{
		$UPLOAD_ERROR = array(0 => 'ļϴɹ',
							  1 => 'ϴļ php.ini  upload_max_filesize ѡƵֵ',
							  2 => 'ϴļĴС HTML  MAX_FILE_SIZE ѡֵָ',
							  3 => 'ļֻвֱϴ',
							  4 => 'ûļϴ',
							  5 => '',
							  6 => 'ҲʱļС',
							  7 => 'ļдʱļʧ',
							  8 => 'Ŀ¼ɹ',
							  9 => 'Ŀ¼ûдȨ',
							  10 => 'ϴļ',
							  11 => 'ļ˹Ա޶ĴС',
							  12 => 'Ƿϴļ',
							  13 => 'ͬļ',
							 );
		return $UPLOAD_ERROR[$this->error];
	}
}
?>