DROP TABLE IF EXISTS `phpcms_admin`;
CREATE TABLE `phpcms_admin` (
  `userid` mediumint(8) unsigned NOT NULL,
  `username` char(20) NOT NULL,
  `allowmultilogin` tinyint(1) unsigned NOT NULL default '0',
  `alloweditpassword` tinyint(1) unsigned NOT NULL default '0',
  `editpasswordnextlogin` tinyint(1) unsigned NOT NULL default '0',
  `disabled` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`userid`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_admin_role`;
CREATE TABLE `phpcms_admin_role` (
  `userid` mediumint(8) unsigned NOT NULL,
  `roleid` tinyint(3) unsigned NOT NULL,
  KEY `userid` (`userid`),
  KEY `roleid` (`roleid`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_admin_role_priv`;
CREATE TABLE `phpcms_admin_role_priv` (
  `roleid` tinyint(3) unsigned NOT NULL default '0',
  `field` char(15) NOT NULL,
  `value` char(15) NOT NULL,
  `priv` char(15) NOT NULL,
  PRIMARY KEY  (`roleid`,`field`,`value`,`priv`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS `phpcms_area`;
CREATE TABLE `phpcms_area` (
  `areaid` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL,
  `style` varchar(35) NOT NULL,
  `parentid` smallint(5) unsigned NOT NULL default '0',
  `arrparentid` varchar(255) NOT NULL default '',
  `child` tinyint(1) unsigned NOT NULL default '0',
  `arrchildid` mediumtext NOT NULL,
  `template` varchar(50) NOT NULL,
  `listorder` smallint(5) unsigned NOT NULL default '0',
  `hits` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`areaid`),
  KEY `parentid` (`parentid`,`listorder`)
) TYPE=MyISAM;

INSERT INTO `phpcms_area` (`areaid`, `name`, `style`, `parentid`, `arrparentid`, `child`, `arrchildid`, `template`, `listorder`, `hits`) VALUES (1, '', '', 0, '0', 0, '1', '', 1, 0);
INSERT INTO `phpcms_area` (`areaid`, `name`, `style`, `parentid`, `arrparentid`, `child`, `arrchildid`, `template`, `listorder`, `hits`) VALUES (2, 'Ϻ', '', 0, '0', 0, '2', '', 2, 0);

DROP TABLE IF EXISTS `phpcms_attachment`;
CREATE TABLE `phpcms_attachment` (
  `aid` int(10) unsigned NOT NULL auto_increment,
  `module` char(15) NOT NULL,
  `catid` smallint(5) unsigned NOT NULL default '0',
  `contentid` mediumint(8) unsigned NOT NULL default '0',
  `field` char(20) NOT NULL,
  `filename` char(50) NOT NULL,
  `filepath` char(200) NOT NULL,
  `filetype` char(30) NOT NULL,
  `filesize` int(10) unsigned NOT NULL default '0',
  `fileext` char(10) NOT NULL,
  `description` char(50) NOT NULL,
  `isimage` tinyint(1) unsigned NOT NULL default '0',
  `isthumb` tinyint(1) unsigned NOT NULL default '0',
  `downloads` mediumint(8) unsigned NOT NULL default '0',
  `listorder` tinyint(3) unsigned NOT NULL default '0',
  `userid` mediumint(8) unsigned NOT NULL default '0',
  `uploadtime` int(10) unsigned NOT NULL default '0',
  `uploadip` char(15) NOT NULL,
  PRIMARY KEY  (`aid`),
  KEY `contentid` (`contentid`,`field`,`listorder`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_author`;
CREATE TABLE `phpcms_author` (
  `authorid` smallint(5) unsigned NOT NULL auto_increment,
  `username` varchar(20) NOT NULL,
  `name` varchar(30) NOT NULL,
  `gender` tinyint(1) unsigned NOT NULL default '0',
  `birthday` date NOT NULL default '0000-00-00',
  `email` varchar(40) NOT NULL,
  `qq` varchar(15) NOT NULL,
  `msn` varchar(40) NOT NULL,
  `homepage` varchar(100) NOT NULL,
  `telephone` varchar(20) NOT NULL,
  `address` varchar(100) NOT NULL,
  `postcode` varchar(6) NOT NULL,
  `photo` varchar(100) NOT NULL,
  `introduce` mediumtext NOT NULL,
  `updatetime` int(10) unsigned NOT NULL default '0',
  `listorder` tinyint(3) unsigned NOT NULL default '0',
  `elite` tinyint(1) unsigned NOT NULL default '0',
  `disabled` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`authorid`),
  UNIQUE KEY `name` (`name`),
  KEY `username` (`username`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS `phpcms_block`;
CREATE TABLE `phpcms_block` (
  `blockid` smallint(5) unsigned NOT NULL auto_increment,
  `pageid` varchar(20) NOT NULL,
  `blockno` tinyint(2) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL,
  `isarray` tinyint(1) unsigned NOT NULL default '0',
  `rows` tinyint(2) unsigned NOT NULL default '8',
  `data` mediumtext NOT NULL,
  `listorder` tinyint(2) unsigned NOT NULL default '0',
  `disabled` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`blockid`),
  KEY `pageid` (`pageid`,`blockno`,`disabled`,`listorder`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_c_down`;
CREATE TABLE `phpcms_c_down` (
  `contentid` mediumint(8) unsigned NOT NULL,
  `template` varchar(30) NOT NULL,
  `content` mediumtext NOT NULL,
  `version` varchar(20) NOT NULL default '',
  `classtype` varchar(20) NOT NULL default '',
  `language` varchar(20) NOT NULL default '',
  `copytype` varchar(15) NOT NULL default 'Ѱ',
  `systems` varchar(100) NOT NULL default 'Win2000/WinXP/Win2003',
  `stars` varchar(20) NOT NULL default '',
  `filesize` varchar(20) NOT NULL default 'δ֪',
  `downurl` varchar(255) NOT NULL default '',
  `downurls` text NOT NULL,
  `groupids_view` tinyint(1) unsigned NOT NULL default '0',
  `readpoint` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contentid`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_c_info`;
CREATE TABLE `phpcms_c_info` (
  `contentid` mediumint(8) unsigned NOT NULL,
  `template` char(30) NOT NULL,
  `content` mediumtext NOT NULL,
  `endtime` date NOT NULL default '0000-00-00',
  `telephone` varchar(100) NOT NULL default '',
  `email` varchar(40) NOT NULL default '',
  `address` varchar(255) NOT NULL default '',
  `groupids_view` tinyint(1) unsigned NOT NULL default '0',
  `readpoint` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contentid`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_c_ku6video`;
CREATE TABLE IF NOT EXISTS `phpcms_c_ku6video` (
  `contentid` mediumint(8) unsigned NOT NULL,
  `template` char(30) NOT NULL,
  `content` mediumtext NOT NULL,
  `photo` tinyint(1) unsigned NOT NULL default '0',
  `ku6video` tinyint(1) unsigned NOT NULL default '0',
  `readpoint` int(10) unsigned NOT NULL default '0',
  `groupids_view` tinyint(1) unsigned NOT NULL default '0',
  `director` varchar(255) NOT NULL default '',
  `actor` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`contentid`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_c_news`;
CREATE TABLE `phpcms_c_news` (
  `contentid` mediumint(8) unsigned NOT NULL,
  `template` varchar(30) NOT NULL default '',
  `titleintact` varchar(200) NOT NULL default '',
  `content` mediumtext NOT NULL,
  `groupids_view` tinyint(1) unsigned NOT NULL default '0',
  `readpoint` smallint(5) unsigned NOT NULL default '0',
  `author` varchar(30) NOT NULL default '',
  `copyfrom` varchar(100) NOT NULL,
  `paginationtype` tinyint(1) NOT NULL default '0',
  `maxcharperpage` mediumint(6) NOT NULL default '10000',
  PRIMARY KEY  (`contentid`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_c_picture`;
CREATE TABLE `phpcms_c_picture` (
  `contentid` mediumint(8) unsigned NOT NULL,
  `template` char(30) NOT NULL,
  `content` mediumtext NOT NULL,
  `pictureurls` tinyint(1) unsigned NOT NULL default '0',
  `author` varchar(30) NOT NULL default '',
  `copyfrom` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`contentid`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_c_product`;
CREATE TABLE `phpcms_c_product` (
  `contentid` mediumint(8) unsigned NOT NULL,
  `template` varchar(255) NOT NULL default '',
  `content` mediumtext NOT NULL,
  `price` float unsigned NOT NULL default '0',
  `size` varchar(50) NOT NULL default '',
  `pictureurls` tinyint(1) unsigned NOT NULL default '0',
  `unit` varchar(4) NOT NULL default '',
  `stock` varchar(20) NOT NULL default '',
  `stars` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`contentid`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_c_video`;
CREATE TABLE IF NOT EXISTS `phpcms_c_video` (
  `contentid` mediumint(8) unsigned NOT NULL,
  `template` char(30) NOT NULL,
  `content` mediumtext NOT NULL,
  `video` text NOT NULL,
  `director` varchar(255) NOT NULL default '',
  `actor` varchar(255) NOT NULL default '',
  `rank` char(255) NOT NULL default '',
  `photo` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contentid`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_cache_count`;
CREATE TABLE `phpcms_cache_count` (
  `id` char(32) NOT NULL default '',
  `count` mediumint(8) unsigned NOT NULL default '0',
  `updatetime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MEMORY;

DROP TABLE IF EXISTS `phpcms_category`;
CREATE TABLE `phpcms_category` (
  `catid` smallint(5) unsigned NOT NULL auto_increment,
  `module` varchar(15) NOT NULL,
  `type` tinyint(1) unsigned NOT NULL default '0',
  `modelid` tinyint(3) unsigned NOT NULL default '0',
  `parentid` smallint(5) unsigned NOT NULL default '0',
  `arrparentid` varchar(255) NOT NULL,
  `child` tinyint(1) unsigned NOT NULL default '0',
  `arrchildid` mediumtext NOT NULL,
  `catname` varchar(30) NOT NULL,
  `style` varchar(5) NOT NULL,
  `image` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `parentdir` varchar(100) NOT NULL,
  `catdir` varchar(30) NOT NULL,
  `url` varchar(100) NOT NULL,
  `content` mediumtext NOT NULL,
  `items` mediumint(8) unsigned NOT NULL default '0',
  `hits` int(10) unsigned NOT NULL default '0',
  `setting` mediumtext NOT NULL,
  `listorder` smallint(5) unsigned NOT NULL default '0',
  `ismenu` tinyint(1) unsigned NOT NULL default '1',
  `letter` varchar(1) NOT NULL,
  `citems` mediumint(8) unsigned NOT NULL default '0',
  `pitems` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`catid`),
  KEY `module` (`module`,`parentid`,`listorder`,`catid`)
) TYPE=MyISAM;

INSERT INTO `phpcms_category` (`catid`, `module`, `type`, `modelid`, `parentid`, `arrparentid`, `child`, `arrchildid`, `catname`, `style`, `image`, `description`, `parentdir`, `catdir`, `url`, `content`, `items`, `hits`, `setting`, `listorder`, `ismenu`) VALUES (1, 'phpcms', 1, 0, 0, '0', 1, '1,2,3,4,5', 'վ', '', '', '', '', 'about', 'about/index.html', 'վ', 0, 0, 'array (\n  ''template'' => ''page'',\n  ''ishtml'' => ''1'',\n  ''category_urlruleid'' => ''1'',\n  ''meta_title'' => '''',\n  ''meta_keywords'' => '''',\n  ''meta_description'' => '''',\n)', 1, 0);
INSERT INTO `phpcms_category` (`catid`, `module`, `type`, `modelid`, `parentid`, `arrparentid`, `child`, `arrchildid`, `catname`, `style`, `image`, `description`, `parentdir`, `catdir`, `url`, `content`, `items`, `hits`, `setting`, `listorder`, `ismenu`) VALUES (2, 'phpcms', 1, 0, 1, '0,1', 0, '2', '', '', '', '', 'about/', 'aboutus', 'about/aboutus/index.html', '', 0, 0, 'array (\n  ''template'' => ''page'',\n  ''ishtml'' => ''1'',\n  ''category_urlruleid'' => ''1'',\n  ''meta_title'' => '''',\n  ''meta_keywords'' => '''',\n  ''meta_description'' => '''',\n)', 2, 0);
INSERT INTO `phpcms_category` (`catid`, `module`, `type`, `modelid`, `parentid`, `arrparentid`, `child`, `arrchildid`, `catname`, `style`, `image`, `description`, `parentdir`, `catdir`, `url`, `content`, `items`, `hits`, `setting`, `listorder`, `ismenu`) VALUES (3, 'phpcms', 1, 0, 1, '0,1', 0, '3', 'ϵʽ', '', '', '', 'about/', 'contactus', 'about/contactus/index.html', 'ϵʽ', 0, 0, 'array (\n  ''template'' => ''page'',\n  ''ishtml'' => ''1'',\n  ''category_urlruleid'' => ''1'',\n  ''meta_title'' => ''ϵʽ'',\n  ''meta_keywords'' => ''ϵʽ'',\n  ''meta_description'' => ''ϵʽ'',\n)', 3, 0);
INSERT INTO `phpcms_category` (`catid`, `module`, `type`, `modelid`, `parentid`, `arrparentid`, `child`, `arrchildid`, `catname`, `style`, `image`, `description`, `parentdir`, `catdir`, `url`, `content`, `items`, `hits`, `setting`, `listorder`, `ismenu`) VALUES (4, 'phpcms', 1, 0, 1, '0,1', 0, '4', 'ƸϢ', '', '', '', 'about/', 'joinus', 'about/joinus/index.html', 'ƸϢ', 0, 0, 'array (\n  ''template'' => ''page'',\n  ''ishtml'' => ''1'',\n  ''category_urlruleid'' => ''1'',\n  ''meta_title'' => ''ƸϢ'',\n  ''meta_keywords'' => ''ƸϢ'',\n  ''meta_description'' => ''ƸϢ'',\n)', 4, 0);
INSERT INTO `phpcms_category` (`catid`, `module`, `type`, `modelid`, `parentid`, `arrparentid`, `child`, `arrchildid`, `catname`, `style`, `image`, `description`, `parentdir`, `catdir`, `url`, `content`, `items`, `hits`, `setting`, `listorder`, `ismenu`) VALUES (5, 'phpcms', 1, 0, 1, '0,1', 0, '5', 'Ȩ', '', '', '', 'about/', 'copyright', 'about/copyright/index.html', 'Ȩ', 0, 0, 'array (\n  ''template'' => ''page'',\n  ''ishtml'' => ''1'',\n  ''category_urlruleid'' => ''1'',\n  ''meta_title'' => ''Ȩ'',\n  ''meta_keywords'' => ''Ȩ'',\n  ''meta_description'' => ''Ȩ'',\n)', 5, 0);
INSERT INTO `phpcms_category` (`catid`, `module`, `type`, `modelid`, `parentid`, `arrparentid`, `child`, `arrchildid`, `catname`, `style`, `image`, `description`, `parentdir`, `catdir`, `url`, `content`, `items`, `hits`, `setting`, `listorder`, `ismenu`) VALUES (7, 'phpcms', 2, 0, 0, '0', 0, '7', 'ר', '', '', '', '', '', 'special/', '', 0, 0, '', 501, 1);
INSERT INTO `phpcms_category` (`catid`, `module`, `type`, `modelid`, `parentid`, `arrparentid`, `child`, `arrchildid`, `catname`, `style`, `image`, `description`, `parentdir`, `catdir`, `url`, `content`, `items`, `hits`, `setting`, `listorder`, `ismenu`) VALUES (30, 'phpcms', 2, 0, 0, '0', 0, '9', 'ҵҳ', '', '', '', '', '', 'yp/', '', 0, 0, '', 502, 1);
INSERT INTO `phpcms_category` (`catid`, `module`, `type`, `modelid`, `parentid`, `arrparentid`, `child`, `arrchildid`, `catname`, `style`, `image`, `description`, `parentdir`, `catdir`, `url`, `content`, `items`, `hits`, `setting`, `listorder`, `ismenu`) VALUES (9, 'phpcms', 2, 0, 0, '0', 0, '9', 'ʰ', '', '', '', '', '', 'ask/', '', 0, 0, '', 503, 1);
INSERT INTO `phpcms_category` (`catid`, `module`, `type`, `modelid`, `parentid`, `arrparentid`, `child`, `arrchildid`, `catname`, `style`, `image`, `description`, `parentdir`, `catdir`, `url`, `content`, `items`, `hits`, `setting`, `listorder`, `ismenu`) VALUES (8, 'phpcms', 2, 0, 0, '0', 0, '8', '', '', '', '', '', '', 'search/', '', 0, 0, '', 504, 1);
INSERT INTO `phpcms_category` (`catid`, `module`, `type`, `modelid`, `parentid`, `arrparentid`, `child`, `arrchildid`, `catname`, `style`, `image`, `description`, `parentdir`, `catdir`, `url`, `content`, `items`, `hits`, `setting`, `listorder`, `ismenu`) VALUES (6, 'phpcms', 2, 0, 0, '0', 0, '6', 'Ա', '', '', '', '', '', 'member/list.php?modelid=10', '', 0, 0, '', 505, 1);
INSERT INTO `phpcms_category` (`catid`, `module`, `type`, `modelid`, `parentid`, `arrparentid`, `child`, `arrchildid`, `catname`, `style`, `image`, `description`, `parentdir`, `catdir`, `url`, `content`, `items`, `hits`, `setting`, `listorder`, `ismenu`) VALUES (10, 'phpcms', 2, 0, 0, '0', 0, '10', '¸', '', '', '', '', '', 'renew.php', '', 0, 0, '', 506, 1);
INSERT INTO `phpcms_category` (`catid`, `module`, `type`, `modelid`, `parentid`, `arrparentid`, `child`, `arrchildid`, `catname`, `style`, `image`, `description`, `parentdir`, `catdir`, `url`, `content`, `items`, `hits`, `setting`, `listorder`, `ismenu`) VALUES (31, 'phpcms', 2, 0, 0, '0', 0, '10', '̳', '', '', '', '', '', 'http://bbs.phpcms.cn', '', 0, 0, '', 507, 1);

DROP TABLE IF EXISTS `phpcms_collect`;
CREATE TABLE IF NOT EXISTS `phpcms_collect` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `contentid` int(10) unsigned NOT NULL,
  `userid` mediumint(8) unsigned NOT NULL,
  `addtime` int(11) unsigned NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `userid` (`userid`),
  KEY `contentid` (`contentid`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_content`;
CREATE TABLE `phpcms_content` (
  `contentid` mediumint(8) unsigned NOT NULL auto_increment,
  `catid` smallint(5) unsigned NOT NULL default '0',
  `typeid` smallint(5) unsigned NOT NULL default '0',
  `areaid` smallint(5) unsigned NOT NULL default '0',
  `title` char(80) NOT NULL default '',
  `style` char(5) NOT NULL default '',
  `thumb` char(100) NOT NULL default '',
  `keywords` char(40) NOT NULL default '',
  `description` char(255) NOT NULL default '',
  `posids` tinyint(1) unsigned NOT NULL default '0',
  `url` char(100) NOT NULL,
  `listorder` tinyint(3) unsigned NOT NULL default '0',
  `status` tinyint(2) unsigned NOT NULL default '3',
  `userid` mediumint(8) unsigned NOT NULL default '0',
  `username` char(20) NOT NULL,
  `inputtime` int(10) unsigned NOT NULL default '0',
  `updatetime` int(10) unsigned NOT NULL default '0',
  `searchid` mediumint(8) unsigned NOT NULL default '0',
  `islink` tinyint(1) unsigned NOT NULL default '0',
  `prefix` char(20) NOT NULL default '',
  PRIMARY KEY  (`contentid`),
  KEY `status` (`status`,`listorder`,`contentid`),
  KEY `listorder` (`catid`,`status`,`listorder`,`contentid`),
  KEY `catid` (`catid`,`status`,`contentid`),
  KEY `updatetime` (`catid`,`status`,`updatetime`),
  KEY `typeid` (`typeid`,`status`,`contentid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS `phpcms_content_count`;
CREATE TABLE `phpcms_content_count` (
  `contentid` mediumint(8) unsigned NOT NULL,
  `hits` mediumint(8) unsigned NOT NULL default '0',
  `hits_day` smallint(5) unsigned NOT NULL default '0',
  `hits_week` mediumint(8) unsigned NOT NULL default '0',
  `hits_month` mediumint(8) unsigned NOT NULL default '0',
  `hits_time` int(10) unsigned NOT NULL default '0',
  `comments` smallint(5) unsigned NOT NULL default '0',
  `comments_checked` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contentid`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_content_position`;
CREATE TABLE `phpcms_content_position` (
  `contentid` mediumint(8) unsigned NOT NULL default '0',
  `posid` smallint(5) unsigned NOT NULL default '0',
  KEY `posid` (`posid`),
  KEY `contentid` (`contentid`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_content_tag`;
CREATE TABLE `phpcms_content_tag` (
  `tag` char(20) NOT NULL,
  `contentid` mediumint(8) unsigned NOT NULL default '0',
  KEY `contentid` (`contentid`),
  KEY `tag` (`tag`(10))
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_copyfrom`;
CREATE TABLE `phpcms_copyfrom` (
  `copyfromid` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  `url` varchar(100) NOT NULL,
  `usetimes` mediumint(8) unsigned NOT NULL default '0',
  `listorder` smallint(5) unsigned NOT NULL default '0',
  `updatetime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`copyfromid`),
  UNIQUE KEY `name` (`name`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_datasource`;
CREATE TABLE `phpcms_datasource` (
  `name` varchar(15) NOT NULL,
  `dbtype` varchar(10) NOT NULL,
  `dbhost` varchar(15) NOT NULL,
  `dbuser` varchar(30) NOT NULL,
  `dbpw` varchar(50) NOT NULL,
  `dbname` varchar(30) NOT NULL,
  `dbcharset` varchar(10) NOT NULL,
  `tablename` varchar(30) NOT NULL,
  `fields` varchar(255) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`name`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_hits`;
CREATE TABLE `phpcms_hits` (
  `field` char(10) NOT NULL,
  `value` mediumint(8) unsigned NOT NULL default '0',
  `date` date NOT NULL default '0000-00-00',
  `hits` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`field`,`value`,`date`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_ipbanned`;
CREATE TABLE `phpcms_ipbanned` (
  `ip` char(15) NOT NULL,
  `expires` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ip`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_keylink`;
CREATE TABLE `phpcms_keylink` (
  `keylinkid` smallint(5) unsigned NOT NULL auto_increment,
  `word` char(40) NOT NULL,
  `url` char(100) NOT NULL,
  `listorder` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`keylinkid`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_keyword`;
CREATE TABLE `phpcms_keyword` (
  `tagid` smallint(5) unsigned NOT NULL auto_increment,
  `tag` char(20) NOT NULL,
  `style` char(5) NOT NULL,
  `usetimes` smallint(5) unsigned NOT NULL default '0',
  `lastusetime` int(10) unsigned NOT NULL default '0',
  `hits` mediumint(8) unsigned NOT NULL default '0',
  `lasthittime` int(10) unsigned NOT NULL default '0',
  `listorder` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`tagid`),
  UNIQUE KEY `tag` (`tag`),
  KEY `usetimes` (`usetimes`,`listorder`),
  KEY `hits` (`hits`,`listorder`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_player`;
CREATE TABLE IF NOT EXISTS `phpcms_player` (
  `playerid` smallint(3) unsigned NOT NULL auto_increment,
  `subject` char(20) NOT NULL,
  `code` mediumtext NOT NULL,
  `disabled` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`playerid`)
) TYPE=MyISAM ;

INSERT INTO `phpcms_player` (`playerid`, `subject`, `code`, `disabled`) VALUES
(1, 'RealPlayer', '<script language="javascript">\r\nvar ERR_FileNotFind="ʾδҵ㲥ļ뱨ӰƬԱ";\r\nvar ERR_NotLocateServer="ʾ޷ӷӷʱ";\r\nvar ERR_UnkownError="ʾδ֪";\r\n</script>\r\n<script LANGUAGE="VBScript">                                    \r\non error resume next \r\nSub player_OnBuffering(lFlags,lPercentage)\r\nif (lPercentage=100) then\r\nStartPlay=false\r\nif (FirstPlay) then\r\nFirstPlay=false\r\nend if\r\nexit sub\r\nend if\r\nEnd Sub\r\nSub player_OnErrorMessage(uSeverity, uRMACode, uUserCode, pUserString, pMoreInfoURL, pErrorString)\r\nselect case player.GetLastErrorRMACode()\r\n   case -2147221496\r\nwindow.alert(ERR_FileNotFind)\r\n   case -2147221433,-2147221428,-2147221417,-2147217468\r\nwindow.alert(ERR_NotLocateServer)\r\ncase -2147221436\r\nwindow.alert("ϵͳʾ޷ӵ㲥ļ")\r\n   case else\r\nwindow.alert(ERR_UnkownError)\r\nend select\r\nEnd Sub\r\n</script>\r\n<center>\r\n<TABLE cellPadding=0 cellSpacing=0 border=1 height="100%" width="100%" id="table2">\r\n<TR>\r\n<TD>\r\n<OBJECT classid="clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA" height="100%" id=RP1 name=RP1 width="100%">\r\n<PARAM NAME="AUTOSTART" VALUE="-1">\r\n<PARAM NAME="SHUFFLE" VALUE="0">\r\n<PARAM NAME="PREFETCH" VALUE="0">\r\n<PARAM NAME="NOLABELS" VALUE="0">\r\n<PARAM NAME="CONTROLS" VALUE="Imagewindow">\r\n<PARAM NAME="CONSOLE" VALUE="clip1">\r\n<PARAM NAME="LOOP" VALUE="0">\r\n<PARAM NAME="NUMLOOP" VALUE="0">\r\n<PARAM NAME="CENTER" VALUE="0">\r\n<PARAM NAME="MAINTAINASPECT" VALUE="1">\r\n<PARAM NAME="BACKGROUNDCOLOR" VALUE="#000000">\r\n</OBJECT>\r\n</TD></TR><TR><TD height=60>\r\n<TABLE align=center border=0 cellPadding=0 cellSpacing=0 width="100%" id="table3">\r\n<TR><TD align=middle bgColor=#000000>\r\n<TABLE border=1 cellPadding=0 cellSpacing=0 width="100%" id="table4">\r\n<TR><TD width=50>\r\n<IMG border=0 height=30 onclick=document.RP1.SetFullScreen() src="{$PHPCMS[siteurl]}images/player/full.gif" width=50></TD>\r\n<TD>\r\n<OBJECT classid=clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA  height=30 id=player name=player width="100%">\r\n<PARAM NAME="_ExtentX" VALUE="4657">\r\n<PARAM NAME="_ExtentY" VALUE="794">\r\n<PARAM NAME="AUTOSTART" VALUE="-1">\r\n<PARAM NAME="SRC" VALUE="{$filepath}">\r\n<PARAM NAME="SHUFFLE" VALUE="0">\r\n<PARAM NAME="PREFETCH" VALUE="0">\r\n<PARAM NAME="NOLABELS" VALUE="-1">\r\n<PARAM NAME="CONTROLS" VALUE="ControlPanel">\r\n<PARAM NAME="CONSOLE" VALUE="clip1">\r\n<PARAM NAME="LOOP" VALUE="0">\r\n<PARAM NAME="NUMLOOP" VALUE="0">\r\n<PARAM NAME="CENTER" VALUE="0">\r\n<PARAM NAME="MAINTAINASPECT" VALUE="1">\r\n<PARAM NAME="BACKGROUNDCOLOR" VALUE="#000000">\r\n</OBJECT>\r\n</TD></TR></TABLE></TD></TR>\r\n<TR>\r\n<TD align=middle bgColor=#000000>\r\n<OBJECT classid=clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA height=30 id=RP3 name=RP3 width="100%">\r\n<PARAM NAME="_ExtentX" VALUE="4657">\r\n<PARAM NAME="_ExtentY" VALUE="794">\r\n<PARAM NAME="AUTOSTART" VALUE="-1">\r\n<PARAM NAME="SHUFFLE" VALUE="0">\r\n<PARAM NAME="PREFETCH" VALUE="0">\r\n<PARAM NAME="NOLABELS" VALUE="-1">\r\n<PARAM NAME="CONTROLS" VALUE="StatusBar">\r\n<PARAM NAME="CONSOLE" VALUE="clip1">\r\n<PARAM NAME="LOOP" VALUE="0">\r\n<PARAM NAME="NUMLOOP" VALUE="0">\r\n<PARAM NAME="CENTER" VALUE="0">\r\n<PARAM NAME="MAINTAINASPECT" VALUE="1">\r\n<PARAM NAME="BACKGROUNDCOLOR" VALUE="#000000">\r\n</OBJECT>\r\n</TD></TR></TABLE></TD></TR></TABLE>', 0),
(2, 'window media player', '<object classid="clsid:22D6F312-B0F6-11D0-94AB-0080C74C7E95" id="MediaPlayer1" width="100%" height="100%">\r\n<param name="AudioStream" value="-1">\r\n<param name="AutoSize" value="-1">\r\n<!--ǷԶŴС-->\r\n<param name="AutoStart" value="-1">\r\n<!--ǷԶ-->\r\n<param name="AnimationAtStart" value="-1">\r\n<param name="AllowScan" value="-1">\r\n<param name="AllowChangeDisplaySize" value="-1">\r\n<param name="AutoRewind" value="0">\r\n<param name="Balance" value="0">\r\n<!--ƽ,-9640,9640-->\r\n<param name="BaseURL" value>\r\n<param name="BufferingTime" value="15">\r\n<!--ʱ-->\r\n<param name="CaptioningID" value>\r\n<param name="ClickToPlay" value="-1">\r\n<param name="CursorType" value="0">\r\n<param name="CurrentPosition" value="0">\r\n<!--ǰŽ -1 ʾ,0ʾͷ λ,10ʾӵ10봦ʼ,ֵ-1.0ڵ0-->\r\n<param name="CurrentMarker" value="0">\r\n<param name="DefaultFrame" value>\r\n<param name="DisplayBackColor" value="0">\r\n<param name="DisplayForeColor" value="16777215">\r\n<param name="DisplayMode" value="0">\r\n<param name="DisplaySize" value="0">\r\n<!--Ƶ1-50%, 0-100%, 2-200%,3-ȫ ֵ0,СȻǰĴ-->\r\n<param name="Enabled" value="-1">\r\n<param name="EnableContextMenu" value="-1">\r\n<!-ǷҼ˵-->\r\n<param name="EnablePositionControls" value="-1">\r\n<param name="EnableFullScreenControls" value="-1">\r\n<param name="EnableTracker" value="-1">\r\n<!--ǷŽط-->\r\n<param name="Filename" value="{$filepath}" valuetype="ref">\r\n<!--ŵļַ-->\r\n<param name="InvokeURLs" value="-1">\r\n<param name="Language" value="-1">\r\n<param name="Mute" value="0">\r\n<!--Ƿ-->\r\n<param name="PlayCount" value="1">\r\n<!--ظŴ,0Ϊʼظ-->\r\n<param name="PreviewMode" value="-1">\r\n<param name="Rate" value="1">\r\n<!--ʿ,1Ϊ,С-->\r\n<param name="SAMIStyle" value="1">\r\n<!--SAMIʽ-->\r\n<param name="SAMILang" value>\r\n<!--SAMI-->\r\n<param name="SAMIFilename" value>\r\n<!--ĻID-->\r\n<param name="SelectionStart" value="-1">\r\n<param name="SelectionEnd" value="-1">\r\n<param name="SendOpenStateChangeEvents" value="-1">\r\n<param name="SendWarningEvents" value="-1">\r\n<param name="SendErrorEvents" value="-1">\r\n<param name="SendKeyboardEvents" value="0">\r\n<param name="SendMouseClickEvents" value="0">\r\n<param name="SendMousemovieeEvents" value="0">\r\n<param name="SendPlayStateChangeEvents" value="-1">\r\n<param name="ShowCaptioning" value="0">\r\n<!--ǷʾĻ,Ϊһɫ,һɫ,һ㲻ʾ-->\r\n<param name="ShowControls" value="-1">\r\n<!--Ƿʾ,粥,ֹͣ,ͣ-->\r\n<param name="ShowAudioControls" value="-1">\r\n<!--Ƿʾ-->\r\n<param name="ShowDisplay" value="0">\r\n<!--ʾĿϢ,Ȩ-->\r\n<param name="ShowGotoBar" value="0">\r\n<!--ǷĲ˵-->\r\n<param name="ShowPositionControls" value="-1">\r\n<!--Ƿʾǰб,ʾһҲǻɫɿ-->\r\n<param name="ShowStatusBar" value="-1">\r\n<!--ǰϢ,ʾǷڲ,ܲʱ͵ǰŵʱ-->\r\n<param name="ShowTracker" value="-1">\r\n<!--ǷʾǰŸ,ǰĲŽ-->\r\n<param name="TransparentAtStart" value="-1">\r\n<param name="VideoBorderWidth" value="0">\r\n<!--ʾĿ,СƵ,СΪƵ,߼Ӵֵָ,ԶӴ߶.˸ıֻıܵĺڿС,ıƵС-->\r\n<param name="VideoBorderColor" value="0">\r\n<!--ʾɫɫ, ΪRGBֵ,ffff00Ϊɫ-->\r\n<param name="VideoBorder3D" value="0">\r\n<param name="Volume" value="0">\r\n<!--С,ֵʾǵǰļֵ,ֵԶȡֵ,Ϊ0,СΪ-9640-->\r\n<param name="WindowlessVideo" value="0">\r\n<!--0ȫ,ֻڴв鿴-->\r\n</object>', 0),
(3, 'real', '<Script Language="JavaScript">\r\nIEvar=navigator.appVersion.substring(navigator.appVersion.indexOf(''MSIE'')+5,navigator.appVersion.indexOf('';'',17));\r\nif(IEvar=="6.0")\r\n{\r\n  ie6 = true;\r\n  width_add = 10;\r\n  height_add = 29;\r\n  jjjj = 5;\r\n  hand_add = -14;\r\n}\r\nelse\r\n{\r\n  ie6 = false;\r\n  width_add = 0;\r\n  height_add = 0;\r\n  jjjj = 0;\r\n  hand_add = 0;\r\n}\r\nb_width = 0;\r\nb_height = 0;\r\n\r\n//Ҽ\r\n   function no_newwin(){\r\n   if((event.ctrlKey)&&(event.keyCode==78)){\r\n   event.keyCode=0;\r\n   event.returnValue=false;\r\n   }\r\n}\r\n\r\nfunction click()\r\n{\r\n   return false;\r\n}\r\ndocument.oncontextmenu=click;\r\ndocument.onmousemoviee=click;\r\n\r\ndocument.ondragstart=doDragStart\r\nfunction doDragStart() {event.returnValue=false}\r\n\r\n\r\n//-------------------------\r\n\r\nvar Real;\r\nReal=''rPlayer.'';\r\nvar Mute=false;\r\nvar CanSetPos=true;\r\nvar SetPosStart=false;\r\nvar SetVolStart=false;\r\nvar loop, timer, initialised;\r\nvar speed=50;\r\nvar oldwidth=566,oldheight=502;\r\nmovieeon=false;movieelen=300;rm_tollen=0;timelen=0;volumlen=56;iScrollLength=140;\r\n\r\ndocument.onmouseup=Total_Up;\r\n\r\nfunction Total_Up(){\r\nif(event.button!=2){\r\nif(SetPosStart){\r\nsetpos();\r\nballmoviee();\r\n}\r\nif(SetVolStart) setvol();\r\n }\r\n}\r\n\r\nfunction moviees()\r\n{\r\nif(CanSetPos&&event.button!=2)\r\n{\r\norix=event.x;\r\norileft=mblock.style.pixelLeft;\r\nif(movieeon)\r\n{\r\nclearTimeout(balltime);\r\n}\r\nSetPosStart=true;\r\n}\r\nelse\r\n  return false;\r\n}\r\n\r\nfunction ChangePos() {\r\nnewleft=event.x;\r\n{\r\nSetPosStart=false;\r\nif (event.x < movieelen+10)\r\n  newleft=event.x-10;\r\nelse\r\n  newleft=movieelen-1;\r\nif (event.x < 10)\r\n  newleft=0;\r\nrm_tollen = GetLength();\r\nrcp=Math.round((newleft/movieelen)*rm_tollen);\r\nSetPosition(rcp);\r\nmblock.style.left = newleft;\r\nplay()\r\n}\r\n}\r\n\r\nfunction movieego()\r\n{\r\nif(SetPosStart)\r\n{\r\nnewx=event.x;\r\ndisx=newx-orix;\r\nnewleft=orileft+disx;\r\nif(newleft>-1&&newleft<movieelen) mblock.style.left=newleft;\r\n}\r\n}\r\n\r\nfunction setpos()\r\n{\r\nSetPosStart=false;\r\nnewleft=mblock.style.pixelLeft;\r\nrm_tollen = GetLength();\r\nrcp=Math.round((newleft/movieelen)*rm_tollen);\r\nSetPosition(rcp);\r\n}\r\n\r\nfunction vols()\r\n{\r\nif(event.button!=2)\r\n{\r\norix=event.x;\r\norileft=vblock.style.pixelLeft;\r\nSetVolStart=true;\r\n}\r\n}\r\n\r\nfunction volgo()\r\n{\r\nif(SetVolStart)\r\n{\r\nnewx=event.x;\r\ndisx=newx-orix;\r\nnewleft=orileft+disx;\r\nif(newleft>5&&newleft<=volumlen) vblock.style.left=newleft;\r\n}\r\n}\r\n\r\nfunction setvol()\r\n{//\r\nSetVolStart=false;\r\nnewleft=vblock.style.pixelLeft;\r\nnewvol=-(Math.round((volumlen-newleft)*2000/(volumlen-6)));\r\nSetVolume(newvol);\r\n}\r\nfunction RealincreaseVolume(){\r\nif(window.rPlayer!=null)\r\n{\r\nif(volumlen >= 100 )\r\nvolumlen = 100;\r\nelse\r\nvolumlen += 10;\r\nrPlayer.SetVolume(volumlen);\r\n}}\r\nfunction RealdecreseVolume()\r\n{\r\n   if(window.rPlayer!=null)\r\n{\r\nif(volumlen <= 0 )\r\nvolumlen = 0;\r\nelse\r\nvolumlen -= 10;\r\nrPlayer.SetVolume(volumlen);\r\n}}\r\n  \r\n//-------------------------\r\n\r\nfunction ballmoviee()\r\n{//ƶ\r\nmovieelen = movie.style.pixelWidth-20;\r\naa = rPlayer.GetPosition();\r\ndd = rPlayer.Getlength();\r\nif (rPlayer.FILENAME!="" && isFinite(Math.round(aa/dd*movieelen)))\r\n{\r\n  mblock.style.left = Math.round(aa/dd*movieelen);\r\n}\r\nballtime = setTimeout(''ballmoviee();'',1000);\r\n}\r\n\r\nfunction SetPosition(Pos)\r\n{\r\neval(Real+''SetPosition(Pos)'');\r\n}\r\nfunction SetVolume(Pos)\r\n{\r\neval(Real+''Volume=Pos'');\r\n}\r\nfunction SetFastForward()\r\n{\r\nif (rPlayer.CanScan)\r\neval(Real+''FastForward()'');\r\n}\r\nfunction SetFastReverse()\r\n{\r\nif (rPlayer.CanScan)\r\neval(Real+''FastReverse()'');\r\n}\r\nfunction GetLength()\r\n{\r\nreturn eval(Real+''GetLength()'');\r\n}\r\nfunction GetPosition()\r\n{\r\ntt=eval(Real+''GetPosition()'');\r\nreturn tt*1000;\r\n}\r\nfunction SetMute(Status)\r\n{\r\nif (Status)\r\n{\r\neval(Real+''Mute=true'');\r\n}\r\nelse\r\neval(Real+''Mute=false'');\r\neval(Real+''Play()'');\r\n}\r\nfunction FastpositionSet() {\r\n  if(window.rPlayer!=null)\r\n  {\r\n var iLength=rPlayer.GetLength();\r\n var iPosition=rPlayer.GetPosition();\r\n var FastPosition=iLength/20;\r\n if ((iPosition+FastPosition)<=iLength) \r\n {\r\n   iPosition=iPosition+FastPosition;\r\n   rPlayer.SetPosition(iPosition);\r\n }\r\n  }  \r\n  }  \r\nfunction BackpositionSet() {\r\nif(window.rPlayer!=null)\r\n  {\r\n var iLength=rPlayer.GetLength();\r\n var iPosition=rPlayer.GetPosition();\r\n var BackPosition=iLength/20;\r\n if (iPosition>=BackPosition) \r\n {\r\n   iPosition=iPosition-BackPosition;\r\n   rPlayer.SetPosition(iPosition);\r\n }\r\n  }\r\n}\r\nfunction ClickSound(aa)\r\n{\r\nif (Mute)\r\n{\r\nMute=false;\r\nSetMute(Mute);\r\naa.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_08_over.gif'';\r\n}\r\nelse\r\n{\r\nMute=true;\r\nSetMute(Mute);\r\naa.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_08_down.gif'';\r\n}\r\n}\r\n\r\n\r\n//------------------------\r\n\r\nvar PauseStatus = 0;\r\nvar Fill = false;\r\nvar Playing=true;\r\nfunction Playorpasue()\r\n{\r\nif (Playing)\r\n{\r\npause();\r\n}\r\nelse\r\n{\r\nplay();\r\n}\r\n}\r\n\r\nfunction Stop() {\r\n\r\n{\r\nrPlayer.DoStop();\r\nif (Playing)\r\n{\r\nPlaying = false;\r\npp001.src = "{$PHPCMS[siteurl]}images/mediaplayer/toole_03.gif";\r\npp001.onmouseover=new Function("this.src = ''{$PHPCMS[siteurl]}images/mediaplayer/toole_03_over.gif''");\r\npp001.onmouseout=new Function("this.src = ''{$PHPCMS[siteurl]}images/mediaplayer/toole_03.gif''");\r\n}\r\nif (PauseStatus==0)\r\n{\r\nPauseStatus = 1;\r\n}\r\nmblock.style.left=0;\r\n\r\n}\r\n}\r\n\r\nfunction pause(){\r\npp001.src = "{$PHPCMS[siteurl]}images/mediaplayer/toole_03.gif";\r\npp001.onmouseover=new Function("this.src = ''{$PHPCMS[siteurl]}images/mediaplayer/toole_03_over.gif''");\r\npp001.onmouseout=new Function("this.src = ''{$PHPCMS[siteurl]}images/mediaplayer/toole_03.gif''");\r\nPlaying = false;\r\n\r\n{\r\n   \r\n{\r\nif (PauseStatus==0)\r\n{\r\nPauseStatus = 1;\r\n}\r\n rPlayer.DoPause();\r\n}\r\n}\r\n}\r\nfunction play(){\r\npp001.src = "{$PHPCMS[siteurl]}images/mediaplayer/toole_04.gif";\r\npp001.onmouseover=new Function("this.src = ''{$PHPCMS[siteurl]}images/mediaplayer/toole_04_over.gif''");\r\npp001.onmouseout=new Function("this.src = ''{$PHPCMS[siteurl]}images/mediaplayer/toole_04.gif''");\r\nPlaying = true;\r\n\r\n{\r\nif (PauseStatus==1)\r\n{\r\nPauseStatus = 0;\r\n}\r\n rPlayer.DoPlay();\r\n}\r\n}\r\n\r\n//-----------------\r\n\r\nfunction DoFill()\r\n{///ԭ\r\nif (Fill) \r\n{//ԭ\r\nwindow.movieeTo((screen.width-b_width)/2,(screen.height-b_height)/2);\r\nwindow.resizeTo(b_width+width_add,b_height+height_add);\r\nfill001.src = "{$PHPCMS[siteurl]}images/mediaplayer/Header_06.gif";\r\nFill = false;\r\nfill001.alt = "";\r\n}\r\nelse \r\n{//󻯴\r\nwindow.movieeTo(0,0);\r\nb_width = document.body.clientWidth;\r\nb_height = document.body.clientHeight;\r\nwindow.resizeTo(screen.width,screen.height);\r\nfill001.src = "{$PHPCMS[siteurl]}images/mediaplayer/Header_08.gif";\r\nFill = true;\r\nfill001.alt = "ԭ";\r\n}\r\n}\r\n\r\nfunction closewin()\r\n{//رմ\r\n  \r\nrPlayer.DoStop();\r\n  window.close();\r\n}\r\n\r\nfunction DoFull()\r\n{//ȫ\r\neval(Real+''SetFullScreen()'');\r\n}\r\n\r\nfunction DoMin() \r\n{//С\r\noldwidth=window.screenLeft;\r\noldheight=window.screenTop;\r\nwindow.movieeTo(-2000,-2000);\r\nwindow.attachEvent("onfocus",res);\r\n}\r\nfunction res() {\r\nwindow.movieeTo(oldwidth,oldheight);\r\nwindow.detachEvent("onfocus",res)\r\n}\r\n</Script>\r\n\r\n<script language="VBScript">\r\n\r\nsub Mute\r\n   imagesrc=document.all("silent").src\r\n   singlechar=mid(imagesrc,instr(imagesrc,".gif")-1,1)\r\n   if singlechar="8" then\r\n   document.all("silent").src="{$PHPCMS[siteurl]}images/mediaplayer/toole_08_down.gif"\r\n   document.all("silent").alt="ָ"\r\n   else\r\n   document.all("silent").src="{$PHPCMS[siteurl]}images/mediaplayer/toole_08.gif"\r\n   document.all("silent").alt=""\r\n   end if\r\n   rPlayer.setMute(not rPlayer.GetMute())\r\nend sub\r\n</script>\r\n\r\n<script for="window" event="onresize" LANGUAGE="JavaScript">\r\n//ı䴰ڴС\r\nif (toole.style.display==''block'' && ((document.body.clientWidth<440) || (document.body.clientHeight<300+hand_add)))\r\n{\r\n   window.resizeTo(440+width_add,428+height_add+hand_add);\r\n}\r\nif (toole.style.display==''none'' && ((document.body.clientWidth<262) || (document.body.clientHeight<252+hand_add)))\r\n{\r\n   window.resizeTo(262+width_add,252+height_add+hand_add);\r\n}\r\n//Image1.style.height = MP1.style.pixelHeight-24;\r\n</script>\r\n<SCRIPT FOR="rPlayer" EVENT="PlayStateChange(lOldState, lNewState)" LANGUAGE="JavaScript">\r\nif (lNewState==0 || lNewState==8){\r\nPlayorpasue();\r\n}\r\n</SCRIPT>\r\n\r\n<SCRIPT FOR="rPlayer" EVENT="OpenStateChange(lOldState, lNewState)" LANGUAGE="JavaScript">\r\nif (lNewState==0){\r\nPlayorpasue();\r\n}\r\n</SCRIPT>\r\n\r\n<SCRIPT FOR="rPlayer" EVENT="Error()" LANGUAGE="JavaScript">\r\nif (rPlayer.ErrorCode==-1072889837)\r\nPlay_Mess.innerHTML="<font color=red size=3>޷ӵ⣬ԡ</font>";\r\nif (rPlayer.ErrorCode==-2147220992)\r\nPlay_Mess.innerHTML="<font color=red size=3>ûʵĽԻװµ΢</font>";\r\nif (rPlayer.ErrorCode==-2147220945)\r\nPlay_Mess.innerHTML="<font color=red size=3>ļʽ֪ͨǣǽάޡ</font>";\r\nif (rPlayer.ErrorCode==-1072889830)\r\nPlay_Mess.innerHTML="<font color=red size=3>ļ򲻿֪ͨǣǽάޡ</font>";\r\nif (rPlayer.ErrorCode==-2146697211)\r\nPlay_Mess.innerHTML="<font color=red size=3>޷Ǵá</font>";\r\nif (rPlayer.ErrorCode==-1072887822)\r\nPlay_Mess.innerHTML="<font color=red size=3>޷ӵһ㲥Ƶ</font>";\r\n</SCRIPT>\r\n\r\n<SCRIPT FOR="rPlayer" EVENT="Warning(lType, lParam, sDescription)" LANGUAGE="JScript">\r\nPlay_Mess.innerHTML="<font color=red size=3>"+sDescription+"</font>";\r\n</SCRIPT>\r\n\r\n<SCRIPT LANGUAGE="VBScript">\r\nSub rplayer_OnBuffering(lFlags,lPercentage)\r\n  if (lPercentage=100) then\r\n  StartPlay=false\r\n  if (FirstPlay) then\r\n///Image1.style.visibility = "visible"\r\n  else\r\nMP1.style.visibility = "visible"\r\n//Image1.style.visibility = "hidden"\r\n  end if\r\n  exit sub\r\n  end if\r\nEnd Sub\r\nSub rplayer_OnErrorMessage(uSeverity, uRMACode, uUserCode, pUserString, pMoreInfoURL, pErrorString)\r\nselect case rPlayer.GetLastErrorRMACode()\r\ncase -2147221496\r\n  window.alert("緱æʱжϣ")\r\ncase -2147221433,-2147221428,-2147221417,-2147217468\r\n  window.alert("緱æʱжϣ")\r\ncase else\r\n  window.alert("û࣬ƣ߻Ժۿ")\r\nend select\r\nend sub\r\n</SCRIPT>\r\n\r\n<script language="JavaScript">\r\nvar dragapproved=false;\r\nvar eventsource,x,y;\r\nfunction moviee()\r\n{//ƶ\r\n  if (event.button==1&&dragapproved) //ı䱻϶Ԫҳϵλ\r\n  {\r\ntop.window.movieeBy(event.clientX-x, event.clientY-y);\r\nreturn false;\r\n  }\r\n}\r\nfunction size()\r\n{//ı䴰ڴС\r\n  if (event.button==1&&dragapproved) \r\n  {\r\ntop.window.resizeTo(event.clientX+5+width_add-jjjj, event.clientY+5+height_add-jjjj);\r\nreturn false;\r\n  }\r\n}\r\nfunction drags()\r\n{\r\n  if (event.srcElement.className=="drag") //׽ͱ϶Ԫصĵǰλ\r\n  {\r\ndragapproved=true;\r\nx=event.clientX;\r\ny=event.clientY;\r\ndocument.onmousemoviee=moviee;\r\n  }\r\n  if (event.srcElement.className=="rs001") //׽ͱ϶Ԫصĵǰλ\r\n  {\r\ndragapproved=true;\r\ndocument.onmousemoviee=size;\r\n  }\r\n}\r\n\r\ndocument.onmousedown=drags;   //ʱ,׼϶\r\ndocument.onmouseup=new Function("dragapproved=false");//ſʱ,϶ֹͣ\r\n\r\nfunction mini(type)\r\n{//л\r\n  if (type==1)\r\n  {\r\ntoole.style.display=''none'';\r\nscroll01.style.display=''none'';\r\nminitoole.style.display=''block'';\r\nwindow.resizeTo(333+width_add,305+height_add+hand_add);\r\n  }\r\n  if (type==0)\r\n  {\r\ntoole.style.display=''block'';\r\nscroll01.style.display=''block'';\r\nminitoole.style.display=''none'';\r\nwindow.resizeTo((440+width_add),428+height_add+hand_add);\r\n  }\r\n}\r\n\r\n//-----------------\r\n\r\n//ʾӰƬʱ\r\nfunction scrollPositionMousemoviee(obj, event)\r\n{\r\n  iCurrentX=event.x;\r\n  if(parseInt(iCurrentX)>=movieelen+20)\r\nreturn;\r\n  if(window.MP1!=null)\r\n  {\r\niTotalTime=GetLength();\r\niPlayTime=parseInt(iCurrentX*iTotalTime/(movieelen+20));\r\nHour=parseInt(iPlayTime/(60*60*1000));\r\nMin=parseInt((iPlayTime-Hour*60*60*1000)/(60*1000));\r\nSec=parseInt((iPlayTime-Hour*60*60*1000-Min*60*1000)/1000);\r\nif(String(Hour).length<2)\r\n  strHour="0"+String(Hour);\r\nelse\r\n  strHour=String(Hour);\r\nif(String(Min).length<2)\r\n  strMin="0"+String(Min);\r\nelse\r\n  strMin=String(Min);\r\nif(String(Sec).length<2)\r\n  strSec="0"+String(Sec);\r\nelse\r\n  strSec=+String(Sec);\r\n \r\nif(Hour!=0)\r\nscrollInfo.replaceAdjacentText("afterBegin",strHour+":"+strMin+":"+strSec);\r\nelse\r\nscrollInfo.replaceAdjacentText("afterBegin",strMin+":"+strSec);\r\n\r\nscrollInfo.style.top=event.y+12;\r\nscrollInfo.style.left=event.x+15;\r\nscrollInfo.style.visibility = "visible";\r\n  }\r\n}\r\nfunction scrollPositionMouseOut()\r\n{\r\n  scrollInfo.style.visibility = "hidden";\r\n}\r\n\r\n//---------------------\r\n\r\nfunction onLond001()\r\n{\r\n  setvol();\r\n  ballmoviee();\r\n}\r\n\r\n</script>\r\n  \r\n</head>\r\n<body bgcolor="#000000" scroll="no" leftmargin="0" topmargin="0" onLoad="onLond001();" onkeydown="no_newwin()">\r\n<center>\r\n<TABLE width="100%" height="100%" BORDER="0" CELLPADDING="0" CELLSPACING="0">\r\n<TR>\r\n<TD colspan="3">\r\n<table id="mini_head" border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse; display: block;" bordercolor="#111111" width="100%">\r\n<tr>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/mini_Header_02.gif">\r\n<img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/mini_Header_01.gif" width="4" height="6"></td>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/mini_Header_02.gif" align="right">\r\n<img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/mini_Header_03.gif" width="3" height="6"></td>\r\n</tr>\r\n</table>\r\n<table id="head" border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse; display: none;" bordercolor="#111111" width="100%">\r\n<tr>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/Header_02.gif">\r\n<img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/Header_01.gif" width="135" height="20" onmouseover="this.style.cursor=''moviee''" id="mydiv1" class="drag" alt="ƶ"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/Header_03.gif" width="2" height="20"></td>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/Header_02.gif"></td>\r\n<td align="right" background="{$PHPCMS[siteurl]}images/mediaplayer/Header_02.gif">\r\n<img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/Header_07.gif" align="absmiddle" width="9" height="9" alt="С" onmousedown="DoMin()" onmouseover="this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="8" height="1"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/Header_06.gif" align="absmiddle" width="9" height="9" id="fill001" ALT="" onmousedown="DoFill()" onmouseover="this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="10" height="1"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/Header_05.gif" align="absmiddle" width="9" height="9" ALT="رմ" onmousedown="closewin()" onmouseover="this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="3" height="1"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/Header_04.gif" align="absmiddle" width="5" height="20" onmouseover="this.style.cursor=''hand''"></td>\r\n</tr>\r\n</table>\r\n<Script language="JavaScript">\r\nif (!ie6)\r\n{\r\nmini_head.style.display = "none";\r\nhead.style.display = "block";\r\n}\r\n</Script>\r\n</TD>\r\n</TR>\r\n<TR>\r\n<TD background="{$PHPCMS[siteurl]}images/mediaplayer/player_01.gif"><IMG SRC="images/Spacer.gif" WIDTH="7" HEIGHT="1" id="left002"></TD>\r\n<TD><IMG SRC="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" WIDTH="200" HEIGHT="1" id="temp002"></TD>\r\n<TD background="{$PHPCMS[siteurl]}images/mediaplayer/player_02.gif" style="background-position:right;"><IMG SRC="images/Spacer.gif" WIDTH="6" HEIGHT="1" id="right002"></TD>\r\n</TR>\r\n<TR>\r\n<TD background="{$PHPCMS[siteurl]}images/mediaplayer/player_01.gif" width="7" HEIGHT="99%" id="left001"></TD>\r\n<TD width="99%">\r\n<DIV id="MP1" style="HEIGHT: 100%; POSITION: relative; TOP: 0px; WIDTH: 100%; Z-INDEX: 1;">\r\n<object ID="rPlayer" CLASSID="clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA" HEIGHT="100%" WIDTH="100%">\r\n  <param name="_ExtentX" value="20055">\r\n  <param name="_ExtentY" value="7064">\r\n  <param name="AUTOSTART" value="-1">\r\n  <param name="SHUFFLE" value="0">\r\n  <param name="PREFETCH" value="0">\r\n  <param name="NOLABELS" value="0">\r\n  <param name="SRC" value="{$filepath}">\r\n  <param name="CONTROLS" value="ImageWindow">\r\n  <param name="CONSOLE" value="Clip1">\r\n  <param name="LOOP" value="0">\r\n  <param name="NUMLOOP" value="0">\r\n  <param name="CENTER" value="0">\r\n  <param name="MAINTAINASPECT" value="0">\r\n  <param name="BACKGROUNDCOLOR" value="#000000">\r\n  </object>\r\n</DIV>\r\n<script language="javascript"> \r\nrPlayer.SetEnableContextMenu(false);\r\nrPlayer.SetWantErrors(true);\r\n</script>\r\n</TD>\r\n<TD background="{$PHPCMS[siteurl]}images/mediaplayer/player_02.gif" style="background-position:right;" width="6" HEIGHT="99%" id="right001"></TD>\r\n</TR>\r\n<tr>\r\n<td colspan="3">\r\n<table id="scroll01" border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="100%">\r\n<tr>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/scroll_02.gif" width="3%">\r\n<img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/scroll_01.gif" width="3" height="15"></td>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/scroll_02.gif" width="2%" align="right">\r\n<img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/scroll_03.gif" width="2" height="15"></td>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/scroll_04.gif" width="70%">\r\n<DIV onmouseup="Total_Up()" onmousemoviee="scrollPositionMousemoviee(this, event)" onmouseout="scrollPositionMouseOut()" onmousedown="ChangePos()" id="movie" style="CURSOR: hand; POSITION: relative; TOP: 1px; LEFT: 0px; WIDTH: 100%; HEIGHT: 8px"><DIV id="mblock" style="LEFT: 0px; POSITION: absolute; TOP: 0px; HEIGHT: 8px"><IMG alt="Ž" src="{$PHPCMS[siteurl]}images/mediaplayer/scroll_07.gif" width="20" height="8" border="0"></DIV>\r\n<DIV id="scrollInfo" style="BORDER: orange 1px ridge; FONT-SIZE: 9px; VISIBILITY: hidden; BACKGROUND: #c0c0c0; POSITION: absolute; zIndex: 9">00:00</DIV>\r\n</DIV>\r\n</td>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/scroll_02.gif" width="10%">\r\n<img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/scroll_05.gif" width="2" height="15"></td>\r\n<td align="center" background="{$PHPCMS[siteurl]}images/mediaplayer/scroll_02.gif" width="9%">\r\n<img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/scroll_08.gif" width="2" height="14"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="1" height="1"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/scroll_09.gif" width="7" height="15" alt="" onmousedown="rPlayer.Balance=-10000" onmouseover="this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="1" height="1"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/scroll_08.gif" width="2" height="14"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="1" height="1"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/scroll_10.gif" width="7" height="15" alt="" onmousedown="rPlayer.Balance=0" onmouseover="this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="1" height="1"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/scroll_08.gif" width="2" height="14"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="1" height="1"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/scroll_11.gif" width="7" height="15" alt="" onmousedown="rPlayer.Balance=10000" onmouseover="this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="1" height="1"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/scroll_08.gif" width="2" height="14"></td>\r\n<td align="right" background="{$PHPCMS[siteurl]}images/mediaplayer/scroll_02.gif" width="6%">\r\n<img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/scroll_06.gif" width="4" height="15"></td>\r\n</tr>\r\n</table>\r\n<table id="toole" border="0" cellpadding="0" cellspacing="0" style="display:block; border-collapse: collapse" bordercolor="#111111" width="100%" background="{$PHPCMS[siteurl]}images/mediaplayer/toole_02.gif">\r\n<tr>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/toole_02.gif">\r\n<img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/toole_01.gif" width="4" height="49"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="10" height="1"><img id="pp001" border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/toole_04.gif" width="36" height="49" ALT="" onmousedown="Playorpasue()" onmouseout="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_04.gif''" onmouseover="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_04_over.gif'';this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/toole_05.gif" width="25" height="49" ALT="ֹͣ" onmousedown="Stop()" onmouseout="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_05.gif''" onmouseover="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_05_over.gif'';this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="10" height="1"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/toole_06.gif" width="25" height="49" ALT="" onmousedown="BackpositionSet()" onmouseout="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_06.gif''" onmouseover="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_06_over.gif'';this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/toole_07.gif" width="25" height="49" ALT="" onmousedown="FastpositionSet()" onmouseout="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_07.gif''" onmouseover="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_07_over.gif'';this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="6" height="1"></td>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/toole_02.gif" align="right">\r\n<img src="{$PHPCMS[siteurl]}images/mediaplayer/toole_08.gif" style="cursor:hand;" alt="" name="silent" width="26" height="49" onclick="vbscript:Mute" border="0"></td>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/toole_02.gif" style="background-repeat: no-repeat;">\r\n<DIV onmouseup="Total_Up()" onmousemoviee="volgo()" id="volume" style="LEFT: 0px; WIDTH: 70px; POSITION: relative;HEIGHT: 23px" valgin="top" align="center"><DIV id="vblock"><IMG src="{$PHPCMS[siteurl]}images/mediaplayer/toole_16.gif" width="25" height="49" border="0" ALT="С" onmousedown="RealdecreseVolume()" onmouseout="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_16.gif''" onmouseover="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_16_over.gif'';this.style.cursor=''hand''"><IMG src="{$PHPCMS[siteurl]}images/mediaplayer/toole_17.gif" width="25" height="49" border="0" ALT="ǿ" onmousedown="RealincreaseVolume()" onmouseout="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_17.gif''" onmouseover="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_17_over.gif'';this.style.cursor=''hand''"></DIV>\r\n</DIV>\r\n</td>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/toole_12.gif" style="background-repeat: no-repeat;">\r\n<MARQUEE id="Play_Mess" WIDTH="100" SCROLLAMOUNT="8" SCROLLDELAY="200" style="margin-left: 8; margin-right: 10;"><FONT color=#284717 size=2>{$PHPCMS[sitename]}ӭۿ</FONT></MARQUEE>\r\n</td>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/toole_02.gif">\r\n<img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="6" height="1"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/toole_09.gif" width="25" height="49" alt="ȫ" onmousedown="DoFull()" onmouseout="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_09.gif''" onmouseover="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_09_over.gif'';this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/toole_10.gif" width="25" height="49" alt="ģʽ" onclick="mini(1);" onmouseout="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_10.gif''" onmouseover="this.src=''{$PHPCMS[siteurl]}images/mediaplayer/toole_10_over.gif'';this.style.cursor=''hand''"></td>\r\n<td background="{$PHPCMS[siteurl]}images/mediaplayer/toole_02.gif" align="right">\r\n<img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/toole_13.gif" width="13" height="17" onmouseover="this.style.cursor=''se-resize''" id="mydiv100" class="rs001" alt="ı䴰ڴС"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/toole_14.gif" width="4" height="49"></td>\r\n</tr>\r\n</table>\r\n<table id="minitoole" border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse; display:none;" bordercolor="#111111" width="100%">\r\n<tr>\r\n<td width="33%" background="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_02.gif">\r\n<img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_01.gif" width="3" height="20"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/1pix.gif" width="10" height="1"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_03.gif" width="6" height="20"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_03.gif" width="6" height="20"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_04.gif" width="18" height="20" ALT="" onmousedown="play()" onmouseover="this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_03.gif" width="6" height="20"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_05.gif" width="18" height="20" ALT="ͣ" onmousedown="pause()" onmouseover="this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_03.gif" width="6" height="20"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_06.gif" width="18" height="20" ALT="ֹͣ" onmousedown="Stop()" onmouseover="this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_03.gif" width="6" height="20"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_03.gif" width="6" height="20"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_07.gif" width="18" height="20" ALT="" onmousedown="BackpositionSet()" onmouseover="this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_03.gif" width="6" height="20"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_08.gif" width="18" height="20" ALT="" onmousedown="FastpositionSet()" onmouseover="this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_03.gif" width="6" height="20"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_03.gif" width="6" height="20"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_09.gif" width="33" height="20" alt="ȫ" onmousedown="DoFull()" onmouseover="this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_03.gif" width="6" height="20"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_10.gif" width="33" height="20" alt="ģʽ" onclick="mini(0);" onmouseover="this.style.cursor=''hand''"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_03.gif" width="6" height="20"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_03.gif" width="6" height="20"></td>\r\n<td width="33%" background="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_02.gif">\r\n</td>\r\n<td width="34%" background="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_02.gif" align="right">\r\n<img class="rs001" border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_12.gif" width="8" height="11" onmouseover="this.style.cursor=''se-resize''" alt="ı䴰ڴС"><img border="0" src="{$PHPCMS[siteurl]}images/mediaplayer/miniToole_11.gif" width="3" height="20"></td>\r\n</tr>\r\n</table>\r\n</td>\r\n</tr>\r\n</TABLE>\r\n', 0),
(4, 'Flv', '<object type="application/x-shockwave-flash" data="{$PHPCMS[siteurl]}images/flvplayer.swf" width="100%" height="100%">\r\n  <param name="movie" value="{$PHPCMS[siteurl]}images/flvplayer.swf?autostart=true&file={$filepath}">\r\n</object>', 0),
(5, 'flash ', '<object width="100%" height="100%"><param name="movie" value="{$filepath}"></param><param name="allowscriptaccess" value="always"><embed src="{$filepath}" type="application/x-shockwave-flash" width="100%" height="100%"></embed></object>\r\n', 0);

DROP TABLE IF EXISTS `phpcms_log`;
CREATE TABLE `phpcms_log` (
  `logid` int(10) unsigned NOT NULL auto_increment,
  `field` varchar(15) NOT NULL,
  `value` int(10) unsigned NOT NULL default '0',
  `module` varchar(15) NOT NULL,
  `file` varchar(20) NOT NULL,
  `action` varchar(20) NOT NULL,
  `querystring` varchar(255) NOT NULL,
  `data` mediumtext NOT NULL,
  `userid` mediumint(8) unsigned NOT NULL default '0',
  `username` varchar(20) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `time` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`logid`),
  KEY `userid` (`userid`),
  KEY `module` (`module`,`file`,`action`),
  KEY `field` (`field`,`value`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_menu`;
CREATE TABLE `phpcms_menu` (
  `menuid` smallint(5) unsigned NOT NULL auto_increment,
  `parentid` smallint(5) unsigned NOT NULL default '0',
  `name` char(20) NOT NULL,
  `image` char(100) NOT NULL,
  `url` char(100) NOT NULL,
  `description` char(100) NOT NULL,
  `target` char(15) NOT NULL default 'right',
  `style` char(15) NOT NULL,
  `js` char(100) NOT NULL,
  `groupids` char(60) NOT NULL,
  `roleids` char(60) NOT NULL,
  `isfolder` tinyint(1) unsigned NOT NULL default '0',
  `isopen` tinyint(1) unsigned NOT NULL default '0',
  `listorder` smallint(5) unsigned NOT NULL default '0',
  `userid` mediumint(8) unsigned NOT NULL default '0',
  `keyid` char(30) NOT NULL,
  PRIMARY KEY  (`menuid`),
  KEY `userid` (`userid`),
  KEY `keyid` (`keyid`),
  KEY `parentid` (`parentid`,`listorder`,`menuid`)
) TYPE=MyISAM;

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (1, 0, '̨˵', '', '', '', '_self', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (20, 0, 'Ա', '', '', '', '_self', '', '', '', '', 1, 0, 0, 0, 'member_0');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (40, 0, 'ԱĿݲ˵', '', '', '', '_self', '', '', '', '', 1, 0, 0, 0, 'member_1');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (2, 1, 'ҵ', '', '', '', 'left', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (3, 1, 'ϵͳ', '', '', '', 'left', '', '', '', '1,2', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (4, 1, 'ݹ', '', '', '', 'left', '', '', '', '1,2,3', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (5, 1, 'ģ', '', '', '', 'left', '', '', '', '1,2,3,5', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (6, 1, 'Ա', '', '', '', 'left', '', '', '', '1,2,3', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (7, 1, 'ģ', '', '', '', 'left', '', '', '', '1,4', 1, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (61, 4, 'ȫ', '', '?mod=phpcms&file=content_all', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (62, 4, '', '', '?mod=phpcms&file=content_all&action=inspect', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (63, 4, 'ר', '', '?mod=special&file=special&action=list', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (64, 4, 'Ƭ', '', '?mod=phpcms&file=block&action=list', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (65, 4, 'Ƽλ', '', '?mod=phpcms&file=position&action=list', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (99, 2, 'ò', '', '', '', '_self', '', '', '', '', 1, 1, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (100, 2, 'Ϣ', '', '', '', '_self', '', '', '', '', 1, 1, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (101, 100, '޸', '', 'member/edit.php', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (102, 100, '޸', '', 'member/editpwd.php', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (103, 100, 'Ϣ', '', 'message/', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (110, 99, 'ӳò˵', '', '?mod=phpcms&file=menu&action=add&parentid=99&parentname=ò', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (111, 99, 'ò˵', '', '?mod=phpcms&file=menu&action=manage&parentid=99&parentname=ò', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (112, 99, '̨ҳ', '', '?mod=phpcms&file=index&action=main', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (113, 99, 'ҳ', '', '?mod=phpcms&file=html&action=index', '', 'right', '', '', '', '', 0, 0, 0, 1, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (114, 99, '»', '', '?mod=phpcms&file=cache', '', 'right', '', '', '', '', 0, 0, 0, 1, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (115, 99, 'Ŀ', '', '?mod=phpcms&file=category&action=add', '', 'right', '', '', '', '', 0, 0, 0, 1, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (116, 99, 'Ŀ', '', '?mod=phpcms&file=category&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 1, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (117, 99, 'Ա', '', '?mod=member&file=member&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 1, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (118, 99, 'ӹԱ', '', '?mod=phpcms&file=admin&action=add', '', 'right', '', '', '', '', 0, 0, 0, 1, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (600, 99, 'ӵ', '', '?mod=phpcms&file=area&action=add', '', 'right', '', '', '', '', 0, 0, 0, 1, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (601, 99, 'ģ', '', '?mod=phpcms&file=model&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 1, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (602, 99, 'ݿⱸ', '', '?mod=phpcms&file=database&action=export', '', 'right', '', '', '', '', 0, 0, 0, 1, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (603, 99, 'վ', '', '?mod=phpcms&file=setting&tab=0', '', 'right', '', '', '', '', 0, 0, 0, 1, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (120, 3, 'Ŀ', '', '', '', '_self', '', '', '', '1,2', 1, 1, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (121, 120, 'Ŀ', '', '?mod=phpcms&file=category&action=add', '', 'right', '', '', '', '1,2', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (122, 120, 'Ŀ', '', '?mod=phpcms&file=category&action=manage', '', 'right', '', '', '', '1,2', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (123, 120, 'ϲĿ', '', '?mod=phpcms&file=category&action=join', '', 'right', '', '', '', '1,2', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (124, 120, 'Ŀ', '', '?mod=phpcms&file=category&action=updatecache', '', 'right', '', '', '', '1,2', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (125, 120, '޸Ŀ', '', '?mod=phpcms&file=category&action=repair', '', 'right', '', '', '', '1,2', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (126, 120, 'Ŀ', '', '?mod=phpcms&file=category&action=more', '', 'right', '', '', '', '1,2', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (130, 3, 'ģ͹', '', '', '', '_self', '', '', '', '1', 1, 1, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (131, 130, 'ģ', '', '?mod=phpcms&file=model&action=add', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (132, 130, 'ģ', '', '?mod=phpcms&file=model&action=manage', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (133, 130, 'ģ', '', '?mod=phpcms&file=model&action=import', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (140, 3, 'ģ', '', '', '', '_self', '', '', '', '1', 1, 1, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (141, 140, 'װģ', '', '?mod=phpcms&file=module&action=install', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (142, 140, 'ģ', '', '?mod=phpcms&file=module&action=manage', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (143, 140, '½ģ', '', '?mod=phpcms&file=module&action=add', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (150, 3, 'Ա', '', '', '', '_self', '', '', '', '1', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (151, 150, 'ӹԱ', '', '?mod=phpcms&file=admin&action=add', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (152, 150, 'Աб', '', '?mod=phpcms&file=admin&action=manage', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (153, 150, 'ӽɫ', '', '?mod=phpcms&file=role&action=add', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (154, 150, 'ɫ', '', '?mod=phpcms&file=role&action=manage', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (160, 3, 'ݿ', '', '', '', '_self', '', '', '', '1', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (161, 160, 'ݿⱸ', '', '?mod=phpcms&file=database&action=export', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (162, 160, 'ݿָ', '', '?mod=phpcms&file=database&action=import', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (163, 160, 'ݿ޸', '', '?mod=phpcms&file=database&action=repair', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (164, 160, 'ַ滻', '', '?mod=phpcms&file=database&action=replace', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (165, 160, 'ִSQL', '', '?mod=phpcms&file=database&action=executesql', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (166, 160, 'ݿ', '', '?mod=phpcms&file=database&action=dbsolution', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (170, 3, '', '', '', '', '_self', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (171, 170, '', '', '', '', 'right', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (500, 171, '', '', '?mod=phpcms&file=type&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (501, 171, '', '', '?mod=phpcms&file=type&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (172, 170, '', '', '', '', 'right', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (505, 172, 'ӵ', '', '?mod=phpcms&file=area&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (506, 172, '', '', '?mod=phpcms&file=area&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (507, 172, 'µ', '', '?mod=phpcms&file=area&action=updatecache', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (508, 172, '޸', '', '?mod=phpcms&file=area&action=repair', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (173, 170, '˵', '', '', '', 'right', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (510, 173, 'Ӳ˵', '', '?mod=phpcms&file=menu&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (511, 173, '˵', '', '?mod=phpcms&file=menu', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (174, 170, 'Ƽλ', '', '', '', 'right', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (515, 174, 'Ƽλ', '', '?mod=phpcms&file=position&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (516, 174, 'Ƽλ', '', '?mod=phpcms&file=position&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (175, 170, 'ؼʹ', '', '', '', 'right', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (520, 175, 'ӹؼ', '', '?mod=phpcms&file=keyword&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (521, 175, 'ؼ', '', '?mod=phpcms&file=keyword&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (176, 170, '߹', '', '', '', 'right', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (525, 176, '', '', '?mod=phpcms&file=author&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (526, 176, '', '', '?mod=phpcms&file=author&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (177, 170, 'Դ', '', '', '', 'right', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (530, 177, 'Դ', '', '?mod=phpcms&file=copyfrom&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (531, 177, 'Դ', '', '?mod=phpcms&file=copyfrom&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (178, 170, 'ӹ', '', '', '', 'right', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (535, 178, 'ӹ', '', '?mod=phpcms&file=keylink&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (536, 178, '', '', '?mod=phpcms&file=keylink&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (180, 170, '', '', '', '', 'right', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (540, 180, 'ӹ', '', '?mod=phpcms&file=workflow&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (541, 180, '', '', '?mod=phpcms&file=workflow', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (181, 170, '״̬', '', '', '', 'right', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (545, 181, '״̬', '', '?mod=phpcms&file=status&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (546, 181, '״̬', '', '?mod=phpcms&file=status', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (200, 170, 'Դ', '', '', '', 'right', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (201, 200, 'Դ', '', '?mod=phpcms&file=datasource&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (202, 200, 'Դ', '', '?mod=phpcms&file=datasource&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (205, 170, 'URL', '', '', '', 'right', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (206, 205, 'URL', '', '?mod=phpcms&file=urlrule&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (207, 205, 'URL', '', '?mod=phpcms&file=urlrule&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (208, 170, '˵', '', '?mod=phpcms&file=linkage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (210, 3, 'ϵͳ', '', '', '', '_self', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (211, 210, 'ľɨ', '', '', '', '_self', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (212, 211, 'ɨľ', '', '?mod=phpcms&file=safe', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (213, 211, 'ļȫУ', '', '?mod=phpcms&file=filecheck', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (214, 211, 'ļУ龵', '', '?mod=phpcms&file=filecheck&action=make', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (215, 210, 'ⲿݵ', '', '', '', '_self', '', '', '', '', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (216, 215, 'ݵ', '', '?mod=phpcms&file=import&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (217, 215, 'Ѷݵ', '', '?mod=phpcms&file=import&action=manage&type=content', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (218, 215, 'Աݵ', '', '?mod=phpcms&file=import&action=manage&type=member', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (219, 210, '»', '', '?mod=phpcms&file=cache', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (220, 210, 'Baibu/Googleͼ', '', '?mod=phpcms&file=googlemap', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (221, 210, 'ϵͳл', '', '?mod=phpcms&file=system', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (222, 210, 'IP ֹ', '', '?mod=phpcms&file=ipbanned', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (223, 210, 'ǷϢ־', '', '?mod=phpcms&file=filterword', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (224, 210, '̨־', '', '?mod=phpcms&file=log', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (225, 210, 'php ־', '', '?mod=phpcms&file=errorlog', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (226, 210, 'ļ', '', '?mod=phpcms&file=filemanager', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (227, 210, 'վͼ', '', '?mod=phpcms&file=sitemap', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (230, 210, 'ֵ', '', '?mod=phpcms&file=datadict', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (231, 210, '', '', '?mod=phpcms&file=attachment&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (232, 210, '', '', '?mod=phpcms&file=player&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (233, 210, 'CNZZվͳ', '', '?mod=phpcms&file=wss', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (234, 210, 'CNZZͳ', '', '?mod=phpcms&file=wss&action=setting', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (235, 210, 'ͳ', '', '?mod=phpcms&file=statistics', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (236, 210, 'Ŀͳ', '', '?mod=phpcms&file=count', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (250, 3, 'վ', '', '', '', '_self', '', '', '', '1', 1, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (251, 250, 'Ϣ', '', '?mod=phpcms&file=setting&tab=0', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (252, 250, 'վ', '', '?mod=phpcms&file=setting&tab=1', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (253, 250, 'Ż', '', '?mod=phpcms&file=setting&tab=2', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (254, 250, 'ȫ', '', '?mod=phpcms&file=setting&tab=3', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (255, 250, '', '', '?mod=phpcms&file=setting&tab=4', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (256, 250, 'ʼ', '', '?mod=phpcms&file=setting&tab=5', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (257, 250, 'FTP', '', '?mod=phpcms&file=setting&tab=6', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (258, 250, '֤ͨ', '', '?mod=phpcms&file=setting&tab=7', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (259, 250, 'չ', '', '?mod=phpcms&file=setting&tab=8', '', 'right', '', '', '', '1', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (300, 4, 'ݷ', '', '', '', '_self', '', '', '', '', 1, 0, 0, 0, 'catid_0');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (310, 300, 'վ', '', '?mod=phpcms&file=content&action=manage&catid=1', '', 'right', '', '', '', '', 1, 0, 0, 0, 'catid_1');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (311, 310, '', '', '?mod=phpcms&file=content&action=manage&catid=2', '', 'right', '', '', '', '', 0, 0, 0, 0, 'catid_2');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (312, 310, 'ϵʽ', '', '?mod=phpcms&file=content&action=manage&catid=3', '', 'right', '', '', '', '', 0, 0, 0, 0, 'catid_3');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (313, 310, 'ƸϢ', '', '?mod=phpcms&file=content&action=manage&catid=4', '', 'right', '', '', '', '', 0, 0, 0, 0, 'catid_4');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (314, 310, 'Ȩ', '', '?mod=phpcms&file=content&action=manage&catid=5', '', 'right', '', '', '', '', 0, 0, 0, 0, 'catid_5');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (319, 4, 'HTML', '', '', '', '_self', '', '', '', '', 1, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (320, 319, 'ҳ', '', '?mod=phpcms&file=html&action=index', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (321, 319, 'Ŀҳ', '', '?mod=phpcms&file=html&action=category', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (323, 319, 'רҳ', '', '?mod=special&file=html', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (324, 319, 'ҳ', '', '?mod=phpcms&file=html&action=show', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (325, 319, 'URL', '', '?mod=phpcms&file=url', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (326, 319, 'ȫվ', '', '?mod=phpcms&file=category&action=update_search', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (350, 7, 'ģ巽', '', '?mod=phpcms&file=templateproject&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (351, 7, '񷽰', '', '?mod=phpcms&file=skin&action=manage', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (352, 7, 'Ƭ', '', '?mod=phpcms&file=block', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (353, 7, 'ģ建', '', '?mod=phpcms&file=template&action=cache', '', 'right', '', '', '', '', 0, 0, 0, 0, '');

INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (360, 7, 'Phpcms', '', '', '', '_self', '', '', '', '', 1, 1, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (361, 360, '½ģ', '', '?mod=phpcms&file=template&action=add', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (362, 360, 'ģ', '', '?mod=phpcms&file=template&action=manage&module=phpcms', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (363, 360, 'ݱǩ', '', '?mod=phpcms&file=tag&action=add&module=phpcms&type=content', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (364, 360, 'ݱǩ', '', '?mod=phpcms&file=tag&action=manage&module=phpcms&type=content', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (365, 360, 'Ŀǩ', '', '?mod=phpcms&file=tag&action=add&type=category', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
INSERT INTO `phpcms_menu` (`menuid`, `parentid`, `name`, `image`, `url`, `description`, `target`, `style`, `js`, `groupids`, `roleids`, `isfolder`, `isopen`, `listorder`, `userid`, `keyid`) VALUES (366, 360, 'Ŀǩ', '', '?mod=phpcms&file=tag&action=manage&type=category', '', 'right', '', '', '', '', 0, 0, 0, 0, '');
DROP TABLE IF EXISTS `phpcms_model`;
CREATE TABLE `phpcms_model` (
  `modelid` tinyint(3) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL,
  `description` varchar(255) NOT NULL,
  `tablename` varchar(20) NOT NULL,
  `itemname` varchar(10) NOT NULL,
  `itemunit` varchar(10) NOT NULL,
  `workflowid` tinyint(3) unsigned NOT NULL default '0',
  `template_category` varchar(30) NOT NULL,
  `template_list` varchar(30) NOT NULL,
  `template_show` varchar(30) NOT NULL,
  `template_print` varchar(30) NOT NULL,
  `ishtml` tinyint(1) unsigned NOT NULL default '0',
  `category_urlruleid` tinyint(1) unsigned NOT NULL default '0',
  `show_urlruleid` tinyint(1) unsigned NOT NULL default '0',
  `enablesearch` tinyint(1) unsigned NOT NULL default '1',
  `ischeck` tinyint(1) unsigned NOT NULL default '1',
  `isrelated` tinyint(1) unsigned NOT NULL default '1',
  `disabled` tinyint(1) unsigned NOT NULL default '0',
  `modeltype` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`modelid`)
) TYPE=MyISAM;

INSERT INTO `phpcms_model` (`modelid`, `name`, `description`, `tablename`, `itemname`, `itemunit`, `workflowid`, `template_category`, `template_list`, `template_show`, `template_print`, `ishtml`, `category_urlruleid`, `show_urlruleid`,`enablesearch`, `ischeck`, `disabled`, `modeltype`) VALUES (1, '', '', 'news', '', 'ƪ', 1, 'category', 'list', 'show', 'print', 1, 1, 7, 1, 1, 0, 0);
INSERT INTO `phpcms_model` (`modelid`, `name`, `description`, `tablename`, `itemname`, `itemunit`, `workflowid`, `template_category`, `template_list`, `template_show`, `template_print`, `ishtml`, `category_urlruleid`, `show_urlruleid`,`enablesearch`, `ischeck`, `disabled`, `modeltype`) VALUES (2, 'ͼƬ', '', 'picture', 'ͼƬ', '', 1, 'category_picture', 'list_picture', 'show_picture', 'print', 1, 1, 7, 1, 1, 0, 0);
INSERT INTO `phpcms_model` (`modelid`, `name`, `description`, `tablename`, `itemname`, `itemunit`, `workflowid`, `template_category`, `template_list`, `template_show`, `template_print`, `ishtml`, `category_urlruleid`, `show_urlruleid`,`enablesearch`, `ischeck`, `disabled`, `modeltype`) VALUES (3, '', '', 'down', '', '', 1, 'category_down', 'list_down', 'show_down', 'print', 1, 1, 7, 1, 1, 0, 0);
INSERT INTO `phpcms_model` (`modelid`, `name`, `description`, `tablename`, `itemname`, `itemunit`, `workflowid`, `template_category`, `template_list`, `template_show`, `template_print`, `ishtml`, `category_urlruleid`, `show_urlruleid`,`enablesearch`, `ischeck`, `disabled`, `modeltype`) VALUES (4, 'Ϣ', '', 'info', 'Ϣ', '', 1, 'category_info', 'list_info', 'show_info', 'print', 1, 1, 7, 1, 0, 0, 0);
INSERT INTO `phpcms_model` (`modelid`, `name`, `description`, `tablename`, `itemname`, `itemunit`, `workflowid`, `template_category`, `template_list`, `template_show`, `template_print`, `ishtml`, `category_urlruleid`, `show_urlruleid`,`enablesearch`, `ischeck`, `disabled`, `modeltype`) VALUES (5, 'Ʒ', '', 'product', 'Ʒ', '', 1, 'category_product', 'list_product', 'show_product', 'print', 1, 1, 7, 1, 1, 0, 0);
INSERT INTO `phpcms_model` (`modelid`, `name`, `description`, `tablename`, `itemname`, `itemunit`, `workflowid`, `template_category`, `template_list`, `template_show`, `template_print`, `ishtml`, `category_urlruleid`, `show_urlruleid`,`enablesearch`, `ischeck`, `disabled`, `modeltype`) VALUES (6, 'Ƶ', '', 'video', '', '', 1, 'category_video', 'list_video', 'show_video', 'print', 0, 4, 10, 1, 1, 0, 0);
INSERT INTO `phpcms_model` (`modelid`, `name`, `description`, `tablename`, `itemname`, `itemunit`, `workflowid`, `template_category`, `template_list`, `template_show`, `template_print`, `ishtml`, `category_urlruleid`, `show_urlruleid`,`enablesearch`, `ischeck`, `disabled`, `modeltype`) VALUES (10, 'ͨԱ', '', 'detail', '', '', 0, '', '', '', '', 0, 0, 0, 1, 0, 0, 2);

DROP TABLE IF EXISTS `phpcms_model_field`;
CREATE TABLE IF NOT EXISTS `phpcms_model_field` (
  `fieldid` mediumint(8) unsigned NOT NULL auto_increment,
  `modelid` tinyint(3) unsigned NOT NULL default '0',
  `field` varchar(20) NOT NULL,
  `name` varchar(30) NOT NULL,
  `tips` text NOT NULL,
  `css` varchar(30) NOT NULL,
  `minlength` int(10) unsigned NOT NULL default '0',
  `maxlength` int(10) unsigned NOT NULL default '0',
  `pattern` varchar(255) NOT NULL,
  `errortips` varchar(255) NOT NULL,
  `formtype` varchar(20) NOT NULL,
  `setting` mediumtext NOT NULL,
  `formattribute` varchar(255) NOT NULL,
  `unsetgroupids` varchar(255) NOT NULL,
  `unsetroleids` varchar(255) NOT NULL,
  `iscore` tinyint(1) unsigned NOT NULL default '0',
  `issystem` tinyint(1) unsigned NOT NULL default '0',
  `isunique` tinyint(1) unsigned NOT NULL default '0',
  `isbase` tinyint(1) unsigned NOT NULL default '1',
  `issearch` tinyint(1) unsigned NOT NULL default '0',
  `isselect` tinyint(1) unsigned NOT NULL default '0',
  `iswhere` tinyint(1) unsigned NOT NULL default '0',
  `isorder` tinyint(1) unsigned NOT NULL default '0',
  `islist` tinyint(1) unsigned NOT NULL default '0',
  `isshow` tinyint(1) unsigned NOT NULL default '0',
  `isadd` tinyint(1) unsigned NOT NULL default '1',
  `isfulltext` tinyint(1) unsigned NOT NULL default '1',
  `listorder` mediumint(8) unsigned NOT NULL default '0',
  `disabled` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`fieldid`),
  KEY `modelid` (`modelid`,`disabled`),
  KEY `field` (`field`,`modelid`)
) TYPE=MyISAM  AUTO_INCREMENT=509 ;

INSERT INTO `phpcms_model_field` (`fieldid`, `modelid`, `field`, `name`, `tips`, `css`, `minlength`, `maxlength`, `pattern`, `errortips`, `formtype`, `setting`, `formattribute`, `unsetgroupids`, `unsetroleids`, `iscore`, `issystem`, `isunique`, `isbase`, `issearch`, `isselect`, `iswhere`, `isorder`, `islist`, `isshow`, `isadd`, `isfulltext`, `listorder`, `disabled`) VALUES
(1, 1, 'contentid', 'ID', '', '', 0, 0, '', '', 'number', '', '', '', '', 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0),
(2, 1, 'catid', 'Ŀ', '', '', 1, 6, '/^[0-9]{1,6}$/', 'ѡĿ', 'catid', 'array (\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0),
(3, 1, 'typeid', '', '', '', 0, 0, '', '', 'typeid', 'array (\n  ''minnumber'' => '''',\n  ''maxnumber'' => '''',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 2, 1),
(4, 1, 'areaid', '', '', '', 0, 0, '', '', 'areaid', 'array (\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 3, 1),
(5, 1, 'title', '', '', 'inputtitle', 1, 80, '', '', 'title', 'array (\n  ''size'' => ''80'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 4, 0),
(6, 1, 'titleintact', '', '', '', 0, 200, '', '', 'text', 'array (\n  ''size'' => ''80'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 4, 0),
(7, 1, 'style', 'ɫ', '', '', 0, 0, '', '', 'style', '', '', '-99', '-99', 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 5, 0),
(8, 1, 'thumb', 'ͼ', '', '', 0, 100, '', '', 'image', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''upload_maxsize'' => ''1024'',\n  ''upload_allowext'' => ''jpg|jpeg|gif|png|bmp'',\n  ''isselectimage'' => ''1'',\n  ''isthumb'' => ''1'',\n  ''thumb_width'' => ''300'',\n  ''thumb_height'' => ''300'',\n  ''iswatermark'' => ''1'',\n  ''watermark_img'' => ''images/watermark.gif'',\n)', '', '', '', 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 6, 0),
(9, 1, 'keywords', 'ؼ', 'ؼ֮ÿո', '', 0, 40, '', '', 'keyword', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 7, 0),
(10, 1, 'author', '', '', '', 0, 30, '', '', 'author', 'array (\n  ''size'' => ''30'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 8, 0),
(11, 1, 'copyfrom', 'Դ', '', '', 0, 0, '', '', 'copyfrom', 'array (\n  ''size'' => ''30'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 9, 0),
(12, 1, 'description', 'ժҪ', '', '', 0, 255, '', '', 'textarea', 'array (\n  ''rows'' => ''4'',\n  ''cols'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''enablekeylink'' => ''0'',\n  ''replacenum'' => '''',\n  ''checkcharacter'' => ''1'',\n)', 'style="width:80%"', '-99', '-99', 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 10, 0),
(13, 1, 'userid', '', '', '', 0, 0, '', '', 'userid', '', '', '', '', 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 11, 0),
(14, 1, 'updatetime', 'ʱ', '', '', 0, 0, '', '', 'datetime', 'array (\r\n  ''dateformat'' => ''int'',\r\n  ''format'' => ''Y-m-d H:i:s'',\r\n  ''defaulttype'' => ''1'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 12, 0),
(15, 1, 'content', '', '<label><input name="add_introduce" type="checkbox"  value="1" checked>Ƿȡ</label><br><input type="text" name="introcude_length" value="200" size="3">ַժҪ\r\n<br/><br/>\r\n<label><input type=''checkbox'' name=''auto_thumb'' value="1" checked>Ƿȡݵ</label><br><input type="text" name="auto_thumb_no" value="1" size="2" class="">ͼƬΪͼƬ', '', 1, 999999, '', '', 'editor', 'array (\n  ''toolbar'' => ''standard'',\n  ''width'' => ''100%'',\n  ''height'' => ''350'',\n  ''defaultvalue'' => '''',\n  ''storage'' => ''database'',\n  ''enablekeylink'' => ''1'',\n  ''replacenum'' => ''2'',\n  ''enablesaveimage'' => ''1'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 13, 0),
(16, 1, 'islink', 'ת', '', '', 0, 0, '', '', 'islink', '', '', '-99', '-99', 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 14, 0),
(17, 1, 'inputtime', 'ʱ', '', '', 0, 0, '', '', 'datetime', 'array (\r\n  ''dateformat'' => ''int'',\r\n  ''format'' => ''Y-m-d H:i:s'',\r\n  ''defaulttype'' => ''1'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 15, 0),
(18, 1, 'posids', 'Ƽλ', 'ȫѡ<input boxid=''posids'' type=''checkbox'' onclick="checkall(''posids'')" >', '', 0, 0, '', '', 'posid', 'array (\n  ''cols'' => ''4'',\n  ''width'' => ''125'',\n)', '', '', '', 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 16, 0),
(19, 1, 'groupids_view', 'ĶȨ', 'ȫѡ<input boxid=''groupids_view'' type=''checkbox'' onclick="checkall(''groupids_view'')" >', '', 0, 0, '', '', 'groupid', 'array (\n  ''priv'' => ''view'',\n  ''cols'' => ''4'',\n  ''width'' => ''125'',\n)', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0),
(20, 1, 'readpoint', 'Ķ', '', '', 0, 5, '', '', 'number', 'array (\n  ''minnumber'' => ''1'',\n  ''maxnumber'' => ''99999'',\n  ''decimaldigits'' => ''0'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 18, 0),
(21, 1, 'prefix', 'htmlļ', '', '', 0, 20, '', '', 'text', 'array (\n  ''size'' => ''20'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 0),
(22, 1, 'url', 'URL', '', '', 0, 100, '', '', 'text', '', '', '', '', 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 96, 0),
(23, 1, 'listorder', '', '', '', 0, 6, '', '', 'number', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 97, 0),
(24, 1, 'status', '״̬', '', '', 0, 2, '', '', 'box', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 98, 0),
(25, 1, 'template', 'ҳģ', '', '', 0, 30, '', '', 'template', 'array (\n  ''size'' => '''',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 0),
(26, 1, 'pages', 'ҳʽ', '', '', 0, 0, '', '', 'pages', '', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 20, 0),
(50, 2, 'contentid', 'ID', '', '', 0, 0, '', '', 'number', '', '', '', '', 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0),
(51, 2, 'catid', 'Ŀ', '', '', 1, 6, '/^[0-9]{1,6}$/', 'ѡĿ', 'catid', 'array (\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0),
(52, 2, 'typeid', '', '', '', 0, 0, '', '', 'typeid', 'array (\n  ''minnumber'' => '''',\n  ''maxnumber'' => '''',\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 2, 0),
(53, 2, 'areaid', '', '', '', 0, 0, '', '', 'areaid', 'array (\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 3, 1),
(54, 2, 'title', '', '', 'inputtitle', 1, 80, '', '', 'title', 'array (\n  ''size'' => ''80'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 4, 0),
(55, 2, 'style', 'ɫ', '', '', 0, 0, '', '', 'style', '', '', '-99', '-99', 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 5, 0),
(56, 2, 'thumb', 'ͼ', '', '', 0, 100, '', '', 'image', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''upload_maxsize'' => ''1024'',\n  ''upload_allowext'' => ''jpg|jpeg|gif|png|bmp'',\n  ''isselectimage'' => ''1'',\n  ''isthumb'' => ''1'',\n  ''thumb_width'' => ''300'',\n  ''thumb_height'' => ''300'',\n  ''iswatermark'' => ''0'',\n  ''watermark_img'' => ''images/watermark.gif'',\n)', '', '', '', 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 6, 0),
(57, 2, 'keywords', 'ؼ', 'ؼ֮ÿո', '', 0, 40, '', '', 'keyword', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 7, 0),
(58, 2, 'author', '', '', '', 0, 30, '', '', 'author', 'array (\n  ''size'' => ''30'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 8, 0),
(59, 2, 'copyfrom', 'Դ', '', '', 0, 100, '', '', 'copyfrom', 'array (\n  ''size'' => ''30'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 9, 0),
(60, 2, 'description', 'ժҪ', '', '', 0, 255, '', '', 'textarea', 'array (\n  ''rows'' => ''6'',\n  ''cols'' => ''90'',\n  ''defaultvalue'' => '''',\n  ''enablekeylink'' => ''0'',\n  ''replacenum'' => '''',\n)', 'style="width:100%"', '-99', '-99', 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 10, 0),
(61, 2, 'userid', '', '', '', 0, 0, '', '', 'userid', '', '', '', '', 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 11, 0),
(62, 2, 'updatetime', 'ʱ', '', '', 0, 0, '', '', 'datetime', 'array (\r\n  ''dateformat'' => ''int'',\r\n  ''format'' => ''Y-m-d H:i:s'',\r\n  ''defaulttype'' => ''1'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 12, 0),
(63, 2, 'content', '', '', '', 1, 999999, '', '', 'editor', 'array (\n  ''toolbar'' => ''basic'',\n  ''width'' => ''90%'',\n  ''height'' => ''300'',\n  ''defaultvalue'' => '''',\n  ''storage'' => ''database'',\n  ''enablekeylink'' => ''0'',\n  ''replacenum'' => '''',\n  ''enablesaveimage'' => ''1'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 13, 1),
(64, 2, 'inputtime', 'ʱ', '', '', 0, 0, '', '', 'datetime', 'array (\r\n  ''dateformat'' => ''int'',\r\n  ''format'' => ''Y-m-d H:i:s'',\r\n  ''defaulttype'' => ''1'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 14, 0),
(65, 2, 'islink', 'ת', '', '', 0, 0, '', '', 'islink', '', '', '-99', '-99', 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 15, 0),
(66, 2, 'posids', 'Ƽλ', 'ȫѡ<input boxid=''posids'' type=''checkbox'' onclick="checkall(''posids'')" >', '', 0, 0, '', '', 'posid', 'array (\n  ''cols'' => ''4'',\n  ''width'' => ''125'',\n)', '', '', '', 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 16, 0),
(67, 2, 'pictureurls', 'ͼ', '', '', 0, 255, '', '', 'images', 'array (\n  ''upload_maxsize'' => ''1024'',\n  ''upload_allowext'' => ''gif|jpg|jpeg|png|bmp'',\n  ''isthumb'' => ''1'',\n  ''thumb_width'' => ''150'',\n  ''thumb_height'' => ''150'',\n  ''iswatermark'' => ''1'',\n  ''ishtml'' => ''1'',\n  ''watermark_img'' => ''images/watermark.gif'',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 17, 0),
(68, 2, 'prefix', 'htmlļ', '', '', 0, 20, '', '', 'text', 'array (\n  ''size'' => ''20'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 0),
(69, 2, 'url', 'URL', '', '', 0, 100, '', '', 'text', '', '', '', '', 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 96, 0),
(70, 2, 'listorder', '', '', '', 0, 6, '', '', 'number', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 97, 0),
(71, 2, 'status', '״̬', '', '', 0, 2, '', '', 'box', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 98, 0),
(72, 2, 'template', 'ҳģ', '', '', 0, 30, '', '', 'template', '', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 0),
(89, 3, 'contentid', 'ID', '', '', 0, 0, '', '', 'number', '', '', '', '', 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0),
(90, 3, 'catid', 'Ŀ', '', '', 1, 6, '/^[0-9]{1,6}$/', 'ѡĿ', 'catid', 'array (\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0),
(91, 3, 'typeid', '', '', '', 0, 0, '', '', 'typeid', 'array (\n  ''minnumber'' => '''',\n  ''maxnumber'' => '''',\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 2, 1),
(92, 3, 'areaid', '', '', '', 0, 0, '', '', 'areaid', 'array (\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 3, 1),
(93, 3, 'title', '', '', 'inputtitle', 1, 80, '', '', 'title', 'array (\n  ''size'' => ''80'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 4, 0),
(94, 3, 'style', 'ɫ', '', '', 0, 0, '', '', 'style', '', '', '-99', '-99', 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 5, 0),
(95, 3, 'thumb', 'ͼ', '', '', 0, 100, '', '', 'image', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''upload_maxsize'' => ''1024'',\n  ''upload_allowext'' => ''jpg|jpeg|gif|png|bmp'',\n  ''isselectimage'' => ''1'',\n  ''isthumb'' => ''1'',\n  ''thumb_width'' => ''300'',\n  ''thumb_height'' => ''300'',\n  ''iswatermark'' => ''1'',\n  ''watermark_img'' => ''images/watermark.gif'',\n)', '', '', '', 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 6, 0),
(96, 3, 'keywords', 'ؼ', 'ؼ֮ÿո', '', 0, 40, '', '', 'keyword', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 7, 0),
(97, 3, 'description', 'ժҪ', '', '', 0, 255, '', '', 'textarea', 'array (\n  ''rows'' => ''4'',\n  ''cols'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''enablehtml'' => ''0'',\n  ''enablekeylink'' => ''0'',\n  ''enablefilterword'' => ''0'',\n)', 'style="width:100%"', '', '', 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 8, 1),
(98, 3, 'userid', '', '', '', 0, 0, '', '', 'userid', '', '', '', '', 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 9, 0),
(99, 3, 'updatetime', 'ʱ', '', '', 0, 0, '', '', 'datetime', 'array (\r\n  ''dateformat'' => ''int'',\r\n  ''format'' => ''Y-m-d H:i:s'',\r\n  ''defaulttype'' => ''1'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 10, 0),
(100, 3, 'content', '', '', '', 1, 999999, '', '', 'editor', 'array (\n  ''toolbar'' => ''basic'',\n  ''width'' => ''100%'',\n  ''height'' => ''300'',\n  ''defaultvalue'' => '''',\n  ''storage'' => ''database'',\n  ''enablekeylink'' => ''0'',\n  ''replacenum'' => '''',\n  ''enablesaveimage'' => ''1'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 11, 0),
(101, 3, 'downurl', 'صַ', '', '', 4, 255, '', '', 'downfile', 'array (\n  ''mode'' => ''1'',\n  ''servers'' => ''|http://tel.xxx.com/\r\nͨ|http://cnc.xxx.com/'',\n  ''size'' => ''60'',\n  ''downloadtype'' => ''1'',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 20, 1),
(102, 3, 'downurls', 'б', '|صַ', '', 6, 0, '', '', 'downfiles', 'array (\n  ''size'' => ''30'',\n  ''downloadtype'' => ''1'',\n)', 'style="width:100%"', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 20, 0),
(103, 3, 'filesize', 'ļС', '', '', 0, 20, '', '', 'text', 'array (\n  ''size'' => ''10'',\n  ''defaultvalue'' => ''δ֪'',\n  ''ispassword'' => ''0'',\n)', 'onfocus="if(this.value==''δ֪'') this.value='''';" onblur="if(this.value=='''') this.value=''δ֪'';"', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 21, 0),
(104, 3, 'version', '汾', '', '', 0, 20, '', '', 'text', 'array (\n  ''size'' => ''10'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 22, 0),
(105, 3, 'classtype', '', '', '', 0, 20, '', '', 'box', 'array (\n  ''options'' => ''|\r\n|\r\n|\r\nԴ|Դ\r\n|'',\n  ''boxtype'' => ''select'',\n  ''fieldtype'' => ''CHAR'',\n  ''cols'' => ''5'',\n  ''width'' => ''80'',\n  ''size'' => ''1'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 23, 0),
(106, 3, 'language', '', '', '', 0, 20, '', '', 'box', 'array (\n  ''options'' => ''Ӣ|Ӣ\r\n|\r\n|\r\n|\r\n|\r\n|'',\n  ''boxtype'' => ''select'',\n  ''fieldtype'' => ''CHAR'',\n  ''cols'' => ''5'',\n  ''width'' => ''80'',\n  ''size'' => ''1'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 24, 0),
(107, 3, 'copytype', 'Ȩʽ', '', '', 0, 15, '', '', 'box', 'array (\n  ''options'' => ''Ѱ|Ѱ\r\n|\r\nð|ð\r\nʾ|ʾ\r\nע|ע\r\nƽ|ƽ\r\n۰|۰\r\nOEM|OEM'',\n  ''boxtype'' => ''select'',\n  ''fieldtype'' => ''CHAR'',\n  ''cols'' => ''5'',\n  ''width'' => ''80'',\n  ''size'' => ''1'',\n  ''defaultvalue'' => ''Ѱ'',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 25, 0),
(108, 3, 'systems', 'ƽ̨', '<select name=''selectSystem'' onchange="ChangeInput(this,document.myform.systems,''/'')">\r\n	<option value=''WinXP''>WinXP</option>\r\n	<option value=''Vista''>Vista</option>\r\n	<option value=''Win2000''>Win2000</option>\r\n	<option value=''Win2003''>Win2003</option>\r\n	<option value=''Unix''>Unix</option>\r\n	<option value=''Linux''>Linux</option>\r\n	<option value=''MacOS''>MacOS</option>\r\n</select>', '', 0, 100, '', '', 'text', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => ''Win2000/WinXP/Win2003'',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 26, 0),
(109, 3, 'stars', 'ֵȼ', '', '', 0, 20, '', '', 'box', 'array (\n  ''options'' => ''|\r\n|\r\n|\r\n|\r\n|'',\n  ''boxtype'' => ''radio'',\n  ''fieldtype'' => ''CHAR'',\n  ''cols'' => ''5'',\n  ''width'' => ''100'',\n  ''size'' => ''1'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 27, 0),
(110, 3, 'inputtime', 'ʱ', '', '', 0, 0, '', '', 'datetime', 'array (\r\n  ''dateformat'' => ''int'',\r\n  ''format'' => ''Y-m-d H:i:s'',\r\n  ''defaulttype'' => ''1'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0),
(111, 3, 'islink', 'ת', '', '', 0, 0, '', '', 'islink', '', '', '-99', '-99', 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 31, 0),
(112, 3, 'posids', 'Ƽλ', 'ȫѡ<input boxid=''posids'' type=''checkbox'' onclick="checkall(''posids'')" >', '', 0, 0, '', '', 'posid', 'array (\n  ''cols'' => ''4'',\n  ''width'' => ''125'',\n)', '', '', '', 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 32, 0),
(113, 3, 'groupids_view', 'Ȩ', 'ȫѡ<input boxid=''groupids_view'' type=''checkbox'' onclick="checkall(''groupids_view'')" >', '', 0, 0, '', '', 'groupid', 'array (\n  ''priv'' => ''view'',\n  ''cols'' => ''4'',\n  ''width'' => ''125'',\n)', '', '-99', '-99', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 0),
(114, 3, 'readpoint', 'Ķ', '', '', 0, 5, '', '', 'number', 'array (\n  ''minnumber'' => ''0'',\n  ''maxnumber'' => ''99999'',\n  ''decimaldigits'' => ''0'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 34, 0),
(115, 3, 'prefix', 'htmlļ', '', '', 0, 20, '', '', 'text', 'array (\n  ''size'' => ''20'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 0),
(116, 3, 'url', 'URL', '', '', 0, 100, '', '', 'text', '', '', '', '', 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 96, 0),
(117, 3, 'listorder', '', '', '', 0, 6, '', '', 'number', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 97, 0),
(118, 3, 'status', '״̬', '', '', 0, 2, '', '', 'box', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 98, 0),
(166, 4, 'contentid', 'ID', '', '', 0, 0, '', '', 'number', '', '', '', '', 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0),
(167, 4, 'catid', 'Ŀ', '', '', 1, 6, '/^[0-9]{1,6}$/', 'ѡĿ', 'catid', 'array (\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0),
(168, 4, 'typeid', '', '', '', 0, 0, '', '', 'typeid', 'array (\n  ''minnumber'' => '''',\n  ''maxnumber'' => '''',\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 2, 1),
(169, 4, 'areaid', '', '', '', 0, 0, '', '', 'areaid', 'array (\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 3, 0),
(170, 4, 'title', '', '', 'inputtitle', 1, 80, '', '', 'title', 'array (\n  ''size'' => ''80'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 4, 0),
(171, 4, 'style', 'ɫ', '', '', 0, 0, '', '', 'style', '', '', '-99', '-99', 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 5, 0),
(172, 4, 'thumb', 'ͼ', '', '', 0, 100, '', '', 'image', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''upload_maxsize'' => ''1024'',\n  ''upload_allowext'' => ''jpg|jpeg|gif|png|bmp'',\n  ''isselectimage'' => ''1'',\n  ''isthumb'' => ''1'',\n  ''thumb_width'' => ''300'',\n  ''thumb_height'' => ''300'',\n  ''iswatermark'' => ''1'',\n  ''watermark_img'' => ''images/watermark.gif'',\n)', '', '', '', 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 6, 0),
(173, 4, 'keywords', 'ؼ', 'ؼ֮ÿո', '', 0, 40, '', '', 'keyword', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 7, 0),
(174, 4, 'description', 'ժҪ', '', '', 0, 255, '', '', 'textarea', 'array (\n  ''rows'' => ''4'',\n  ''cols'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''enablehtml'' => ''0'',\n  ''enablekeylink'' => ''0'',\n  ''enablefilterword'' => ''0'',\n)', 'style="width:100%"', '', '', 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 8, 1),
(178, 4, 'userid', '', '', '', 0, 0, '', '', 'userid', '', '', '', '', 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 9, 0),
(179, 4, 'updatetime', 'ʱ', '', '', 0, 0, '', '', 'datetime', 'array (\r\n  ''dateformat'' => ''int'',\r\n  ''format'' => ''Y-m-d H:i:s'',\r\n  ''defaulttype'' => ''1'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 10, 0),
(180, 4, 'content', '', '', '', 1, 999999, '', '', 'editor', 'array (\n  ''toolbar'' => ''basic'',\n  ''width'' => ''100%'',\n  ''height'' => ''350'',\n  ''defaultvalue'' => '''',\n  ''storage'' => ''database'',\n  ''enablekeylink'' => ''0'',\n  ''replacenum'' => '''',\n  ''enablesaveimage'' => ''1'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 11, 0),
(181, 4, 'inputtime', 'ʱ', '', '', 0, 0, '', '', 'datetime', 'array (\r\n  ''dateformat'' => ''int'',\r\n  ''format'' => ''Y-m-d H:i:s'',\r\n  ''defaulttype'' => ''1'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 12, 0),
(182, 4, 'endtime', 'ֹ', '', '', 0, 0, '', '', 'datetime', 'array (\n  ''dateformat'' => ''date'',\n  ''format'' => ''Y-m-d H:i:s'',\n  ''defaulttype'' => ''0'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 13, 0),
(183, 4, 'telephone', 'ϵ绰', '', '', 0, 20, '/^[0-9-]{6,20}$/', 'дȷĵ绰', 'text', 'array (\n  ''size'' => ''20'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 14, 0),
(184, 4, 'email', 'E-mail', '', '', 6, 40, '/^[\\w\\-\\.]+@[\\w\\-\\.]+(\\.\\w+)+$/', 'дȷE-mail', 'text', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 15, 0),
(185, 4, 'address', 'ַ', '', '', 0, 0, '', '', 'text', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 16, 0),
(186, 4, 'islink', 'ת', '', '', 0, 0, '', '', 'islink', '', '', '-99', '-99', 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 19, 0),
(187, 4, 'posids', 'Ƽλ', 'ȫѡ<input boxid=''posids'' type=''checkbox'' onclick="checkall(''posids'')" >', '', 0, 0, '', '', 'posid', 'array (\n  ''cols'' => ''4'',\n  ''width'' => ''125'',\n)', '', '', '', 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 20, 0),
(188, 4, 'groupids_view', 'ĶȨ', 'ȫѡ<input boxid=''groupids_view'' type=''checkbox'' onclick="checkall(''groupids_view'')" >', '', 0, 0, '', '', 'groupid', 'array (\n  ''priv'' => ''view'',\n  ''cols'' => ''4'',\n  ''width'' => ''125'',\n)', '', '-99', '-99', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0),
(189, 4, 'readpoint', 'Ķ', '', '', 0, 5, '', '', 'number', 'array (\n  ''minnumber'' => ''0'',\n  ''maxnumber'' => ''99999'',\n  ''decimaldigits'' => ''0'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 22, 0),
(190, 4, 'prefix', 'htmlļ', '', '', 0, 20, '', '', 'text', 'array (\n  ''size'' => ''20'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 0),
(191, 4, 'url', 'URL', '', '', 0, 100, '', '', 'text', '', '', '', '', 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 96, 0),
(192, 4, 'listorder', '', '', '', 0, 6, '', '', 'number', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 97, 0),
(193, 4, 'status', '״̬', '', '', 0, 2, '', '', 'box', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 98, 0),
(194, 4, 'template', 'ҳģ', '', '', 0, 30, '', '', 'template', '', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 0),
(210, 5, 'contentid', 'ID', '', '', 0, 0, '', '', 'number', '', '', '', '', 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0),
(211, 5, 'catid', 'Ŀ', '', '', 1, 9999, '/^[0-9]+$/', 'ѡĿ', 'catid', 'array (\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0),
(212, 5, 'typeid', '', '', '', 0, 0, '', '', 'typeid', 'array (\n  ''minnumber'' => '''',\n  ''maxnumber'' => '''',\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 2, 1),
(213, 5, 'areaid', '', '', '', 0, 0, '', '', 'areaid', 'array (\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 3, 1),
(214, 5, 'title', 'Ʒ', '', 'inputtitle', 1, 80, '', '', 'title', 'array (\n  ''size'' => ''80'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 4, 0),
(215, 5, 'style', 'ɫ', '', '', 0, 0, '', '', 'style', '', '', '-99', '-99', 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 5, 0),
(216, 5, 'thumb', 'ͼ', '', '', 0, 100, '', '', 'image', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''upload_maxsize'' => ''1024'',\n  ''upload_allowext'' => ''jpg|jpeg|gif|png|bmp'',\n  ''isselectimage'' => ''1'',\n  ''isthumb'' => ''1'',\n  ''thumb_width'' => ''800'',\n  ''thumb_height'' => ''600'',\n  ''iswatermark'' => ''1'',\n  ''watermark_img'' => ''images/watermark.gif'',\n)', '', '-99', '-99', 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 6, 0),
(217, 5, 'keywords', 'ؼ', 'ؼ֮ÿո', '', 0, 40, '', '', 'keyword', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 7, 0),
(218, 5, 'userid', '', '', '', 0, 0, '', '', 'userid', '', '', '', '', 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 9, 0),
(219, 5, 'updatetime', 'ʱ', '', '', 0, 0, '', '', 'datetime', 'array (\r\n  ''dateformat'' => ''int'',\r\n  ''format'' => ''Y-m-d H:i:s'',\r\n  ''defaulttype'' => ''1'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 10, 0),
(220, 5, 'unit', 'Ʒλ', '', '', 1, 4, '', '', 'box', 'array (\n  ''options'' => ''|\r\n|\r\n̨|̨\r\n|\r\n|\r\n|\r\nֻ|ֻ\r\n|\r\nƿ|ƿ\r\n|\r\nKg|Kg\r\nm|m'',\n  ''boxtype'' => ''select'',\n  ''fieldtype'' => ''CHAR'',\n  ''cols'' => '''',\n  ''width'' => '''',\n  ''size'' => '''',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 20, 0),
(221, 5, 'price', '۸', 'λԪ', '', 0, 7, '/^[0-9\\.]+$/', 'ȷļ۸', 'number', 'array (\n  ''minnumber'' => ''0.01'',\n  ''maxnumber'' => ''9999999'',\n  ''decimaldigits'' => ''2'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 20, 0),
(222, 5, 'size', 'Ʒͺ', '', '', 0, 50, '', '', 'text', 'array (\n  ''size'' => ''30'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 22, 0),
(223, 5, 'stock', '', '', '', 0, 20, '', '', 'text', 'array (\n  ''size'' => ''10'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 23, 0),
(224, 5, 'description', 'Ʒ', '', '', 0, 255, '', '', 'textarea', 'array (\n  ''rows'' => ''4'',\n  ''cols'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''enablekeylink'' => ''0'',\n  ''replacenum'' => '''',\n)', 'style="width:100%"', '-99', '-99', 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 29, 0),
(225, 5, 'content', 'Ʒ', '', '', 1, 999999, '', '', 'editor', 'array (\n  ''toolbar'' => ''standard'',\n  ''width'' => ''100%'',\n  ''height'' => ''350'',\n  ''defaultvalue'' => '''',\n  ''storage'' => ''database'',\n  ''enablekeylink'' => ''0'',\n  ''replacenum'' => '''',\n  ''enablesaveimage'' => ''1'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 30, 0),
(226, 5, 'pictureurls', 'ͼ', '', '', 0, 255, '', '', 'images', 'array (\n  ''upload_maxsize'' => ''1024'',\n  ''upload_allowext'' => ''gif|jpg|jpeg|png|bmp'',\n  ''isthumb'' => ''0'',\n  ''thumb_width'' => ''150'',\n  ''thumb_height'' => ''150'',\n  ''iswatermark'' => ''1'',\n  ''ishtml'' => ''0'',\n  ''watermark_img'' => ''images/watermark.gif'',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 31, 0),
(227, 5, 'inputtime', 'ʱ', '', '', 0, 0, '', '', 'datetime', 'array (\r\n  ''dateformat'' => ''int'',\r\n  ''format'' => ''Y-m-d H:i:s'',\r\n  ''defaulttype'' => ''1'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 32, 0),
(228, 5, 'islink', 'ת', '', '', 0, 0, '', '', 'islink', '', '', '-99', '-99', 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 32, 0),
(229, 5, 'stars', 'Ƽȼ', '', '', 0, 20, '', '', 'box', 'array (\n  ''options'' => ''|\r\n|\r\n|\r\n|\r\n|'',\n  ''boxtype'' => ''radio'',\n  ''fieldtype'' => ''VARCHAR'',\n  ''cols'' => ''5'',\n  ''width'' => ''100'',\n  ''size'' => ''1'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 33, 0),
(230, 5, 'posids', 'Ƽλ', 'ȫѡ<input boxid=''posids'' type=''checkbox'' onclick="checkall(''posids'')" >', '', 0, 0, '', '', 'posid', 'array (\n  ''cols'' => ''4'',\n  ''width'' => ''125'',\n)', '', '-99', '-99', 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 36, 0),
(231, 5, 'prefix', 'htmlļ', '', '', 0, 20, '', '', 'text', 'array (\n  ''size'' => ''20'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 0),
(232, 5, 'url', 'URL', '', '', 0, 100, '', '', 'text', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 96, 0),
(233, 5, 'listorder', '', '', '', 1, 1, '', '', 'number', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 97, 0),
(234, 5, 'status', '״̬', '', '', 0, 2, '', '', 'box', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 98, 0),
(235, 5, 'template', 'ҳģ', '', '', 0, 255, '', '', 'template', 'array (\n  ''size'' => '''',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 0),
(500, 10, 'truename', '', '', '', 0, 0, '', '', 'text', 'array (\n  ''size'' => ''12'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0),
(501, 10, 'gender', 'Ա', '', '', 0, 1, '', '', 'box', 'array (\n  ''options'' => ''|0\r\nŮ|1'',\n  ''boxtype'' => ''radio'',\n  ''fieldtype'' => ''TINYINT'',\n  ''cols'' => ''5'',\n  ''width'' => ''80'',\n  ''size'' => ''1'',\n  ''defaultvalue'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0),
(502, 10, 'birthday', '', '', '', 0, 0, '', '', 'datetime', 'array (\n  ''dateformat'' => ''date'',\n  ''format'' => ''Y-m-d H:i:s'',\n  ''defaulttype'' => ''0'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0),
(503, 10, 'mobile', 'ֻ', '', '', 0, 0, '/^(13|15)[0-9]{9}$/', 'ֻŸʽ', 'text', 'array (\n  ''size'' => ''15'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0),
(504, 10, 'telephone', '绰', '', '', 0, 0, '/^[0-9-]{6,13}$/', '绰ʽ', 'text', 'array (\n  ''size'' => ''20'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0),
(505, 10, 'qq', 'QQ', '', '', 0, 0, '/^[0-9]{5,20}$/', 'QQŸʽ', 'text', 'array (\n  ''size'' => ''20'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0),
(506, 10, 'msn', 'MSN', '', '', 0, 0, '/^[\\w\\-\\.]+@[\\w\\-\\.]+(\\.\\w+)+$/', 'MSNʽ', 'text', 'array (\n  ''size'' => ''40'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0),
(507, 10, 'address', 'ַ', '', '', 0, 0, '', '', 'text', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0),
(508, 10, 'postcode', 'ʱ', '', '', 0, 0, '/^[0-9]{6}$/', 'ʱʽ', 'text', 'array (\n  ''size'' => ''6'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0),
(509, 6, 'contentid', 'ID', '', '', 0, 0, '', '', 'number', '', '', '', '', 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0),
(510, 6, 'catid', 'Ŀ', '', '', 1, 9999, '/^[0-9]+$/', 'ѡĿ', 'catid', 'array (\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0),
(511, 6, 'typeid', '', '', '', 0, 0, '', '', 'typeid', 'array (\n  ''minnumber'' => '''',\n  ''maxnumber'' => '''',\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 2, 0),
(512, 6, 'areaid', '', '', '', 0, 0, '', '', 'areaid', 'array (\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 3, 0),
(513, 6, 'title', '', '', 'inputtitle', 1, 80, '', '', 'title', 'array (\n  ''size'' => ''60'',\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 4, 0),
(514, 6, 'style', 'ɫ', '', '', 0, 0, '', '', 'style', '', '', '', '', 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 5, 0),
(515, 6, 'thumb', 'ͼ', '', '', 0, 100, '', '', 'image', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''upload_maxsize'' => ''1024'',\n  ''upload_allowext'' => ''jpg|jpeg|gif|png|bmp'',\n  ''isselectimage'' => ''1'',\n  ''isthumb'' => ''1'',\n  ''thumb_width'' => ''300'',\n  ''thumb_height'' => ''300'',\n  ''iswatermark'' => ''1'',\n  ''watermark_img'' => ''images/watermark.gif'',\n)', '', '', '', 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 6, 0),
(516, 6, 'keywords', 'ؼ', 'ؼ֮ÿո', '', 0, 40, '', '', 'keyword', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 7, 0),
(517, 6, 'posids', 'Ƽλ', 'ȫѡ<input boxid=''posids'' type=''checkbox'' onclick="checkall(''posids'')" >', '', 0, 0, '', '', 'posid', 'array (\n  ''cols'' => ''4'',\n  ''width'' => ''150'',\n)', '', '-99', '-99', 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 17, 0),
(518, 6, 'listorder', '', '', '', 1, 1, '', '', 'number', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 97, 0),
(519, 6, 'url', 'URL', '', '', 0, 100, '', '', 'text', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 96, 0),
(520, 6, 'userid', '', '', '', 0, 0, '', '', 'userid', '', '', '', '', 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 14, 0),
(521, 6, 'updatetime', 'ʱ', '', '', 0, 0, '', '', 'datetime', 'array (\r\n  ''dateformat'' => ''int'',\r\n  ''format'' => ''Y-m-d H:i:s'',\r\n  ''defaulttype'' => ''1'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 15, 0),
(522, 6, 'inputtime', 'ʱ', '', '', 0, 0, '', '', 'datetime', 'array (\r\n  ''dateformat'' => ''int'',\r\n  ''format'' => ''Y-m-d H:i:s'',\r\n  ''defaulttype'' => ''1'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 15, 0),
(523, 6, 'islink', 'ת', '', '', 0, 0, '', '', 'islink', '', '', '', '', 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 32, 0),
(524, 6, 'prefix', 'htmlļ', '', '', 0, 20, '', '', 'text', 'array (\n  ''size'' => ''12'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 0),
(525, 6, 'status', '״̬', '', '', 0, 2, '', '', 'box', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 98, 0),
(526, 6, 'template', 'ҳģ', '', '', 0, 255, '', '', 'template', '', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 0),
(527, 6, 'video', 'Ƶ', '', '', 0, 255, '', '', 'flashupload', 'array (\n  ''upload_maxsize'' => ''1024000'',\n  ''upload_allowext'' => ''rm|wma|wmv|mp4|flv'',\n  ''upload_items'' => ''2'',\n  ''servers'' => ''Ƶ|\r\nŷ|http://tel.xxx.com/\r\nͨ|http://cnc.xxx.com/'',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 8, 0),
(528, 6, 'director', '', '', '', 0, 255, '', '', 'text', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 9, 0),
(529, 6, 'actor', '', '', '', 0, 0, '', '', 'text', 'array (\n  ''size'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''ispassword'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 10, 0),
(530, 6, 'rank', 'ӰƬ', '', '', 0, 255, '', '', 'box', 'array (\n  ''options'' => ''|\r\n|\r\n|\r\n|\r\n|'',\n  ''boxtype'' => ''radio'',\n  ''fieldtype'' => ''CHAR'',\n  ''cols'' => ''5'',\n  ''width'' => ''100'',\n  ''size'' => ''1'',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 13, 0),
(531, 6, 'photo', '', '', '', 0, 0, '', '', 'images', 'array (\n  ''upload_maxsize'' => ''1024'',\n  ''upload_allowext'' => ''gif|jpg|jpeg|png|bmp'',\n  ''isthumb'' => ''1'',\n  ''thumb_width'' => ''300'',\n  ''thumb_height'' => ''300'',\n  ''iswatermark'' => ''1'',\n  ''ishtml'' => ''1'',\n  ''watermark_img'' => ''images/watermark.gif'',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 11, 0),
(532, 6, 'content', 'ӰƬ', '', '', 0, 0, '', '', 'editor', 'array (\n  ''toolbar'' => ''basic'',\n  ''width'' => ''100%'',\n  ''height'' => ''300'',\n  ''defaultvalue'' => '''',\n  ''storage'' => ''database'',\n  ''enablekeylink'' => ''0'',\n  ''replacenum'' => ''1'',\n  ''enablesaveimage'' => ''0'',\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 12, 0),
(533, 6, 'description', 'ժҪ', '', '', 0, 255, '', '', 'textarea', 'array (\n  ''rows'' => ''6'',\n  ''cols'' => ''50'',\n  ''defaultvalue'' => '''',\n  ''enablekeylink'' => ''0'',\n  ''replacenum'' => '''',\n)', 'style="width:100%"', '-99', '-99', 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 12, 1);

DROP TABLE IF EXISTS `phpcms_module`;
CREATE TABLE `phpcms_module` (
  `module` varchar(15) NOT NULL,
  `name` varchar(20) NOT NULL,
  `path` varchar(50) NOT NULL,
  `url` varchar(50) NOT NULL,
  `iscore` tinyint(1) unsigned NOT NULL default '0',
  `version` varchar(50) NOT NULL default '',
  `author` varchar(50) NOT NULL default '',
  `site` varchar(100) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `description` mediumtext NOT NULL,
  `license` mediumtext NOT NULL,
  `faq` mediumtext NOT NULL,
  `tagtypes` mediumtext NOT NULL,
  `setting` mediumtext NOT NULL,
  `listorder` tinyint(3) unsigned NOT NULL default '0',
  `disabled` tinyint(1) unsigned NOT NULL default '0',
  `publishdate` date NOT NULL default '0000-00-00',
  `installdate` date NOT NULL default '0000-00-00',
  `updatedate` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`module`)
) TYPE=MyISAM;

INSERT INTO `phpcms_module` (`module`, `name`, `path`, `url`, `iscore`, `version`, `author`, `site`, `email`, `description`, `license`, `faq`, `tagtypes`, `setting`, `listorder`, `disabled`, `publishdate`, `installdate`, `updatedate`) VALUES ('phpcms', 'Phpcms', '', '', 1, '1.0.0.0', 'Phpcms Team', 'http://www.phpcms.cn/', 'phpcms@163.com', 'Phpcms Content Manage System', '', '', 'array (\r\n ''phpcms-content''=>''phpcms'',\r\n ''phpcms-category''=>''Ŀǩ'',\r\n)', 'array (\n  ''phpcmsusername'' => '''',\n  ''phpcmspassword'' => '''',\n  ''sitename'' => ''Phpcms'',\n  ''siteurl'' => '''',\n  ''ishtml'' => ''1'',\n  ''fileext'' => ''html'',\n  ''meta_title'' => ''йȵվݹϵͳ'',\n  ''meta_keywords'' => ''Phpcms վݹϵͳ'',\n  ''meta_description'' => ''Phpcms վݹϵͳ'',\n  ''copyright'' => ''<p>CopyRight 2006---2009&nbsp; <a href="http://www.phpcms.cn/">6Ϣ޹˾</a>Ȩ</p>'',\n  ''icpno'' => ''ICP֤060955'',\n  ''pageshtml'' => ''<b>{$total}</b>\r\n<a href="{$firstpage}">ҳ</a><a href="{$prepage}">һҳ</a><a href="{$nextpage}">һҳ</a><a href="{$lastpage}">βҳ</a>\r\nҳΣ<b><font color="red">{$page}</font>/{$pages}</b>\r\n<input type="text" name="page" id="page" size="2" onKeyDown="if(event.keyCode==13) {redirect(\\''{$urlpre}\\''+this.value); return false;}"> \r\n<input type="button" value="GO" class="gotopage" onclick="redirect(\\''{$urlpre}\\''+$(\\''#page\\'').val())">'',\n  ''segmentclass'' => ''segment'',\n  ''enablegetkeywords'' => ''1'',\n  ''enablegetscrollbar'' => ''1'',\n ''enable_urlencode'' => ''0'',\n ''areaid'' => ''1'',\n  ''editor_max_data_hour'' => ''4'',\n  ''editor_interval_data'' => ''30'',\n  ''maxpage'' => ''100'',\n  ''pagesize'' => ''20'',\n  ''autoupdatelist'' => ''5'',\n  ''search_time'' => ''10'',\n  ''search_maxresults'' => ''500'',\n  ''search_pagesize'' => ''10'',\n  ''category_count'' => ''1'',\n  ''show_hits'' => ''1'',\n  ''adminaccessip'' => '''',\n  ''maxloginfailedtimes'' => ''5'',\n  ''maxiplockedtime'' => ''1'',\n  ''enable_ipbanned'' => ''0'',\n  ''minrefreshtime'' => ''0'',\n  ''filter_word'' => '''',\n  ''thumb_enable'' => ''1'',\n  ''thumb_width'' => ''300'',\n  ''thumb_height'' => ''300'',\n  ''watermark_enable'' => ''1'',\n  ''watermark_minwidth'' => ''300'',\n  ''watermark_minheight'' => ''300'',\n  ''watermark_img'' => ''images/watermark.gif'',\n  ''watermark_pct'' => ''100'',\n  ''watermark_quality'' => ''80'',\n  ''watermark_pos'' => ''9'',\n  ''mail_type'' => ''1'',\n  ''mail_server'' => ''smtp.163.com'',\n  ''mail_port'' => ''25'',\n  ''mail_user'' => ''phpcms@163.com'',\n  ''mail_password'' => '''',\n  ''mail_sign'' => '''',\n  ''enablepassport'' => ''0'',\n  ''passport_file'' => ''discuz'',\n  ''passport_charset'' => ''gbk'',\n  ''passport_url'' => ''http://www.***.com/bbs/api/passport.php'',\n  ''passport_key'' => '''',\n  ''enableserverpassport'' => ''0'',\n  ''passport_serverurl'' => ''http://www.***.com/bbs/'',\n  ''passport_registerurl'' => ''register.php'',\n  ''passport_loginurl'' => ''login.php'',\n  ''passport_logouturl'' => ''login.php?action=quit'',\n  ''passport_getpasswordurl'' => ''sendpwd.php'',\n  ''passport_serverkey'' => '''',\n  ''passport_expire'' => '''',\n  ''uc'' => ''0'',\n  ''uc_api'' => ''http://uc.phpcms.cn/uc'',\n  ''uc_ip'' => '''',\n  ''uc_dbhost'' => ''localhost'',\n  ''uc_dbname'' => ''dbname'',\n  ''uc_dbuser'' => ''dbuser'',\n  ''uc_dbpwd'' => ''dbpw'',\n  ''uc_dbpre'' => ''uc_'',\n  ''uc_charset'' => ''gbk'',\n  ''uc_appid'' => ''3'',\n  ''uc_key'' => '''',\n  ''enabletm'' => ''0'',\n  ''qq'' => '''',\n  ''msn'' => '''',\n  ''skype'' => '''',\n  ''taobao'' => '''',\n  ''alibaba'' => '''',\n  ''version'' => ''2008'',\n)', 0, 0, '2008-10-28', '2008-10-28', '2008-10-28');

DROP TABLE IF EXISTS `phpcms_position`;
CREATE TABLE IF NOT EXISTS `phpcms_position` (
  `posid` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `listorder` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`posid`)
) TYPE=MyISAM;

INSERT INTO `phpcms_position` (`posid`, `name`, `listorder`) VALUES (1, 'ҳƼ', 0);
INSERT INTO `phpcms_position` (`posid`, `name`, `listorder`) VALUES (2, 'ҳ', 0);
INSERT INTO `phpcms_position` (`posid`, `name`, `listorder`) VALUES (3, 'ҳͷ', 0);
INSERT INTO `phpcms_position` (`posid`, `name`, `listorder`) VALUES (4, 'бҳƼ', 0);
INSERT INTO `phpcms_position` (`posid`, `name`, `listorder`) VALUES (5, 'ҳƼ', 0);

DROP TABLE IF EXISTS `phpcms_process`;
CREATE TABLE IF NOT EXISTS `phpcms_process` (
  `processid` smallint(5) unsigned NOT NULL auto_increment,
  `workflowid` tinyint(3) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL,
  `description` varchar(255) NOT NULL,
  `passname` varchar(20) NOT NULL,
  `passstatus` tinyint(3) unsigned NOT NULL default '0',
  `rejectname` varchar(20) NOT NULL,
  `rejectstatus` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`processid`)
) TYPE=MyISAM;

INSERT INTO `phpcms_process` (`processid`, `workflowid`, `name`, `description`, `passname`, `passstatus`, `rejectname`, `rejectstatus`) VALUES (1, 1, '', '', '׼', 99, '˸', 1);
INSERT INTO `phpcms_process` (`processid`, `workflowid`, `name`, `description`, `passname`, `passstatus`, `rejectname`, `rejectstatus`) VALUES (2, 2, 'һ', '', '׼', 4, '˸', 1);
INSERT INTO `phpcms_process` (`processid`, `workflowid`, `name`, `description`, `passname`, `passstatus`, `rejectname`, `rejectstatus`) VALUES (3, 2, '', '', '׼', 99, '˸', 7);
INSERT INTO `phpcms_process` (`processid`, `workflowid`, `name`, `description`, `passname`, `passstatus`, `rejectname`, `rejectstatus`) VALUES (4, 3, 'һ', '', '׼', 4, '˸', 1);
INSERT INTO `phpcms_process` (`processid`, `workflowid`, `name`, `description`, `passname`, `passstatus`, `rejectname`, `rejectstatus`) VALUES (5, 3, '', '', '׼', 6, '˸', 5);
INSERT INTO `phpcms_process` (`processid`, `workflowid`, `name`, `description`, `passname`, `passstatus`, `rejectname`, `rejectstatus`) VALUES (6, 3, '', '', '׼', 99, '˸', 7);

DROP TABLE IF EXISTS `phpcms_process_status`;
CREATE TABLE IF NOT EXISTS `phpcms_process_status` (
  `processid` smallint(5) unsigned NOT NULL,
  `status` tinyint(3) unsigned NOT NULL,
  KEY `processid` (`processid`),
  KEY `status` (`status`)
) TYPE=MyISAM;

INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (1, 1);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (1, 3);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (1, 99);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (2, 1);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (2, 3);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (2, 4);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (2, 7);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (3, 4);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (3, 7);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (3, 99);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (4, 1);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (4, 3);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (4, 4);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (4, 5);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (5, 4);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (5, 5);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (5, 6);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (5, 7);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (6, 6);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (6, 7);
INSERT INTO `phpcms_process_status` (`processid`, `status`) VALUES (6, 99);

DROP TABLE IF EXISTS `phpcms_role`;
CREATE TABLE `phpcms_role` (
  `roleid` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `ipaccess` text NOT NULL,
  `listorder` smallint(5) unsigned NOT NULL default '0',
  `disabled` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`roleid`),
  UNIQUE KEY `name` (`name`)
) TYPE=MyISAM;

INSERT INTO `phpcms_role` (`roleid`, `name`, `description`, `ipaccess`, `listorder`, `disabled`) VALUES (1, 'Ա', 'Ա', '', 0, 0);
INSERT INTO `phpcms_role` (`roleid`, `name`, `description`, `ipaccess`, `listorder`, `disabled`) VALUES (2, 'ܱ', 'ӵĿרȨޣҿĿר', '', 0, 0);
INSERT INTO `phpcms_role` (`roleid`, `name`, `description`, `ipaccess`, `listorder`, `disabled`) VALUES (3, 'Ŀ༭', 'ӵĳЩĿϢ¼롢˼ȨޣҪһϸá', '', 0, 0);
INSERT INTO `phpcms_role` (`roleid`, `name`, `description`, `ipaccess`, `listorder`, `disabled`) VALUES (4, 'ʦ', 'ӵģǩȨ', '', 0, 0);
INSERT INTO `phpcms_role` (`roleid`, `name`, `description`, `ipaccess`, `listorder`, `disabled`) VALUES (5, 'Ա', 'ӵж鿴¼лƱȨޡ', '', 0, 0);

DROP TABLE IF EXISTS `phpcms_session`;
CREATE TABLE `phpcms_session` (
  `sessionid` char(32) NOT NULL,
  `userid` mediumint(8) unsigned NOT NULL default '0',
  `ip` char(15) NOT NULL,
  `lastvisit` int(10) unsigned NOT NULL default '0',
  `groupid` tinyint(3) unsigned NOT NULL default '0',
  `module` char(15) NOT NULL,
  `catid` smallint(5) unsigned NOT NULL default '0',
  `contentid` mediumint(8) unsigned NOT NULL default '0',
  `data` char(255) NOT NULL,
  PRIMARY KEY  (`sessionid`),
  KEY `lastvisit` (`lastvisit`)
) TYPE=MEMORY;

DROP TABLE IF EXISTS `phpcms_status`;
CREATE TABLE `phpcms_status` (
  `status` tinyint(3) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL,
  `description` varchar(255) NOT NULL,
  `issystem` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`status`)
) TYPE=MyISAM;

INSERT INTO `phpcms_status` (`status`, `name`, `description`, `issystem`) VALUES (0, 'ɾ', 'ѱɾվ', 1);
INSERT INTO `phpcms_status` (`status`, `name`, `description`, `issystem`) VALUES (1, '˸', '˻', 1);
INSERT INTO `phpcms_status` (`status`, `name`, `description`, `issystem`) VALUES (2, 'ݸ', 'ݸ', 1);
INSERT INTO `phpcms_status` (`status`, `name`, `description`, `issystem`) VALUES (3, '', 'ȴ', 1);
INSERT INTO `phpcms_status` (`status`, `name`, `description`, `issystem`) VALUES (99, 'ͨ', 'Ѿͨ', 1);
INSERT INTO `phpcms_status` (`status`, `name`, `description`, `issystem`) VALUES (4, 'һͨ', 'һͨ', 0);
INSERT INTO `phpcms_status` (`status`, `name`, `description`, `issystem`) VALUES (5, '˸', '˸', 0);
INSERT INTO `phpcms_status` (`status`, `name`, `description`, `issystem`) VALUES (6, 'ͨ', 'ͨ', 0);
INSERT INTO `phpcms_status` (`status`, `name`, `description`, `issystem`) VALUES (7, '˸', '˸', 0);
INSERT INTO `phpcms_status` (`status`, `name`, `description`, `issystem`) VALUES (98, 'ʱ', 'ʱ', 1);

DROP TABLE IF EXISTS `phpcms_type`;
CREATE TABLE IF NOT EXISTS `phpcms_type` (
  `typeid` smallint(5) unsigned NOT NULL auto_increment,
  `module` char(15) NOT NULL default 'phpcms',
  `modelid` tinyint(3) unsigned NOT NULL default '0',
  `name` char(30) NOT NULL,
  `style` char(5) NOT NULL,
  `typedir` char(20) NOT NULL,
  `description` char(255) NOT NULL,
  `thumb` char(100) NOT NULL,
  `url` char(100) NOT NULL,
  `template` char(50) NOT NULL,
  `listorder` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`typeid`),
  KEY `module` (`module`,`listorder`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_times`;
CREATE TABLE `phpcms_times` (
  `action` char(10) NOT NULL,
  `ip` char(15) NOT NULL,
  `time` int(10) unsigned NOT NULL default '0',
  `times` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`action`,`ip`)
) TYPE=MEMORY;

DROP TABLE IF EXISTS `phpcms_urlrule`;
CREATE TABLE `phpcms_urlrule` (
  `urlruleid` smallint(5) unsigned NOT NULL auto_increment,
  `module` varchar(15) NOT NULL,
  `file` varchar(20) NOT NULL,
  `ishtml` tinyint(1) unsigned NOT NULL default '0',
  `urlrule` varchar(255) NOT NULL,
  `example` varchar(255) NOT NULL,
  PRIMARY KEY  (`urlruleid`)
) TYPE=MyISAM;

INSERT INTO `phpcms_urlrule` (`urlruleid`, `module`, `file`, `ishtml`, `urlrule`, `example`) VALUES (1, 'phpcms', 'category', 1, '{$categorydir}/index.{$fileext}|{$categorydir}/{$page}.{$fileext}', 'it/product/2.html');
INSERT INTO `phpcms_urlrule` (`urlruleid`, `module`, `file`, `ishtml`, `urlrule`, `example`) VALUES (2, 'phpcms', 'category', 1, 'category/{$catid}.{$fileext}|category/{$catid}_{$page}.{$fileext}', 'category/2_1.html');
INSERT INTO `phpcms_urlrule` (`urlruleid`, `module`, `file`, `ishtml`, `urlrule`, `example`) VALUES (3, 'phpcms', 'category', 1, '{$catdir}/index.{$fileext}|{$catdir}/{$page}.{$fileext}', 'news/2_1.html');
INSERT INTO `phpcms_urlrule` (`urlruleid`, `module`, `file`, `ishtml`, `urlrule`, `example`) VALUES (4, 'phpcms', 'category', 0, 'list.php?catid={$catid}|list.php?catid={$catid}&page={$page}', 'list.php?catid=1&page=2');
INSERT INTO `phpcms_urlrule` (`urlruleid`, `module`, `file`, `ishtml`, `urlrule`, `example`) VALUES (5, 'phpcms', 'category', 0, 'list.php?catid-{$catid}.html|list.php?catid-{$catid}/page-{$page}.html', 'list.php?catid-1/page-2.html');
INSERT INTO `phpcms_urlrule` (`urlruleid`, `module`, `file`, `ishtml`, `urlrule`, `example`) VALUES (6, 'phpcms', 'category', 0, 'list-{$catid}-{$page}.html', 'list-1-2.html');
INSERT INTO `phpcms_urlrule` (`urlruleid`, `module`, `file`, `ishtml`, `urlrule`, `example`) VALUES (7, 'phpcms', 'show', 1, '{$year}/{$month}{$day}/{$contentid}.{$fileext}|{$year}/{$month}{$day}/{$contentid}_{$page}.{$fileext}', '2006/1010/1_2.html');
INSERT INTO `phpcms_urlrule` (`urlruleid`, `module`, `file`, `ishtml`, `urlrule`, `example`) VALUES (8, 'phpcms', 'show', 1, '{$categorydir}/{$year}/{$month}{$day}/{$contentid}.{$fileext}|{$categorydir}/{$year}/{$month}{$day}/{$contentid}_{$page}.{$fileext}', 'it/product/2006/1010/1_2.html');
INSERT INTO `phpcms_urlrule` (`urlruleid`, `module`, `file`, `ishtml`, `urlrule`, `example`) VALUES (9, 'phpcms', 'show', 1, 'show/{$contentid}.{$fileext}|show/{$contentid}_{$page}.{$fileext}', 'show/1_2.html');
INSERT INTO `phpcms_urlrule` (`urlruleid`, `module`, `file`, `ishtml`, `urlrule`, `example`) VALUES (10, 'phpcms', 'show', 0, 'show.php?contentid={$contentid}|show.php?contentid={$contentid}&page={$page}', 'show.php?contentid=1&page=2');
INSERT INTO `phpcms_urlrule` (`urlruleid`, `module`, `file`, `ishtml`, `urlrule`, `example`) VALUES (11, 'phpcms', 'show', 0, 'show.php?contentid-{$contentid}.html|show.php?contentid-{$contentid}/page-{$page}.html', 'show.php?contentid-1/page-2.html');
INSERT INTO `phpcms_urlrule` (`urlruleid`, `module`, `file`, `ishtml`, `urlrule`, `example`) VALUES (12, 'phpcms', 'show', 0, 'show-{$contentid}-1.html|show-{$contentid}-{$page}.html', 'show-1-2.html');

DROP TABLE IF EXISTS `phpcms_workflow`;
CREATE TABLE `phpcms_workflow` (
  `workflowid` tinyint(3) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY  (`workflowid`),
  UNIQUE KEY `name` (`name`)
) TYPE=MyISAM;

INSERT INTO `phpcms_workflow` (`workflowid`, `name`, `description`) VALUES (1, 'һ', 'һ˷Ҫ1˲ʽ');
INSERT INTO `phpcms_workflow` (`workflowid`, `name`, `description`) VALUES (2, '', '˷Ҫ2˲ʽ');
INSERT INTO `phpcms_workflow` (`workflowid`, `name`, `description`) VALUES (3, '', '˷Ҫ3˲ʽ');

DROP TABLE IF EXISTS `phpcms_editor_data`;
CREATE TABLE `phpcms_editor_data` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `userid` mediumint(8) unsigned NOT NULL default '0',
  `editorid` char(15) NOT NULL,
  `ip` char(15) NOT NULL,
  `created_time` int(10) unsigned NOT NULL default '0',
  `data` mediumtext NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `userid` (`userid`,`editorid`,`created_time`,`id`)
) TYPE=MyISAM;

DROP TABLE IF EXISTS `phpcms_linkage`;
CREATE TABLE `phpcms_linkage` (
  `linkageid` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL,
  `style` varchar(35) NOT NULL,
  `parentid` smallint(5) unsigned NOT NULL default '0',
  `arrparentid` varchar(255) NOT NULL default '',
  `child` tinyint(1) unsigned NOT NULL default '0',
  `arrchildid` mediumtext NOT NULL,
  `keyid` smallint(5) unsigned NOT NULL default '0',
  `listorder` smallint(5) unsigned NOT NULL default '0',
  `description` varchar(255) default NULL,
  PRIMARY KEY  (`linkageid`,`keyid`),
  KEY `parentid` (`parentid`,`listorder`)
) TYPE=MyISAM;