<?php

namespace App\Http\Controllers\Support;

use App\Modules\Modules;
use App\Types\ModuleStatus;
use App\Types\UserPayOauthType;
use Edwin404\Admin\Http\Controllers\Support\AdminCheckController;
use Edwin404\Article\Services\ArticleService;
use Edwin404\Common\Support\TemplateViewTrait;
use Edwin404\Member\Services\MemberMessageService;
use Edwin404\Member\Services\MemberService;
use Edwin404\Member\Support\MemberTrait;
use Edwin404\Wechat\Helpers\WechatHelper;
use Edwin404\Wechat\Services\WechatService;
use Edwin404\Wechat\Types\WechatServiceInfo;
use Edwin404\Wechat\Types\WechatVerifyInfo;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Str;

class BaseController extends AdminCheckController
{
    //use TemplateViewTrait;

    public function __construct()
    {
        parent::__construct();
        View::share('_memberUser', [
            'id' => 0,
        ]);
    }

    protected function memberUserId()
    {
        //mock
        return 0;
    }

    protected function _view($view, $data = [])
    {
        return view('theme.default.pc.' . $view, $data);
    }
}