<?php

Route::group(
    [
        'middleware' => [
            \Edwin404\Base\Support\BaseMiddleware::class,
            \App\Http\Middleware\MemberAuth::class,
        ],
    ],
    function () {

        Route::match(['get', 'post'], '', '\App\Http\Controllers\Main\IndexController@index');

    }
);
include __DIR__ . '/routes_admin.php';

Route::match(['get', 'post'], 'oauth_wechat_proxy', '\App\Http\Controllers\Main\IndexController@oauthWechatProxy');

Route::match(['get', 'post'], 'placeholder/{width}x{height}', '\Edwin404\Placeholder\Controllers\PlaceholderController@index');
Route::match(['get', 'post'], 'data_image/{file}/limit_{width}x{height}', '\Edwin404\Data\Controllers\ImageController@limit')
    ->where(['file' => 'data\\/[a-z0-9_]+\\/\\d+\\/\\d+\\/\\d+\\/[a-z0-9_\\.]+', 'width' => '[0-9]+', 'height' => '[0-9]+']);

Route::match(['get', 'post'], 'install/ping', '\Edwin404\Tecmz\Controllers\InstallController@ping');
Route::match(['get', 'post'], 'install/execute', '\Edwin404\Tecmz\Controllers\InstallController@execute');
Route::match(['get', 'post'], 'install/lock', '\Edwin404\Tecmz\Controllers\InstallController@lock');

Route::match(['get', 'post'], 'detect_device', '\App\Http\Controllers\Main\IndexController@detectDevice');

Route::any('pay/return/{payType}', '\Edwin404\Pay\Controllers\ReturnController@index');
Route::any('pay/notify/{payType}', '\Edwin404\Pay\Controllers\NotifyController@index');

