<?php

Route::group(
    [
        'prefix' => env('ADMIN_PATH', '/admin/'),
        'middleware' => [
            \Edwin404\Admin\Http\Middleware\AdminWebAuth::class,
        ]
    ], function () {

    // 公用
    include __DIR__ . '/../../vendor/edwin404/laravel-admin/src/Config/routes.php';
    Route::match(['get', 'post'], '', '\App\Http\Controllers\Admin\IndexController@index');
    Route::match(['get', 'post'], 'system/data/image_select_dialog', '\Edwin404\Admin\Http\Controllers\DataController@imageSelectDialog');
    Route::match(['get', 'post'], 'system/data/temp_data_upload/{category}', '\Edwin404\Admin\Http\Controllers\DataController@tempDataUpload');
    // 公用

    Route::match(['get', 'post'], 'config/setting', '\App\Http\Controllers\Admin\ConfigController@setting');
    Route::match(['get', 'post'], 'config/email', '\App\Http\Controllers\Admin\ConfigController@email');
    Route::match(['get', 'post'], 'config/sms', '\App\Http\Controllers\Admin\ConfigController@sms');
    Route::match(['get', 'post'], 'config/visit', '\App\Http\Controllers\Admin\ConfigController@visit');
    Route::match(['get', 'post'], 'config/register', '\App\Http\Controllers\Admin\ConfigController@register');
    Route::match(['get', 'post'], 'config/pay_alipay', '\App\Http\Controllers\Admin\ConfigController@payAlipay');
    Route::match(['get', 'post'], 'config/pay_wechat_mobile', '\App\Http\Controllers\Admin\ConfigController@payWechatMobile');
    Route::match(['get', 'post'], 'config/pay_wechat', '\App\Http\Controllers\Admin\ConfigController@payWechat');
    Route::match(['get', 'post'], 'config/oauth_qq', '\App\Http\Controllers\Admin\ConfigController@oauthQQ');
    Route::match(['get', 'post'], 'config/oauth_wechat_mobile', '\App\Http\Controllers\Admin\ConfigController@oauthWechatMobile');
    Route::match(['get', 'post'], 'config/oauth_weibo', '\App\Http\Controllers\Admin\ConfigController@oauthWeibo');
    Route::match(['get', 'post'], 'config/oauth_wechat_server', '\App\Http\Controllers\Admin\ConfigController@oauthWechatServer');
    Route::match(['get', 'post'], 'config/retrieve', '\App\Http\Controllers\Admin\ConfigController@retrieve');
    Route::match(['get', 'post'], 'config/contact', '\App\Http\Controllers\Admin\ConfigController@contact');


});
